/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.common.dd.connector.MapElement;
import com.sun.enterprise.tools.common.dd.connector.Principal;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class PrincipalDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PrincipalDialog.class);
    private final String PRINCIPAL_TITLE = localStrings.getLocalString("ui.sunone.principaldialog.principal_dialog_title", "Properties for Principal");
    private final String PRINCIPAL_TOOLTIP = localStrings.getLocalString("ui.sunone.principaldialog.principal_dialog_tool_tip", "Modify Principal Properties for Role Map");
    private final String PRINCIPAL_TABLE_TITLE = localStrings.getLocalString("ui.sunone.rolemapconnectorinspector.rolemap_principal", "Principal");
    private final String PRINCIPAL_TABLE_USERNAME = localStrings.getLocalString("ui.sunone.principaldialog.principal_username", "UserName");
    private final String ATR_USERNAME = "user-name";
    private static String PrincipalDialogHelpSetMapID = "PrincipalElement";
    private boolean okSelected = false;
    PrincipalTable principalTable = null;
    MapElement mapElement = null;
    UITitledTable pnlProp = null;

    public PrincipalDialog(Frame frame, JPanel panel, MapElement me) {
        super(frame, true);
        this.mapElement = me;
        this._initLayout(panel);
        this.principalTable.updateTableData(me.getPrincipal());
    }

    public PrincipalDialog(Dialog dialog, JPanel panel, MapElement me) {
        super(dialog, true);
        this.mapElement = me;
        this._initLayout(panel);
        this.principalTable.updateTableData(me.getPrincipal());
    }

    private void _initLayout(JPanel panel) {
        this.setTitle(this.PRINCIPAL_TITLE);
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent we) {
                PrincipalDialog.this.cancelAction();
            }
        });
        UITitledBox contentPane = new UITitledBox(null, false);
        contentPane.setToolTipText(this.PRINCIPAL_TOOLTIP);
        contentPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
        this.pnlProp = new UITitledTable(this.PRINCIPAL_TABLE_TITLE, true);
        contentPane.addWithGBConstraints(this.pnlProp);
        PrincipalTableModel prinTableModel = new PrincipalTableModel(null, -1);
        prinTableModel.setAutoValueUpdate(false);
        this.principalTable = new PrincipalTable(prinTableModel);
        this.pnlProp.setTableView(this.principalTable);
        UIButton btnAddProp = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrincipalDialog.this.addPropAction();
            }
        });
        this.pnlProp.addControlButton(btnAddProp);
        UIButton btnDeleteProp = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrincipalDialog.this.deletePropAction();
            }
        });
        this.pnlProp.addSelectionEnabledButton(btnDeleteProp);
        UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
        dialogPane.setControlButtonLocation(101);
        dialogPane.setView(contentPane);
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrincipalDialog.this.okAction();
            }
        });
        dialogPane.addControlButton(okPB);
        UIButton canPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrincipalDialog.this.cancelAction();
            }
        });
        dialogPane.addControlButton(canPB);
        UIHelpButton helpPB = new UIHelpButton(PrincipalDialogHelpSetMapID);
        dialogPane.addControlButton(helpPB);
        this.setContentPane(dialogPane);
        this.setSize(400, 300);
        this.pack();
        this.setBounds(0, 0, 380, 245);
        this.setLocationRelativeTo(panel);
    }

    private void addPropAction() {
        if (this.principalTable.getRowWithValue(0, "") == null) {
            Principal wp = new Principal();
            wp.setAttributeValue("user-name", "");
            wp.setDescription("");
            this.mapElement.addPrincipal(wp);
        }
        this.principalTable.selectRowWithValueOnUpdate(0, "");
        this.principalTable.updateTableData(this.mapElement.getPrincipal());
    }

    private void deletePropAction() {
        Object[] list = this.principalTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                Principal ref = (Principal)list[i];
                this.mapElement.removePrincipal(ref);
            }
            this.principalTable.updateTableData(this.mapElement.getPrincipal());
        }
    }

    public void setMapElement(MapElement ch) {
        this.mapElement = ch;
        this.pnlProp.setTitle(this.PRINCIPAL_TABLE_TITLE);
        this.principalTable.updateTableData(this.mapElement.getPrincipal());
    }

    public void okAction() {
        this.okSelected = true;
        this.hide();
    }

    public void cancelAction() {
        this.okSelected = false;
        this.hide();
    }

    public boolean userSelectedOK() {
        return this.okSelected;
    }

    public class PrincipalTableModel
    extends InspectorTableModel {
        private ConnectorDescriptor descriptor;
        private boolean autoValueUpdate;

        public PrincipalTableModel(ConnectorDescriptor desc, int index) {
            super(new String[]{PrincipalDialog.this.PRINCIPAL_TABLE_USERNAME, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.descriptor = null;
            this.autoValueUpdate = true;
        }

        public void setDescriptor(ConnectorDescriptor desc) {
            this.descriptor = desc;
        }

        public void setAutoValueUpdate(boolean b) {
            this.autoValueUpdate = b;
        }

        public Principal getRow(int index) {
            return (Principal)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            Principal ref = (Principal)obj;
            if (ref == null) {
                return null;
            }
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getAttributeValue("user-name");
                    break;
                }
                case 1: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            Principal ref = (Principal)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setAttributeValue("user-name", valStr);
                    break;
                }
                case 1: {
                    ref.setDescription(value.toString());
                }
            }
            if (this.descriptor != null) {
                this.descriptor.changed();
            }
        }
    }

    private class PrincipalTable
    extends InspectorTable {
        public PrincipalTable(PrincipalTableModel model) {
            super(model);
            this.setToolTipText(PrincipalDialog.this.PRINCIPAL_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

