/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.LocaleCharsetInfo;
import com.sun.enterprise.tools.common.dd.webapp.LocaleCharsetMap;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class LocaleInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LocaleInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.localeinspector.cbox_name", "Sun Specific Locale Inspector ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.localeinspector.cbox_desc", "This is a ComboBox for Sun specific locale inspector window");
    private static final String TABNAME = localStrings.getLocalString("ui.sunone.localeinspector.tabname", "Locale");
    private static final String DEFAULT_LOCALE = localStrings.getLocalString("ui.sunone.localeinspector.default_locale", "Default Locale:");
    private static final String DEFAULT_LOCALE_TOOLTIP = localStrings.getLocalString("ui.sunonelocaleinspector.default_locale.tooltip", "Select a locale defined in the Locale Charset Map Table");
    private static final String DEFAULT_CHARSET = localStrings.getLocalString("ui.sunone.localeinspector.default_charset", "Default Charset:");
    private static final String DEFAULT_CHARSET_TOOLTIP = localStrings.getLocalString("ui.sunonelocaleinspector.default_locale.tooltip", "Select a charset defined in the Locale Charset Map Table");
    private static final String PARAMETER_ENCODING = localStrings.getLocalString("ui.sunone.localeinspector.parameter_encoding", "Form Hint Field for Parameter Encoding:");
    private static final String PARAMETER_ENCODING_TOOLTIP = localStrings.getLocalString("ui.sunone.localeinspector.parameter_encoding.tooltip", "Enter the name of the hidden field in the form that specifies the parameter encoding");
    private static final String LOCALE_TABLE_TOOLTIP = localStrings.getLocalString("ui.sunone.localeinspector.table.tooltip", "Table of locale charset maps");
    private static final String LOCALE_CHARSET_MAP_TITLE = localStrings.getLocalString("ui.sunone.localeinspector.localecharsetmap", "Maps locales and agents to character sets");
    private static final String TABLE_LOCALE = localStrings.getLocalString("ui.sunone.localeinspector.table.locale", "Locale");
    private static final String TABLE_CHARSET = localStrings.getLocalString("ui.sunone.localeinspector.table.charset", "Charset");
    private static final String TABLE_AGENT = localStrings.getLocalString("ui.sunone.localeinspector.table.agent", "Agent");
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.sunone.localeinspector.table.title", "Locale Charset Map");
    private static final String LOCALE_TOOLTIP = localStrings.getLocalString("ui.sunone.localeinspector.localecharsetmapstable.locale.tooltip", "Click to Edit Locale");
    private static final String CHARSET_TOOLTIP = localStrings.getLocalString("ui.sunone.localeinspector.localecharsetmapstable.charset.tooltip", "Click to Edit Charset");
    String[] locales = new String[]{"ar", "ar_AE", "ar_BH", "ar_DZ", "ar_EG", "ar_IQ", "ar_JO", "ar_KW", "ar_LB", "ar_LY", "ar_MA", "ar_OM", "ar_QA", "ar_SA", "ar_SD", "ar_SY", "ar_TN", "ar_YE", "be", "be_BY", "bg", "bg_BG", "ca", "ca_ES", "ca_ES_EURO", "cs", "cs_CZ", "da", "da_DK", "de", "de_AT", "de_AT_EURO", "de_CH", "de_DE", "de_DE_EURO", "de_LU", "de_LU_EURO", "el", "el_GR", "en", "en_AU", "en_BE", "en_CA", "en_GB", "en_IE", "en_NZ", "en_US", "en_ZA", "es", "es_AR", "es_BO", "es_CL", "es_CO", "es_CR", "es_DO", "es_EC", "es_ES", "es_ES_EURO", "es_GT", "es_HN", "es_MX", "es_NI", "es_PA", "es_PE", "es_PR", "es_PY", "es_SV", "es_UY", "es_VE", "et", "et_EE", "fi", "fi_FI", "fi_FI_EURO", "fr", "fr_BE", "fr_BE_EURO", "fr_CA", "fr_CH", "fr_FR", "fr_FR_EURO", "fr_LU", "fr_LU_EURO", "hr", "hr_HR", "hu", "hu_HU", "is", "is_IS", "it", "it_CH", "it_IT", "it_IT_EURO", "iw", "iw_IL", "ja", "ja_JP", "ko", "ko_KR", "lt", "lt_LT", "lv", "lv_LV", "mk", "mk_MK", "nl", "nl_BE", "nl_BE_EURO", "nl_NL", "nl_NL_EURO", "no", "no_NO", "no_NO_NY", "pl", "pl_PL", "pt", "pt_BR", "pt_PT", "pt_PT_EURO", "ro", "ro_RO", "ru", "ru_RU", "sh", "sh_YU", "sk", "sk_SK", "sl", "sl_SI", "sq", "sq_AL", "sr", "sr_YU", "sv", "sv_SE", "th", "th_TH", "tr", "tr_TR", "uk", "uk_UA", "vi", "vi_VN", "zh", "zh_CN", "zh_HK", "zh_TW"};
    String[] charsets = new String[]{"UTF8", "ISO_8859-1", "ISO_8859-2", "ISO_8859-4", "ISO_8859-5", "ISO_8859-6", "ISO_8859-9", "ISO-2022-JP", "ISO-2022-KR", "Cp866", "Cp874", "Cp949", "Cp1250", "Cp1251", "Cp1252", "Cp1254", "Cp1256", "Cp1257", "Cp1258", "Shift_JIS", "EUC_JP", "EUC_KR", "EUC-TW", "KOI8-R", "GB2312", "GBK", "Big5"};
    private static String wizardHelpID = "LocaleWizard";
    private static String deployHelpID = "LocaleDeploy";
    private WebBundleDescriptor descriptor = null;
    private SunWebApp sunWebApp = null;
    private LocaleCharsetMapsTable localeCharsetMapsTable = null;
    private UITitledComboBox defaultLocaleCombo = null;
    private UITitledComboBox defaultCharsetCombo = null;
    private UITitledTextField parameterEncodingField = null;
    JButton addPB;
    JButton delPB;

    public static InspectorPane newInspectorPane(String mode) {
        return new LocaleInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.localeCharsetMapsTable.clearTableData();
            if (this.descriptor != null) {
                this.sunWebApp = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            }
            if (this.descriptor != null && this.defaultLocaleCombo != null) {
                this.defaultLocaleCombo.setModel(this.getSupportedLocales());
            }
            if (this.descriptor != null && this.defaultCharsetCombo != null) {
                this.defaultCharsetCombo.setModel(this.charsets);
            }
        }
    }

    private LocaleInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.defaultLocaleCombo = new UITitledComboBox(DEFAULT_LOCALE, false);
        this.defaultLocaleCombo.setToolTipText(DEFAULT_LOCALE_TOOLTIP);
        this.defaultLocaleCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (LocaleInspector.this.defaultLocaleCombo.isSetSelectionUpdate()) {
                    return;
                }
                WebBundleDescriptor desc = (WebBundleDescriptor)LocaleInspector.this.getDescriptor();
                if (desc != null && LocaleInspector.this.sunWebApp.getLocaleCharsetInfo() != null && LocaleInspector.this.defaultLocaleCombo.getSelectedItem() != null) {
                    LocaleInspector.this.sunWebApp.getLocaleCharsetInfo().setAttributeValue("DefaultLocale", (String)LocaleInspector.this.defaultLocaleCombo.getSelectedItem());
                    desc.changed();
                }
            }
        });
        c.weightx = 0.4;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 15, 85);
        c.fill = 2;
        this.add((Component)this.defaultLocaleCombo, c);
        this.defaultCharsetCombo = new UITitledComboBox(DEFAULT_CHARSET, false);
        this.defaultCharsetCombo.setToolTipText(DEFAULT_CHARSET_TOOLTIP);
        this.defaultCharsetCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (LocaleInspector.this.defaultCharsetCombo.isSetSelectionUpdate()) {
                    return;
                }
                WebBundleDescriptor desc = (WebBundleDescriptor)LocaleInspector.this.getDescriptor();
                if (desc != null && LocaleInspector.this.sunWebApp.getLocaleCharsetInfo() != null && LocaleInspector.this.defaultCharsetCombo.getSelectedItem() != null) {
                    LocaleInspector.this.sunWebApp.getLocaleCharsetInfo().setParameterEncoding(true);
                    LocaleInspector.this.sunWebApp.getLocaleCharsetInfo().setParameterEncodingDefaultCharset((String)LocaleInspector.this.defaultCharsetCombo.getSelectedItem());
                    desc.changed();
                }
            }
        });
        c.weightx = 0.4;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 15, 85);
        c.fill = 2;
        this.add((Component)this.defaultCharsetCombo, c);
        this.parameterEncodingField = new UITitledTextField(PARAMETER_ENCODING, false);
        this.parameterEncodingField.setToolTipText(PARAMETER_ENCODING_TOOLTIP);
        this.parameterEncodingField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LocaleInspector.this.setParameterEncoding(LocaleInspector.this.parameterEncodingField.getText());
                LocaleInspector.this.descriptor.changed();
            }
        });
        c.weightx = 0.4;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 15, 85);
        this.add((Component)this.parameterEncodingField, c);
        UITitledBox titledBox = new UITitledBox(LOCALE_CHARSET_MAP_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)titledBox, c);
        UITitledTable localeCharsetMapsPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(localeCharsetMapsPanel);
        this.localeCharsetMapsTable = new LocaleCharsetMapsTable(new LocaleCharsetMapsTableModel());
        this.localeCharsetMapsTable.setAutoResizeMode(4);
        localeCharsetMapsPanel.getGBConstraints().weighty = 0.85;
        localeCharsetMapsPanel.setTableView(this.localeCharsetMapsTable);
        this.addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocaleInspector.this.addLocaleCharsetMapAction();
            }
        });
        localeCharsetMapsPanel.addControlButton(this.addPB);
        this.delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocaleInspector.this.deleteLocaleCharsetMapAction();
            }
        }, true);
        localeCharsetMapsPanel.addSelectionEnabledButton(this.delPB);
    }

    private void setParameterEncoding(String text) {
        if (this.descriptor == null) {
            return;
        }
        LocaleCharsetInfo info = this.sunWebApp.getLocaleCharsetInfo();
        if (info == null) {
            return;
        }
        info.setParameterEncoding(true);
        info.setAttributeValue("ParameterEncoding", "FormHintField", this.parameterEncodingField.getText());
    }

    private void addLocaleCharsetMapAction() {
        if (this.localeCharsetMapsTable.getRowWithValue(0, "") == null) {
            LocaleCharsetMap map = new LocaleCharsetMap();
            map.setAttributeValue("Locale", this.locales[0]);
            map.setAttributeValue("Agent", "");
            map.setAttributeValue("Charset", this.charsets[0]);
            map.setDescription("");
            LocaleCharsetInfo info = this.sunWebApp.getLocaleCharsetInfo();
            if (info == null) {
                info = new LocaleCharsetInfo();
                this.sunWebApp.setLocaleCharsetInfo(info);
            }
            info.addLocaleCharsetMap(map);
        }
        this.localeCharsetMapsTable.selectRowWithValueOnUpdate(1, "");
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteLocaleCharsetMapAction() {
        Object[] list = this.localeCharsetMapsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this.sunWebApp.getLocaleCharsetInfo().removeLocaleCharsetMap((LocaleCharsetMap)list[i]);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    public void refresh() {
        LocaleCharsetInfo info = this.sunWebApp.getLocaleCharsetInfo();
        if (this.localeCharsetMapsTable == null || info == null) {
            return;
        }
        this.localeCharsetMapsTable.updateTableData(info.getLocaleCharsetMap());
        this.localeCharsetMapsTable.sizeColumnsToFit(0);
        Set supportedLocales = this.getSupportedLocalesAsSet();
        this.defaultLocaleCombo.setModel(this.getSupportedLocales(supportedLocales));
        String valStr = info.getAttributeValue("DefaultLocale");
        if (valStr != null) {
            if (this.isSupportedLocale(valStr, supportedLocales)) {
                this.defaultLocaleCombo.setSelectedItem(valStr);
            } else {
                info.setAttributeValue("DefaultLocale", null);
            }
        } else if (this.descriptor != null && this.sunWebApp.getLocaleCharsetInfo() != null && this.defaultLocaleCombo.getSelectedItem() != null) {
            this.sunWebApp.getLocaleCharsetInfo().setAttributeValue("DefaultLocale", (String)this.defaultLocaleCombo.getSelectedItem());
            this.descriptor.changed();
        }
        this.defaultCharsetCombo.setModel(this.charsets);
        String charsetStr = info.getParameterEncodingDefaultCharset();
        if (charsetStr != null) {
            this.defaultCharsetCombo.setSelectedItem(charsetStr);
        } else if (this.descriptor != null && this.sunWebApp.getLocaleCharsetInfo() != null && this.defaultCharsetCombo.getSelectedItem() != null) {
            this.sunWebApp.getLocaleCharsetInfo().setParameterEncoding(true);
            this.sunWebApp.getLocaleCharsetInfo().setParameterEncodingDefaultCharset((String)this.defaultCharsetCombo.getSelectedItem());
            this.descriptor.changed();
        }
        if (info.isParameterEncoding() && (valStr = info.getAttributeValue("ParameterEncoding", "FormHintField")) != null) {
            this.parameterEncodingField.setText(valStr);
        }
    }

    public Set getSupportedLocalesAsSet() {
        LocaleCharsetInfo info = this.sunWebApp.getLocaleCharsetInfo();
        if (info == null) {
            return new TreeSet();
        }
        LocaleCharsetMap[] maps = info.getLocaleCharsetMap();
        TreeSet<String> locales = new TreeSet<String>();
        for (int i = 0; i < maps.length; ++i) {
            locales.add(maps[i].getAttributeValue("Locale"));
        }
        return locales;
    }

    public String[] getSupportedLocales(Set supported) {
        Set locales = supported;
        if (locales == null) {
            locales = this.getSupportedLocalesAsSet();
        }
        String[] arr = new String[locales.size()];
        return locales.toArray(arr);
    }

    public String[] getSupportedLocales() {
        return this.getSupportedLocales(null);
    }

    public boolean isSupportedLocale(String locale, Set supported) {
        Set locales = supported;
        if (locales == null && (locales = this.getSupportedLocalesAsSet()) == null) {
            return false;
        }
        return locales.contains(locale);
    }

    public boolean isUnique(String locale, String agent) {
        LocaleCharsetInfo info = this.sunWebApp.getLocaleCharsetInfo();
        if (info == null) {
            return true;
        }
        LocaleCharsetMap[] maps = info.getLocaleCharsetMap();
        for (int i = 0; i < maps.length; ++i) {
            String mapLocale = maps[i].getAttributeValue("Locale");
            String mapAgent = maps[i].getAttributeValue("Agent");
            if (!mapLocale.equals(locale) || !mapAgent.equals(agent)) continue;
            return false;
        }
        return true;
    }

    public LocaleCharsetMap[] findWith(String locale, String agent) {
        LocaleCharsetInfo info = this.sunWebApp.getLocaleCharsetInfo();
        if (info == null) {
            return new LocaleCharsetMap[0];
        }
        LocaleCharsetMap[] maps = info.getLocaleCharsetMap();
        Vector<LocaleCharsetMap> vec = new Vector<LocaleCharsetMap>();
        for (int i = 0; i < maps.length; ++i) {
            String mapLocale = maps[i].getAttributeValue("Locale");
            String mapAgent = maps[i].getAttributeValue("Agent");
            if (!mapLocale.equals(locale) || !mapAgent.equals(agent)) continue;
            vec.add(maps[i]);
        }
        Object[] arr = new LocaleCharsetMap[vec.size()];
        vec.copyInto(arr);
        return arr;
    }

    private class LocaleCharsetMapsTableModel
    extends InspectorTableModel {
        public LocaleCharsetMapsTableModel() {
            super(new String[]{TABLE_LOCALE, TABLE_AGENT, TABLE_CHARSET, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public LocaleCharsetMap getRow(int index) {
            return (LocaleCharsetMap)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            LocaleCharsetMap map = (LocaleCharsetMap)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = map.getAttributeValue("Locale");
                    break;
                }
                case 1: {
                    value = map.getAttributeValue("Agent");
                    break;
                }
                case 2: {
                    value = map.getAttributeValue("Charset");
                    break;
                }
                case 3: {
                    value = map.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            LocaleCharsetMap map = (LocaleCharsetMap)obj;
            if (map == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    map.setAttributeValue("Locale", valStr);
                    break;
                }
                case 1: {
                    map.setAttributeValue("Agent", valStr);
                    break;
                }
                case 2: {
                    map.setAttributeValue("Charset", valStr);
                    break;
                }
                case 3: {
                    map.setDescription(valStr);
                }
            }
            LocaleInspector.this.descriptor.changed();
            LocaleInspector.this.invokeRefresh();
        }
    }

    private class LocaleCharsetMapsTable
    extends InspectorTable {
        public LocaleCharsetMapsTable(LocaleCharsetMapsTableModel model) {
            super(model);
            this.setToolTipText(LOCALE_TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            TableColumn localeColumn = this.getColumnModel().getColumn(0);
            JComboBox<String> localeComboBox = new JComboBox<String>(LocaleInspector.this.locales);
            localeComboBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            localeComboBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            localeComboBox.setEditable(true);
            localeColumn.setCellEditor(new DefaultCellEditor(localeComboBox));
            DefaultTableCellRenderer localeRenderer = new DefaultTableCellRenderer();
            localeRenderer.setToolTipText(LOCALE_TOOLTIP);
            localeColumn.setCellRenderer(localeRenderer);
            TableColumn agentColumn = this.getColumnModel().getColumn(1);
            JTextField agentField = new JTextField();
            agentField.setEditable(true);
            agentColumn.setCellEditor(new DefaultCellEditor(agentField));
            TableColumn charsetColumn = this.getColumnModel().getColumn(2);
            JComboBox<String> charsetComboBox = new JComboBox<String>(LocaleInspector.this.charsets);
            charsetComboBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            charsetComboBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            charsetColumn.setCellEditor(new DefaultCellEditor(charsetComboBox));
            DefaultTableCellRenderer charsetRenderer = new DefaultTableCellRenderer();
            charsetRenderer.setToolTipText(CHARSET_TOOLTIP);
            charsetColumn.setCellRenderer(charsetRenderer);
        }
    }
}

