/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.ClassLoader;
import com.sun.enterprise.tools.common.dd.webapp.JspConfig;
import com.sun.enterprise.tools.common.dd.webapp.MetaData;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.common.dd.webapp.WebProperty;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.sunone.WebPropertyTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.table.TableCellEditor;

public class JspInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JspInspector.class);
    private final String JSP_TOOLTIP = localStrings.getLocalString("ui.sunone.JspInspector.Jsp_tool_tip", "Properties for JSP Configuration");
    private final String JSP_TITLE = localStrings.getLocalString("ui.sunone.JspInspector.Jsp_title", "JSP Configuration");
    private final String EXTRA_TOOLTIP = localStrings.getLocalString("ui.sunone.JspInspector.Extra_tool_tip", "Params for Extra Properties");
    private final String EXTRA_TITLE = localStrings.getLocalString("ui.sunone.JspInspector.Extra_title", "Extra Properties");
    private final String TABNAME = localStrings.getLocalString("ui.sunone.JspInspector.Jsp_Tab", "Servlet/JSP Settings");
    private final String MISSING_CLASSLOADER_PROP_NAME = localStrings.getLocalString("ui.sunone.JspInspector.Missing_classloader_prop_name", "All Class Loader properties must have a 'Name'.");
    private final String MISSING_CLASSLOADER_PROP_VALUE = localStrings.getLocalString("ui.sunone.JspInspector.Missing_classloader_prop_value", "All Class Loader properties must have a 'Value'.");
    private final String MISSING_EXTRA_PROP_NAME = localStrings.getLocalString("ui.sunone.JspInspector.Missing_extra_prop_name", "All extra properties must have a 'Name'.");
    private final String MISSING_EXTRA_PROP_VALUE = localStrings.getLocalString("ui.sunone.JspInspector.Missing_extra_prop_value", "All extra properties must have a 'Value'.");
    private final String MISSING_JSP_VALUE = localStrings.getLocalString("ui.sunone.JspInspector.Missing_jsp_value", "All JSP Configuration properties must have a 'Value'.");
    private final String SERVLET_CLASS_LOADER = localStrings.getLocalString("ui.sunone.JspInspector.servlet_class_loader", "Servlet Class Loader");
    private final String CLASSPATH = localStrings.getLocalString("ui.sunone.JspInspector.classpath", "Classpath:");
    private final String DELEGATE_TO_PARENT = localStrings.getLocalString("ui.sunone.JspInspector.delegate_to_parent", "Delegate to Parent");
    private final String CLASS_LOADER_PROPERTIES = localStrings.getLocalString("ui.sunone.JspInspector.class_loader_properties", "Class Loader Properties");
    private final String CLASS_LOADER_PROPS_TOOLTIP = localStrings.getLocalString("ui.sunone.JspInspector.class_loader_props_tooltip", "Class Loader Properties");
    private static final String DEFAULT_CHARSET = localStrings.getLocalString("ui.sunone.JspInspector.default_charset", "Default Charset:");
    private static final String DEFAULT_CHARSET_TOOLTIP = localStrings.getLocalString("ui.sunone.JspInspector.default_charset.tooltip", "Select a charset defined in the Locale Charset Map Table");
    private static final String PARAMETER_ENCODING = localStrings.getLocalString("ui.sunone.JspInspector.parameter_encoding", "Parameter Encoding");
    private static final String FORM_HINT_FIELD = localStrings.getLocalString("ui.sunone.JspInspector.form_hint_field", "Form Hint Field:");
    private static final String PARAMETER_ENCODING_TOOLTIP = localStrings.getLocalString("ui.sunone.JspInspector.parameter_encoding.tooltip", "Enter the name of the hidden field in the form that specifies the parameter encoding");
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private final String TRUE = "true";
    private final String FALSE = "false";
    String[] charsets = new String[]{"UTF8", "ISO_8859-1", "ISO_8859-2", "ISO_8859-4", "ISO_8859-5", "ISO_8859-6", "ISO_8859-9", "ISO-2022-JP", "ISO-2022-KR", "Cp866", "Cp874", "Cp949", "Cp1250", "Cp1251", "Cp1252", "Cp1254", "Cp1256", "Cp1257", "Cp1258", "Shift_JIS", "EUC_JP", "EUC_KR", "EUC-TW", "KOI8-R", "GB2312", "GBK", "Big5"};
    private static final char mnemonic_Delegate = localStrings.getLocalString("ui.sunone.JspInspector.delegate_to_parent_mnemonic", "P").charAt(0);
    private JspConfig jspConfig;
    private JspTable jspTable = null;
    private JButton btnAddJsp = null;
    private SunWebApp sunWebApp = null;
    private ExtraTable extraTable = null;
    private ClassLoaderTable classLoaderTable = null;
    private UITitledTextField classpathField = null;
    private UICheckBox delegate = null;
    private ClassLoader classLoader = null;
    private UITitledComboBox defaultCharsetCombo = null;
    private UITitledTextField parameterEncodingField = null;
    private static String wizardHelpID = "JspRef";
    private static String deployHelpID = "JspRef";
    private WebBundleDescriptor descriptor = null;
    private static Vector jspParamName = ListTools.toList(MetaData.getParamNames((int)4));
    private static Vector extraParamName = ListTools.toList(MetaData.getParamNames((int)1));

    public static InspectorPane newInspectorPane(String mode) {
        return new JspInspector(mode);
    }

    public String getTabName() {
        return this.TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.classLoaderTable.clearTableData();
            this.jspTable.clearTableData();
            this.extraTable.clearTableData();
            if (this.descriptor != null) {
                this.sunWebApp = (SunWebApp)SunOneUtils.getSunDescriptor(desc);
                this.jspConfig = this.sunWebApp.getJspConfig();
                if (this.jspConfig == null) {
                    this.jspConfig = new JspConfig();
                    this.sunWebApp.setJspConfig(this.jspConfig);
                }
                ((WebPropertyTableModel)this.jspTable.getModel()).setDescriptor(this.descriptor);
                ((WebPropertyTableModel)this.extraTable.getModel()).setDescriptor(this.descriptor);
                ((WebPropertyTableModel)this.classLoaderTable.getModel()).setDescriptor(this.descriptor);
                this.classLoader = this.sunWebApp.getClassLoader();
                if (this.classLoader == null) {
                    this.classLoader = new ClassLoader();
                    this.sunWebApp.setClassLoader(this.classLoader);
                }
                if (this.sunWebApp.getClassLoader().getDelegate() == null) {
                    this.sunWebApp.getClassLoader().setDelegate(Boolean.TRUE.toString());
                }
                if (this.defaultCharsetCombo != null) {
                    this.defaultCharsetCombo.setModel(this.charsets);
                }
            }
        }
    }

    private JspInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledBox box = new UITitledBox(this.SERVLET_CLASS_LOADER, true);
        box.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)box, c);
        this.classpathField = new UITitledTextField(this.CLASSPATH, false);
        this.classpathField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (JspInspector.this.classpathField.getText().trim().length() == 0) {
                    JspInspector.this.classLoader.setExtraClassPath(null);
                } else {
                    JspInspector.this.classLoader.setExtraClassPath(JspInspector.this.classpathField.getText());
                }
            }
        });
        c.weightx = 0.8;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 15);
        c.fill = 2;
        box.add((Component)this.classpathField, c);
        this.delegate = new UICheckBox(this.DELEGATE_TO_PARENT, mnemonic_Delegate);
        this.delegate.setSelected(true);
        this.delegate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspInspector.this.classLoader.setDelegate(Boolean.toString(JspInspector.this.delegate.isSelected()));
            }
        });
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        box.add((Component)this.delegate, c);
        UITitledTable classLoaderPanel = new UITitledTable(this.CLASS_LOADER_PROPERTIES, true);
        this.classLoaderTable = new ClassLoaderTable(new WebPropertyTableModel(this.descriptor, -1));
        classLoaderPanel.setTableView(this.classLoaderTable);
        UIButton btnAddProp = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JspInspector.this.addPropAction();
            }
        });
        classLoaderPanel.addControlButton(btnAddProp);
        UIButton btnDeleteProp = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspInspector.this.deletePropAction();
            }
        });
        classLoaderPanel.addSelectionEnabledButton(btnDeleteProp);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        box.add((Component)classLoaderPanel, c);
        UITitledTable pnlJsp = new UITitledTable(this.JSP_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.25;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlJsp, c);
        this.jspTable = new JspTable(new WebPropertyTableModel(this.descriptor, 4));
        pnlJsp.setTableView(this.jspTable);
        this.btnAddJsp = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JspInspector.this.addJspAction();
            }
        });
        pnlJsp.addControlButton(this.btnAddJsp);
        UIButton btnDeleteJsp = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspInspector.this.deleteJspAction();
            }
        });
        btnDeleteJsp.setMnemonic(69);
        pnlJsp.addSelectionEnabledButton(btnDeleteJsp);
        UITitledTable pnlExtra = new UITitledTable(this.EXTRA_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.25;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlExtra, c);
        this.extraTable = new ExtraTable(new WebPropertyTableModel(this.descriptor, 1));
        pnlExtra.setTableView(this.extraTable);
        UIButton btnAddExtra = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JspInspector.this.addExtraAction();
            }
        });
        btnAddExtra.setMnemonic(68);
        pnlExtra.addControlButton(btnAddExtra);
        UIButton btnDeleteExtra = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspInspector.this.deleteExtraAction();
            }
        });
        btnDeleteExtra.setMnemonic(76);
        pnlExtra.addSelectionEnabledButton(btnDeleteExtra);
        UITitledBox parameterBox = new UITitledBox(PARAMETER_ENCODING, true);
        parameterBox.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)parameterBox, c);
        this.defaultCharsetCombo = new UITitledComboBox(DEFAULT_CHARSET, false);
        this.defaultCharsetCombo.setToolTipText(DEFAULT_CHARSET_TOOLTIP);
        this.defaultCharsetCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (JspInspector.this.defaultCharsetCombo.isSetSelectionUpdate()) {
                    return;
                }
                if (JspInspector.this.defaultCharsetCombo.getSelectedItem() != null) {
                    JspInspector.this.sunWebApp.setParameterEncoding(true);
                    JspInspector.this.sunWebApp.setParameterEncodingDefaultCharset((String)JspInspector.this.defaultCharsetCombo.getSelectedItem());
                }
            }
        });
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 15, 85);
        c.fill = 2;
        parameterBox.add((Component)this.defaultCharsetCombo, c);
        this.parameterEncodingField = new UITitledTextField(FORM_HINT_FIELD, false);
        this.parameterEncodingField.setToolTipText(PARAMETER_ENCODING_TOOLTIP);
        this.parameterEncodingField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JspInspector.this.sunWebApp.setParameterEncoding(true);
                JspInspector.this.sunWebApp.setParameterEncodingFormHintField(JspInspector.this.parameterEncodingField.getText());
            }
        });
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 15, 85);
        parameterBox.add((Component)this.parameterEncodingField, c);
    }

    public void refresh() {
        String valStr;
        this.jspTable.updateTableData(this.jspConfig.getWebProperty());
        this.extraTable.updateTableData(this.sunWebApp.getWebProperty());
        this.classLoaderTable.updateTableData(this.classLoader.getWebProperty());
        this.classpathField.setText(this.classLoader.getExtraClassPath());
        if (this.classLoader.getDelegate() != null) {
            this.delegate.setSelected(this.classLoader.getDelegate().equals(Boolean.TRUE.toString()));
        }
        this.defaultCharsetCombo.setModel(this.charsets);
        String charsetStr = this.sunWebApp.getParameterEncodingDefaultCharset();
        if (charsetStr != null) {
            this.defaultCharsetCombo.setSelectedItem(charsetStr);
        } else if (this.descriptor != null && this.defaultCharsetCombo.getSelectedItem() != null) {
            this.sunWebApp.setParameterEncoding(true);
            this.sunWebApp.setParameterEncodingDefaultCharset((String)this.defaultCharsetCombo.getSelectedItem());
        }
        if (this.sunWebApp.isParameterEncoding() && (valStr = this.sunWebApp.getParameterEncodingFormHintField()) != null) {
            this.parameterEncodingField.setText(valStr);
        }
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.classLoaderTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_CLASSLOADER_PROP_NAME);
            }
            return false;
        }
        if (this.classLoaderTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_CLASSLOADER_PROP_VALUE);
            }
            return false;
        }
        if (this.jspTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_JSP_VALUE);
            }
            return false;
        }
        if (this.extraTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_EXTRA_PROP_NAME);
            }
            return false;
        }
        if (this.extraTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_EXTRA_PROP_VALUE);
            }
            return false;
        }
        return true;
    }

    private void addJspAction() {
        WebProperty wp = null;
        wp = (WebProperty)this.jspTable.getRowWithValue(1, "");
        if (wp == null) {
            wp = WebPropertyTableModel.findNewWebProperty(this.jspConfig.getWebProperty(), 4);
            if (wp == null) {
                wp = this.jspConfig.getWebProperty(this.jspConfig.sizeWebProperty() - 1);
            } else {
                this.jspConfig.addWebProperty(wp);
            }
            if (jspParamName.size() == this.jspConfig.sizeWebProperty()) {
                this.btnAddJsp.setEnabled(false);
            }
        }
        this.jspTable.selectRowWithValueOnUpdate(0, wp.getAttributeValue("name"));
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteJspAction() {
        Object[] list = this.jspTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.jspConfig.removeWebProperty(ref);
            }
            this.btnAddJsp.setEnabled(true);
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void addExtraAction() {
        WebProperty wp = null;
        wp = (WebProperty)this.extraTable.getRowWithValue(1, "");
        if (wp == null) {
            wp = WebPropertyTableModel.findNewWebProperty(this.sunWebApp.getWebProperty(), 1);
            if (wp == null) {
                wp = (WebProperty)this.extraTable.getRowWithValue(0, "");
                if (wp == null) {
                    wp = new WebProperty();
                    wp.setAttributeValue("name", "");
                    this.sunWebApp.addWebProperty(wp);
                }
            } else {
                this.sunWebApp.addWebProperty(wp);
            }
        }
        this.extraTable.selectRowWithValueOnUpdate(0, wp.getAttributeValue("name"));
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteExtraAction() {
        Object[] list = this.extraTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.sunWebApp.removeWebProperty(ref);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void addPropAction() {
        int index = 0;
        Object obj0 = this.classLoaderTable.getRowWithValue(0, "");
        Object obj1 = this.classLoaderTable.getRowWithValue(1, "");
        if (obj0 == null && obj1 == null && this.classLoaderTable.getRowWithValue(0, "") == null) {
            WebProperty wp = new WebProperty();
            wp.setAttributeValue("name", "");
            wp.setAttributeValue("value", "");
            wp.setDescription("");
            this.classLoader.addWebProperty(wp);
        }
        if (index == 2 || obj0 != null) {
            this.classLoaderTable.selectRowWithValueOnUpdate(0, "");
        } else {
            this.classLoaderTable.selectRowWithValueOnUpdate(1, "");
        }
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deletePropAction() {
        Object[] list = this.classLoaderTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.classLoader.removeWebProperty(ref);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private class ClassLoaderTable
    extends InspectorTable {
        public ClassLoaderTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(JspInspector.this.CLASS_LOADER_PROPS_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class ExtraTable
    extends InspectorTable {
        public ExtraTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(JspInspector.this.EXTRA_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            WebProperty ref = (WebProperty)this.getRowObject(row);
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(WebPropertyTableModel.findFilteredParam(JspInspector.this.sunWebApp.getWebProperty(), extraParamName, row));
                    ((InspectorTable.TableComboBoxEditor)rtn).setEditable(true);
                    break;
                }
                case 1: {
                    String name = ref.getAttributeValue("name");
                    String[] values = MetaData.getParamValues((int)1, (String)name);
                    rtn = WebPropertyTableModel.getTableCellEditor(values, this);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    private class JspTable
    extends InspectorTable {
        public JspTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(JspInspector.this.JSP_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            WebProperty ref = (WebProperty)this.getRowObject(row);
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.getComboBoxEditor(WebPropertyTableModel.findFilteredParam(JspInspector.this.jspConfig.getWebProperty(), jspParamName, row));
                    break;
                }
                case 1: {
                    String name = ref.getAttributeValue("name");
                    String[] values = MetaData.getParamValues((int)4, (String)name);
                    rtn = WebPropertyTableModel.getTableCellEditor(values, this);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

