/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.Cache;
import com.sun.enterprise.tools.common.dd.webapp.DefaultHelper;
import com.sun.enterprise.tools.common.dd.webapp.MetaData;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.common.dd.webapp.WebProperty;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.sunone.WebPropertyTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class CacheInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CacheInspector.class);
    private final String DEFAULT_HELPER_TOOLTIP = localStrings.getLocalString("ui.sunone.CacheInspector.DefaultHelper_tool_tip", "Default, build-in cache-helper properties");
    private final String DEFAULT_HELPER_TITLE = localStrings.getLocalString("ui.sunone.CacheInspector.DefaultHelper_title", "Default Helper Properties");
    private final String EXTRA_TOOLTIP = localStrings.getLocalString("ui.sunone.CacheInspector.Cache_extra_tool_tip", "Extra properties for cache");
    private final String EXTRA_TITLE = localStrings.getLocalString("ui.sunone.CacheInspector.Cache_extra_title", "Extra Properties for Cache");
    private final String TABNAME = localStrings.getLocalString("ui.sunone.CacheInspector.Cache_Tab", "Cache");
    private final String MAXCAP = localStrings.getLocalString("ui.sunone.CacheInspector.Max_capacity", "Maximum Capacity");
    private final String MAXCAP_TOOL_TIP = localStrings.getLocalString("ui.sunone.CacheInspector.Max_capacity_tool_tip", "Maximum number of entries this cache may hold, default is {0}", new Object[]{"4096"});
    private final String TIMEOUT_SECOND = localStrings.getLocalString("ui.sunone.CacheInspector.Timeout_second", "Default Timeout in seconds");
    private final String CACHE_ENABLED = localStrings.getLocalString("ui.sunone.CacheInspector.Cache_enabled", "Cache Enabled:");
    private final String NO_WINDOW = localStrings.getLocalString("ui.sunone.CacheInspector.No_Window", "Didn't find a parent window, using 'null'.");
    private final String MISSING_EXTRA_NAME = localStrings.getLocalString("ui.sunone.CacheInspector.Missing_extra_name", "All Extra Properties must have a 'name' ");
    private final String MISSING_EXTRA_VALUE = localStrings.getLocalString("ui.sunone.CacheInspector.Missing_extra_value", "All Extra Properties must have a 'value' ");
    private final String MISSING_HELPER_NAME = localStrings.getLocalString("ui.sunone.CacheInspector.Missing_helper_name", "All Default Helper Properties must have a 'name' ");
    private final String MISSING_HELPER_VALUE = localStrings.getLocalString("ui.sunone.CacheInspector.Missing_helper_value", "All Default Helper Properties must have a 'value' ");
    private final String TIMEOUT_SECOND_TOOLTIP = localStrings.getLocalString("ui.sunone.CacheInspector.Timeout_second_tooltip", "Set Default Timeout in seconds, default is {0}", new Object[]{"30"});
    private final String CACHE_ENABLED_TOOLTIP = localStrings.getLocalString("ui.sunone.CacheInspector.Cache_enabled_tooltip", "Select if Cache Enabled is true or false");
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private final String ATR_CLASSNAME = "ClassName";
    private final String MAXENTRIES = "MaxEntries";
    private final String TIMEOUT = "TimeoutInSeconds";
    private final String ENABLED = "Enabled";
    private Cache cache;
    private DefaultHelper defaultHelper;
    private String maxCapacity = null;
    private String timeout = null;
    private String enabled = null;
    private DefaultHelperTable defaultHelperTable = null;
    private JButton btnAddDefaultHelper = null;
    private ExtraTable extraTable = null;
    UITitledTextField maxCapacityText;
    UITitledTextField timeoutText;
    UITitledComboBox cacheEnabled;
    private static String wizardHelpID = "CacheRef";
    private static String deployHelpID = "CacheRef";
    private WebBundleDescriptor descriptor = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new CacheInspector(mode);
    }

    public String getTabName() {
        return this.TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.defaultHelperTable.clearTableData();
            this.extraTable.clearTableData();
            if (this.descriptor != null) {
                this.initializeSession((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor));
                ((WebPropertyTableModel)this.defaultHelperTable.getModel()).setDescriptor(this.descriptor);
                ((WebPropertyTableModel)this.extraTable.getModel()).setDescriptor(this.descriptor);
            }
        }
    }

    public void initializeSession(SunWebApp swa) {
        this.cache = swa.getCache();
        if (this.cache == null) {
            this.cache = new Cache();
            swa.setCache(this.cache);
            this.descriptor.changed();
        }
        this.defaultHelper = this.cache.getDefaultHelper();
        if (this.defaultHelper == null) {
            this.defaultHelper = new DefaultHelper();
            this.cache.setDefaultHelper(this.defaultHelper);
        }
        this.maxCapacity = this.cache.getAttributeValue("MaxEntries");
        if (CacheInspector.isEmpty(this.maxCapacity)) {
            this.maxCapacity = "";
        }
        this.timeout = this.cache.getAttributeValue("TimeoutInSeconds");
        if (CacheInspector.isEmpty(this.timeout)) {
            this.timeout = "";
        }
        this.enabled = this.cache.getAttributeValue("Enabled");
        if (CacheInspector.isEmpty(this.enabled)) {
            this.enabled = MetaData.CACHE_KEY_BOOLEAN[0];
        }
    }

    private CacheInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UIPanel infoPanel = new UIPanel(new GridBagLayout());
        this.maxCapacityText = new UITitledTextField(this.MAXCAP, false);
        this.maxCapacityText.setToolTipText(this.MAXCAP_TOOL_TIP);
        this.maxCapacityText.setIntegerDocument(false);
        this.maxCapacityText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CacheInspector.this.maxCapacity = CacheInspector.this.maxCapacityText.getText();
                CacheInspector.this.cache.setAttributeValue("MaxEntries", CacheInspector.this.maxCapacity);
                CacheInspector.this.descriptor.changed();
            }
        });
        c.fill = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 10, 0, 7);
        infoPanel.add((Component)this.maxCapacityText, c);
        this.timeoutText = new UITitledTextField(this.TIMEOUT_SECOND, false);
        this.timeoutText.setToolTipText(this.TIMEOUT_SECOND_TOOLTIP);
        this.timeoutText.setIntegerDocument(false);
        this.timeoutText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CacheInspector.this.timeout = CacheInspector.this.timeoutText.getText();
                CacheInspector.this.cache.setAttributeValue("TimeoutInSeconds", CacheInspector.this.timeout);
                CacheInspector.this.descriptor.changed();
            }
        });
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 7);
        infoPanel.add((Component)this.timeoutText, c);
        this.cacheEnabled = new UITitledComboBox(this.CACHE_ENABLED, false);
        this.cacheEnabled.setToolTipText(this.CACHE_ENABLED_TOOLTIP);
        this.cacheEnabled.setModel(MetaData.CACHE_KEY_BOOLEAN);
        this.cacheEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (CacheInspector.this.cacheEnabled.isSetSelectionUpdate()) {
                    return;
                }
                String en = (String)CacheInspector.this.cacheEnabled.getSelectedItem();
                if (!en.equals(CacheInspector.this.cache.getAttributeValue("Enabled"))) {
                    CacheInspector.this.cache.setAttributeValue("Enabled", en);
                    CacheInspector.this.descriptor.changed();
                }
            }
        });
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 40);
        infoPanel.add((Component)this.cacheEnabled, c);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)infoPanel, c);
        UITitledTable pnlExtra = new UITitledTable(this.EXTRA_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlExtra, c);
        this.extraTable = new ExtraTable(new WebPropertyTableModel(this.descriptor, -1));
        pnlExtra.setTableView(this.extraTable);
        UIButton btnAddExtra = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheInspector.this.addExtraAction();
            }
        });
        pnlExtra.addControlButton(btnAddExtra);
        UIButton btnDeleteExtra = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CacheInspector.this.deleteExtraAction();
            }
        });
        pnlExtra.addSelectionEnabledButton(btnDeleteExtra);
        UITitledTable pnlDefaultHelper = new UITitledTable(this.DEFAULT_HELPER_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlDefaultHelper, c);
        WebPropertyTableModel wpt = new WebPropertyTableModel(this.descriptor, 8);
        wpt.setAutoValueUpdate(false);
        this.defaultHelperTable = new DefaultHelperTable(wpt);
        pnlDefaultHelper.setTableView(this.defaultHelperTable);
        UIButton btnAddDefaultHelper = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheInspector.this.addDefaultHelperAction();
            }
        });
        pnlDefaultHelper.addControlButton(btnAddDefaultHelper);
        UIButton btnDeleteDefaultHelper = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CacheInspector.this.deleteDefaultHelperAction();
            }
        });
        pnlDefaultHelper.addSelectionEnabledButton(btnDeleteDefaultHelper);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.maxCapacityText.setText(this.cache.getAttributeValue("MaxEntries"));
        this.timeoutText.setText(this.cache.getAttributeValue("TimeoutInSeconds"));
        this.cacheEnabled.setSelectedItem(this.cache.getAttributeValue("Enabled"));
        this.defaultHelperTable.updateTableData(this.defaultHelper.getWebProperty());
        this.extraTable.updateTableData(this.cache.getWebProperty());
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.extraTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_EXTRA_NAME);
            }
            return false;
        }
        if (this.extraTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_EXTRA_VALUE);
            }
            return false;
        }
        if (this.defaultHelperTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_HELPER_NAME);
            }
            return false;
        }
        if (this.defaultHelperTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_HELPER_VALUE);
            }
            return false;
        }
        return true;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    private void addDefaultHelperAction() {
        int index = 0;
        Object obj0 = this.defaultHelperTable.getRowWithValue(0, "");
        Object obj1 = this.defaultHelperTable.getRowWithValue(1, "");
        if (obj0 == null && obj1 == null) {
            WebProperty wp = new WebProperty();
            wp.setAttributeValue("name", "");
            wp.setAttributeValue("value", "");
            wp.setDescription("");
            this.defaultHelper.addWebProperty(wp);
            index = 2;
        }
        if (index == 2 || obj0 != null) {
            this.defaultHelperTable.selectRowWithValueOnUpdate(0, "");
        } else {
            this.defaultHelperTable.selectRowWithValueOnUpdate(1, "");
        }
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteDefaultHelperAction() {
        Object[] list = this.defaultHelperTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.defaultHelper.removeWebProperty(ref);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private void addExtraAction() {
        int index = 0;
        Object obj0 = this.extraTable.getRowWithValue(0, "");
        Object obj1 = this.extraTable.getRowWithValue(1, "");
        if (obj0 == null && obj1 == null && this.extraTable.getRowWithValue(0, "") == null) {
            WebProperty wp = new WebProperty();
            wp.setAttributeValue("name", "");
            wp.setAttributeValue("value", "");
            wp.setDescription("");
            this.cache.addWebProperty(wp);
        }
        if (index == 2 || obj0 != null) {
            this.extraTable.selectRowWithValueOnUpdate(0, "");
        } else {
            this.extraTable.selectRowWithValueOnUpdate(1, "");
        }
        this.descriptor.changed();
        this.invokeRefresh();
    }

    private void deleteExtraAction() {
        Object[] list = this.extraTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebProperty ref = (WebProperty)list[i];
                this.cache.removeWebProperty(ref);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    private class ExtraTable
    extends InspectorTable {
        public ExtraTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(CacheInspector.this.EXTRA_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class DefaultHelperTable
    extends InspectorTable {
        public DefaultHelperTable(WebPropertyTableModel model) {
            super(model);
            this.setToolTipText(CacheInspector.this.DEFAULT_HELPER_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

