/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared.sunone;

import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIListSelector;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Vector;

public class UsersDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UsersDialog.class);
    private static String USERS = localStrings.getLocalString("ui.usersdialog.users", "Edit Users - {0}");
    private static String MAP_USERS_ACC_DSC = localStrings.getLocalString("ui.usersdialog.map_users_acc_dsc", "Select users to map to role");
    private static String USERS_IN_ROLE = localStrings.getLocalString("ui.usersdialog.users_in_role", "Users in Role \"{0}\":");
    private static String USERS_IN_ROLE_MNEMONIC = localStrings.getLocalString("ui.usersdialog.users_in_role.mnemonic", "R");
    private static String AVAILABLE_USERS = localStrings.getLocalString("ui.usersdialog.available_users", "Available Users:");
    private static String AVAILABLE_USERS_MNEMONIC = localStrings.getLocalString("ui.usersdialog.available_users.mnemonic", "U");
    private static String helpSetMapID = "UsersGroups";
    UIButton okPB = null;
    boolean finished = true;
    private String roleName;
    private UIListSelector listSelector;
    SecurityRoleMapping[] roleMaps = null;

    public UsersDialog(Frame frame, SecurityRoleMapping[] maps, boolean modal, boolean allowCreation) {
        super(frame, modal);
        this.roleMaps = maps;
        this.doNothingOnClose();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                UsersDialog.this.cancelAction();
            }
        });
        UIPanel contentPane = new UIPanel();
        GridBagLayout gb1 = new GridBagLayout();
        contentPane.setLayout(gb1);
        GridBagConstraints c = new GridBagConstraints();
        int gridyOffset = 0;
        this.listSelector = new UIListSelector(AVAILABLE_USERS, USERS_IN_ROLE);
        this.listSelector.getAccessibleContext().setAccessibleDescription(MAP_USERS_ACC_DSC);
        this.listSelector.setMnemonicLeft(AVAILABLE_USERS_MNEMONIC.charAt(0));
        this.listSelector.setMnemonicRight(USERS_IN_ROLE_MNEMONIC.charAt(0));
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        contentPane.add((Component)this.listSelector, c);
        UIPanel dialogButtonPanel = new UIPanel();
        dialogButtonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        this.okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.okAction();
            }
        });
        this.okPB.clearMnemonic();
        dialogButtonPanel.add(this.okPB);
        this.getRootPane().setDefaultButton(this.okPB);
        UIButton cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.cancelAction();
            }
        });
        cancelPB.clearMnemonic();
        dialogButtonPanel.add(cancelPB);
        UIButton helpPB = UIButton.createHelpButton(helpSetMapID);
        dialogButtonPanel.add(helpPB);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 2 + gridyOffset;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        c.fill = 0;
        gb1.setConstraints(dialogButtonPanel, c);
        contentPane.add(dialogButtonPanel);
        this.setContentPane(contentPane);
    }

    public void setTitles(String role) {
        this.roleName = role;
        this.setTitle(MessageFormat.format(USERS, this.roleName));
        this.listSelector.setListContentsRight(new Vector());
        this.listSelector.setTitleRight(MessageFormat.format(USERS_IN_ROLE, this.roleName));
        for (int i = 0; i < this.roleMaps.length; ++i) {
            if (!this.roleMaps[i].getRoleName().equals(this.roleName)) continue;
            Vector<String> v = new Vector<String>();
            String[] principals = this.roleMaps[i].getPrincipalName();
            for (int j = 0; j < principals.length; ++j) {
                v.add(principals[j]);
            }
            this.listSelector.setListContentsRight(v);
            this.listSelector.sortListContentsRight(true);
        }
    }

    public String[] getSelectedUsers() {
        Vector v = this.listSelector.getListContentsRight();
        String[] selectedUsers = new String[v.size()];
        int i = 0;
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String s;
            selectedUsers[i] = s = (String)iter.next();
            ++i;
        }
        return selectedUsers;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void okAction() {
        this.finished = true;
        this.hide();
    }

    protected void cancelAction() {
        this.finished = false;
        this.hide();
    }

    public void show(boolean enableAddToRole) {
        this.setSize(565, 250);
        this.okPB.setEnabled(enableAddToRole);
        this.showServerUsers();
        super.show();
    }

    public void show() {
        this.show(true);
    }

    public void setRoleMaps(SecurityRoleMapping[] maps) {
        this.roleMaps = maps;
    }

    private void showServerUsers() {
        this.listSelector.setListContentsLeft(new Vector(DT.getServerManager().getServerUserNames()));
        this.listSelector.sortListContentsLeft(true);
    }
}

