/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared.sunone;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentManagerSettings;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.CommonDescriptorUtil;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.GroupsDialog;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.UsersDialog;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RoleMapInspector
extends InspectorPane
implements NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RoleMapInspector.class);
    private static String TABNAME = localStrings.getLocalString("ui.rolemapinspector.tabname", "User to Role Mappings");
    private static String TITLE = localStrings.getLocalString("rolemapinspector.users_label", "Users/Groups in Role \"{0}\"");
    private static String ROLE_NAMES_REF = localStrings.getLocalString("rolemapinspector.role_names_label", "Roles:");
    private static String ROLES_MNEMONIC = localStrings.getLocalString("rolemapinspector.role_names_label.mnemonic", "R");
    private static String USERS = localStrings.getLocalString("rolemapinspector.users", "Users:");
    private static String GROUPS = localStrings.getLocalString("rolemapinspector.groups", "Groups:");
    private static String ROLE_NAMES_REF_ACC_DSC = localStrings.getLocalString("rolemapinspector.role_names_label_acc_dsc", "List of referenced Role Names");
    private static String USER_NAMES_REF_ACC_DSC = localStrings.getLocalString("rolemapinspector.role_names_users_acc_dsc", "List of Users mapped to selected Role Name");
    private static String GROUP_NAMES_REF_ACC_DSC = localStrings.getLocalString("rolemapinspector.role_names_groups_acc_dsc", "List of Groups mapped to selected Role Name");
    private static String wizardHelpID = "SecRoleMapping";
    private static String deployHelpID = "SecRoleMapping";
    private Descriptor descriptor;
    private CommonDescriptorUtil commonDescriptor;
    private Application application;
    private UITitledList roleNamesView = null;
    private JList roleList = null;
    private RoleUsersTableModel usersTableModel;
    private RoleUsersTable usersTable;
    private RoleUsersTableModel userGroupsTableModel;
    private RoleUsersTable userGroupsTable;
    private UsersDialog usersDialog;
    private UsersDialog editUsersDialog;
    private GroupsDialog groupsDialog;
    private UITitledBox usersGroups;
    private UIButton editUsersPB;
    private UIButton editGroupsPB;

    public static InspectorPane newInspectorPane(String mode) {
        return new RoleMapInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return this.descriptor != null ? this.descriptor.getClass() : Descriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc;
            this.roleNamesView.clearTableData();
            this.usersTable.clearTableData();
            this.userGroupsTable.clearTableData();
            if (this.descriptor instanceof BundleDescriptor) {
                this.application = ((BundleDescriptor)this.descriptor).getApplication();
                this.commonDescriptor = DescriptorTools.isStandAlone(this.descriptor) ? new CommonDescriptorUtil(this.descriptor) : (desc == null ? null : new CommonDescriptorUtil((Descriptor)this.application));
            } else if (this.descriptor instanceof Application) {
                this.application = (Application)this.descriptor;
                this.commonDescriptor = desc == null ? null : new CommonDescriptorUtil((Descriptor)this.application);
            }
        }
        this.invokeRefresh();
    }

    private RoleMapInspector() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout tgb = new GridBagLayout();
        this.setLayout(tgb);
        this.roleList = new JList();
        this.roleNamesView = new UITitledList(ROLE_NAMES_REF, false, this.roleList);
        this.roleNamesView.getAccessibleContext().setAccessibleDescription(ROLE_NAMES_REF_ACC_DSC);
        this.roleNamesView.setMnemonic(ROLES_MNEMONIC.charAt(0));
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.roleNamesView, c);
        this.roleNamesView.setSorted(true);
        this.roleList.setSelectionMode(0);
        this.roleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JList list = (JList)e.getSource();
                if (list.isSelectionEmpty()) {
                    RoleMapInspector.this.usersTable.clearSelection();
                    RoleMapInspector.this.userGroupsTable.clearSelection();
                } else {
                    RoleMapInspector.this.showUsersInSelectedRole();
                }
            }
        });
        String roleName = null;
        if (this.roleNamesView.getSelectedValue() != null) {
            roleName = this.roleNamesView.getSelectedValue().toString();
        }
        String titleStr = MessageFormat.format(TITLE, roleName == null ? "" : roleName);
        this.usersGroups = new UITitledBox(titleStr, true);
        this.usersGroups.setLayout(tgb);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.usersGroups, c);
        UIControlButtonBox tablesBox1 = new UIControlButtonBox(null, false);
        tablesBox1.setControlButtonLocation(101);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.usersGroups.add((Component)tablesBox1, c);
        UIControlButtonBox tablesBox2 = new UIControlButtonBox(null, false);
        tablesBox2.setControlButtonLocation(101);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.usersGroups.add((Component)tablesBox2, c);
        UITitledTable users = new UITitledTable(USERS, false);
        users.getAccessibleContext().setAccessibleDescription(USER_NAMES_REF_ACC_DSC);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        tablesBox1.setView(users);
        this.usersTableModel = new RoleUsersTableModel(true);
        this.usersTable = new RoleUsersTable(this.usersTableModel);
        users.setTableView(this.usersTable);
        this.usersTable.setRowSelectionAllowed(false);
        this.usersTable.setAutoResizeMode(4);
        UITitledTable userGroupsView = new UITitledTable(GROUPS, false);
        userGroupsView.getAccessibleContext().setAccessibleDescription(GROUP_NAMES_REF_ACC_DSC);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        tablesBox2.setView(userGroupsView);
        this.userGroupsTableModel = new RoleUsersTableModel(false);
        this.userGroupsTable = new RoleUsersTable(this.userGroupsTableModel);
        userGroupsView.setTableView(this.userGroupsTable);
        this.userGroupsTable.setRowSelectionAllowed(false);
        this.userGroupsTable.setAutoResizeMode(4);
        this.editUsersPB = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleMapInspector.this.editUserAction();
            }
        });
        this.editUsersPB.setEnabled(false);
        this.editGroupsPB = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleMapInspector.this.editGroupAction();
            }
        });
        this.editGroupsPB.setEnabled(false);
        tablesBox1.addControlButton(this.editUsersPB);
        tablesBox2.addControlButton(this.editGroupsPB);
        DT.getModuleManager().addNotificationListener(this);
    }

    private void showUsersInSelectedRole() {
        String role;
        this.usersTable.clearTableData();
        this.userGroupsTable.clearTableData();
        if (this.descriptor == null) {
            return;
        }
        String string = role = this.roleNamesView.getSelectedValue() != null ? this.roleNamesView.getSelectedValue().toString() : null;
        if (role == null) {
            return;
        }
        String titleStr = MessageFormat.format(TITLE, this.roleNamesView.getSelectedValue() != null ? this.roleNamesView.getSelectedValue().toString() : null);
        this.usersGroups.setTitle(titleStr);
        ArrayList associatedPrincipals = new ArrayList();
        Object e = null;
        SecurityRoleMapping[] srm = this.commonDescriptor.getSecurityRoleMapping();
        if (srm != null) {
            for (int i = 0; i < srm.length; ++i) {
                if (!srm[i].getRoleName().equals(role)) continue;
                String[] principalArray = srm[i].getPrincipalName();
                this.usersTable.updateTableData(Arrays.asList(principalArray));
                String[] groupArray = srm[i].getGroupName();
                this.userGroupsTable.updateTableData(Arrays.asList(groupArray));
                break;
            }
        }
        this.editUsersPB.setEnabled(true);
        this.editGroupsPB.setEnabled(true);
    }

    private SecurityRoleMapping getSecurityRoleMapping(String roleName) {
        SecurityRoleMapping[] roleMaps = this.commonDescriptor.getSecurityRoleMapping();
        for (int i = 0; i < roleMaps.length; ++i) {
            if (!roleMaps[i].getRoleName().equals(roleName)) continue;
            return roleMaps[i];
        }
        return null;
    }

    private void addRoleMapping(String roleName, String userName, String groupName) {
        SecurityRoleMapping roleMap = this.getSecurityRoleMapping(roleName);
        if (roleMap == null) {
            roleMap = new SecurityRoleMapping();
            this.commonDescriptor.addSecurityRoleMapping(roleMap);
            roleMap.setRoleName(roleName);
        }
        if (userName != null) {
            roleMap.addPrincipalName(userName);
        } else if (groupName != null) {
            roleMap.addGroupName(groupName);
        }
    }

    private void mapUsersToRole(String[] selectedUsers) {
        String roleName = this.roleNamesView.getSelectedValue() != null ? this.roleNamesView.getSelectedValue().toString() : null;
        Role role = new Role(roleName);
        List<Object> userList = new ArrayList();
        SecurityRoleMapping[] srm = this.commonDescriptor.getSecurityRoleMapping();
        if (srm != null) {
            for (int i = 0; i < srm.length; ++i) {
                if (!srm[i].getRoleName().equals(roleName)) continue;
                String[] principalArray = srm[i].getPrincipalName();
                userList = Arrays.asList(principalArray);
                break;
            }
        }
        try {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < selectedUsers.length; ++i) {
                if (!userList.contains(selectedUsers[i])) {
                    this.addRoleMapping(roleName, selectedUsers[i], null);
                }
                v.add(selectedUsers[i]);
            }
            Iterator iter = userList.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (v.contains(s)) continue;
                this.deleteRoleMapping(roleName, s, null);
            }
        }
        catch (NullPointerException npe) {
            Print.printStackTrace((String)"NPE!", (Throwable)npe);
        }
    }

    private void mapGroupsToRole(String[] selectedGroups) {
        String roleName = this.roleNamesView.getSelectedValue() != null ? this.roleNamesView.getSelectedValue().toString() : null;
        Role role = new Role(roleName);
        List<Object> groupList = new ArrayList();
        SecurityRoleMapping[] srm = this.commonDescriptor.getSecurityRoleMapping();
        if (srm != null) {
            for (int i = 0; i < srm.length; ++i) {
                if (!srm[i].getRoleName().equals(roleName)) continue;
                String[] groupArray = srm[i].getGroupName();
                groupList = Arrays.asList(groupArray);
                break;
            }
        }
        try {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < selectedGroups.length; ++i) {
                if (!groupList.contains(selectedGroups[i])) {
                    this.addRoleMapping(roleName, null, selectedGroups[i]);
                }
                v.add(selectedGroups[i]);
            }
            Iterator iter = groupList.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (v.contains(s)) continue;
                this.deleteRoleMapping(roleName, null, s);
            }
        }
        catch (NullPointerException npe) {
            Print.printStackTrace((String)"NPE!", (Throwable)npe);
        }
    }

    private void editUserAction() {
        if (this.roleNamesView.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("rolemapinspector.must_select_role", "You must select a role before attempting to add users."));
            return;
        }
        if (DeploymentManagerSettings.getConnectedManagerURI() == null) {
            return;
        }
        if (this.usersDialog == null) {
            Frame frame = this.getMyParentFrame();
            this.usersDialog = new UsersDialog(frame, this.commonDescriptor.getSecurityRoleMapping(), true, false);
            CSH.setHelpIDString((Component)this.usersDialog, (String)"AIAddUser");
            this.usersDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent we) {
                    if (RoleMapInspector.this.usersDialog.isFinished()) {
                        String[] selectedUsers = RoleMapInspector.this.usersDialog.getSelectedUsers();
                        RoleMapInspector.this.mapUsersToRole(selectedUsers);
                        RoleMapInspector.this.showUsersInSelectedRole();
                    }
                }
            });
            this.usersDialog.pack();
        }
        this.usersDialog.setLocationRelativeTo(this.usersDialog.getOwner());
        this.usersDialog.setRoleMaps(this.commonDescriptor.getSecurityRoleMapping());
        this.usersDialog.setTitles(this.roleNamesView.getSelectedValue() != null ? this.roleNamesView.getSelectedValue().toString() : null);
        this.usersDialog.show();
    }

    private void editGroupAction() {
        if (DeploymentManagerSettings.getConnectedManagerURI() == null) {
            return;
        }
        if (this.roleNamesView.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("rolemapinspector.must_select_role", "You must select a role before attempting to edit groups."));
            return;
        }
        if (this.groupsDialog == null) {
            Frame frame = this.getMyParentFrame();
            this.groupsDialog = new GroupsDialog(frame, this.commonDescriptor.getSecurityRoleMapping(), true, false);
            CSH.setHelpIDString((Component)this.groupsDialog, (String)"AIAddUser");
            this.groupsDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent we) {
                    if (RoleMapInspector.this.groupsDialog.isFinished()) {
                        String[] selectedGroups = RoleMapInspector.this.groupsDialog.getSelectedGroups();
                        RoleMapInspector.this.mapGroupsToRole(selectedGroups);
                        RoleMapInspector.this.showUsersInSelectedRole();
                    }
                }
            });
            this.groupsDialog.pack();
        }
        this.groupsDialog.setLocationRelativeTo(this.groupsDialog.getOwner());
        this.groupsDialog.setRoleMaps(this.commonDescriptor.getSecurityRoleMapping());
        this.groupsDialog.setTitles(this.roleNamesView.getSelectedValue() != null ? this.roleNamesView.getSelectedValue().toString() : null);
        this.groupsDialog.show();
    }

    private void deleteRoleMapping(String roleName, String userName, String groupName) {
        SecurityRoleMapping roleMap = this.getSecurityRoleMapping(roleName);
        if (roleMap == null) {
            return;
        }
        if (userName != null) {
            roleMap.removePrincipalName(userName);
        } else if (groupName != null) {
            roleMap.removeGroupName(groupName);
        }
        if (roleMap.sizePrincipalName() == 0 && roleMap.sizeGroupName() == 0) {
            this.commonDescriptor.removeSecurityRoleMapping(roleMap);
        }
    }

    public void notification(NotificationEvent ne) {
    }

    private void editRolesAction() {
        RolesDialog rolesDialog = RolesDialog.newRolesDialog(this, false);
        rolesDialog.showDialog(this.descriptor);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        Vector<StringBuffer> roleNames = new Vector<StringBuffer>();
        Iterator itr = ((Roles)this.descriptor).getRoles().iterator();
        while (itr.hasNext()) {
            Role nextRole = (Role)itr.next();
            String n = nextRole.getName();
            roleNames.add(new StringBuffer(n));
        }
        Object lastSelectedRole = this.roleNamesView.getSelectedValue();
        this.roleNamesView.clearTableData();
        this.editUsersPB.setEnabled(false);
        this.editGroupsPB.setEnabled(false);
        this.roleNamesView.updateTableData(roleNames);
        if (this.roleNamesView.isSelectionEmpty()) {
            if (lastSelectedRole != null) {
                this.roleNamesView.setSelectedValue(lastSelectedRole.toString());
            } else if (!roleNames.isEmpty()) {
                this.roleNamesView.setSelectedIndex(0);
            }
        }
        this.showUsersInSelectedRole();
    }

    public class RoleUsersTableModel
    extends InspectorTableModel {
        public RoleUsersTableModel(boolean isUserTable) {
            super(new String[]{""});
            this.columnNames = this.columnNames;
            this.setDataOrdering(1);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }
    }

    private class RoleUsersTable
    extends InspectorTable {
        public RoleUsersTable(RoleUsersTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public String getSelectedUser() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }
}

