/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared.sunone;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.tools.common.dd.EjbRef;
import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.common.dd.ResourceRef;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.CommonDescriptorUtil;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.util.Print;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class CommonUtil {
    public static void initEjbDescriptors(Application app) {
        if (app != null) {
            Iterator itr = app.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
                Iterator ejbItr = ejbBundleDescriptor.getEjbs().iterator();
                while (ejbItr.hasNext()) {
                    EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbItr.next();
                    ejbDescriptor.setJndiName(((Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejbDescriptor)).getJndiName());
                }
            }
        }
    }

    public static void initReferences(Application app, Hashtable map) {
        if (app != null) {
            Vector namedRefPairs = app.getNamedReferencePairs();
            for (int i = 0; i < namedRefPairs.size(); ++i) {
                NamedReferencePair refPair = (NamedReferencePair)namedRefPairs.elementAt(i);
                int pairType = refPair.getPairType();
                if (pairType == 1) continue;
                Descriptor referant = refPair.getReferant();
                CommonDescriptorUtil commonDesc = (CommonDescriptorUtil)map.get(referant);
                if (commonDesc == null) {
                    commonDesc = new CommonDescriptorUtil(referant);
                    map.put(referant, commonDesc);
                }
                String jndiName = null;
                NamedDescriptor referee = refPair.getReferee();
                if (pairType == 2) {
                    EjbRef ejbRef = commonDesc.getEjbRef(referee.getName());
                    if (ejbRef != null) {
                        jndiName = ejbRef.getJndiName();
                    }
                } else if (pairType == 4) {
                    ResourceEnvRef envRef = commonDesc.getResourceEnvRef(referee.getName());
                    if (envRef != null) {
                        jndiName = envRef.getJndiName();
                    }
                } else if (pairType == 3) {
                    ResourceRef resRef = commonDesc.getResourceRef(referee.getName());
                    if (resRef != null) {
                        jndiName = resRef.getJndiName();
                    }
                } else {
                    Print.println((String)("JndiNameInspector: pair type = " + pairType));
                }
                if (jndiName == null) continue;
                referee.setJndiName(jndiName);
            }
        }
    }
}

