/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared.sunone;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.DefaultResourcePrincipal;
import com.sun.enterprise.tools.common.dd.EjbRef;
import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.common.dd.ResourceRef;
import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.application.SunApplication;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import java.util.Hashtable;

public class CommonDescriptorUtil {
    public static final String RESOURCE_ENV_REF = "resource-env-ref";
    public static final String EJB_REF = "ejb-ref";
    public static final String RESOURCE_REF = "resource-ref";
    private Descriptor descriptor;
    private Hashtable beanToEjbRefMap = null;
    private Hashtable beanToResRefMap = null;
    private Hashtable beanToResEnvRefMap = null;
    private boolean isForEjb = false;
    private Ejb ejb = null;

    public CommonDescriptorUtil(Descriptor desc) {
        this.descriptor = desc;
        if (desc instanceof EjbDescriptor) {
            EjbDescriptor ejbDesc = (EjbDescriptor)desc;
            try {
                this.ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejbDesc);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.isForEjb = true;
        }
    }

    public SecurityRoleMapping[] getSecurityRoleMapping() {
        if (this.descriptor instanceof WebBundleDescriptor) {
            return ((SunWebApp)SunOneUtils.getSunDescriptor(this.descriptor)).getSecurityRoleMapping();
        }
        if (this.descriptor instanceof EjbBundleDescriptor) {
            return ((SunEjbJar)SunOneUtils.getSunDescriptor(this.descriptor)).getSecurityRoleMapping();
        }
        if (this.descriptor instanceof Application) {
            return ((SunApplication)SunOneUtils.getSunDescriptor(this.descriptor)).getSecurityRoleMapping();
        }
        return null;
    }

    public void setSecurityRoleMapping(SecurityRoleMapping[] roleMaps) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)SunOneUtils.getSunDescriptor(this.descriptor)).setSecurityRoleMapping(roleMaps);
        } else if (this.descriptor instanceof EjbBundleDescriptor) {
            ((SunEjbJar)SunOneUtils.getSunDescriptor(this.descriptor)).setSecurityRoleMapping(roleMaps);
        } else if (this.descriptor instanceof Application) {
            ((SunApplication)SunOneUtils.getSunDescriptor(this.descriptor)).setSecurityRoleMapping(roleMaps);
        }
    }

    public int addSecurityRoleMapping(SecurityRoleMapping roleMap) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            return ((SunWebApp)SunOneUtils.getSunDescriptor(this.descriptor)).addSecurityRoleMapping(roleMap);
        }
        if (this.descriptor instanceof EjbBundleDescriptor) {
            return ((SunEjbJar)SunOneUtils.getSunDescriptor(this.descriptor)).addSecurityRoleMapping(roleMap);
        }
        if (this.descriptor instanceof Application) {
            return ((SunApplication)SunOneUtils.getSunDescriptor(this.descriptor)).addSecurityRoleMapping(roleMap);
        }
        return -1;
    }

    public int removeSecurityRoleMapping(SecurityRoleMapping roleMap) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            return ((SunWebApp)SunOneUtils.getSunDescriptor(this.descriptor)).removeSecurityRoleMapping(roleMap);
        }
        if (this.descriptor instanceof EjbBundleDescriptor) {
            return ((SunEjbJar)SunOneUtils.getSunDescriptor(this.descriptor)).removeSecurityRoleMapping(roleMap);
        }
        if (this.descriptor instanceof Application) {
            return ((SunApplication)SunOneUtils.getSunDescriptor(this.descriptor)).removeSecurityRoleMapping(roleMap);
        }
        return -1;
    }

    public SunBaseBean getSunBaseBean() {
        SunBaseBean bean = null;
        if (this.descriptor instanceof WebBundleDescriptor) {
            bean = SunOneUtils.getSunDescriptor((Descriptor)((WebBundleDescriptor)this.descriptor));
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            bean = SunOneUtils.getSunDescriptor((Descriptor)((ApplicationClientDescriptor)this.descriptor));
        } else if (this.isForEjb && this.ejb != null) {
            bean = this.ejb;
        }
        return bean;
    }

    public Hashtable getBeanToEjbRefMap() {
        SunBaseBean bean = this.getSunBaseBean();
        if (bean == null) {
            return null;
        }
        if (this.beanToEjbRefMap == null) {
            this.beanToEjbRefMap = new Hashtable();
            EjbRef[] refs = null;
            if (this.descriptor instanceof WebBundleDescriptor) {
                refs = ((SunWebApp)bean).getEjbRef();
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                refs = ((SunApplicationClient)bean).getEjbRef();
            } else if (this.isForEjb && bean != null) {
                refs = ((Ejb)bean).getEjbRef();
            }
            if (refs != null) {
                Hashtable<String, EjbRef> map = new Hashtable<String, EjbRef>();
                for (int i = 0; i < refs.length; ++i) {
                    map.put(this.prefix(EJB_REF, refs[i].getEjbRefName()), refs[i]);
                }
                this.beanToEjbRefMap.put(bean, map);
            }
        }
        return this.beanToEjbRefMap;
    }

    public Hashtable getBeanToResEnvRefMap() {
        SunBaseBean bean = this.getSunBaseBean();
        if (bean == null) {
            System.out.println(bean == null ? "getSunBaseBean() returns null" : "getSunBaseBean() not null");
            return null;
        }
        if (this.beanToResEnvRefMap == null) {
            this.beanToResEnvRefMap = new Hashtable();
            ResourceEnvRef[] refs = null;
            if (this.descriptor instanceof WebBundleDescriptor) {
                refs = ((SunWebApp)bean).getResourceEnvRef();
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                refs = ((SunApplicationClient)bean).getResourceEnvRef();
            } else if (this.isForEjb && bean != null) {
                refs = ((Ejb)bean).getResourceEnvRef();
            } else {
                System.out.println(bean == null ? "getSunBaseBean() returns null" : "getSunBaseBean() not null");
            }
            if (refs != null) {
                Hashtable<String, ResourceEnvRef> map = new Hashtable<String, ResourceEnvRef>();
                for (int i = 0; i < refs.length; ++i) {
                    map.put(this.prefix(RESOURCE_ENV_REF, refs[i].getResourceEnvRefName()), refs[i]);
                }
                this.beanToResEnvRefMap.put(bean, map);
            }
        }
        return this.beanToResEnvRefMap;
    }

    public Hashtable getBeanToResRefMap() {
        SunBaseBean bean = this.getSunBaseBean();
        if (bean == null) {
            System.out.println(bean == null ? "getSunBaseBean() returns null" : "getSunBaseBean() not null");
            return null;
        }
        if (this.beanToResRefMap == null) {
            this.beanToResRefMap = new Hashtable();
            ResourceRef[] refs = null;
            if (this.descriptor instanceof WebBundleDescriptor) {
                refs = ((SunWebApp)bean).getResourceRef();
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                refs = ((SunApplicationClient)bean).getResourceRef();
            } else if (bean != null) {
                refs = ((Ejb)bean).getResourceRef();
            } else {
                System.out.println(bean == null ? "getSunBaseBean() returns null" : "getSunBaseBean() not null");
            }
            if (refs != null) {
                Hashtable<String, ResourceRef> map = new Hashtable<String, ResourceRef>();
                for (int i = 0; i < refs.length; ++i) {
                    map.put(this.prefix(RESOURCE_REF, refs[i].getResRefName()), refs[i]);
                }
                this.beanToResRefMap.put(bean, map);
            }
        }
        return this.beanToResRefMap;
    }

    public void addEjbRef(String oldEjbRefName, String newEjbRefName, String jndiName) {
        EjbRef ref;
        SunBaseBean bean = this.getSunBaseBean();
        Hashtable b2eMap = this.getBeanToEjbRefMap();
        if (b2eMap == null) {
            return;
        }
        Hashtable<String, EjbRef> map = (Hashtable<String, EjbRef>)b2eMap.get(bean);
        if (map == null) {
            map = new Hashtable<String, EjbRef>();
            this.getBeanToEjbRefMap().put(bean, map);
        }
        String name = newEjbRefName;
        if (oldEjbRefName != null) {
            name = oldEjbRefName;
        }
        if ((ref = (EjbRef)map.get(this.prefix(EJB_REF, name))) == null) {
            ref = new EjbRef();
            ref.setEjbRefName(newEjbRefName);
            ref.setJndiName(jndiName);
            this.addEjbRef(ref);
            map.put(this.prefix(EJB_REF, newEjbRefName), ref);
        } else {
            if (!name.equals(newEjbRefName)) {
                map.remove(this.prefix(EJB_REF, name));
                map.put(this.prefix(EJB_REF, newEjbRefName), ref);
            }
            ref.setEjbRefName(newEjbRefName);
            ref.setJndiName(jndiName);
        }
    }

    public void addEjbRef(String ejbRefName, String jndiName) {
        this.addEjbRef(null, ejbRefName, jndiName);
    }

    public void addEjbRef(EjbRef ref) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)this.getSunBaseBean()).addEjbRef(ref);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)this.getSunBaseBean()).addEjbRef(ref);
        } else if (this.isForEjb) {
            this.ejb.addEjbRef(ref);
        }
    }

    public void removeEjbRef(String ejbRefName) {
        SunBaseBean bean = this.getSunBaseBean();
        Hashtable b2eMap = this.getBeanToEjbRefMap();
        if (b2eMap == null) {
            return;
        }
        Hashtable map = (Hashtable)b2eMap.get(bean);
        if (map == null) {
            return;
        }
        EjbRef ref = (EjbRef)map.get(this.prefix(EJB_REF, ejbRefName));
        map.remove(this.prefix(EJB_REF, ejbRefName));
        if (ref != null) {
            this.removeEjbRef(ref);
        }
    }

    public void removeEjbRef(EjbRef ref) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)this.getSunBaseBean()).removeEjbRef(ref);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)this.getSunBaseBean()).removeEjbRef(ref);
        } else if (this.isForEjb) {
            this.ejb.removeEjbRef(ref);
        }
    }

    public EjbRef getEjbRef(String refName) {
        Hashtable map = (Hashtable)this.getBeanToEjbRefMap().get(this.getSunBaseBean());
        EjbRef ref = (EjbRef)map.get(this.prefix(EJB_REF, refName));
        if (ref == null) {
            EjbRef[] ejbRefs = null;
            if (this.descriptor instanceof WebBundleDescriptor) {
                ejbRefs = ((SunWebApp)this.getSunBaseBean()).getEjbRef();
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                ejbRefs = ((SunApplicationClient)this.getSunBaseBean()).getEjbRef();
            } else if (this.isForEjb) {
                ejbRefs = this.ejb.getEjbRef();
            }
            if (ejbRefs != null) {
                for (int i = 0; i < ejbRefs.length; ++i) {
                    if (!ejbRefs[i].getEjbRefName().equals(refName)) continue;
                    ref = ejbRefs[i];
                    map.put(this.prefix(EJB_REF, refName), ref);
                    break;
                }
            }
        }
        return ref;
    }

    public void addResourceEnvRef(String oldName, String newName, String jndiName) {
        ResourceEnvRef ref;
        SunBaseBean bean = this.getSunBaseBean();
        Hashtable b2reMap = this.getBeanToResEnvRefMap();
        if (b2reMap == null) {
            return;
        }
        Hashtable<String, ResourceEnvRef> map = (Hashtable<String, ResourceEnvRef>)b2reMap.get(bean);
        if (map == null) {
            map = new Hashtable<String, ResourceEnvRef>();
            b2reMap.put(bean, map);
        }
        String name = newName;
        if (oldName != null) {
            name = oldName;
        }
        if ((ref = (ResourceEnvRef)map.get(this.prefix(RESOURCE_ENV_REF, name))) == null) {
            ref = new ResourceEnvRef();
            ref.setResourceEnvRefName(newName);
            ref.setJndiName(jndiName);
            map.put(this.prefix(RESOURCE_ENV_REF, newName), ref);
            this.addResourceEnvRef(ref);
        } else {
            if (!name.equals(newName)) {
                map.remove(this.prefix(RESOURCE_ENV_REF, name));
                map.put(this.prefix(RESOURCE_ENV_REF, newName), ref);
            }
            ref.setResourceEnvRefName(newName);
            ref.setJndiName(jndiName);
        }
    }

    public void addResourceEnvRef(String name, String jndiName) {
        this.addResourceEnvRef(null, name, jndiName);
    }

    public void addResourceEnvRef(ResourceEnvRef ref) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)this.getSunBaseBean()).addResourceEnvRef(ref);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)this.getSunBaseBean()).addResourceEnvRef(ref);
        } else if (this.isForEjb) {
            this.ejb.addResourceEnvRef(ref);
        }
    }

    public void removeResourceEnvRef(String name) {
        SunBaseBean bean = this.getSunBaseBean();
        Hashtable b2reMap = this.getBeanToResEnvRefMap();
        if (b2reMap == null) {
            return;
        }
        Hashtable map = (Hashtable)b2reMap.get(bean);
        if (map == null) {
            return;
        }
        ResourceEnvRef ref = (ResourceEnvRef)map.get(this.prefix(RESOURCE_ENV_REF, name));
        map.remove(this.prefix(RESOURCE_ENV_REF, name));
        if (ref != null) {
            this.removeResourceEnvRef(ref);
        }
    }

    public void removeResourceEnvRef(ResourceEnvRef ref) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)this.getSunBaseBean()).removeResourceEnvRef(ref);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)this.getSunBaseBean()).removeResourceEnvRef(ref);
        } else if (this.isForEjb) {
            this.ejb.removeResourceEnvRef(ref);
        }
    }

    public ResourceEnvRef getResourceEnvRef(String refName) {
        Hashtable map = (Hashtable)this.getBeanToResEnvRefMap().get(this.getSunBaseBean());
        ResourceEnvRef ref = (ResourceEnvRef)map.get(this.prefix(RESOURCE_ENV_REF, refName));
        if (ref == null) {
            ResourceEnvRef[] refs = null;
            if (this.descriptor instanceof WebBundleDescriptor) {
                refs = ((SunWebApp)this.getSunBaseBean()).getResourceEnvRef();
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                refs = ((SunApplicationClient)this.getSunBaseBean()).getResourceEnvRef();
            } else if (this.isForEjb) {
                refs = this.ejb.getResourceEnvRef();
            }
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    if (!refs[i].getResourceEnvRefName().equals(refName)) continue;
                    ref = refs[i];
                    map.put(this.prefix(RESOURCE_ENV_REF, refName), ref);
                    break;
                }
            }
        }
        return ref;
    }

    public void addResourceRef(String oldName, String newName, String jndiName, String defaultPrincipalName, String defaultPrincipalPassword) {
        ResourceRef ref;
        SunBaseBean bean = this.getSunBaseBean();
        Hashtable b2rMap = this.getBeanToResRefMap();
        if (b2rMap == null) {
            return;
        }
        Hashtable<String, ResourceRef> map = (Hashtable<String, ResourceRef>)b2rMap.get(bean);
        if (map == null) {
            map = new Hashtable<String, ResourceRef>();
            this.getBeanToResRefMap().put(bean, map);
        }
        String name = newName;
        if (oldName != null) {
            name = oldName;
        }
        if ((ref = (ResourceRef)map.get(this.prefix(RESOURCE_REF, name))) == null) {
            ref = new ResourceRef();
            ref.setResRefName(newName);
            if (jndiName != null && !jndiName.equals("")) {
                ref.setJndiName(jndiName);
            }
            if (defaultPrincipalName != null || defaultPrincipalPassword != null) {
                DefaultResourcePrincipal principal = new DefaultResourcePrincipal();
                if (defaultPrincipalName != null) {
                    principal.setName(defaultPrincipalName);
                }
                if (defaultPrincipalPassword != null) {
                    principal.setPassword(defaultPrincipalPassword);
                }
                ref.setDefaultResourcePrincipal(principal);
            }
            map.put(this.prefix(RESOURCE_REF, newName), ref);
            this.addResourceRef(ref);
        } else {
            if (!name.equals(newName)) {
                map.remove(this.prefix(RESOURCE_REF, name));
                map.put(this.prefix(RESOURCE_REF, newName), ref);
            }
            ref.setResRefName(newName);
            if (jndiName != null) {
                ref.setJndiName(jndiName);
            }
            if (defaultPrincipalName != null || defaultPrincipalPassword != null) {
                DefaultResourcePrincipal principal = new DefaultResourcePrincipal();
                if (defaultPrincipalName != null) {
                    principal.setName(defaultPrincipalName);
                }
                if (defaultPrincipalPassword != null) {
                    principal.setPassword(defaultPrincipalPassword);
                }
                ref.setDefaultResourcePrincipal(principal);
            }
        }
    }

    public void addResourceRef(String name, String jndiName, String defaultPrincipalName, String defaultPrincipalPassword) {
        this.addResourceRef(null, name, jndiName, defaultPrincipalName, defaultPrincipalPassword);
    }

    public void addResourceRef(ResourceRef ref) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)this.getSunBaseBean()).addResourceRef(ref);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)this.getSunBaseBean()).addResourceRef(ref);
        } else if (this.isForEjb && this.ejb != null) {
            this.ejb.addResourceRef(ref);
        }
    }

    public void removeResourceRef(String name) {
        SunBaseBean bean = this.getSunBaseBean();
        Hashtable b2rMap = this.getBeanToResRefMap();
        if (b2rMap == null) {
            return;
        }
        Hashtable map = (Hashtable)b2rMap.get(bean);
        if (map == null) {
            return;
        }
        ResourceRef ref = (ResourceRef)map.get(this.prefix(RESOURCE_REF, name));
        map.remove(this.prefix(RESOURCE_REF, name));
        if (ref != null) {
            this.removeResourceRef(ref);
        }
    }

    public void removeResourceRef(ResourceRef ref) {
        if (this.descriptor instanceof WebBundleDescriptor) {
            ((SunWebApp)this.getSunBaseBean()).removeResourceRef(ref);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)this.getSunBaseBean()).removeResourceRef(ref);
        } else if (this.isForEjb) {
            this.ejb.removeResourceRef(ref);
        }
    }

    public ResourceRef getResourceRef(String refName) {
        Hashtable map = (Hashtable)this.getBeanToResRefMap().get(this.getSunBaseBean());
        ResourceRef ref = (ResourceRef)map.get(this.prefix(RESOURCE_REF, refName));
        if (ref == null) {
            ResourceRef[] refs = null;
            if (this.descriptor instanceof WebBundleDescriptor) {
                refs = ((SunWebApp)this.getSunBaseBean()).getResourceRef();
            } else if (this.descriptor instanceof ApplicationClientDescriptor) {
                refs = ((SunApplicationClient)this.getSunBaseBean()).getResourceRef();
            } else if (this.isForEjb) {
                refs = this.ejb.getResourceRef();
            }
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    if (!refs[i].getResRefName().equals(refName)) continue;
                    ref = refs[i];
                    map.put(this.prefix(RESOURCE_REF, refName), ref);
                    break;
                }
            }
        }
        return ref;
    }

    public void setResourceRefJndiName(String refName, String jndiName) {
        ResourceRef ref = this.getResourceRef(refName);
        if (jndiName == null || jndiName.equals("")) {
            if (ref == null) {
                return;
            }
            ref.setJndiName(null);
            return;
        }
        if (ref == null) {
            this.addResourceRef(refName, jndiName, null, null);
        } else {
            ref.setJndiName(jndiName);
        }
    }

    public void setResourceRefPrincipal(String refName, String principalName, String password) {
        ResourceRef ref = this.getResourceRef(refName);
        if (ref == null) {
            this.addResourceRef(refName, null, principalName, password);
        } else {
            DefaultResourcePrincipal principal = ref.getDefaultResourcePrincipal();
            if ((principalName == null || principalName.equals("")) && (password == null || password.equals(""))) {
                ref.setDefaultResourcePrincipal(null);
            } else {
                if (principal == null) {
                    principal = new DefaultResourcePrincipal();
                    ref.setDefaultResourcePrincipal(principal);
                }
                if (principalName != null) {
                    principal.setName(principalName);
                }
                if (password != null) {
                    principal.setPassword(password);
                }
            }
        }
    }

    public void reset() {
        this.beanToEjbRefMap = null;
        this.beanToResRefMap = null;
        this.beanToResEnvRefMap = null;
    }

    public String prefix(String pref, String name) {
        return name;
    }

    public void changed() {
        this.descriptor.changed();
    }
}

