/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared.sunone;

import com.sun.enterprise.tools.deployment.ui.shared.sunone.Groups;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.SunAssemblyToolData;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.Users;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ATData {
    private static final String AT_DATA_FILENAME = "SunAssemblyToolData.xml";
    private SunAssemblyToolData data = null;
    private static ATData singleton = null;
    private File dataFile = null;

    public ATData() {
        if (this.data == null) {
            this.loadData();
        }
    }

    public static ATData getSingleton() {
        if (singleton == null) {
            singleton = new ATData();
        }
        return singleton;
    }

    public boolean userExists(String userName) {
        return this.getUserNamesAsSet().contains(userName);
    }

    public boolean groupExists(String groupName) {
        return this.getGroupNamesAsSet().contains(groupName);
    }

    public void addUser(String userName) {
        Users users = this.data.getUsers();
        if (users == null) {
            users = new Users();
            this.data.setUsers(users);
        }
        if (!this.userExists(userName)) {
            users.addUserName(userName);
        }
    }

    public Users getUsers() {
        return this.data.getUsers();
    }

    public void removeUser(String name) {
        if (this.userExists(name)) {
            this.data.getUsers().removeUserName(name);
        }
    }

    public void removeGroup(String name) {
        if (this.groupExists(name)) {
            this.data.getGroups().removeGroupName(name);
        }
    }

    public Vector getUserNames() {
        String[] names = this.getUsers().getUserName();
        Vector<String> userNames = new Vector<String>();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                userNames.add(names[i]);
            }
        }
        return userNames;
    }

    public Set getUserNamesAsSet() {
        return new TreeSet(this.getUserNames());
    }

    public Groups getGroups() {
        return this.data.getGroups();
    }

    public void reset() {
        singleton = null;
    }

    public Vector getGroupNames() {
        String[] names = this.getGroups().getGroupName();
        Vector<String> groupNames = new Vector<String>();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                groupNames.add(names[i]);
            }
        }
        return groupNames;
    }

    public Set getGroupNamesAsSet() {
        return new TreeSet(this.getGroupNames());
    }

    public void addGroup(String groupName) {
        Groups groups = this.data.getGroups();
        if (groups == null) {
            groups = new Groups();
            this.data.setGroups(groups);
        }
        if (!this.groupExists(groupName)) {
            groups.addGroupName(groupName);
        }
    }

    public void loadData() {
        try {
            FileInputStream in = new FileInputStream(this.getDataFile());
            this.data = SunAssemblyToolData.createGraph(in);
            in.close();
            if (this.data.getUsers() == null) {
                this.data.setUsers(new Users());
            }
            if (this.data.getGroups() == null) {
                this.data.setGroups(new Groups());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isDataFileExists() {
        File file = new File(UIConfig.getConfigDirectory(), AT_DATA_FILENAME);
        return file.exists();
    }

    private void initData() {
        this.data = new SunAssemblyToolData();
        this.data.setUsers(new Users());
        this.data.setGroups(new Groups());
    }

    public File getDataFile() {
        try {
            if (this.dataFile == null) {
                this.dataFile = new File(UIConfig.getConfigDirectory(), AT_DATA_FILENAME);
            }
            if (!this.dataFile.exists()) {
                Print.dprintln((String)"file not exists, create new file");
                this.dataFile.createNewFile();
                this.initData();
                this.saveData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dataFile;
    }

    public void saveData() {
        try {
            FileOutputStream out = new FileOutputStream(this.getDataFile());
            this.data.write(out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

