/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RolesInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RolesInspector.class);
    private static final String DEFINED_ROLES = localStrings.getLocalString("ui.rolesinspector.defined_roles", "Defined Roles");
    private static final String ARCHIVE = localStrings.getLocalString("ui.rolesinspector.module", "Module");
    private static final String TABLE_NAME = localStrings.getLocalString("ui.rolesinspector.table.name", "Name");
    private static final String IMPORT_ROLES = localStrings.getLocalString("ui.rolesinspector.import_roles", "Import...");
    private static final String DEFINED_ROLES_ACC_DSC = localStrings.getLocalString("at.rolesinspector.defined_roles_acc_dsc", "Table to define and delete roles");
    private static final String DUPLICATE_ROLE_NAME = localStrings.getLocalString("at.rolesinspector.duplicate_role_name", "Duplicate Role Name");
    private static final String MISSING_ROLE_NAME = localStrings.getLocalString("at.rolesinspector.missing_role_name", "All defined roles must have a name");
    private static final String TABNAME = localStrings.getLocalString("ui.rolesinspector.tabname", "Roles");
    private static UIActionDispatcher importRolesAction = null;
    private static String wizardHelpID = "Role";
    private static String deployHelpID = "Role";
    private Roles descriptor = null;
    private UITitledTable rolesPanel = null;
    private UITitledTextField archiveName = null;
    private RolesTable rolesTable = null;
    private UIButton importPB = null;
    private UIButton addPB = null;
    private UIButton delPB = null;

    private static String EDIT_ROLES_FOR(String v0) {
        return localStrings.getLocalString("ui.rolesinspector.edit_roles_for", "Edit Roles for {0}", new Object[]{v0});
    }

    public static void setImportRolesAction(UIActionDispatcher importRoles) {
        importRolesAction = importRoles;
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new RolesInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return Roles.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        this.descriptor = desc instanceof Roles ? (Roles)desc : null;
        this.rolesTable.clearTableData();
    }

    private RolesInspector(String mode) {
        this(mode, false);
    }

    private RolesInspector(String mode, boolean showArchive) {
        this.setInspectorMode(mode);
        this._initLayout(showArchive);
    }

    private void _initLayout(boolean showArchive) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setToolTipText(DEFINED_ROLES_ACC_DSC);
        this.getAccessibleContext().setAccessibleDescription(DEFINED_ROLES_ACC_DSC);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        if (showArchive) {
            this.archiveName = new UITitledTextField(ARCHIVE, false);
            this.archiveName.setReadOnly(true);
            c.weighty = 0.0;
            c.fill = 2;
            this.add((Component)this.archiveName, c);
            ++c.gridy;
        }
        this.rolesPanel = new UITitledTable(DEFINED_ROLES, true);
        c.weighty = 0.5;
        c.fill = 1;
        this.add((Component)this.rolesPanel, c);
        this.rolesTable = new RolesTable(new RolesTableModel(new HashSet()));
        this.rolesPanel.setTableView(this.rolesTable);
        this.addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RolesInspector.this.addRoleAction();
            }
        });
        this.rolesPanel.addControlButton(this.addPB);
        this.delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RolesInspector.this.deleteRoleAction();
            }
        }, true);
        this.rolesPanel.addSelectionEnabledButton(this.delPB);
        this.importPB = new UIButton(IMPORT_ROLES, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RolesInspector.this.importRoles();
            }
        });
        this.rolesPanel.addControlButton(this.importPB);
        this.importPB.setVisible(importRolesAction != null);
    }

    public void refresh() {
        if (this.archiveName != null) {
            Descriptor d = this.getDescriptor();
            this.archiveName.setText(d != null ? d.getDisplayName() : "");
        }
        if (this.descriptor != null) {
            this.rolesTable.updateTableData(this.descriptor.getRoles());
        } else {
            this.rolesTable.clearTableData();
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.rolesPanel.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.rolesTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_ROLE_NAME);
            }
            return false;
        }
        return true;
    }

    protected void addRoleAction() {
        if (this.rolesTable.getRowWithValue(0, "") == null) {
            this.descriptor.addRole(new Role(""));
        }
        this.rolesTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    protected void deleteRoleAction() {
        Object[] list = this.rolesTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                Role ref = (Role)list[i];
                this.descriptor.removeRole(ref);
            }
        }
        this.invokeRefresh();
    }

    protected void importRoles() {
        if (importRolesAction != null) {
            importRolesAction.invoke(new Object[]{this.descriptor});
            this.refresh();
        } else {
            Print.dprintln((String)"No importRoles Action");
        }
    }

    private class TempRoles
    extends Descriptor
    implements Roles {
        private HashSet tempRoles;

        public TempRoles(Roles roles) {
            super("TempRoles", "");
            this.tempRoles = new HashSet();
            this.tempRoles.addAll(roles.getRoles());
        }

        public Set getRoles() {
            return this.tempRoles;
        }

        public void addRole(Role role) {
            this.tempRoles.remove(role);
            this.tempRoles.add(role);
            this.changed();
        }

        public void removeRole(Role role) {
            this.tempRoles.remove(role);
            this.changed();
        }
    }

    private class RolesTableModel
    extends InspectorTableModel {
        private boolean skipUpdate;

        public RolesTableModel(Set roleSet) {
            super(new ArrayList(roleSet), new String[]{TABLE_NAME, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.skipUpdate = false;
            super.setCompareWithEquals(true);
            super.setDataOrdering(1);
        }

        public Role getRow(int index) {
            return (Role)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            Role role = (Role)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = role.getName();
                    break;
                }
                case 1: {
                    value = role.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            Role role = (Role)obj;
            if (role == null) {
                return;
            }
            switch (col) {
                case 0: {
                    Set s = RolesInspector.this.descriptor.getRoles();
                    String valueLC = value.toString().toLowerCase();
                    boolean duplicate = false;
                    Iterator iter = s.iterator();
                    while (iter.hasNext()) {
                        Role r = (Role)iter.next();
                        String rLC = r.getName().toLowerCase();
                        if (!valueLC.equals(rLC)) continue;
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        Role newRole = new Role(value.toString());
                        if (role != null) {
                            newRole.setDescription(role.getDescription());
                            this.skipUpdate = true;
                            if (this.replaceRowObject(role, newRole) < 0) {
                                Print.dprintln((String)"Previous Role not found!");
                            }
                            RolesInspector.this.descriptor.removeRole(role);
                            this.skipUpdate = false;
                        }
                        RolesInspector.this.descriptor.addRole(newRole);
                        break;
                    }
                    UIOptionPane.showErrorDialog(RolesInspector.this, DUPLICATE_ROLE_NAME);
                    break;
                }
                case 1: {
                    role.setDescription(value.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _updateTableData(Collection c) {
            if (this.skipUpdate) {
                return;
            }
            List list = this.getData();
            synchronized (list) {
                if (c == null) {
                    try {
                        this.getData().clear();
                    }
                    catch (UnsupportedOperationException uso) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < this.getRowCount(); ++i) {
                    Role r1 = this.getRow(i);
                    for (int j = this.getRowCount() - 1; j > i; --j) {
                        Role r2 = this.getRow(j);
                        if (!r1.getName().equals(r2.getName())) continue;
                        this.getData().remove(r2);
                    }
                }
                Iterator i = this.getData().iterator();
                while (i.hasNext()) {
                    if (c != null && c.contains(i.next())) continue;
                    i.remove();
                }
                if (c != null) {
                    i = c.iterator();
                    while (i.hasNext()) {
                        this.addRowObject(i.next());
                    }
                }
            }
            this.fireTableRowsInserted(0, this.getRowCount() - 1);
        }
    }

    private class RolesTable
    extends InspectorTable {
        public RolesTable(RolesTableModel model) {
            super(model);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

