/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;

public class MsgDestRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MsgDestRefsInspector.class);
    private static String MSG_DEST_REFS_TBL_TITLE = localStrings.getLocalString("ui.msgdestrefsinspector.table.title", "Message Destination References");
    private static final String TABLE_CODED_NAME = localStrings.getLocalString("ui.msgdestrefsinspector.table.coded_name", "Coded Name");
    private static final String TABLE_TYPE = localStrings.getLocalString("ui.msgdestrefsinspector.table.type", "Type");
    private static final String TABLE_DEST_NAME = localStrings.getLocalString("ui.msgdestrefsinspector.table.dest_name", "Destination Name");
    private static final String TABLE_USAGE = localStrings.getLocalString("ui.msgdestrefsinspector.table.usage", "Usage");
    private static final String TABNAME = localStrings.getLocalString("ui.msgdestrefsinspector.tabname", "Msg Dest Refs");
    private static String wizardHelpID = "MsgDestRef";
    private static String deployHelpID = "MsgDestRef";
    protected MessageDestinationReferenceContainer descriptor = null;
    private UITitledTable msgRefsPanel = null;
    private MsgDestRefDialog mDRDialog = null;
    private static final String DIALOG_ADD_TITLE = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.add", "Add Message Destination Reference");
    private static final String DIALOG_EDIT_TITLE = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.edit_title", "Edit Message Destination Reference");
    private static final String MDR_REFERENCE = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.reference", "Reference");
    private static final String MDR_DIALOG_CODED_NAME = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.coded_name", "Coded Name:");
    private static final String MDR_DIALOG_DEST_TYPE = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.dest_type", "Destination Type:");
    private static final String MDR_DIALOG_USAGE = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.usage", "Usage:");
    private static final String MDR_TARGET_DESTINATION = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.target_destination", "Target Destination");
    private static final String MDR_DIALOG_DEST_NAME = localStrings.getLocalString("ui.msgdestrefsinspector.dialog.destination_name", "Destination Name:");
    private static String mDRDialogHelpSetMapID = "WWMDRDIALOG";

    public static InspectorPane newInspectorPane(String mode) {
        return new MsgDestRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return MessageDestinationReferenceContainer.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            this.descriptor = d instanceof MessageDestinationReferenceContainer ? (MessageDestinationReferenceContainer)d : null;
            this.msgRefsPanel.clear();
            this.resetFirstRefresh();
        }
    }

    protected MsgDestRefsInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        UITitledBox titledBox = new UITitledBox(MSG_DEST_REFS_TBL_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)titledBox, c);
        this.msgRefsPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(this.msgRefsPanel);
        this.msgRefsPanel.getGBConstraints().weighty = 0.85;
        this.msgRefsPanel.setTableView(new MsgRefsTable(new MsgRefsTableModel()));
        this.msgRefsPanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MsgDestRefsInspector.this.addEditMDRAction(null);
            }
        }, true));
        this.msgRefsPanel.addSelectionEnabledButton(UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MsgDestRefsInspector.this.addEditMDRAction(MsgDestRefsInspector.this.getSelectedMessageDestinationReferenceDescriptor());
            }
        }, true));
        this.msgRefsPanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MsgDestRefsInspector.this.deleteMDRAction();
            }
        }, true));
    }

    public void refresh() {
        this.msgRefsPanel.updateTableData(this.descriptor.getMessageDestinationReferenceDescriptors());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.msgRefsPanel.setReadOnly(state);
    }

    private void addEditMDRAction(MessageDestinationReferenceDescriptor sel) {
        if (this.mDRDialog == null) {
            this.mDRDialog = new MsgDestRefDialog(this.getMyParentFrame());
        }
        this.mDRDialog.setInitValues(sel);
        this.mDRDialog.setSize(380, 410);
        this.mDRDialog.setLocationRelativeTo(this);
        this.mDRDialog.show();
        this.invokeRefresh();
    }

    private void deleteMDRAction() {
        Object[] list = this.msgRefsPanel.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                MessageDestinationReferenceDescriptor ref = (MessageDestinationReferenceDescriptor)list[i];
                this.descriptor.removeMessageDestinationReferenceDescriptor(ref);
            }
        }
        this.invokeRefresh();
    }

    private MessageDestinationReferenceDescriptor getSelectedMessageDestinationReferenceDescriptor() {
        return (MessageDestinationReferenceDescriptor)this.msgRefsPanel.getSelectedRowObject();
    }

    protected Collection getMessageDesinationNames() {
        Vector mdList = new Vector();
        if (this.isWizardMode()) {
            Descriptor p = ((Wizard)this.getOwner()).getSelectedParentDescriptor();
            mdList.addAll(DescriptorTools.getMessageDestinationNames(p));
        }
        mdList.addAll(DescriptorTools.getMessageDestinationNames(this.getDescriptor()));
        return ListTools.sortList(mdList, true);
    }

    private class MsgDestRefDialog
    extends UIDialog {
        private MessageDestinationReferenceDescriptor msgDestRefDescOriginal;
        private MessageDestinationReferenceDescriptor msgDestRefDescCopy;
        private UITitledTextField txCodedName;
        private UITitledComboBox cbDestName;
        private UITitledComboBox cbUsage;
        private UITitledComboBox cbDestType;
        private DescriptionInspector.DialogDisplayButton descInspector;

        public MsgDestRefDialog(Frame owner) {
            super(owner, true);
            this.msgDestRefDescOriginal = null;
            this.msgDestRefDescCopy = null;
            this.txCodedName = null;
            this.cbDestName = null;
            this.cbUsage = null;
            this.cbDestType = null;
            this.descInspector = null;
            this.initDialogLayout();
        }

        public MsgDestRefDialog(Dialog owner) {
            super(owner, true);
            this.msgDestRefDescOriginal = null;
            this.msgDestRefDescCopy = null;
            this.txCodedName = null;
            this.cbDestName = null;
            this.cbUsage = null;
            this.cbDestType = null;
            this.descInspector = null;
            this.initDialogLayout();
        }

        private void setInitValues(MessageDestinationReferenceDescriptor mdrd) {
            this.msgDestRefDescOriginal = mdrd;
            if (this.msgDestRefDescOriginal != null) {
                this.setTitle(DIALOG_EDIT_TITLE);
                this.msgDestRefDescCopy = new MessageDestinationReferenceDescriptor(this.msgDestRefDescOriginal);
            } else {
                this.setTitle(DIALOG_ADD_TITLE);
                this.msgDestRefDescCopy = new MessageDestinationReferenceDescriptor();
            }
            this.txCodedName.setText(this.msgDestRefDescCopy.getDisplayName());
            this.cbDestType.setSelectedItem(this.msgDestRefDescCopy.getDestinationType());
            this.cbUsage.setSelectedItem(this.msgDestRefDescCopy.getUsage());
            this.descInspector.setDescriptionInspector((Descriptor)this.msgDestRefDescCopy);
            String mdLink = this.msgDestRefDescCopy.getMessageDestinationLinkName();
            Collection mdNames = MsgDestRefsInspector.this.getMessageDesinationNames();
            if (mdLink != null && !mdNames.contains(mdLink)) {
                mdNames.add(mdLink);
            }
            this.cbDestName.setModel(mdNames);
            this.cbDestName.setSelectedItem(mdLink);
        }

        private void initDialogLayout() {
            UITitledBox contentPanel = new UITitledBox(null, false);
            GridBagConstraints gbc = contentPanel.getGBConstraints();
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 5);
            UITitledBox referenceBox = new UITitledBox(MDR_REFERENCE, true);
            contentPanel.addWithGBConstraints(referenceBox);
            referenceBox.getGBConstraints().weighty = 0.0;
            referenceBox.getGBConstraints().insets = new Insets(4, 5, 4, 5);
            referenceBox.getGBConstraints().fill = 2;
            this.txCodedName = new UITitledTextField(MDR_DIALOG_CODED_NAME, false);
            this.txCodedName.setRequired(true);
            this.txCodedName.addActionListener(new ActionListener(this){
                private final /* synthetic */ MsgDestRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    MsgDestRefDialog.access$1300(this.this$1).setDisplayName(MsgDestRefDialog.access$1200(this.this$1).getText());
                }
            });
            referenceBox.addWithGBConstraints(this.txCodedName);
            this.cbDestType = new UITitledComboBox(MDR_DIALOG_DEST_TYPE, false);
            this.cbDestType.setModel(new String[]{"javax.jms.Queue", "javax.jms.Topic"});
            this.cbDestType.setRequired(true);
            this.cbDestType.setEditable(true);
            this.cbDestType.addActionListener(new ActionListener(this){
                private final /* synthetic */ MsgDestRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    MsgDestRefDialog.access$1300(this.this$1).setDestinationType((String)MsgDestRefDialog.access$1500(this.this$1).getSelectedItem());
                }
            });
            referenceBox.addWithGBConstraints(this.cbDestType);
            this.cbUsage = new UITitledComboBox(MDR_DIALOG_USAGE, false);
            this.cbUsage.setRequired(true);
            this.cbUsage.setModel(new String[]{"Consumes", "Produces", "ConsumesProduces"});
            this.cbUsage.addActionListener(new ActionListener(this){
                private final /* synthetic */ MsgDestRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    MsgDestRefDialog.access$1300(this.this$1).setUsage((String)MsgDestRefDialog.access$1700(this.this$1).getSelectedItem());
                }
            });
            referenceBox.addWithGBConstraints(this.cbUsage);
            this.descInspector = new DescriptionInspector.DialogDisplayButton();
            referenceBox.addWithGBConstraints(this.descInspector);
            UITitledBox targetDestBox = new UITitledBox(MDR_TARGET_DESTINATION, true);
            contentPanel.addWithGBConstraints(targetDestBox);
            targetDestBox.getGBConstraints().weighty = 0.0;
            targetDestBox.getGBConstraints().insets = new Insets(3, 5, 3, 5);
            targetDestBox.getGBConstraints().fill = 2;
            this.cbDestName = new UITitledComboBox(MDR_DIALOG_DEST_NAME, false);
            this.cbDestName.setEditable(true);
            this.cbDestName.addActionListener(new ActionListener(this){
                private final /* synthetic */ MsgDestRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String mddName = MsgDestRefDialog.access$2000(this.this$1).getText();
                    MsgDestRefDialog.access$1300(this.this$1).setMessageDestination(null);
                    MsgDestRefDialog.access$1300(this.this$1).setMessageDestinationLinkName(mddName);
                }
            });
            targetDestBox.addWithGBConstraints(this.cbDestName);
            UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
            dialogPane.setControlButtonLocation(101);
            dialogPane.setView(contentPanel);
            dialogPane.addControlButton(UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ MsgDestRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.okAction();
                }
            }));
            dialogPane.addControlButton(UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ MsgDestRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.cancelAction();
                }
            }));
            dialogPane.addControlButton(new UIHelpButton(mDRDialogHelpSetMapID));
            this.setContentPane(dialogPane);
        }

        public void okAction() {
            String dn = this.msgDestRefDescCopy.getDisplayName();
            if (dn == null || dn.equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.msgdestrefsinspector.dialog.error.coded_name", "Please provide a coded name"));
                return;
            }
            String dt = this.msgDestRefDescCopy.getDestinationType();
            if (dt == null || dt.equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.msgdestrefsinspector.dialog.error.destination_type", "Please provide a destination type"));
                return;
            }
            String us = this.msgDestRefDescCopy.getUsage();
            if (us == null || us.equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.msgdestrefsinspector.dialog.error.usage", "Please select a usage"));
                return;
            }
            if (this.msgDestRefDescOriginal != null) {
                this.msgDestRefDescOriginal.setDisplayName(this.msgDestRefDescCopy.getDisplayName());
                this.msgDestRefDescOriginal.setMessageDestination(null);
                this.msgDestRefDescOriginal.setMessageDestinationLinkName(this.msgDestRefDescCopy.getMessageDestinationLinkName());
                this.msgDestRefDescOriginal.setUsage(this.msgDestRefDescCopy.getUsage());
                this.msgDestRefDescOriginal.setDestinationType(this.msgDestRefDescCopy.getDestinationType());
            } else {
                MsgDestRefsInspector.this.descriptor.addMessageDestinationReferenceDescriptor(this.msgDestRefDescCopy);
            }
            this.hide();
        }

        public void cancelAction() {
            this.hide();
        }

        static /* synthetic */ UITitledTextField access$1200(MsgDestRefDialog x0) {
            return x0.txCodedName;
        }

        static /* synthetic */ MessageDestinationReferenceDescriptor access$1300(MsgDestRefDialog x0) {
            return x0.msgDestRefDescCopy;
        }

        static /* synthetic */ UITitledComboBox access$1500(MsgDestRefDialog x0) {
            return x0.cbDestType;
        }

        static /* synthetic */ UITitledComboBox access$1700(MsgDestRefDialog x0) {
            return x0.cbUsage;
        }

        static /* synthetic */ UITitledComboBox access$2000(MsgDestRefDialog x0) {
            return x0.cbDestName;
        }
    }

    public class MsgRefsTableModel
    extends InspectorTableModel {
        public MsgRefsTableModel() {
            super(new String[]{TABLE_CODED_NAME, TABLE_DEST_NAME, TABLE_TYPE, TABLE_USAGE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            MessageDestinationReferenceDescriptor ref = (MessageDestinationReferenceDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getMessageDestinationLinkName();
                    break;
                }
                case 2: {
                    value = ref.getDestinationType();
                    break;
                }
                case 3: {
                    value = ref.getUsage();
                    break;
                }
                case 4: {
                    value = ref.getDescription();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MessageDestinationReferenceDescriptor ref = (MessageDestinationReferenceDescriptor)obj;
        }
    }

    private class MsgRefsTable
    extends InspectorTable {
        public MsgRefsTable(MsgRefsTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

