/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.CommonDescriptorUtil;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIJndiName;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JmsDestinationRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JmsDestinationRefsInspector.class);
    private static String BOX_TITLE = localStrings.getLocalString("ui.jmsdestinationrefsinspector.resrc_env_refincode", "Resource Environment References in Code");
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.jmsdestinationrefsinspector.deployment_settings", "Sun-specific Settings");
    private static String JNDI_NAME = localStrings.getLocalString("ui.jmsdestinationrefsinspector.jndi_name", "JNDI Name:");
    private static String TABLE_TOOLTIP = localStrings.getLocalString("ui.jmsdestinationrefsinspector.table_tooltip", "Table of Resource Environment references");
    private static String TABLE_CODED_NAME = localStrings.getLocalString("ui.jmsdestinationrefsinspector.coded_name", "Coded Name");
    private static String TABLE_TYPE = localStrings.getLocalString("ui.jmsdestinationrefsinspector.type", "Type");
    private static String JNDI_NAME_TOOLTIP = localStrings.getLocalString("ui.jmsdestinationrefsinspector.linkvalue_tooltip", "Enter value for JNDI Name");
    private static String TABNAME = localStrings.getLocalString("ui.jmsdestinationrefsinspector.tabname", "Resource Env Refs");
    private static String wizardHelpID = "ResEnvRef";
    private static String deployHelpID = "ResEnvRef";
    private WritableJndiNameEnvironment descriptor;
    private CommonDescriptorUtil commonDescriptor = null;
    private UITitledTable jmsDestRefsPanel = null;
    private JmsDestRefsTable jmsDestRefsTable = null;
    private DeploymentSettingsBox deploymentSettingsPanel = null;
    private static String[] JMS_DEST_TYPES = new String[]{"javax.jms.Queue", "javax.jms.Topic"};

    private static String DEPLOYMENT_SETTINGS_FOR(String v0) {
        return localStrings.getLocalString("ui.jmsdestinationrefsinspector.deployment_settings_for", "Sun-specific Settings for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new JmsDestinationRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WritableJndiNameEnvironment.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)desc : null;
            this.jmsDestRefsTable.clearTableData();
            if (this.descriptor != null) {
                if (this.descriptor instanceof ApplicationClientDescriptor) {
                    this.commonDescriptor = new CommonDescriptorUtil((Descriptor)((ApplicationClientDescriptor)this.descriptor));
                } else if (this.descriptor instanceof WebBundleDescriptor) {
                    this.commonDescriptor = new CommonDescriptorUtil((Descriptor)((WebBundleDescriptor)this.descriptor));
                } else if (this.descriptor instanceof EjbDescriptor) {
                    this.commonDescriptor = new CommonDescriptorUtil((Descriptor)((EjbDescriptor)this.descriptor));
                }
            }
        }
    }

    private JmsDestinationRefsInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        UITitledBox titledBox = new UITitledBox(BOX_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)titledBox, c);
        this.jmsDestRefsPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(this.jmsDestRefsPanel);
        this.jmsDestRefsTable = new JmsDestRefsTable(new JmsDestRefsTableModel());
        this.jmsDestRefsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JmsDestinationRefsInspector.this.invokeRefresh();
            }
        });
        this.jmsDestRefsPanel.getGBConstraints().weighty = 0.85;
        this.jmsDestRefsPanel.setTableView(this.jmsDestRefsTable);
        UIButton addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JmsDestinationRefsInspector.this.addJmsDestRefAction();
            }
        });
        this.jmsDestRefsPanel.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JmsDestinationRefsInspector.this.deleteJmsDestRefAction();
            }
        }, true);
        this.jmsDestRefsPanel.addSelectionEnabledButton(delPB);
        this.deploymentSettingsPanel = new DeploymentSettingsBox();
        GridBagConstraints gbc = titledBox.getGBConstraints();
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        gbc.insets.right = 85;
        titledBox.addWithGBConstraints(this.deploymentSettingsPanel);
        this.deploymentSettingsPanel.setVisible(UIConfig.getConfigBoolean("/showDeploymentSettings"));
    }

    public void refresh() {
        this.jmsDestRefsTable.updateTableData(this.descriptor.getJmsDestinationReferenceDescriptors());
        this.deploymentSettingsPanel.setVisible(UIConfig.getConfigBoolean("/showDeploymentSettings"));
        this.selectAction();
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.jmsDestRefsPanel.setReadOnly(state);
        this.deploymentSettingsPanel.setReadOnly(state, true);
    }

    private JmsDestinationReferenceDescriptor getSelectedJmsDestReference() {
        return (JmsDestinationReferenceDescriptor)this.jmsDestRefsTable.getSelectedRowObject();
    }

    private void deSelectAction() {
        this.jmsDestRefsTable.clearSelection();
        this.deploymentSettingsPanel.selectRef(null);
    }

    private void selectAction() {
        JmsDestinationReferenceDescriptor ref = this.getSelectedJmsDestReference();
        if (ref != null) {
            this.deploymentSettingsPanel.selectRef(ref);
        } else {
            this.deSelectAction();
        }
    }

    private void addJmsDestRefAction() {
        if (this.jmsDestRefsTable.getRowWithValue(0, "") == null) {
            JmsDestinationReferenceDescriptor ref = new JmsDestinationReferenceDescriptor();
            ref.setDisplayName("");
            ref.setRefType("");
            ref.setDescription("");
            this.descriptor.addJmsDestinationReferenceDescriptor(ref);
        }
        this.jmsDestRefsTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteJmsDestRefAction() {
        Object[] list = this.jmsDestRefsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                JmsDestinationReferenceDescriptor ref = (JmsDestinationReferenceDescriptor)list[i];
                this.commonDescriptor.removeResourceEnvRef(ref.getName());
                this.descriptor.removeJmsDestinationReferenceDescriptor(ref);
            }
        }
        this.invokeRefresh();
    }

    public boolean hasEmptyRow() {
        return this.jmsDestRefsTable.getRowWithValue(0, "") != null;
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.hasEmptyRow()) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.jmsdestinationrefsinspector.missing_coded_name", "All references must specify a 'Coded Name'."));
            }
            return false;
        }
        if (this.jmsDestRefsTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.jmsdestinationrefsinspector.missing_type", "All Resource Environment References must specify a 'Type'."));
            }
            return false;
        }
        return true;
    }

    public class JmsDestRefsTableModel
    extends InspectorTableModel {
        JmsDestinationRefsInspector inspector;

        public JmsDestRefsTableModel() {
            super(new String[]{TABLE_CODED_NAME, TABLE_TYPE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            JmsDestinationReferenceDescriptor ref = (JmsDestinationReferenceDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getRefType();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            JmsDestinationReferenceDescriptor ref = (JmsDestinationReferenceDescriptor)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    String oldName = ref.getDisplayName();
                    String newName = value.toString();
                    if (newName.equals(oldName)) break;
                    if (JmsDestinationRefsInspector.this.commonDescriptor.getResourceEnvRef(newName) != null) {
                        UIOptionPane.showErrorDialog(null, localStrings.getLocalString("ui.jmsdestinationrefsinspector.dup_name", "Error: Duplicate Coded Name"));
                        break;
                    }
                    ref.setDisplayName(newName);
                    JmsDestinationRefsInspector.this.commonDescriptor.addResourceEnvRef(oldName, newName, ref.getJndiName());
                    break;
                }
                case 1: {
                    ref.setRefType(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            ((Descriptor)JmsDestinationRefsInspector.this.descriptor).changed();
        }
    }

    private class JmsDestRefsTable
    extends InspectorTable {
        public JmsDestRefsTable(JmsDestRefsTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class DeploymentSettingsBox
    extends UITitledBox {
        public UIJndiName jndiNameText;
        private JmsDestinationReferenceDescriptor selectedRef;

        public DeploymentSettingsBox() {
            super(DEPLOYMENT_SETTINGS, true);
            this.jndiNameText = null;
            this.selectedRef = null;
            this.initLayout();
        }

        private void initLayout() {
            this.jndiNameText = new UIJndiName();
            this.jndiNameText.setToolTipText(JNDI_NAME_TOOLTIP);
            this.jndiNameText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsBox this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    DeploymentSettingsBox.access$400(this.this$1);
                }
            });
            GridBagConstraints gbc = this.getGBConstraints();
            gbc.insets = new Insets(5, 5, 10, 25);
            this.addWithGBConstraints(this.jndiNameText);
            this.selectRef(null);
        }

        public void selectRef(JmsDestinationReferenceDescriptor ref) {
            this.selectedRef = ref;
            if (this.selectedRef == null) {
                this.setTitle(DEPLOYMENT_SETTINGS);
                this.jndiNameText.setEnabled(false);
            } else {
                this.setTitle(JmsDestinationRefsInspector.DEPLOYMENT_SETTINGS_FOR(this.selectedRef.getDisplayName()));
                ResourceEnvRef resEnvref = JmsDestinationRefsInspector.this.commonDescriptor.getResourceEnvRef(this.selectedRef.getDisplayName());
                String jndiName = resEnvref != null ? resEnvref.getJndiName() : null;
                this.jndiNameText.setJndiName(jndiName != null ? jndiName : "");
                this.jndiNameText.setEnabled(true);
            }
        }

        private void storeJndiNameValue() {
            if (this.selectedRef == null) {
                this.selectedRef = JmsDestinationRefsInspector.this.getSelectedJmsDestReference();
            }
            if (this.selectedRef != null) {
                this.selectedRef.setJndiName(JmsDestinationRefsInspector.this.deploymentSettingsPanel.getJndiName());
                if (JmsDestinationRefsInspector.this.commonDescriptor != null) {
                    JmsDestinationRefsInspector.this.commonDescriptor.addResourceEnvRef(this.selectedRef.getName(), this.selectedRef.getJndiName());
                }
                if (JmsDestinationRefsInspector.this.descriptor != null) {
                    ((Descriptor)JmsDestinationRefsInspector.this.descriptor).changed();
                }
                JmsDestinationRefsInspector.this.invokeRefresh();
            } else {
                Print.dprintln((String)"Expected a non-null selection!!!");
            }
        }

        public String getJndiName() {
            return this.jndiNameText.getJndiName();
        }

        static /* synthetic */ void access$400(DeploymentSettingsBox x0) {
            x0.storeJndiNameValue();
        }
    }
}

