/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;

public class IconInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(IconInspector.class);
    private static String SMALL_ICON = localStrings.getLocalString("ui.iconinspector.small_icon", "Small Icon (16x16)");
    private static String LARGE_ICON = localStrings.getLocalString("ui.iconinspector.large_icon", "Large Icon (32x32)");
    private static String ICON_INSPECTOR = localStrings.getLocalString("ui.iconinspector.icons", "Icons");
    private static String CHOOSE_ICON = localStrings.getLocalString("ui.iconinspector.choose_icon", "Choose Icon");
    private static String ICON_BUTTON = localStrings.getLocalString("ui.iconinspector.icon_button", "Icons...");
    private static char ICON_BUTTON_MNEMONIC = localStrings.getLocalString("ui.iconinspector.icon_button_mnemonic", "o").charAt(0);
    private static String HELP_ID = "Icons";
    private static String ICONS_YES = UIIcons.ICONS_ICON;
    private static String ICONS_NO = UIIcons.NO_ICONS_ICON;
    private static File smallIconStartingDir = null;
    private static File largeIconStartingDir = null;

    private static String ICON_INSPECTOR_FOR(Object v0) {
        return localStrings.getLocalString("ui.iconinspector.icons_for", "Icons for {0}", new Object[]{v0});
    }

    private static UIControlButtonBox getIconInspectorPane(final InspectorPanel iconInspector) {
        UIControlButtonBox iconInspectorContent = new UIControlButtonBox(null, false);
        iconInspectorContent.setControlButtonLocation(101);
        iconInspectorContent.setView(iconInspector);
        UIButton ok_btn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                iconInspector.updateIconsNow();
                WinTools.getAncestorDialog(c).hide();
            }
        });
        iconInspectorContent.addControlButton(ok_btn);
        UIButton cancel_btn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                WinTools.getAncestorDialog(c).hide();
            }
        });
        iconInspectorContent.addControlButton(cancel_btn);
        UIHelpButton help_btn = new UIHelpButton(HELP_ID);
        iconInspectorContent.addControlButton(help_btn);
        return iconInspectorContent;
    }

    private IconInspector() {
    }

    static /* synthetic */ String access$000() {
        return ICONS_YES;
    }

    static /* synthetic */ String access$100() {
        return ICONS_NO;
    }

    public static class InspectorPanel
    extends UITitledBox {
        private UITitledTextField smallIconTextField = null;
        private UITitledTextField largeIconTextField = null;
        private UpdateListener iconUpdater = null;
        private boolean modalPanelMode = false;
        private String smallIconPath = null;
        private File smallIconFile = null;
        private String largeIconPath = null;
        private File largeIconFile = null;

        public InspectorPanel(UpdateListener iconUpdater) {
            this(iconUpdater, false);
        }

        public InspectorPanel(UpdateListener iconUpdater, boolean modalPanelMode) {
            super(ICON_INSPECTOR, true);
            this.modalPanelMode = modalPanelMode;
            this.smallIconTextField = new UITitledTextField(SMALL_ICON, false);
            this.smallIconTextField.addActionListener(new ActionListener(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent c) {
                    this.this$0.addSmallAction(InspectorPanel.access$800(this.this$0).getText());
                }
            });
            this.smallIconTextField.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.addSmallAction(null);
                }
            });
            this.addWithGBConstraints(this.smallIconTextField);
            this.largeIconTextField = new UITitledTextField(LARGE_ICON, false);
            this.largeIconTextField.addActionListener(new ActionListener(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent c) {
                    this.this$0.addLargeAction(InspectorPanel.access$1000(this.this$0).getText());
                }
            });
            this.largeIconTextField.setBrowserActionListener(new ActionListener(this){
                private final /* synthetic */ InspectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.addLargeAction(null);
                }
            });
            this.addWithGBConstraints(this.largeIconTextField);
            this.setUpdateListener(iconUpdater);
        }

        protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c) {
            c = super.getDefaultGBConstraints(c);
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 5, 0);
            c.fill = 2;
            c.anchor = 10;
            return c;
        }

        public void addSmallAction(String pathName) {
            if (pathName == null) {
                File startDir = null;
                String startDirPath = this.smallIconTextField.getText();
                startDir = !startDirPath.equals("") ? new File(startDirPath) : (smallIconStartingDir != null ? smallIconStartingDir : largeIconStartingDir);
                UIFileChooser jfc = UIFileChooser.getFileChooser(startDir, "ImageFiles");
                int returnValue = ((JFileChooser)jfc).showDialog(this, CHOOSE_ICON);
                if (returnValue != 0) {
                    return;
                }
                smallIconStartingDir = jfc.getCurrentDirectory();
                this.smallIconFile = ((JFileChooser)jfc).getSelectedFile().getAbsoluteFile();
                Print.dprintln((String)("SmallIconFile: " + this.smallIconFile));
                if (this.modalPanelMode || this.iconUpdater == null) {
                    this.smallIconPath = this.smallIconFile.getPath();
                } else {
                    this.iconUpdater.addSmallIcon(this.smallIconFile);
                    this.smallIconPath = this.iconUpdater.getSmallIconUri();
                }
                this.smallIconTextField.setText(this.smallIconPath);
            } else if (!pathName.equals("")) {
                this.smallIconFile = new File(pathName);
                this.smallIconPath = this.smallIconFile.getPath();
            } else {
                this.smallIconFile = null;
                this.smallIconPath = null;
            }
        }

        public void addLargeAction(String pathName) {
            if (pathName == null) {
                File startDir = null;
                String startDirPath = this.largeIconTextField.getText();
                startDir = !startDirPath.equals("") ? new File(startDirPath) : (largeIconStartingDir != null ? largeIconStartingDir : smallIconStartingDir);
                UIFileChooser jfc = UIFileChooser.getFileChooser(startDir, "ImageFiles");
                int returnValue = ((JFileChooser)jfc).showDialog(this, CHOOSE_ICON);
                if (returnValue != 0) {
                    return;
                }
                largeIconStartingDir = jfc.getCurrentDirectory();
                this.largeIconFile = ((JFileChooser)jfc).getSelectedFile().getAbsoluteFile();
                if (this.modalPanelMode || this.iconUpdater == null) {
                    this.largeIconPath = this.largeIconFile.getPath();
                } else {
                    this.iconUpdater.addLargeIcon(this.largeIconFile);
                    this.largeIconPath = this.iconUpdater.getLargeIconUri();
                }
                this.largeIconTextField.setText(this.largeIconPath);
            } else if (!pathName.equals("")) {
                this.largeIconFile = new File(pathName);
                this.largeIconPath = this.largeIconFile.getPath();
            } else {
                this.largeIconFile = null;
                this.largeIconPath = null;
            }
        }

        public UpdateListener getUpdateListener() {
            return this.iconUpdater;
        }

        public void setUpdateListener(UpdateListener iconUpdater) {
            this.iconUpdater = iconUpdater;
            if (this.iconUpdater != null) {
                this.smallIconPath = this.iconUpdater.getSmallIconUri();
                this.largeIconPath = this.iconUpdater.getLargeIconUri();
            } else {
                this.smallIconPath = "";
                this.largeIconPath = "";
            }
            this.smallIconTextField.setText(this.smallIconPath);
            this.largeIconTextField.setText(this.largeIconPath);
        }

        public void updateIconsNow() {
            if (this.iconUpdater != null) {
                this.iconUpdater.addSmallIcon(this.smallIconFile);
                this.smallIconPath = this.iconUpdater.getSmallIconUri();
                this.iconUpdater.addLargeIcon(this.largeIconFile);
                this.largeIconPath = this.iconUpdater.getLargeIconUri();
            }
        }

        public void setDescriptor(Descriptor obj) {
            this.smallIconPath = this.iconUpdater.getSmallIconUri();
            this.smallIconTextField.setText(this.smallIconPath);
            this.largeIconPath = this.iconUpdater.getLargeIconUri();
            this.largeIconTextField.setText(this.largeIconPath);
        }

        static /* synthetic */ UITitledTextField access$800(InspectorPanel x0) {
            return x0.smallIconTextField;
        }

        static /* synthetic */ UITitledTextField access$1000(InspectorPanel x0) {
            return x0.largeIconTextField;
        }
    }

    public static class DialogDisplayButton
    extends UIButton
    implements ActionListener {
        private static final Icon hasIcons_true = IconInspector.access$000() != null ? UIIcons.getImageIconFor(IconInspector.access$000()) : null;
        private static final Icon hasIcons_false = IconInspector.access$100() != null ? UIIcons.getImageIconFor(IconInspector.access$100()) : null;
        private String titleName = null;
        private UpdateListener iconUpdater = null;
        private InspectorPanel iconInspector = null;
        private UIDialog iconDialog = null;
        private boolean hasIcons = true;

        public DialogDisplayButton(UpdateListener iconUpdater) {
            super(ICON_BUTTON, ICON_BUTTON_MNEMONIC);
            this.setHasIcons(false);
            this.iconUpdater = iconUpdater;
            super.addActionListener(this);
        }

        public void setHasIcons(boolean state) {
            if (this.hasIcons != state) {
                this.hasIcons = state;
                this.setIcon(state ? hasIcons_true : hasIcons_false);
            }
        }

        public void setTitleName(String name) {
            this.titleName = name;
        }

        public void actionPerformed(ActionEvent ae) {
            Window win = WinTools.getAncestorWindow(this);
            if (win == null) {
                Print.printStackTrace((String)"parent frame not found for component");
                return;
            }
            if (this.iconDialog == null) {
                this.iconDialog = UIDialog.newDialog(win, true);
                this.iconDialog.doNothingOnClose();
                this.iconInspector = new InspectorPanel(null, true);
                this.iconDialog.setContentPane(IconInspector.getIconInspectorPane(this.iconInspector));
            }
            this.iconInspector.setUpdateListener(this.iconUpdater);
            String n = this.iconUpdater.getIconInspectorName();
            this.iconDialog.setTitle(n == null || n.equals("") ? ICON_INSPECTOR : IconInspector.ICON_INSPECTOR_FOR(n));
            Rectangle newBounds = win.getBounds();
            Dimension d = new Dimension(380, 205);
            newBounds.x += 20;
            newBounds.y += 20;
            newBounds.width = d.width;
            newBounds.height = d.height;
            this.iconDialog.setBounds(newBounds);
            this.iconDialog.show();
            this.iconInspector.setUpdateListener(null);
            this.iconDialog.setTitle(ICON_INSPECTOR);
        }
    }

    public static interface UpdateListener {
        public String getIconInspectorName();

        public String getLargeIconUri();

        public void addLargeIcon(File var1);

        public String getSmallIconUri();

        public void addSmallIcon(File var1);
    }
}

