/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EnvironmentPropertyTable
extends UITitledTable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnvironmentPropertyTable.class);
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.environmentpropertytable.title", "Environment Properties");
    private static final String TABLE_PARAMETER = localStrings.getLocalString("ui.environmentpropertytable.column.property", "Property");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.environmentpropertytable.column.value", "Value");
    private EnvPropertyTable envPropTable = null;
    private UIButton addButton = null;
    private UIButton delButton = null;
    protected Descriptor descriptor = null;

    public EnvironmentPropertyTable() {
        super(TABLE_TITLE, true);
        this.initLayout();
    }

    private void initLayout() {
        this.envPropTable = new EnvPropertyTable(new EnvPropertyTableModel());
        this.setTableView(this.envPropTable);
        this.addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnvironmentPropertyTable.this.addAction();
            }
        });
        this.addControlButton(this.addButton);
        this.delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EnvironmentPropertyTable.this.deleteAction();
            }
        }, true);
        this.addSelectionEnabledButton(this.delButton);
    }

    public void setDescriptor(Descriptor d) {
        this.descriptor = d;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void refresh() {
    }

    public void addRecord() {
        Print.printStackTrace((String)"This should be overridden");
    }

    public void deleteRecord(Object ref) {
        Print.printStackTrace((String)"This should be overridden");
    }

    public void changed() {
    }

    private void addAction() {
        if (this.envPropTable.getRowWithValue(0, "") == null) {
            this.addRecord();
        }
        this.envPropTable.selectRowWithValueOnUpdate(0, "");
        this.refresh();
    }

    private void deleteAction() {
        Object[] list = this.envPropTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this.deleteRecord(list[i]);
            }
            this.refresh();
        }
    }

    private class EnvPropertyTableModel
    extends InspectorTableModel {
        public EnvPropertyTableModel() {
            super(new String[]{TABLE_PARAMETER, TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setDisplayName(value.toString());
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            EnvironmentPropertyTable.this.changed();
        }
    }

    private class EnvPropertyTable
    extends InspectorTable {
        public EnvPropertyTable(EnvPropertyTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

