/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DescriptionInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DescriptionInspector.class);
    private static final String DESCRIPTION_TITLE = localStrings.getLocalString("ui.descriptioninspector.description_title", "Description");
    private static final String DESCRIPTION_TEXT = localStrings.getLocalString("ui.descriptioninspector.description_button", "Description...");
    private static final char DESCRIPTION_TEXT_MNEMONIC = localStrings.getLocalString("ui.descriptioninspector.description_button_mnemonic", "D").charAt(0);
    private static final String DESCRIPTION_LABEL = "D";
    private static String DESCRIPTION_ICON_YES = UIIcons.DESCRIPTION_ICON;
    private static String DESCRIPTION_ICON_NO = UIIcons.NO_DESCRIPTION_ICON;
    private static final String help_id = "Description";
    public static String DESCRIPTION_COLUMN_INIT = "*DESCRIPTION_INSPECTOR*";
    private static Vector descriptionInspectorList = new Vector();
    private static Rectangle lastFrameBounds = null;
    private DescriptionFrame descInspectorFrame = null;
    private UIControlButtonBox descInspectorPane = null;
    private DescriptionTextArea descInspectorText = null;
    private Window dialogOwner = null;
    private String originalDescription = "";
    private UIButton descButton_OK = null;
    private UIButton descButton_APPLY = null;
    private UIButton descButton_CANCEL = null;
    private boolean isReadOnly = false;

    private static final String DESCRIPTION_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.descriptioninspector.description_title_for", "Description for {0}", new Object[]{v0});
    }

    private DescriptionInspector(Window owner) {
        this.dialogOwner = owner;
        descriptionInspectorList.add(this);
        this.initInspectorPane();
        this.dialogOwner.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent we) {
                boolean didHide = DescriptionInspector.this.hideOtherInspectors();
                if (didHide) {
                    DescriptionFrame frame = DescriptionInspector.this.initInspectorFrame();
                    frame.setBounds(lastFrameBounds);
                    frame.show();
                }
            }

            public void windowClosed(WindowEvent we) {
                descriptionInspectorList.remove(DescriptionInspector.this);
            }
        });
    }

    public DescriptionInspector(Frame owner) {
        this((Window)owner);
    }

    public DescriptionInspector(Dialog owner) {
        this((Window)owner);
    }

    public DescriptionInspector(Component owner) {
        this(WinTools.getAncestorWindow(owner));
    }

    private void initInspectorPane() {
        this.descInspectorPane = new UIControlButtonBox(null, false);
        this.descInspectorPane.setControlButtonLocation(101);
        this.descInspectorPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
        this.descInspectorText = new DescriptionTextArea(false, true);
        this.descInspectorPane.setView(this.descInspectorText);
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("ok")) {
                    DescriptionInspector.this.originalDescription = DescriptionInspector.this.descInspectorText.getText();
                    DescriptionInspector.this.descInspectorText.updateDescriptionNow();
                    DescriptionInspector.this.cancelInspector(false);
                } else if (cmd.equals("apply")) {
                    DescriptionInspector.this.originalDescription = DescriptionInspector.this.descInspectorText.getText();
                    DescriptionInspector.this.descInspectorText.updateDescriptionNow();
                    DescriptionInspector.this.descButton_APPLY.setEnabled(false);
                } else if (cmd.equals("cancel")) {
                    DescriptionInspector.this.cancelInspector(false);
                }
            }
        };
        this.descButton_OK = UIButton.createOkButton(buttonListener);
        this.descButton_OK.setEnabled(false);
        this.descInspectorPane.addControlButton(this.descButton_OK);
        this.descButton_APPLY = UIButton.createApplyButton(buttonListener);
        this.descButton_APPLY.setEnabled(false);
        this.descInspectorPane.addControlButton(this.descButton_APPLY);
        this.descButton_CANCEL = UIButton.createCancelButton(buttonListener);
        this.descInspectorPane.addControlButton(this.descButton_CANCEL);
        this.descInspectorPane.addControlButton(new UIHelpButton(help_id));
        this.descInspectorText.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ke) {
                if (!DescriptionInspector.this.isReadOnly() && !DescriptionInspector.this.descButton_APPLY.isEnabled()) {
                    DescriptionInspector.this.descButton_APPLY.setEnabled(true);
                }
            }
        });
    }

    private DescriptionFrame initInspectorFrame() {
        if (this.descInspectorFrame == null) {
            Window window = WinTools.getAncestorWindow(this.dialogOwner);
            if (window == null) {
                Print.printStackTrace((String)"parent frame not found for component");
                return this.descInspectorFrame;
            }
            if (window instanceof Dialog) {
                this.descInspectorFrame = new DescriptionFrame((Dialog)window, (JPanel)this.descInspectorPane, this.descInspectorText);
                window.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent we) {
                        Dialog d = (Dialog)we.getSource();
                        if (DescriptionInspector.this.descInspectorFrame != null && d == DescriptionInspector.this.descInspectorFrame.getOwner()) {
                            DescriptionInspector.this.cancelInspector(true);
                        }
                    }
                });
            } else if (window instanceof Frame) {
                this.descInspectorFrame = new DescriptionFrame((Frame)window, (JPanel)this.descInspectorPane, this.descInspectorText);
            }
            if (lastFrameBounds == null) {
                Rectangle b = window.getBounds();
                Dimension d = this.descInspectorFrame.getPreferredSize();
                b.x += 20;
                b.y += 20;
                b.width = d.width;
                b.height = d.height;
                lastFrameBounds = b;
            }
            this.descInspectorFrame.setBounds(lastFrameBounds);
            this.descInspectorFrame.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent ce) {
                    lastFrameBounds = DescriptionInspector.this.descInspectorFrame.getBounds();
                }

                public void componentResized(ComponentEvent ce) {
                    lastFrameBounds = DescriptionInspector.this.descInspectorFrame.getBounds();
                }
            });
        }
        this.descInspectorText.setText(this.originalDescription);
        this.descInspectorFrame.updateTitle();
        return this.descInspectorFrame;
    }

    private void cancelInspector(boolean dispose) {
        if (this.descInspectorFrame != null) {
            if (dispose) {
                this.descInspectorFrame.setContentPane(new UIPanel());
                this.descInspectorFrame.dispose();
                this.descInspectorFrame = null;
            } else {
                this.descInspectorText.setText(this.originalDescription);
                this.hideInspector();
            }
        }
    }

    public void showDescriptionInspector() {
        this.initInspectorFrame().show();
    }

    public void hideInspector() {
        if (this.descInspectorFrame != null) {
            this.descInspectorFrame.hide();
        }
    }

    public boolean hideOtherInspectors() {
        boolean wasVisible = false;
        Enumeration enumeration = descriptionInspectorList.elements();
        while (enumeration.hasMoreElements()) {
            DescriptionInspector d = (DescriptionInspector)enumeration.nextElement();
            if (d == this || !d.isInspectorVisible()) continue;
            wasVisible = true;
            d.hideInspector();
        }
        return wasVisible;
    }

    public boolean isInspectorVisible() {
        return this.descInspectorFrame != null && this.descInspectorFrame.isShowing();
    }

    public void clearDescription() {
        this.clearDescription(false);
    }

    public void clearDescription(boolean rdonly) {
        this.setDescription(null, null, null, null, rdonly);
    }

    public void setDescription(String descr, String refName, Vector updList, Object refObj) {
        this.setDescription(descr, refName, updList, refObj, false);
    }

    public void setDescription(String descr, String refName, Vector updList, Object refObj, boolean rdonly) {
        this.originalDescription = updList != null && updList.size() > 0 ? descr : "";
        this.setReadOnly(rdonly);
        this.descInspectorText.setDescription(descr, refName, updList, refObj);
        if (this.descInspectorFrame != null) {
            this.descInspectorFrame.updateTitle();
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        this.isReadOnly = state;
        this.descInspectorText.setReadOnly(state, true);
        this.descButton_OK.setReadOnly(state);
        this.descButton_APPLY.setReadOnly(state);
    }

    public static DescriptionInspector findDescriptionInspector(Component comp) {
        DescriptionInspectorManager dim = (DescriptionInspectorManager)((Object)WinTools.getAncestorOfClass(DescriptionInspectorManager.class, comp));
        if (dim != null) {
            return dim.getDescriptionInspector();
        }
        return null;
    }

    public static void addDescriptionColumnToTable(JTable table) {
        int modelColumnIndex = table.getModel().getColumnCount();
        int tableColumnIndex = table.getColumnCount();
        table.addColumn(new TableColumn(modelColumnIndex));
        DescriptionInspector.setDescriptionColumnForTable(table, modelColumnIndex);
    }

    public static void setDescriptionColumnForTable(JTable table, int column) {
        int columnWidth = 25;
        TableColumn descCol = table.getColumnModel().getColumn(column);
        descCol.setCellRenderer(new DescriptionCellRenderer());
        descCol.setCellEditor(new DescriptionCellEditor(table));
        descCol.setHeaderRenderer(new DescriptionColumnLabel());
        descCol.setMinWidth(columnWidth);
        descCol.setMaxWidth(columnWidth);
        descCol.setPreferredWidth(columnWidth);
        table.sizeColumnsToFit(column);
    }

    static /* synthetic */ String access$1200() {
        return DESCRIPTION_ICON_YES;
    }

    static /* synthetic */ String access$1300() {
        return DESCRIPTION_ICON_NO;
    }

    private static class DescriptionColumnLabel
    extends InspectorTable.TableIconColumnRenderer {
        private static final Icon columnIcon = DescriptionInspector.access$1200() != null ? UIIcons.getImageIconFor(DescriptionInspector.access$1200()) : null;

        public DescriptionColumnLabel() {
            super(columnIcon, DescriptionInspector.DESCRIPTION_LABEL);
        }
    }

    private static class DescriptionCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTable table = null;

        public DescriptionCellEditor(JTable table) {
            super(new UICheckBox());
            this.table = table;
        }

        public boolean isCellEditable(EventObject anEvent) {
            DescriptionInspector din;
            if (this.table instanceof InspectorTable) {
                ((InspectorTable)this.table).showSelectedDescription();
            }
            if ((din = DescriptionInspector.findDescriptionInspector(this.table)) != null) {
                din.showDescriptionInspector();
            } else {
                Print.dprintln((String)"DescriptionInspector not found!");
            }
            return false;
        }
    }

    private static class DescriptionCellRenderer
    implements TableCellRenderer {
        private DialogDisplayButton iconButton = new DialogDisplayButton(true);

        private DescriptionCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color selColor = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.iconButton.setBackground(selColor);
            if (value == null) {
                this.iconButton.setHasDescription(false);
                return this.iconButton;
            }
            if (value instanceof Boolean) {
                this.iconButton.setHasDescription((Boolean)value);
                return this.iconButton;
            }
            if (value instanceof String) {
                this.iconButton.setHasDescription(!((String)value).equals(""));
                return this.iconButton;
            }
            Print.printStackTrace((String)("Unsupported value class '" + UIUtils.debugClassName(value) + "'"));
            JLabel jl = new JLabel(value.toString());
            Object[] obj = new Object[]{value.toString()};
            jl.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.descriptioninspector.label_name", "Name is {0}", obj));
            jl.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.descriptioninspector.label_desc", "This is Label for {0}", obj));
            return jl;
        }
    }

    public static class DialogDisplayButton
    extends UIButton
    implements ActionListener {
        private static final Icon hasDescription_true = DescriptionInspector.access$1200() != null ? UIIcons.getImageIconFor(DescriptionInspector.access$1200()) : null;
        private static final Icon hasDescription_false = DescriptionInspector.access$1300() != null ? UIIcons.getImageIconFor(DescriptionInspector.access$1300()) : null;
        private InspectorPane inspectorPane = null;
        private boolean isIconButton = false;
        private boolean hasDescription = false;
        private UpdateListener descriptorUpdater = null;

        public DialogDisplayButton() {
            this(false);
        }

        public DialogDisplayButton(InspectorPane insp) {
            this(false);
            if (insp != null) {
                this.inspectorPane = insp;
                this.inspectorPane.addDescriptionButtonUpdate(this);
            }
        }

        public DialogDisplayButton(boolean isIconButton) {
            this.addActionListener(this);
            this.hasDescription = true;
            this.setHasDescription(false);
            this.isIconButton = isIconButton;
            if (this.isIconButton) {
                this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                this.setMargin(new Insets(0, 0, 0, 0));
            } else {
                UIButton.setButtonText((AbstractButton)this, DESCRIPTION_TEXT, DESCRIPTION_TEXT_MNEMONIC);
            }
        }

        public boolean hasDescription() {
            return this.hasDescription;
        }

        public void setHasDescription(boolean state) {
            if (this.hasDescription != state) {
                this.hasDescription = state;
                this.setIcon(state ? hasDescription_true : hasDescription_false);
            }
        }

        public void setDescriptionInspector(String description, String refName, UpdateListener listener, Object refObject) {
            if (this.inspectorPane != null) {
                this.inspectorPane._setDescriptionInspector(description, refName, listener, refObject);
            } else {
                DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this);
                if (din != null) {
                    Vector<UpdateListener> list = new Vector<UpdateListener>();
                    list.add(listener);
                    din.setDescription(description, refName, list, refObject, this.isReadOnly());
                }
            }
        }

        public void setDescriptionInspector(Descriptor d, UpdateListener listener) {
            this.setDescriptionInspector(d.getDescription(), DescriptorTools.getDisplayName(d), listener, d);
        }

        public void setDescriptionInspector(Descriptor d) {
            if (d != null) {
                if (this.descriptorUpdater == null) {
                    this.descriptorUpdater = new UpdateListener(this){
                        private final /* synthetic */ DialogDisplayButton this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void descriptionUpdated(String desc, Object ref) {
                            ((Descriptor)ref).setDescription(desc);
                        }
                    };
                }
                this.setDescriptionInspector(d, this.descriptorUpdater);
            } else {
                this.clearDescriptionInspector();
            }
        }

        public void clearDescriptionInspector() {
            if (this.inspectorPane != null) {
                this.inspectorPane._clearDescriptionInspector();
            } else {
                DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this);
                if (din != null) {
                    din.clearDescription();
                }
            }
        }

        public void actionPerformed(ActionEvent ae) {
            Component comp = (Component)ae.getSource();
            DescriptionInspector din = DescriptionInspector.findDescriptionInspector(comp);
            if (din != null) {
                din.setReadOnly(this.isReadOnly());
                din.showDescriptionInspector();
            } else {
                Print.dprintln((String)"DescriptionInspector not found!");
            }
        }

        public void setReadOnly(boolean state) {
            DescriptionInspector din;
            super.setReadOnly(state, false);
            if (this.inspectorPane == null && (din = DescriptionInspector.findDescriptionInspector(this)) != null) {
                din.setReadOnly(this.isReadOnly());
            }
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state, false);
        }
    }

    private class DescriptionFrame
    extends UIDialog {
        private DescriptionTextArea textArea;

        public DescriptionFrame(Frame frame, JPanel inspPane, DescriptionTextArea textArea) {
            super(frame, true);
            this.textArea = null;
            this.initFrame(inspPane, textArea);
        }

        public DescriptionFrame(Dialog dialog, JPanel inspPane, DescriptionTextArea textArea) {
            super(dialog, true);
            this.textArea = null;
            this.initFrame(inspPane, textArea);
        }

        private void initFrame(JPanel inspPane, DescriptionTextArea text) {
            this.textArea = text;
            this.setContentPane(inspPane);
            this.setDefaultCloseOperation(0);
        }

        public Dimension getPreferredSize() {
            return new Dimension(500, 205);
        }

        public void updateTitle() {
            String dn = this.textArea.getDescriptorName();
            this.setTitle(dn == null ? DESCRIPTION_TITLE : DescriptionInspector.DESCRIPTION_TITLE_FOR(dn));
            DescriptionInspector.this.descButton_OK.setEnabled(this.textArea.getUpdaterList() != null);
            DescriptionInspector.this.descButton_APPLY.setEnabled(false);
        }
    }

    private static class DescriptionTextArea
    extends UITitledTextArea {
        private Vector updaterList = null;
        private UpdateListener updater = null;
        private String refName = null;
        private Object refObject = null;
        private boolean hasWindowFrame = false;

        public DescriptionTextArea() {
            this(false, false);
        }

        public DescriptionTextArea(boolean showBorder) {
            this(showBorder, false);
        }

        public DescriptionTextArea(boolean showBorder, boolean hasWindowFrame) {
            super(showBorder || !hasWindowFrame ? DESCRIPTION_TITLE : null, showBorder);
            this.hasWindowFrame = hasWindowFrame;
            this.clearDescription();
        }

        public void setDescription(String description, String refName, Vector updaterList, Object refObject) {
            this.updaterList = updaterList;
            if (this.updaterList != null) {
                Enumeration enumeration = this.updaterList.elements();
                while (enumeration.hasMoreElements()) {
                    if (enumeration.nextElement() != null) continue;
                    Print.printStackTrace((String)"'updaterList' contains a null entry!");
                    break;
                }
                this.refName = refName;
                this.refObject = refObject;
                this.setEnabled(true);
                this.setText(description != null ? description : "");
            } else {
                this.refName = null;
                this.refObject = null;
                this.removeAllActionListeners();
                this.setEnabled(false);
                this.setText("");
            }
            if (this.hasTitle()) {
                this.setTitle(this.refName == null ? DESCRIPTION_TITLE : DescriptionInspector.DESCRIPTION_TITLE_FOR(this.refName));
            }
        }

        public void clearDescription() {
            this.setDescription(null, null, null, null);
        }

        public Vector getUpdaterList() {
            return this.updaterList;
        }

        public String getDescriptorName() {
            return this.refName;
        }

        public Object getReference() {
            return this.refObject;
        }

        public void setText(String text) {
            super.setText(text);
        }

        protected void updateComponent() {
            if (!this.hasWindowFrame) {
                this.updateDescriptionNow();
            }
        }

        protected void updateDescriptionNow() {
            if (this.updaterList != null) {
                Enumeration enumeration = this.updaterList.elements();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    if (obj instanceof UpdateListener) {
                        String desc = this.getText();
                        if (desc != null && desc.equals("")) {
                            desc = null;
                        }
                        ((UpdateListener)obj).descriptionUpdated(desc, this.getReference());
                        continue;
                    }
                    if (obj == null) {
                        Print.dprintln((String)"'null' UpdateListener found!");
                        continue;
                    }
                    Print.printStackTrace((String)("Class does not implement UpdateListener - " + DT.className(obj)));
                }
            } else {
                Print.printStackTrace((String)"updaterList == null !!!");
            }
        }
    }

    public static interface UpdateListener {
        public void descriptionUpdated(String var1, Object var2);
    }

    public static class DescriptionManagerDialog
    extends UIDialog
    implements DescriptionInspectorManager {
        private DescriptionInspector descriptionInspector = new DescriptionInspector(this);

        public static DescriptionManagerDialog newDialog(Component owner) {
            Window window = WinTools.getAncestorWindow(owner);
            if (window instanceof Dialog) {
                return new DescriptionManagerDialog((Dialog)window, true);
            }
            if (window instanceof Frame) {
                return new DescriptionManagerDialog((Frame)window, true);
            }
            return null;
        }

        public DescriptionManagerDialog(Dialog d, boolean m) {
            super(d, m);
        }

        public DescriptionManagerDialog(Frame f, boolean m) {
            super(f, m);
        }

        public DescriptionInspector getDescriptionInspector() {
            return this.descriptionInspector;
        }
    }

    public static interface DescriptionInspectorManager {
        public DescriptionInspector getDescriptionInspector();
    }
}

