/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.server;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.server.ConnectionFactoryDialog;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;

public class ServerResAdptInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServerResAdptInspector.class);
    private final String SCROLL_NAME = localStrings.getLocalString("ui.serverresadptinspector.scroll_name", "Scroll Panel");
    private final String SCROLL_DESC = localStrings.getLocalString("ui.serverresadptinspector.scroll_desc", "This scroll pane is for resource adapter tree view");
    private static final String TREE_NAME = localStrings.getLocalString("ui.serverresadptinspector.tree_name", "Tree");
    private static final String TREE_DESC = localStrings.getLocalString("ui.serverresadptinspector.tree_desc", "This is a tree view of the contents of the resource adapter");
    private static final String TREE_PANEL_NAME = localStrings.getLocalString("ui.serverresadptinspector.tree_panel_name", "Tree Panel");
    private static final String TREE_PANEL_DESC = localStrings.getLocalString("ui.serverresadptinspector.tree_panel_desc", "This is a panel for tree view of the contents of the resource adapter");
    private static final String TABNAME = localStrings.getLocalString("ui.serverresadptinspector.tabname", "Resource Adapters");
    private static final String BOX_TITLE = localStrings.getLocalString("ui.serverresadptinspector.connection_factories", "Deployed Connection Factories");
    private static final String CONFIRM_DELETE = localStrings.getLocalString("ui.serverresadptinspector.delete_confirmation", "Do you want to delete selected connection factory(s)?");
    private static String wizardHelpID = "ResAdapt";
    private static String deployHelpID = "ResAdapt";
    ServerDescriptor descriptor = null;
    private UIControlButtonBox mainTreePanel = null;
    private JTree resourceAdptTree = new JTree();
    private ResourceAdptTreeView treeView = null;
    private DefaultMutableTreeNode selectedNode = null;
    private JButton btnEdit = null;
    private JButton btnDelete = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;
    static /* synthetic */ Class class$java$lang$Object;

    private static String ERROR_DELETING(String v0, String v1) {
        return localStrings.getLocalString("ui.serverresadptinspector.error_while_deleting", "An error was encountered while deleting ''{0}''\n {1}", new Object[]{v0, v1});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new ServerResAdptInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ServerDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ServerDescriptor) {
            this.descriptor = (ServerDescriptor)obj;
            this.invokeRefresh();
        }
    }

    private ServerResAdptInspector(String mode) {
        this.setInspectorMode(mode);
        this.resourceAdptTree.getAccessibleContext().setAccessibleName(TREE_NAME);
        this.resourceAdptTree.getAccessibleContext().setAccessibleDescription(TREE_DESC);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.mainTreePanel = new UIControlButtonBox(BOX_TITLE, true);
        this.mainTreePanel.setControlButtonLocation(13);
        this.add((Component)this.mainTreePanel, "Center");
        this.treeView = this.getResourceAdptTreeView();
        GridBagConstraints c = this.mainTreePanel.getGBConstraints();
        c.weightx = 0.8;
        c.weighty = 0.8;
        c.insets = new Insets(5, 5, 5, 5);
        this.mainTreePanel.setGBConstraints(this.treeView, c);
        this.mainTreePanel.addWithGBConstraints(this.treeView);
        UIButton btnNew = UIButton.createNewButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerResAdptInspector.this.newAction();
            }
        }, true);
        this.mainTreePanel.addControlButton(btnNew);
        this.btnEdit = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerResAdptInspector.this.editAction();
            }
        }, true);
        this.mainTreePanel.addControlButton(this.btnEdit);
        this.btnDelete = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerResAdptInspector.this.deleteAction();
            }
        }, true);
        this.mainTreePanel.addControlButton(this.btnDelete);
        this.enableButtons(false);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ServerResAdptInspector.this.resourceAdptTree.clearSelection();
                ServerResAdptInspector.this.enableButtons(false);
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void enableButtons(boolean state) {
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(state);
            this.btnDelete.setEnabled(state);
        }
    }

    private void newAction() {
        ConnectionFactoryDialog cfd = ConnectionFactoryDialog.showNewDialog(this);
        if (cfd.isOk()) {
            this.invokeRefresh();
        }
    }

    private void editAction() {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.resourceAdptTree.getLastSelectedPathComponent();
        if (dmtn == null) {
            return;
        }
        Object obj = dmtn.getUserObject();
        if (!(obj instanceof ConnectorResource)) {
            return;
        }
        ConnectorResource cr = (ConnectorResource)obj;
        String factoryName = cr.getName();
        ConnectionFactoryDialog cfd = ConnectionFactoryDialog.showEditDialog(this, factoryName);
        if (cfd.isOk()) {
            this.invokeRefresh();
        }
    }

    private void deleteAction() {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.resourceAdptTree.getLastSelectedPathComponent();
        if (dmtn == null) {
            return;
        }
        Object obj = dmtn.getUserObject();
        if (!(obj instanceof ConnectorResource)) {
            return;
        }
        ConnectorResource cr = (ConnectorResource)obj;
        boolean action = UIOptionPane.showConfirmDialog(this, CONFIRM_DELETE);
        if (action) {
            try {
                ConnectionFactoryDialog.removeConnectorResource(cr.getName());
                this.invokeRefresh();
            }
            catch (Exception ex) {
                UIOptionPane.showErrorDialog(this, ServerResAdptInspector.ERROR_DELETING(cr.getName(), ex.toString()));
            }
        }
    }

    public void refresh() {
        try {
            this.treeView.buildView(false);
            this.treeView.setEnabled(true);
            this.mainTreePanel.setEnabled(true);
        }
        catch (Exception ex) {
            this.treeView.setEnabled(false);
            this.mainTreePanel.setEnabled(false);
        }
    }

    public void notification(NotificationEvent ne) {
        this.invokeRefresh();
    }

    private ResourceAdptTreeView getResourceAdptTreeView() {
        if (this.treeView == null) {
            this.treeView = new ResourceAdptTreeView(this.resourceAdptTree);
            this.resourceAdptTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 17) {
                        try {
                            ServerResAdptInspector.this.treeView.buildView(false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return;
                    }
                }
            });
            this.resourceAdptTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent tse) {
                    JTree srcTree = (JTree)tse.getSource();
                    ServerResAdptInspector.this.selectedNode = (DefaultMutableTreeNode)srcTree.getLastSelectedPathComponent();
                    Object obj = ServerResAdptInspector.this.selectedNode != null ? ServerResAdptInspector.this.selectedNode.getUserObject() : null;
                    ServerResAdptInspector.this.enableButtons(obj instanceof ConnectorResource);
                    ServerResAdptInspector.this.resourceAdptTree.grabFocus();
                }
            });
        }
        this.treeView.setPreferredSize(this.treeView.getMaximumSize());
        return this.treeView;
    }

    class RootTreeCellRenderer
    extends DefaultTreeCellRenderer {
        RootTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color textColor = Color.black;
            JLabel defaultRenderingLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof DescriptorTreeNode) {
                DescriptorTreeNode dtn = (DescriptorTreeNode)value;
                Class type = dtn.getType();
                defaultRenderingLabel.setIcon(UIIcons.getIconFor(type));
            }
            return defaultRenderingLabel;
        }
    }

    private class DescriptorTreeNode
    extends DefaultMutableTreeNode {
        private boolean tag;
        private Class type;
        private ConnectorResource factory;

        public void setTag(boolean t) {
            this.tag = t;
        }

        public boolean isTagged() {
            return this.tag;
        }

        public DescriptorTreeNode(Object userObj, Class type) {
            super(userObj, true);
            this.tag = false;
            this.type = class$java$lang$Object == null ? (class$java$lang$Object = ServerResAdptInspector.class$("java.lang.Object")) : class$java$lang$Object;
            this.factory = null;
            this.type = type != null ? type : (class$java$lang$Object == null ? (class$java$lang$Object = ServerResAdptInspector.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public DescriptorTreeNode(ConnectorResource cr) {
            super(cr.getName(), false);
            this.tag = false;
            this.type = class$java$lang$Object == null ? (class$java$lang$Object = ServerResAdptInspector.class$("java.lang.Object")) : class$java$lang$Object;
            this.factory = null;
            this.setFactory(cr);
        }

        public void setFactory(ConnectorResource cr) {
            this.factory = cr;
            this.type = this.factory.getClass();
        }

        public Class getType() {
            return this.type;
        }

        public Object getUserObject() {
            return this.factory != null ? this.factory : super.getUserObject();
        }

        public boolean equals(Object obj) {
            if (obj instanceof String && this.toString().equals((String)obj)) {
                return true;
            }
            return obj instanceof DescriptorTreeNode && this.toString().equals(obj.toString());
        }

        public String toString() {
            Object obj = this.getUserObject();
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof ConnectorResource) {
                return ((ConnectorResource)obj).getName();
            }
            if (obj instanceof Descriptor) {
                return ((Descriptor)obj).getName();
            }
            return obj.toString();
        }
    }

    private class ResourceAdptTreeView
    extends JPanel {
        private JTree tree = null;
        private Color treeBackgroundColor = null;

        public ResourceAdptTreeView(JTree rootTree) {
            this.tree = rootTree;
            this.treeBackgroundColor = this.tree.getBackground();
            this.getAccessibleContext().setAccessibleName(TREE_PANEL_NAME);
            this.getAccessibleContext().setAccessibleDescription(TREE_PANEL_DESC);
            this.tree.setModel(new DefaultTreeModel(new DescriptorTreeNode("Root", null)));
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setCellRenderer(new RootTreeCellRenderer());
            this.setLayout(new BorderLayout());
            UIPanel treePanel = new UIPanel();
            treePanel.setBorder(new LineBorder(Color.black, 0));
            treePanel.setLayout(new BorderLayout());
            JScrollPane js = new JScrollPane(this.tree);
            js.getAccessibleContext().setAccessibleName(ServerResAdptInspector.this.SCROLL_NAME);
            js.getAccessibleContext().setAccessibleDescription(ServerResAdptInspector.this.SCROLL_DESC);
            treePanel.add(js);
            this.add(treePanel);
            TreeSelectionModel selectionModel = this.tree.getSelectionModel();
            selectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(selectionModel);
        }

        public void buildView(boolean reload) throws Exception {
            DescriptorTreeNode dtn;
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            DescriptorTreeNode root = (DescriptorTreeNode)treeModel.getRoot();
            if (!reload && root.getChildCount() <= 0) {
                reload = true;
            }
            Enumeration<TreeNode> re = root.depthFirstEnumeration();
            while (re.hasMoreElements()) {
                DescriptorTreeNode dtn2 = (DescriptorTreeNode)re.nextElement();
                dtn2.setTag(false);
            }
            root.setTag(true);
            Set cflist = null;
            try {
                cflist = DT.getServerManager().listConnectorResources();
            }
            catch (RemoteException re2) {
                Print.dprintln((String)("Unable to get ConnectorResources: " + re2.toString()));
                throw re2;
            }
            catch (Exception se) {
                Print.dprintln((String)("Unable to get ConnectorResources: " + se.toString()));
                throw se;
            }
            Iterator cfIter = cflist.iterator();
            while (cfIter.hasNext()) {
                String connName;
                DescriptorTreeNode connNode;
                DescriptorTreeNode topNode = root;
                ConnectorResource cr = (ConnectorResource)cfIter.next();
                String applName = cr.getApplicationName();
                if (applName != null && !applName.equals("")) {
                    topNode = this.getNamedChildNode(root, applName, class$com$sun$enterprise$deployment$Application == null ? ServerResAdptInspector.class$("com.sun.enterprise.deployment.Application") : class$com$sun$enterprise$deployment$Application);
                    if (topNode == null) {
                        topNode = new DescriptorTreeNode(applName, class$com$sun$enterprise$deployment$Application == null ? ServerResAdptInspector.class$("com.sun.enterprise.deployment.Application") : class$com$sun$enterprise$deployment$Application);
                        treeModel.insertNodeInto(topNode, root, root.getChildCount());
                    }
                    topNode.setTag(true);
                }
                if ((connNode = this.getNamedChildNode(topNode, connName = cr.getConnectorName(), class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? ServerResAdptInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor)) == null) {
                    connNode = new DescriptorTreeNode(connName, class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? ServerResAdptInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor);
                    treeModel.insertNodeInto(connNode, topNode, topNode.getChildCount());
                }
                connNode.setTag(true);
                DescriptorTreeNode factNode = this.getNamedChildNode(connNode, cr.getName(), null);
                if (factNode == null) {
                    factNode = new DescriptorTreeNode(cr);
                    treeModel.insertNodeInto(factNode, connNode, connNode.getChildCount());
                } else {
                    factNode.setFactory(cr);
                }
                factNode.setTag(true);
            }
            Vector<DescriptorTreeNode> delNodes = new Vector<DescriptorTreeNode>();
            Enumeration<TreeNode> re3 = root.depthFirstEnumeration();
            while (re3.hasMoreElements()) {
                dtn = (DescriptorTreeNode)re3.nextElement();
                if (dtn.isTagged()) continue;
                delNodes.add(dtn);
            }
            Enumeration e = delNodes.elements();
            while (e.hasMoreElements()) {
                dtn = (DescriptorTreeNode)e.nextElement();
                treeModel.removeNodeFromParent(dtn);
            }
            if (reload) {
                treeModel.reload();
            }
        }

        private DescriptorTreeNode getNamedChildNode(DescriptorTreeNode root, String name, Class type) {
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                DescriptorTreeNode node = (DescriptorTreeNode)e.nextElement();
                if (!node.toString().equals(name) || type != null && node.getType() != type) continue;
                return node;
            }
            return null;
        }

        public void setEnabled(boolean enabled) {
            if (this.isEnabled() != enabled) {
                super.setEnabled(enabled);
                this.tree.setEnabled(enabled);
                this.tree.setBackground(enabled ? this.treeBackgroundColor : UITitledBox.DisabledBackgroundColor);
            }
        }
    }
}

