/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.server;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.TLSParams;
import com.sun.enterprise.tools.deployment.ui.server.X509TrustManager;
import com.sun.enterprise.tools.deployment.ui.utils.PortDetector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public abstract class ServerInfoRetriever {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServerInfoRetriever.class);
    private static String UNABLE_TO_RETRIEVE = localStrings.getLocalString("ui.serverinforetriever.unable_to_retrieve", "Unable to retrieve information from server.");
    private String adminHost;
    private int adminPort;
    private String user;
    private String password;

    public ServerInfoRetriever(String adminHost, int adminPort, String user, String password) {
        this.adminHost = adminHost;
        this.adminPort = adminPort;
        this.user = user;
        this.password = password;
    }

    protected Object callServer(String objectName, String operationName, Object[] params, String[] paramTypes) {
        try {
            TLSParams tlsParams = null;
            if (PortDetector.isSecurePort(this.adminHost, this.adminPort)) {
                tlsParams = new TLSParams((javax.net.ssl.X509TrustManager)((Object)new X509TrustManager()), null);
            }
            AppserverConnectionSource asConn = new AppserverConnectionSource("sun-as-http", this.adminHost, this.adminPort, this.user, this.password, tlsParams, (Map)null);
            MBeanServerConnection mbsc = asConn.getMBeanServerConnection(false);
            return mbsc.invoke(new ObjectName(objectName), operationName, params, paramTypes);
        }
        catch (Exception ex) {
            Print.dprintStackTrace((String)UNABLE_TO_RETRIEVE, (Throwable)ex);
            return null;
        }
    }
}

