/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.server;

import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.server.JNDINamesRetriever;
import com.sun.enterprise.tools.deployment.ui.server.UserGroupRetriever;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class DTServerManager {
    public static final String SERVER_ADDED = "ServerAdded";
    public static final String SERVER_REMOVED = "ServerRemoved";
    public static final String SERVER_CHANGED = "ServerChanged";
    public static final String SERVER_SELECTED = "ServerSelected";
    public static final String SERVER_TARGETED = "ServerTargeted";
    public static final String SERVER_REFRESH = "ServerRefresh";
    public static final String MODULE_DEPLOYED = "ModuleDeployed";
    public static final String MODULE_UNDEPLOYED = "ModuleUndeployed";
    public static final String SERVER_PROPERTY = "ServerPropertyValue";
    public static final String LOCAL_HOST = "localhost";
    private ServerManager oldServerManager = null;
    private Vector serverListeners = new Vector();
    private boolean isNotifyEnabled = true;

    private ServerManager getOldServerManager() {
        if (this.oldServerManager == null) {
            this.oldServerManager = new ServerManager();
        }
        return this.oldServerManager;
    }

    public Collection getGlobalJndiNames(String type) {
        try {
            DeploymentPlatform.ManagerURI serverInfo = DeploymentPlatform.getTargetManagerURI();
            JNDINamesRetriever jndiNamesRetriever = new JNDINamesRetriever(serverInfo.getHost(), serverInfo.getPort(), serverInfo.getUser(), serverInfo.getPassword());
            return jndiNamesRetriever.getJndiNames(type);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public List getServerUserNames() {
        try {
            DeploymentPlatform.ManagerURI serverInfo = DeploymentPlatform.getTargetManagerURI();
            UserGroupRetriever userGroupRetriever = new UserGroupRetriever(serverInfo.getHost(), serverInfo.getPort(), serverInfo.getUser(), serverInfo.getPassword());
            return userGroupRetriever.getUsers();
        }
        catch (Throwable t) {
            return new Vector();
        }
    }

    public List getServerGroupNames() {
        try {
            DeploymentPlatform.ManagerURI serverInfo = DeploymentPlatform.getTargetManagerURI();
            UserGroupRetriever userGroupRetriever = new UserGroupRetriever(serverInfo.getHost(), serverInfo.getPort(), serverInfo.getUser(), serverInfo.getPassword());
            return userGroupRetriever.getGroups();
        }
        catch (Throwable t) {
            return new Vector();
        }
    }

    public String getSelectedServer() {
        return DeploymentPlatform.getSelectedManagerHost();
    }

    public String getTargetServer() {
        return DeploymentPlatform.getTargetManagerHost();
    }

    public void setNotificationEnabled(boolean flag) {
        this.isNotifyEnabled = flag;
    }

    public boolean isNotificationEnabled() {
        return this.isNotifyEnabled;
    }

    public void addNotificationListener(NotificationListener nl) {
        this.serverListeners.addElement(nl);
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.serverListeners.removeElement(nl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(String type, String name, Object value) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        NotificationEvent ne = name != null ? new NotificationEvent((Object)this, type, name, value != null ? value : "") : new NotificationEvent((Object)this, type);
        Vector listenersClone = null;
        Vector vector = this.serverListeners;
        synchronized (vector) {
            listenersClone = (Vector)this.serverListeners.clone();
        }
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            ((NotificationListener)e.nextElement()).notification(ne);
        }
    }

    public void fireDeployedModuleNotification(Object module) {
        this.notify(MODULE_DEPLOYED, SERVER_PROPERTY, module);
    }

    public void fireUndeployedModuleNotification(Object module) {
        this.notify(MODULE_UNDEPLOYED, SERVER_PROPERTY, module);
    }

    public void fireSelectedServerNotification(Object serverName) {
        this.notify(SERVER_SELECTED, SERVER_PROPERTY, serverName);
    }

    public void fireTargetedServerNotification(Object serverName) {
        this.notify(SERVER_TARGETED, SERVER_PROPERTY, serverName);
    }

    public void fireServerChangedNotification(Object serverName) {
        this.notify(SERVER_CHANGED, SERVER_PROPERTY, serverName);
    }

    public void fireServerRefreshNotification() {
        this.notify(SERVER_REFRESH, SERVER_PROPERTY, "");
    }

    public Set getConnectionFactoryPropertyTemplate(String appName, String connectorName) throws Exception {
        throw new Exception("NotSupported");
    }

    public void addConnectionFactory(String appName, String conName, String jndiName, String xaRecoveryUser, String xaRecoveryPwd, Properties props) throws Exception {
        throw new Exception("NotSupported");
    }

    public void removeConnectionFactory(String jndiName) throws Exception {
        throw new Exception("NotSupported");
    }

    public Set listConnectorResources() throws Exception {
        throw new Exception("NotSupported");
    }

    private class ServerManager {
        private ServerManager() {
        }
    }
}

