/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.server;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import javax.help.CSH;
import javax.swing.border.EmptyBorder;

public class AddServerDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AddServerDialog.class);
    private static String ADD_SERVER_TITLE = localStrings.getLocalString("ui.addserverdialog.add_server.title", "Add Server");
    private static String SERVER_NAME = localStrings.getLocalString("ui.addserverdialog.add_server.server_name", "Server Name:");
    private static String SERVER_PORT = localStrings.getLocalString("ui.addserverdialog.add_server.server_port", "Server Port:");
    private static String TARGET_SERVER = localStrings.getLocalString("ui.addserverdialog.add_server.set_target_server", "Target Server");
    private static final String PLEASE_SELECT_SERVER = localStrings.getLocalString("ui.addserverdialog.selectservertoremove", "Please select a server");
    private static AddServerDialog addServerDialog = null;
    private static String addServerHelpId = "AddServer";
    private UITitledTextField serverURIField = null;
    private UITitledTextField serverPortField = null;
    private UICheckBox serverTargetCB = null;

    private static String OKTOREMOVE_SERVER(Object v0) {
        return localStrings.getLocalString("ui.addserverdialog.confirm_remove_server", "Are you sure you want to remove selected server?\n ''{0}''", new Object[]{v0});
    }

    private static String OKTOTARGET_SERVER(Object v0) {
        return localStrings.getLocalString("ui.addserverdialog.set_target_server", "Do you wish to set this server as the current target server?\n ''{0}''", new Object[]{v0});
    }

    private static final String UNKNOWN_HOST(Object v0) {
        return localStrings.getLocalString("ui.addserverdialog.unknownhost", "Unknown host: {0}", new Object[]{v0});
    }

    private static final String ALREADY_ADDED(Object v0, Object v1, Object v2) {
        return localStrings.getLocalString("ui.addserverdialog.alreadyadded", "{0}:{1} has already been added as {2}", new Object[]{v0, v1, v2});
    }

    public static void showAddServerDialog() {
        AddServerDialog.showAddServerDialog(null);
    }

    public static void showAddServerDialog(Frame f) {
        if (addServerDialog == null) {
            Frame frame = f != null ? f : DT.getApplicationFrame();
            addServerDialog = new AddServerDialog(frame);
        }
        addServerDialog.show();
    }

    public static void showRemoveServerDialog() {
        AddServerDialog.showRemoveServerDialog(null);
    }

    public static void showRemoveServerDialog(Frame f) {
        Frame frame = f != null ? f : DT.getApplicationFrame();
        DeploymentPlatform.ManagerURI mu = DeploymentPlatform.getSelectedManagerURI();
        if (mu != null) {
            if (UIOptionPane.showConfirmDialog(frame, AddServerDialog.OKTOREMOVE_SERVER(mu))) {
                AddServerDialog.removeServerURI(mu);
            }
        } else {
            UIOptionPane.showWarningDialog(frame, PLEASE_SELECT_SERVER);
        }
    }

    public static void showTargetServerDialog() {
        AddServerDialog.showTargetServerDialog(null);
    }

    public static void showTargetServerDialog(Frame f) {
        Frame frame = f != null ? f : DT.getApplicationFrame();
        DeploymentPlatform.ManagerURI mu = DeploymentPlatform.getSelectedManagerURI();
        if (mu != null) {
            String name = mu.getURI();
            if (UIConfig.getConfigBoolean("ui.tree.showAbbreviatedUri") && name.startsWith("deployer:Sun:AppServer::")) {
                name = name.substring("deployer:Sun:AppServer::".length());
            }
            if (UIOptionPane.showConfirmDialog(frame, AddServerDialog.OKTOTARGET_SERVER(name))) {
                mu.setAsDefaultTarget();
            }
        } else {
            UIOptionPane.showWarningDialog(frame, PLEASE_SELECT_SERVER);
        }
    }

    private AddServerDialog(Frame owner) {
        super(owner, true);
        this.setWindowClosingAction(null);
        this.setTitle(ADD_SERVER_TITLE);
        CSH.setHelpIDString((Component)this, (String)addServerHelpId);
        UITitledBox content = new UITitledBox(null, false);
        content.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        content.getGBConstraints().weighty = 0.0;
        content.getGBConstraints().fill = 2;
        this.setContentPane(content);
        this.serverURIField = new UITitledTextField(SERVER_NAME, false);
        this.serverURIField.setText("localhost");
        content.addWithGBConstraints(this.serverURIField);
        this.serverPortField = new UITitledTextField(SERVER_PORT, false);
        this.serverPortField.setIntValue(4848);
        content.addWithGBConstraints(this.serverPortField);
        this.serverTargetCB = new UICheckBox(TARGET_SERVER);
        this.serverTargetCB.setSelected(false);
        content.addWithGBConstraints(this.serverTargetCB);
        UIControlButtonBox buttonsPanel = new UIControlButtonBox(null, false);
        buttonsPanel.setControlButtonLocation(101);
        content.addWithGBConstraints(buttonsPanel);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AddServerDialog.this.okAction();
            }
        });
        buttonsPanel.addControlButton(okBtn);
        okBtn.makeDefaultButton(true);
        buttonsPanel.addControlButton(UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AddServerDialog.this.hide();
            }
        }));
        buttonsPanel.addControlButton(new UIHelpButton(addServerHelpId));
        this.pack();
        Rectangle r = owner != null ? owner.getBounds() : new Rectangle(20, 20, 1, 1);
        int x = r.x + super.getBounds().width / 3;
        int y = r.y + super.getBounds().height / 3;
        this.setBounds(x, y, super.getBounds().width + 50, super.getBounds().height);
    }

    public void show() {
        this.serverTargetCB.setSelected(false);
        super.show();
    }

    private void okAction() {
        if (this.serverURIField.isBlank()) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.addserverdialog.supply_host_name", "Please supply the name of the host running the server"));
            return;
        }
        String host = this.serverURIField.getText();
        int port = this.serverPortField.getIntValue(-1);
        if (this.serverPortField.isBlank()) {
            port = 4848;
        } else if (port < 0) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.addserverdialog.supply_port_number", "\"" + this.serverPortField.getText() + "\" is not a valid port number, please supply the " + "port number of the host running the server.  (e.g. " + 4848 + ")", new Object[]{this.serverPortField.getText(), "4848"}));
            return;
        }
        Iterator i = DeploymentPlatform.getManagerURIs().iterator();
        while (i.hasNext()) {
            DeploymentPlatform.ManagerURI server = (DeploymentPlatform.ManagerURI)i.next();
            if (port != server.getPort()) continue;
            try {
                if (!AddServerDialog.equalHost(host, server.getHost())) continue;
                UIOptionPane.showInfoDialog(this, AddServerDialog.ALREADY_ADDED(host, Integer.toString(port), server.getHostInfo()));
                return;
            }
            catch (UnknownHostException uhe) {
                UIOptionPane.showErrorDialog(this, AddServerDialog.UNKNOWN_HOST(host));
                return;
            }
        }
        boolean target = this.serverTargetCB.isSelected();
        AddServerDialog.addServerURI(host + ":" + port, target);
        this.hide();
    }

    private static DeploymentPlatform getDefaultPlatform() {
        List pl = DeploymentPlatform.getPlatforms();
        return pl.size() > 0 ? (DeploymentPlatform)pl.get(0) : null;
    }

    private static void addServerURI(String serverURI, boolean setTarget) {
        if (serverURI != null && !serverURI.equals("")) {
            String uri = DeploymentPlatform.NormalizeDefaultURI(serverURI);
            DeploymentPlatform dp = AddServerDialog.getDefaultPlatform();
            if (dp != null) {
                dp.setDefaultURI(uri);
                if (setTarget) {
                    DeploymentPlatform.setTargetManagerURI(dp.getManagerURI(uri));
                }
                DeploymentPlatform.savePlatforms();
                DT.getServerManager().fireServerChangedNotification(null);
            }
        }
    }

    private static void removeServerURI(DeploymentPlatform.ManagerURI mgrURI) {
        if (mgrURI != null) {
            DeploymentPlatform dp = mgrURI.getDeploymentPlatform();
            if (dp.removeURI(mgrURI.getURI())) {
                Print.dprintln((String)("Removed server: " + mgrURI));
            } else {
                Print.dprintln((String)("Unable to remove server: " + mgrURI));
            }
            DeploymentPlatform.savePlatforms();
            DT.getServerManager().fireServerChangedNotification(null);
        }
    }

    private static boolean equalHost(String h1, String h2) throws UnknownHostException {
        InetAddress a2;
        InetAddress a1 = InetAddress.getByName(h1);
        if (a1.isLoopbackAddress() || a1.isAnyLocalAddress()) {
            a1 = InetAddress.getLocalHost();
        }
        if ((a2 = InetAddress.getByName(h2)).isLoopbackAddress() || a2.isAnyLocalAddress()) {
            a2 = InetAddress.getLocalHost();
        }
        return a1.equals(a2);
    }
}

