/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.script;

import com.sun.enterprise.tools.deployment.ui.script.ScriptException;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.Print;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import sun.awt.AppContext;

public abstract class ScriptRunnerCore {
    protected static boolean debug = false;
    private static final String SCRIPT = "Script";
    protected static final String MAIN_WINDOW = "Application Deployment Tool";
    protected static final String EDIT_CONTENTS = "Edit Contents";
    private static int activeWindowListenerLevel = 0;
    private static WindowActivationListener activeWindowListener = null;
    private static final Object DialogOwnerKey = new StringBuffer("SwingUtilities.sharedOwnerFrame");
    private static boolean SharedOwnerFirst = true;

    public void invoke(Runnable r) throws ScriptException {
        this.invoke(r, false);
    }

    public void invoke(Runnable r, boolean wait) throws ScriptException {
        if (wait) {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InterruptedException ie) {
                this.error("Interrupted...");
            }
            catch (InvocationTargetException te) {
                Print.printStackTrace((String)"InvocationTargetException...", (Throwable)te);
                this.error("InvocationTargetException...");
            }
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public void error(String msg) throws ScriptException {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        t.printStackTrace(ps);
        StringTokenizer st = new StringTokenizer(bos.toString(), "\n");
        st.nextToken();
        st.nextToken();
        String srcFile = this.extractSource(st.nextToken());
        String scriptSrc = this.getScriptSource();
        if (scriptSrc != null && !srcFile.startsWith(scriptSrc)) {
            while (st.hasMoreTokens()) {
                String s = this.extractSource(st.nextToken());
                if (!s.startsWith(scriptSrc)) continue;
                srcFile = s;
                break;
            }
        }
        if (msg == null) {
            msg = "";
        }
        Print.dprintStackTrace((String)msg);
        throw new ScriptException(srcFile, msg);
    }

    private String extractSource(String frame) {
        int p1 = frame.indexOf("(");
        int p2 = frame.indexOf(")");
        return p1 >= 0 && p2 > p1 ? frame.substring(p1 + 1, p2) : frame;
    }

    public String getScriptSource() {
        return null;
    }

    public void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printWindows() {
        Frame[] frame = ScriptRunnerCore.GetFrames();
        for (int f = 0; f < frame.length; ++f) {
            ScriptRunnerCore._printWindows(frame[f], 0);
        }
    }

    private static void _printWindows(Window parent, int level) {
        StringBuffer sb = new StringBuffer(ScriptRunnerCore.indent(level));
        sb.append(" ==> ").append(ScriptRunnerCore._getWindowTitle(parent));
        sb.append(" [isModal=").append(ScriptRunnerCore.isModalDialog(parent));
        sb.append("]");
        Print.dprintln((String)sb.toString());
        Window[] child = parent.getOwnedWindows();
        for (int i = 0; i < child.length; ++i) {
            ScriptRunnerCore._printWindows(child[i], level + 1);
        }
    }

    protected Vector getDepthFirstWindowList() {
        Vector list = new Vector();
        Frame[] frame = ScriptRunnerCore.GetFrames();
        for (int i = 0; i < frame.length; ++i) {
            this.getDepthFirstWindowList(list, frame[i]);
        }
        return list;
    }

    public Window findWindow(String title) throws ScriptException {
        return this.findWindow(title, 10000, true);
    }

    public Window findWindow(String title, int timeout) throws ScriptException {
        return this.findWindow(title, timeout, true);
    }

    public Window findWindow(String title, int timeout, boolean expected) throws ScriptException {
        int interval = 1000;
        Window found = null;
        while (true) {
            if (title == null) {
                found = this.findActiveWindow();
            } else {
                Frame[] frame = ScriptRunnerCore.GetFrames();
                for (int f = 0; f < frame.length; ++f) {
                    Window w = this._findWindow(frame[f], title);
                    if (w == null || !w.isVisible()) continue;
                    found = w;
                    break;
                }
            }
            if (found != null || timeout <= 0) break;
            int tm = timeout > interval ? interval : timeout;
            this.pause(tm);
            timeout -= tm;
        }
        if (expected && found == null) {
            this.error("Window Not Found: " + title);
        } else if (!expected && found != null) {
            this.error("Unexpected Window Found: " + title);
        }
        return found;
    }

    public boolean isWindowActive(Component c) throws ScriptException {
        int timeout = 5000;
        int interval = 500;
        while (true) {
            Window actvWin = this.findActiveWindow();
            Window compWin = WinTools.getAncestorWindow(c);
            if (actvWin != null && actvWin == compWin) {
                return true;
            }
            if (timeout <= 0) break;
            int tm = timeout > interval ? interval : timeout;
            this.pause(tm);
            timeout -= tm;
        }
        return false;
    }

    public Window findActiveWindow() throws ScriptException {
        if (activeWindowListenerLevel > 0) {
            Window win = activeWindowListener.getActiveWindow();
            return win;
        }
        this.error("ERROR: 'addWindowActivationListener()' not installed!");
        return null;
    }

    public static void addWindowActivationListener() {
        if (activeWindowListenerLevel == 0) {
            if (activeWindowListener == null) {
                activeWindowListener = new WindowActivationListener();
            }
            activeWindowListener.reset();
            Toolkit.getDefaultToolkit().addAWTEventListener(activeWindowListener, 64L);
        }
        ++activeWindowListenerLevel;
    }

    public static void removeWindowActivationListener() {
        if (--activeWindowListenerLevel <= 0 && activeWindowListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(activeWindowListener);
            activeWindowListener.reset();
            activeWindowListenerLevel = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window findModalWindow() {
        Vector probeList;
        Vector vector = probeList = new Vector();
        synchronized (vector) {
            Frame[] frame = ScriptRunnerCore.GetFrames();
            for (int f = 0; f < frame.length; ++f) {
                this._probeModalDialogWindows(frame[f], probeList);
            }
            if (probeList.size() > 0) {
                try {
                    probeList.wait(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                Iterator i = probeList.iterator();
                while (i.hasNext()) {
                    ModalWindowProbe probe = (ModalWindowProbe)i.next();
                    if (!probe.found()) continue;
                    Window win = probe.getWindow();
                    return win;
                }
            }
        }
        return null;
    }

    private static boolean isModalDialog(Window win) {
        return win.isVisible() && win instanceof Dialog && ((Dialog)win).isModal();
    }

    private void _probeModalDialogWindows(Window parent, Vector probeList) {
        if (ScriptRunnerCore.isModalDialog(parent)) {
            ModalWindowProbe probe = new ModalWindowProbe((Dialog)parent, probeList);
            UIEventQueue.getSystemEventQueue().postEvent(probe);
            probeList.add(probe);
        }
        Window[] childWin = parent.getOwnedWindows();
        for (int i = 0; i < childWin.length; ++i) {
            this._probeModalDialogWindows(childWin[i], probeList);
        }
    }

    private static Frame GetSharedDialogOwner() {
        return (Frame)AppContext.getAppContext().get(DialogOwnerKey);
    }

    private static Frame[] GetFrames() {
        Frame[] frame = Frame.getFrames();
        Frame sharedOwner = (Frame)AppContext.getAppContext().get(DialogOwnerKey);
        if (sharedOwner != null) {
            Frame[] newFrame = new Frame[frame.length + 1];
            System.arraycopy(frame, 0, newFrame, SharedOwnerFirst ? 1 : 0, frame.length);
            newFrame[ScriptRunnerCore.SharedOwnerFirst ? 0 : frame.length] = sharedOwner;
            frame = newFrame;
        }
        return frame;
    }

    private Vector getDepthFirstWindowList(Vector list, Window win) {
        Window[] children = win.getOwnedWindows();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.getDepthFirstWindowList(list, children[i]);
            }
        }
        list.add(win);
        return list;
    }

    protected Window _findWindow(Window win, String title) {
        if (title == null) {
            return null;
        }
        String winTitle = ScriptRunnerCore._getWindowTitle(win);
        if (this.compareTitle(winTitle, title)) {
            return win;
        }
        Window[] children = win.getOwnedWindows();
        for (int i = 0; i < children.length; ++i) {
            Window w = this._findWindow(children[i], title);
            if (w == null || !w.isVisible()) continue;
            return w;
        }
        return null;
    }

    private static String _getWindowTitle(Window win) {
        return win == null ? "<null>" : (win instanceof Dialog ? ((Dialog)win).getTitle() : (win instanceof Frame ? ((Frame)win).getTitle() : "?"));
    }

    public Component findComponent(Component parent, Class compClass, String title) throws ScriptException {
        return this.findComponent(parent, new Class[]{compClass}, title);
    }

    public Component findComponent(Component parent, Class[] compClass, String title) throws ScriptException {
        if (parent == null) {
            parent = this.findWindow(MAIN_WINDOW);
        }
        int timeout = 5000;
        int interval = 500;
        Component c = null;
        while (true) {
            if (debug) {
                Print.dprintln((String)("[" + timeout + "] Looking for " + ScriptRunnerCore.CompName(compClass, title)));
            }
            if ((c = this._findComponent(parent, compClass, title, 0)) != null || timeout <= 0) break;
            int tm = timeout > interval ? interval : timeout;
            this.pause(tm);
            timeout -= tm;
        }
        if (c == null) {
            this.error("Not Found: " + ScriptRunnerCore.CompName(compClass, title));
        }
        return c;
    }

    private static String CompName(Class[] c, String t) {
        int p;
        String cn = "Component";
        if (c != null && c.length > 0 && (p = (cn = c[0].getName()).lastIndexOf(".")) >= 0) {
            cn = cn.substring(p + 1);
        }
        return cn + " \"" + t + "\"";
    }

    protected boolean compareTitle(String compTitle, String match) {
        if (compTitle == null) {
            return false;
        }
        int startsWith = 0;
        int endsWith = 0;
        if (match.startsWith("^")) {
            startsWith = 1;
            match = match.substring(1);
        } else if (match.startsWith("*")) {
            if (endsWith == 0) {
                endsWith = 2;
            }
            match = match.substring(1);
        }
        if (match.endsWith("$")) {
            endsWith = 1;
            match = match.substring(0, match.length() - 1);
        } else if (match.endsWith("*")) {
            if (startsWith == 0) {
                startsWith = 2;
            }
            match = match.substring(0, match.length() - 1);
        }
        if (startsWith == 2 && endsWith == 2) {
            return compTitle.indexOf(match) >= 0;
        }
        if (startsWith == 1 && endsWith == 1) {
            return compTitle.equals(match);
        }
        if (endsWith != 0) {
            return compTitle.endsWith(match);
        }
        return compTitle.startsWith(match);
    }

    private Component _findComponent(Component parent, Class[] compClass, String title, int level) {
        if (parent == null) {
            this.debugMsg(level, "Parent/Component is null: " + title);
            return null;
        }
        if (!parent.isVisible()) {
            this.debugMsg(level, "Parent/Component is not visible: " + parent.getClass().getName());
            return null;
        }
        this.debugMsg(level, "Checking parent/Component: " + parent.getClass().getName());
        if (this._classMatch(parent, compClass)) {
            String t;
            if (title == null) {
                this.debugMsg(level, "Found first Class match (null title) ...");
                return parent;
            }
            if (parent instanceof UITitledBox) {
                UITitledBox box = (UITitledBox)parent;
                String id = box.getScriptId();
                if (title.startsWith("$.")) {
                    this.debugMsg(level, "Comparing against UITitledBox ID: " + id);
                    if (id != null && (id.startsWith("$.") ? id.equals(title) : id.equals(title.substring("$.".length())))) {
                        return box;
                    }
                } else {
                    if (id != null && id.substring("$.".length()).equals(title)) {
                        return box;
                    }
                    t = ScriptRunnerCore.getComponentTitle(box);
                    this.debugMsg(level, "Comparing against UITitledBox title: " + t);
                    if (this.compareTitle(t, title)) {
                        return box;
                    }
                }
            } else if (parent instanceof JTabbedPane) {
                this.debugMsg(level, "Looking through JTabbedPane ...");
                JTabbedPane p = (JTabbedPane)parent;
                for (int i = 0; i < p.getTabCount(); ++i) {
                    t = ScriptRunnerCore.getComponentTitle((Component)p, i);
                    this.debugMsg(level + 1, "Comparing against tab: " + t);
                    if (!this.compareTitle(t, title)) continue;
                    return parent;
                }
            } else {
                String t2 = ScriptRunnerCore.getComponentTitle(parent);
                this.debugMsg(level, "Comparing against Component title: " + t2);
                if (this.compareTitle(t2, title)) {
                    return parent;
                }
            }
        }
        if (compClass != null && compClass.length > 0 && compClass[0] == JMenuBar.class) {
            JMenuBar mb;
            if (parent instanceof JFrame) {
                mb = ((JFrame)parent).getJMenuBar();
                return mb;
            }
            if (parent instanceof JDialog) {
                mb = ((JDialog)parent).getJMenuBar();
                return mb;
            }
        }
        if (parent instanceof JMenu) {
            JMenu m = (JMenu)parent;
            for (int i = 0; i < m.getItemCount(); ++i) {
                JMenuItem mi = m.getItem(i);
                if (mi == null || !this._classMatch(mi, compClass) || !this.compareTitle(mi.getText(), title)) continue;
                return mi;
            }
        }
        if (parent instanceof Container) {
            this.debugMsg(level, "Looking through Container children ...");
            Component[] child = ((Container)parent).getComponents();
            for (int i = 0; i < child.length; ++i) {
                Component c = this._findComponent(child[i], compClass, title, level + 1);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    private boolean _classMatch(Object obj, Class[] c) {
        if (c == null) {
            return true;
        }
        for (int i = 0; i < c.length; ++i) {
            if (!c[i].isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    public static String getComponentTitle(Component parent) {
        return ScriptRunnerCore.getComponentTitle(parent, null, -1);
    }

    public static String getComponentTitle(Component parent, int index) {
        return ScriptRunnerCore.getComponentTitle(parent, null, index);
    }

    public static String getComponentTitle(Component parent, Point loc) {
        return ScriptRunnerCore.getComponentTitle(parent, loc, -1);
    }

    private static String getComponentTitle(Component parent, Point loc, int index) {
        String title = null;
        if (parent instanceof UITitledBox) {
            title = ((UITitledBox)parent).getTitle();
            if (title == null) {
                title = ((UITitledBox)parent).getScriptId();
            }
        } else if (parent instanceof JTree) {
            TreePath tp;
            JTree tree = (JTree)parent;
            int sel = loc != null ? tree.getRowForLocation(loc.x, loc.y) : index;
            TreePath treePath = tp = sel >= 0 ? tree.getPathForRow(sel) : tree.getSelectionPath();
            if (tp != null) {
                title = tp.getLastPathComponent().toString();
            }
        } else if (parent instanceof JTabbedPane) {
            int tab;
            JTabbedPane tp = (JTabbedPane)parent;
            int n = tab = loc != null ? tp.getUI().tabForCoordinate(tp, loc.x, loc.y) : index;
            if (tab < 0) {
                tab = tp.getSelectedIndex();
            }
            if (tab >= 0) {
                title = tp.getTitleAt(tab);
            }
        } else if (parent instanceof InspectorPane) {
            title = ((InspectorPane)parent).getTabName();
        } else if (parent instanceof AbstractButton) {
            title = ((AbstractButton)parent).getText();
            if (title == null || title.equals("")) {
                title = ScriptRunnerCore.getIconTitle(((AbstractButton)parent).getIcon());
            }
        } else if (parent instanceof JLabel) {
            title = ((JLabel)parent).getText();
            if (title == null || title.equals("")) {
                title = ScriptRunnerCore.getIconTitle(((JLabel)parent).getIcon());
            }
        } else if (parent instanceof JComponent) {
            Object lblProp = ((JComponent)parent).getClientProperty("labeledBy");
            if (lblProp instanceof JLabel) {
                title = ((JLabel)lblProp).getText();
            }
        } else if (parent instanceof Frame) {
            title = ((Frame)parent).getTitle();
        } else if (parent instanceof Dialog) {
            title = ((Dialog)parent).getTitle();
        }
        if (title == null || title.equals("")) {
            title = ScriptRunnerCore.getDefaultTitle(parent);
        }
        return title;
    }

    private static String getIconTitle(Icon icon) {
        String title = null;
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            int s;
            title = ((ImageIcon)icon).getDescription();
            int n = s = title != null ? title.lastIndexOf(File.separator) : -1;
            if (s >= 0) {
                title = title.substring(s + 1);
            }
        } else {
            String cn = icon.getClass().getName();
            if (cn.indexOf("IconFactory$") >= 0) {
                int p = cn.lastIndexOf("$");
                title = cn.substring(p + 1);
            }
        }
        return title;
    }

    private static String getDefaultTitle(Component parent) {
        int cp;
        String title = parent.toString();
        int lp = title.indexOf("[");
        if (lp > 0) {
            title = title.substring(0, lp);
        }
        if ((cp = title.lastIndexOf(".")) >= 0) {
            title = title.substring(cp + 1);
        }
        title = title + "_" + ScriptRunnerCore.getComponentIndex(parent).toString();
        return title;
    }

    private static StringBuffer getComponentIndex(Component c) {
        Container p = c.getParent();
        if (p != null) {
            Component[] ch = p.getComponents();
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] != c) continue;
                StringBuffer sb = ScriptRunnerCore.getComponentIndex(p);
                if (sb.length() > 0) {
                    sb.append(".");
                }
                return sb.append(i);
            }
        }
        return new StringBuffer();
    }

    public static String getComponentSelection(Component parent) {
        if (parent instanceof UITitledList) {
            int ndx = ((UITitledList)parent).getSelectedIndex();
            return ndx >= 0 ? ((UITitledList)parent).getTitleAt(ndx) : null;
        }
        if (parent instanceof JList) {
            int ndx = ((JList)parent).getSelectedIndex();
            return ndx >= 0 ? "Row " + ndx : null;
        }
        if (parent instanceof UITitledTable) {
            JTable table = ((UITitledTable)parent).getTableView();
            if (table instanceof InspectorTable) {
                Object obj = ((InspectorTable)table).getSelectedRowObject();
                Object objVal = obj != null ? ((InspectorTable)table).getObjectValue(obj, 0) : null;
                return objVal != null ? objVal.toString() : null;
            }
            int ndx = table.getSelectedRow();
            return ndx >= 0 ? "Row " + ndx : null;
        }
        if (parent instanceof JTable) {
            int ndx = ((JTable)parent).getSelectedRow();
            return ndx >= 0 ? "Row " + ndx : null;
        }
        if (parent instanceof UITitledTree) {
            Object objVal = ((UITitledTree)parent).getSelectedUserObject();
            return objVal != null ? objVal.toString() : null;
        }
        if (parent instanceof JTree) {
            TreePath tp = ((JTree)parent).getSelectionPath();
            return tp != null ? tp.getLastPathComponent().toString() : null;
        }
        if (parent instanceof JTabbedPane) {
            int tab = ((JTabbedPane)parent).getSelectedIndex();
            return tab >= 0 ? ((JTabbedPane)parent).getTitleAt(tab) : null;
        }
        return null;
    }

    protected static String indent(int level) {
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "  ";
        }
        return indent;
    }

    protected void debugMsg(int level, String msg) {
        if (!debug) {
            return;
        }
        Print.println((String)(ScriptRunnerCore.indent(level) + msg));
    }

    protected class ModalWindowProbe
    extends MouseEvent
    implements ActiveEvent {
        private Object lock;
        private Window window;
        private boolean found;

        public ModalWindowProbe(Window win, Object lock) {
            super(win, 0, 0L, 0, 0, 0, 0, false);
            this.lock = null;
            this.window = null;
            this.found = false;
            this.lock = lock != null ? lock : this;
            this.window = win;
        }

        public Object getSource() {
            return this.window;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            Object object = this.lock;
            synchronized (object) {
                this.found = true;
                this.lock.notifyAll();
            }
        }

        public boolean found() {
            return this.found;
        }

        public Window getWindow() {
            return this.window;
        }
    }

    private static class WindowActivationListener
    implements AWTEventListener {
        private Window activeWindow = null;

        private WindowActivationListener() {
        }

        public void eventDispatched(AWTEvent ev) {
            switch (ev.getID()) {
                case 205: {
                    this.setActiveWindow((Window)ev.getSource());
                    break;
                }
                case 206: {
                    this.reset();
                }
            }
        }

        public void reset() {
            this.activeWindow = null;
        }

        private void setActiveWindow(Window win) {
            this.activeWindow = win;
        }

        public Window getActiveWindow() {
            return this.activeWindow;
        }
    }
}

