/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.script;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.script.Script;
import com.sun.enterprise.tools.deployment.ui.script.ScriptException;
import com.sun.enterprise.tools.deployment.ui.script.ScriptRunner;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.Print;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class RunScript
extends Thread {
    private static final String CONFIG_EXTENSION = ".conf";
    private static final String DFT_CONFIG = "TestHarness.conf";
    private static final String REASON_UNKNOWN = "Reason Unknown";
    private static final String SCRIPT_SUCCESSFUL = "Script completed successfully";
    private static final String SCRIPT_FAILED = "Script failed:";
    public static String SCRIPT_PACKAGE = UIConfig.UI_PACKAGE + "script";
    private static ClassLoader classLoader;
    protected Script script = null;
    protected boolean interactive = true;
    private boolean testPassed = false;
    private String errorMessage = null;
    private static ComponentCheckListener compCheckListener;
    private static ScriptRunner compInfoScriptRunner;
    static /* synthetic */ Class class$javax$swing$JComboBox;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledComboBox;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTable;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledBox;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTree;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList;

    public static void setClassLoader(ClassLoader cl) {
        classLoader = cl;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void runScript(String scriptName, Boolean interactive, Object arg) {
        if (scriptName != null && !scriptName.equals("")) {
            new RunScript(scriptName, interactive, arg);
        }
    }

    public static void runScript(String scriptName, Boolean interactive) {
        RunScript.runScript(scriptName, interactive, null);
    }

    public static void runScript(String scriptName, boolean interactive) {
        RunScript.runScript(scriptName, new Boolean(interactive), null);
    }

    private static Class getScriptClass(String className) {
        try {
            return RunScript.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private RunScript(String scriptName, Boolean interactive, Object arg) {
        this.interactive = interactive;
        Class scriptClass = RunScript.getScriptClass(scriptName);
        if (scriptClass == null && !scriptName.startsWith(SCRIPT_PACKAGE)) {
            scriptClass = RunScript.getScriptClass(SCRIPT_PACKAGE + "." + scriptName);
        }
        if (scriptClass == null) {
            this.showErrorMessage("Script not found:\n" + scriptName);
            return;
        }
        if (!Script.class.isAssignableFrom(scriptClass)) {
            this.showErrorMessage("Not a subclass of Script:\n" + scriptClass.getName());
            return;
        }
        try {
            if (arg != null) {
                Constructor c = scriptClass.getConstructor(Object.class);
                this.script = (Script)c.newInstance(arg);
            } else {
                this.script = (Script)scriptClass.newInstance();
            }
            this.script.setRunScriptThread(this);
            this.script.setInteractive(this.interactive);
        }
        catch (Exception ex) {
            Print.printStackTrace((String)"Error instantiating script class", (Throwable)ex);
            this.showErrorMessage("Unable to instantiate script class:\n" + scriptClass.getName());
            return;
        }
        if (!this.script.preCheck()) {
            return;
        }
        this.start();
    }

    public void run() {
        ScriptRunner.addWindowActivationListener();
        try {
            this.script.runScript();
            this.testPassed = true;
        }
        catch (ScriptException se) {
            this.errorMessage = se.getMessage();
            this.testPassed = false;
        }
        ScriptRunner.removeWindowActivationListener();
        if (this.script.isInteractive()) {
            EventQueue.invokeLater(new UIActionDispatcher((Object)this, "_scriptCompleted"));
        } else if (!this.testPassed) {
            String msg = this.errorMessage != null ? this.errorMessage : REASON_UNKNOWN;
            this.logMessage("Script failed: " + msg);
        } else {
            this.logMessage(SCRIPT_SUCCESSFUL);
        }
    }

    public void _scriptCompleted() {
        if (!this.testPassed) {
            String msg = this.errorMessage != null ? this.errorMessage : REASON_UNKNOWN;
            this.showErrorMessage("Script failed:\n" + msg);
        } else {
            this.showInfoMessage(SCRIPT_SUCCESSFUL);
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    protected void showErrorMessage(String msg) {
        this.logMessage(msg);
        if (this.isInteractive()) {
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), msg);
        }
    }

    protected void showInfoMessage(String msg) {
        this.logMessage(msg);
        if (this.isInteractive()) {
            UIOptionPane.showInfoDialog(DT.getApplicationFrame(), msg);
        }
    }

    protected boolean showConfirmMessage(String msg, boolean dftVal) {
        boolean rtn = this.isInteractive() ? UIOptionPane.showConfirmDialog(DT.getApplicationFrame(), msg) : dftVal;
        this.logMessage(msg + " [" + rtn + "]");
        return rtn;
    }

    public void logMessage(String m) {
        String msg = (this.script != null ? "{" + this.script.getScriptSource() + "} " + m : m).replace('\n', ' ');
        Print.println((String)msg);
    }

    public static UIConfigProperties getConfigProperties(String cfgName) {
        if (!cfgName.endsWith(CONFIG_EXTENSION)) {
            cfgName = cfgName + CONFIG_EXTENSION;
        }
        UIConfigProperties cfgProps = new UIConfigProperties();
        StringBuffer cfgListStr = new StringBuffer();
        Vector<String> cfgList = new Vector<String>();
        String[] cfgListArr = new String[]{cfgName, "testharness.conf", DFT_CONFIG};
        for (int i = 0; i < cfgListArr.length; ++i) {
            if (cfgList.contains(cfgListArr[i])) continue;
            if (cfgListStr.length() > 0) {
                cfgListStr.append(", ");
            }
            cfgListStr.append(cfgListArr[i]);
            cfgList.add(cfgListArr[i]);
        }
        ClassLoader rcl = RunScript.getClassLoader();
        Iterator i = cfgList.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            InputStream ris = rcl.getResourceAsStream(name);
            if (ris == null) continue;
            try {
                Print.println((String)("Loading TestHarness config resource: " + name));
                cfgProps.loadStream(ris);
                return cfgProps;
            }
            catch (IOException ioe) {
                Print.println((String)("Error loading: " + name + " => " + ioe));
            }
        }
        File cfgFile = new File(UIConfig.getConfigDirectory(), "testharness.conf");
        if (cfgFile.exists()) {
            Print.println((String)("Loading TestHarness config file: " + cfgFile));
            try {
                cfgProps.loadFile(cfgFile);
                return cfgProps;
            }
            catch (Exception ex) {
                Print.println((String)("Unable to load config: " + cfgFile));
            }
        }
        Print.println((String)"\n");
        Print.println((String)"Unable to locate TestHarness runtime config in the following locations:");
        Print.println((String)("  - Classpath resources: " + cfgListStr));
        Print.println((String)("  - Config File: " + cfgFile));
        Print.println((String)"Returning empty config");
        Print.println((String)"\n");
        return cfgProps;
    }

    public static boolean saveConfigProperties(UIConfigProperties cfgProps) {
        return RunScript.saveConfigProperties(cfgProps, null);
    }

    public static boolean saveConfigProperties(UIConfigProperties cfgProps, String header) {
        if (cfgProps == null) {
            return false;
        }
        if (cfgProps == UIConfig.getConfigProperties()) {
            return false;
        }
        if (cfgProps.getConfigFile() != null) {
            try {
                cfgProps.save(header != null ? header : " Script Configuration");
                return true;
            }
            catch (IOException ioe) {
                Print.dprintStackTrace((String)"Unable to save config", (Throwable)ioe);
                return false;
            }
        }
        return false;
    }

    public static void setComponentCheckEnabled(boolean flag) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (flag) {
            if (compCheckListener == null) {
                compCheckListener = new ComponentCheckListener();
            }
            tk.addAWTEventListener(compCheckListener, 40L);
        } else {
            tk.removeAWTEventListener(compCheckListener);
        }
    }

    private static void showComponentInfo(Component c, Point loc, boolean showAncestry) {
        String id;
        if (compInfoScriptRunner == null) {
            compInfoScriptRunner = new ScriptRunner();
        }
        if (c == null) {
            return;
        }
        Component p = c;
        while (true) {
            Container b;
            Container parent = p.getParent();
            if (p instanceof JButton && (b = RunScript.getParent(p, class$javax$swing$JComboBox == null ? RunScript.class$("javax.swing.JComboBox") : class$javax$swing$JComboBox)) != null) {
                p = b;
                continue;
            }
            if (p instanceof JComboBox && (b = RunScript.getParent(p, class$com$sun$enterprise$tools$deployment$ui$utils$UITitledComboBox == null ? RunScript.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox") : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledComboBox)) != null) {
                p = b;
                continue;
            }
            if (p instanceof JTextField && (b = RunScript.getParent(p, class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField == null ? RunScript.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField") : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField)) != null) {
                p = b;
                continue;
            }
            if (p instanceof JLabel && parent instanceof UITitledBox) {
                p = parent;
                continue;
            }
            if ((p instanceof JTable || p instanceof JTableHeader) && (b = RunScript.getParent(p, class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTable == null ? RunScript.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledTable") : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTable)) != null) {
                p = b;
                continue;
            }
            if (p instanceof JViewport && (b = RunScript.getParent(p, class$com$sun$enterprise$tools$deployment$ui$utils$UITitledBox == null ? RunScript.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledBox") : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledBox)) != null) {
                p = b;
                continue;
            }
            if (p instanceof JTree && (b = RunScript.getParent(p, class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTree == null ? RunScript.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledTree") : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTree)) != null) {
                p = b;
                continue;
            }
            if (!(p instanceof JList) || (b = RunScript.getParent(p, class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList == null ? RunScript.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledList") : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList)) == null) break;
            p = b;
        }
        Point parLoc = SwingUtilities.convertPoint(c, loc, p);
        String className = RunScript.getRecognizedClass(p.getClass()).getName();
        int cnp = className.lastIndexOf(".");
        if (cnp >= 0) {
            className = className.substring(cnp + 1);
        }
        Window w = WinTools.getAncestorWindow(p);
        Dimension wd = w.getSize();
        String wt = ScriptRunner.getComponentTitle(w);
        String pt = ScriptRunner.getComponentTitle(p, parLoc);
        String sel = ScriptRunner.getComponentSelection(p);
        String si = "";
        if (p instanceof UITitledBox && (id = ((UITitledBox)p).getScriptId()) != null) {
            si = "  [\"" + id + "\"]";
        }
        Print.println((String)"");
        Print.println((String)("Class    : " + className));
        Print.println((String)("Title    : \"" + pt + "\"" + si));
        Print.println((String)("Selection: \"" + sel + "\""));
        Print.println((String)("Window   : \"" + wt + "\"  [" + wd.width + "/" + wd.height + "]"));
        if (p instanceof UIHelpButton) {
            Print.println((String)("HelpID   : \"" + ((UIHelpButton)p).getHelpID() + "\""));
        } else {
            Print.println((String)("HelpID   : \"" + CSH.getHelpIDString((Component)p) + "\""));
        }
        try {
            Window fw = compInfoScriptRunner.findWindow(wt);
            Component fc = compInfoScriptRunner.findComponent((Component)fw, p.getClass(), pt);
            Print.println((String)"Found?   : Yes");
        }
        catch (Throwable t) {
            Print.println((String)("Found?   : No (" + t.getMessage() + ")"));
        }
        if (showAncestry) {
            Vector hier = new Vector();
            Print.println((String)"Parents  : ");
            for (Component cc = p; cc != null; cc = cc.getParent()) {
                Print.println((String)("     ==> " + UIUtils.debugClassName(cc)));
            }
        }
    }

    private static Class getRecognizedClass(Class c) {
        if (JTabbedPane.class.isAssignableFrom(c)) {
            return JTabbedPane.class;
        }
        if (UIButton.class.isAssignableFrom(c)) {
            return UIButton.class;
        }
        String n = c.getName();
        while (n.indexOf("$") >= 0 || n.indexOf(".plaf.") >= 0) {
            c = c.getSuperclass();
            n = c.getName();
        }
        return c;
    }

    private static Container getParent(Component comp, Class parentClass) {
        return WinTools.getAncestorOfClass(parentClass, comp);
    }

    static {
        Print.dprintln((String)"RunScript global initialization");
        RunScript.setComponentCheckEnabled(true);
        classLoader = null;
        compCheckListener = null;
        compInfoScriptRunner = null;
    }

    private static class ComponentCheckListener
    implements AWTEventListener {
        private Point lastCursor = null;

        private ComponentCheckListener() {
        }

        public void eventDispatched(AWTEvent ev) {
            KeyEvent ke;
            if (ev instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)ev;
                if (me.getID() == 503) {
                    Component c = (Component)me.getSource();
                    Point p = (Point)me.getPoint().clone();
                    SwingUtilities.convertPointToScreen(p, c);
                    this.lastCursor = p;
                }
            } else if (ev instanceof KeyEvent && (ke = (KeyEvent)ev).getID() == 401 && ke.getKeyCode() == 123) {
                Component c = (Component)ke.getSource();
                Window win = WinTools.getAncestorWindow(c);
                if (this.lastCursor != null) {
                    Point winLoc = (Point)this.lastCursor.clone();
                    SwingUtilities.convertPointFromScreen(winLoc, win);
                    Component topc = win.findComponentAt(winLoc);
                    Point compLoc = SwingUtilities.convertPoint(win, winLoc, topc);
                    RunScript.showComponentInfo(topc, compLoc, false);
                } else {
                    Print.dprintln((String)"Cursor location is unknown!");
                }
                ke.consume();
            }
        }
    }
}

