/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.script;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.script.Script;
import com.sun.enterprise.tools.deployment.ui.script.ScriptException;
import com.sun.enterprise.tools.deployment.ui.script.ScriptRunner;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import java.awt.Component;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class Deploytool
extends ScriptRunner {
    private Script script = null;

    public Deploytool() {
    }

    public Deploytool(Script script) {
        this.script = script;
    }

    public String getScriptSource() {
        return this.script != null ? this.script.getScriptSource() : "???";
    }

    public void closeAllObjects() throws ScriptException {
        Vector apps = DT.getModuleManager().getApplications();
        Enumeration e = apps.elements();
        while (e.hasMoreElements()) {
            Application app = (Application)e.nextElement();
            this.selectTreeDescriptor(app.getName());
            this.selectMenuItem(new String[]{"File", "Close"});
        }
    }

    public void newApplication(String newAppFile) throws ScriptException {
        this.selectMenuItem(new String[]{"File", "New", "Application"});
        Window appWin = this.findWindow("New Application");
        this.setTextField(appWin, "Application File Name", newAppFile);
        this.clickButton(appWin, "OK");
        try {
            Window confirmWin = this.findWindow("Confirmation Dialog");
            this.clickButton(confirmWin, "Yes");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
    }

    public void simpleObjectDeploy(String target, String server, boolean rtnClientJar) throws ScriptException {
        Window mainWin = this.findWindow("Application Deployment Tool");
        this.selectTreeDescriptor(target);
        this.selectMenuItem(new String[]{"Tools", "Deploy..."});
        this.pause(3000);
        Window depWin = this.findWindow("Deploy " + target);
        this.selectComboBox(depWin, "Object to Deploy", target);
        this.selectComboBox(depWin, "Target Server", server);
        if (rtnClientJar) {
            JCheckBox clientJarCB = (JCheckBox)this.findComponent((Component)depWin, JCheckBox.class, "Return Client");
            clientJarCB.setSelected(true);
        }
        this.clickButton(depWin, "Next");
        this.pause(2000);
        this.clickButton(depWin, "Next");
        this.pause(1000);
        this.clickButton(depWin, "Next");
        this.pause(1000);
        this.clickButton(depWin, "Finish");
        this.pause(1000);
        Window progWin = this.findWindow("Deployment Progress");
        this.pause(20000);
        this.findWindow("Error Dialog", 5000, false);
    }

    protected void saveObject(String target) throws ScriptException {
        Window mainWin = this.findWindow("Application Deployment Tool");
        this.selectTreeDescriptor(target);
        this.selectMenuItem(new String[]{"File", "Save"});
        this.pause(3000);
    }

    public JDialog newEjbWizard() throws ScriptException {
        this.selectMenuItem(new String[]{"File", "New", "Enterprise"});
        this.pause(3000);
        JDialog win = (JDialog)this.findWindow("New Enterprise Bean");
        if (win.getTitle().endsWith("Introduction")) {
            this.clickButton(win, "Next");
        }
        return win;
    }

    public JDialog newWarWizard() throws ScriptException {
        this.selectMenuItem(new String[]{"File", "New", "Web"});
        this.pause(3000);
        JDialog win = (JDialog)this.findWindow("New Web Component");
        if (win.getTitle().endsWith("Introduction")) {
            this.clickButton(win, "Next");
        }
        return win;
    }

    public void finishWizard(Window win, boolean gotoEnd) throws ScriptException {
        if (!(win instanceof Wizard)) {
            this.error("Not a 'Wizard' Window");
        }
        Wizard ejbWin = (Wizard)win;
        if (gotoEnd) {
            while (!ejbWin.getTitle().endsWith("Review Settings")) {
                this.clickButton(ejbWin, "Next");
            }
        }
        this.clickButton(ejbWin, "Finish");
    }

    public void createSimpleJSP(String warBundle, String appName, String jspName) throws ScriptException {
        JDialog warWin = this.newWarWizard();
        this.selectRadioButton(warWin, "Add to");
        this.selectComboBox(warWin, "$.WarChooser", warBundle + " (" + appName + ")");
        this.clickButton(warWin, "Next");
        this.selectRadioButton(warWin, "JSP");
        this.clickButton(warWin, "Next");
        this.selectComboBox(warWin, "JSP Filename", jspName);
        String name = jspName.substring(0, jspName.lastIndexOf(".")) + "Jsp";
        this.setTextField(warWin, "Web Component Name", name);
        this.clickButton(warWin, "Next");
        this.clickButton(warWin, "Next");
        UITitledTable table = (UITitledTable)this.findComponent((Component)warWin, UITitledTable.class, "Component Aliases");
        this.clickButton(warWin, "Add");
        this.setTableValues((Component)table, null, "", new String[]{"/" + jspName});
        this.clickButton(warWin, "Next");
        this.clickButton(warWin, "Finish");
    }
}

