/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.script;

import com.sun.enterprise.tools.deployment.ui.app.ApplicationWebContextInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbRefsInspector;
import com.sun.enterprise.tools.deployment.ui.script.Deploytool;
import com.sun.enterprise.tools.deployment.ui.script.Script;
import com.sun.enterprise.tools.deployment.ui.script.ScriptException;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JDialog;

public class CmpCustomerScript
extends Script {
    private static final String EJB_BUNDLE = "CmpEJB";
    private static final String WAR_BUNDLE = "CmpWAR";
    private static final String APP_NAME = "CmpCustomerApp";
    private static final String APP_EAR = "CmpCustomerApp.ear";
    private static final String SERVER = "localhost";
    private static String CONFIG_BASE_DIR = "ui.script.CmpCustomerScript.baseDir";
    private static String CONFIG_BASE_DIR_DEFAULT = "/tmp";
    private static String CONFIG_EAR_DIR = "ui.script.CmpCustomerScript.earDir";
    private static String CONFIG_TEST_VERSION = "ui.script.CmpCustomerScript.useTestVersion";
    private String scriptBaseDir = this.getConfigValue(CONFIG_BASE_DIR);
    private String earDir;
    private String earFile;
    private boolean useTestVersion;
    private Deploytool dtw = null;

    public CmpCustomerScript() {
        if (this.scriptBaseDir != null) {
            this.scriptBaseDir = CmpCustomerScript.platformFilename(this.scriptBaseDir);
            this.earDir = this.getConfigValue(CONFIG_EAR_DIR);
            if (this.earDir == null || this.earDir.equals("")) {
                this.earDir = this.scriptBaseDir;
            }
            this.earFile = CmpCustomerScript.makeFilename(this.earDir, APP_EAR);
        } else {
            this.scriptBaseDir = CmpCustomerScript.platformFilename(CONFIG_BASE_DIR_DEFAULT);
            this.earDir = CmpCustomerScript.getTemporaryDirectory();
            this.earFile = CmpCustomerScript.makeFilename(this.earDir, APP_EAR);
        }
        this.useTestVersion = this.getConfigBoolean(CONFIG_TEST_VERSION, true);
    }

    public boolean preCheck() {
        StringBuffer sb = new StringBuffer();
        sb.append("Test Script 'CmpCustomerApp' will run with the following settings:\n");
        sb.append("    Base Directory: " + this.scriptBaseDir + "\n");
        sb.append("    EAR File Directory: " + this.earDir + "\n");
        sb.append("    Use Test Version: " + this.useTestVersion);
        if (!this.showConfirmMessage(sb.toString(), true)) {
            return false;
        }
        if (!this.requireFileExists(this.scriptBaseDir, false)) {
            return false;
        }
        if (!this.requireServerRunning(SERVER, true)) {
            return false;
        }
        return this.requireApplicationClosed(APP_NAME, true);
    }

    public void runScript() throws ScriptException {
        this.dtw = new Deploytool();
        this.dtw.newApplication(this.earFile);
        this.create_webBundle();
        this.customer_security();
    }

    private void ejbGeneral_LocalEntity(Window ejbWin, String className, String localHome, String local) throws ScriptException {
        this.dtw.selectRadioButton(ejbWin, "Entity");
        this.dtw.selectComboBox(ejbWin, "Enterprise Bean Class", className);
        int p = className.lastIndexOf(".");
        String name = p < 0 ? className : className.substring(p + 1);
        this.dtw.setTextField(ejbWin, "Enterprise Bean Name", name);
        this.dtw.selectComboBox(ejbWin, "Local Home Interface", localHome);
        this.dtw.selectComboBox(ejbWin, "Local Interface", local);
    }

    private void ejbClickFinish(Window win) throws ScriptException {
        this.dtw.finishWizard(win, false);
    }

    public void create_AddressBean() throws ScriptException {
        JDialog ejbWin = this.dtw.newEjbWizard();
        this.dtw.selectRadioButton(ejbWin, "Create");
        this.dtw.selectComboBox(ejbWin, "AppChooser", APP_NAME);
        this.dtw.setTextField(ejbWin, "JAR Display Name", EJB_BUNDLE);
        this.dtw.clickButton(ejbWin, "Edit...");
        JDialog ceWin = (JDialog)this.dtw.findWindow("Edit Contents");
        if (this.useTestVersion) {
            this.dtw.selectComboBox(ceWin, null, this.scriptBaseDir);
            this.dtw.selectTreeItems(ceWin, null, new String[]{"classes"});
            this.dtw.clickButton(ceWin, "Add");
        } else {
            this.dtw.selectComboBox(ceWin, null, CmpCustomerScript.makeFilename(this.scriptBaseDir, "customer"));
            this.dtw.selectTreeItems(ceWin, null, new String[]{"AddressBean.class", "LocalCustomer.class", "SubscriptionBean.class", "CustomerBean.class", "LocalCustomerHome.class", "SubscriptionType.class", "LocalAddress.class", "LocalSubscription.class", "LocalAddressHome.class", "LocalSubscriptionHome.class"});
            this.dtw.clickButton(ceWin, "Add");
            this.dtw.selectComboBox(ceWin, null, CmpCustomerScript.makeFilename(this.scriptBaseDir, "util"));
            this.dtw.selectTreeItems(ceWin, null, new String[]{"Log.class"});
            this.dtw.clickButton(ceWin, "Add");
        }
        this.dtw.clickButton(ceWin, "OK");
        this.dtw.clickButton(ejbWin, "Next");
        this.ejbGeneral_LocalEntity(ejbWin, "customer.AddressBean", "customer.LocalAddressHome", "customer.LocalAddress");
        this.dtw.clickButton(ejbWin, "Next");
        this.dtw.selectRadioButton(ejbWin, "Container managed persistence (2.0)");
        this.dtw.selectCheckBoxList(ejbWin, null, new String[]{"state", "addressID", "street", "city", "zip"});
        this.dtw.setTextField(ejbWin, "Abstract Schema Name", "Address");
        this.dtw.setTextField(ejbWin, "Primary Key Class", "java.lang.String");
        this.dtw.selectComboBox(ejbWin, "Primary Key Field", "addressID");
        this.ejbClickFinish(ejbWin);
    }

    public void create_CustomerBean() throws ScriptException {
        JDialog ejbWin = this.dtw.newEjbWizard();
        this.dtw.selectRadioButton(ejbWin, "Add");
        this.dtw.selectComboBox(ejbWin, "EjbChooser", "CmpEJB (CmpCustomerApp)");
        this.dtw.clickButton(ejbWin, "Next");
        this.ejbGeneral_LocalEntity(ejbWin, "customer.CustomerBean", "customer.LocalCustomerHome", "customer.LocalCustomer");
        this.dtw.clickButton(ejbWin, "Next");
        this.dtw.selectRadioButton(ejbWin, "Container managed persistence (2.0)");
        this.dtw.selectCheckBoxList(ejbWin, null, new String[]{"customerID", "firstName", "lastName"});
        this.dtw.setTextField(ejbWin, "Abstract Schema Name", "Customer");
        this.dtw.setTextField(ejbWin, "Primary Key Class", "java.lang.String");
        this.dtw.selectComboBox(ejbWin, "Primary Key Field", "customerID");
        this.dtw.clickButton(ejbWin, "Finder/Select");
        JDialog fsWin = (JDialog)this.dtw.findWindow("Finder/Select Methods");
        this.dtw.selectRadioButton(fsWin, "Local Finders");
        Component table = this.dtw.findComponent((Component)fsWin, UITitledTable.class, null);
        Component text = this.dtw.findComponent((Component)fsWin, UITitledTextArea.class, null);
        this.dtw.selectTableRow(table, null, "findByLastName");
        this.pause(1000);
        this.dtw.setTextArea(text, null, "SELECT DISTINCT OBJECT(c) FROM Customer c WHERE c.lastName= ?1");
        this.pause(1000);
        this.dtw.selectTableRow(table, null, "findByFirstName");
        this.pause(1000);
        this.dtw.setTextArea(text, null, "SELECT DISTINCT OBJECT(c) FROM Customer AS c WHERE c.firstName = ?1");
        this.pause(1000);
        this.dtw.clickButton(fsWin, "OK");
        this.ejbClickFinish(ejbWin);
    }

    private void create_SubscriptionBean() throws ScriptException {
        JDialog ejbWin = this.dtw.newEjbWizard();
        this.dtw.selectRadioButton(ejbWin, "Add");
        this.dtw.selectComboBox(ejbWin, "EjbChooser", "CmpEJB (CmpCustomerApp)");
        this.dtw.clickButton(ejbWin, "Next");
        this.ejbGeneral_LocalEntity(ejbWin, "customer.SubscriptionBean", "customer.LocalSubscriptionHome", "customer.LocalSubscription");
        this.dtw.clickButton(ejbWin, "Next");
        this.dtw.selectRadioButton(ejbWin, "Container managed persistence (2.0)");
        this.dtw.selectCheckBoxList(ejbWin, null, new String[]{"title", "type"});
        this.dtw.setTextField(ejbWin, "Abstract Schema Name", "Subscription");
        this.dtw.setTextField(ejbWin, "Primary Key Class", "java.lang.String");
        this.dtw.selectComboBox(ejbWin, "Primary Key Field", "title");
        this.dtw.clickButton(ejbWin, "Finder/Select");
        JDialog fsWin = (JDialog)this.dtw.findWindow("Finder/Select Methods");
        this.dtw.selectRadioButton(fsWin, "Local Finders");
        Component table = this.dtw.findComponent((Component)fsWin, UITitledTable.class, null);
        Component text = this.dtw.findComponent((Component)fsWin, UITitledTextArea.class, null);
        this.dtw.selectTableRow(table, null, "findAllSubscription");
        this.pause(1000);
        this.dtw.setTextArea(text, null, "SELECT DISTINCT OBJECT(s) FROM Subscription s");
        this.pause(1000);
        this.dtw.clickButton(fsWin, "OK");
        this.ejbClickFinish(ejbWin);
    }

    private void set_EjbRelationships() throws ScriptException {
        this.dtw.selectTreeDescriptor(EJB_BUNDLE);
        this.dtw.selectTab("Relationships");
        this.dtw.clickButton(null, "Add");
        JDialog relWin = (JDialog)this.dtw.findWindow("Add Relationship");
        this.dtw.selectComboBox(relWin, "Multiplicity", "One to Many (1:*)");
        Component ejbA = this.dtw.findComponent((Component)relWin, UITitledBox.class, "Enterprise Bean A");
        this.dtw.selectComboBox(ejbA, "Enterprise Bean Name", "CustomerBean");
        this.dtw.selectComboBox(ejbA, "Field Referencing", "addresses");
        this.dtw.selectComboBox(ejbA, "Field Type", "java.util.Collection");
        Component ejbB = this.dtw.findComponent((Component)relWin, UITitledBox.class, "Enterprise Bean B");
        this.dtw.selectComboBox(ejbB, "Enterprise Bean Name", "AddressBean");
        this.dtw.selectComboBox(ejbB, "Field Referencing", "<none>");
        this.dtw.setCheckBox(ejbB, "Delete When", true);
        this.dtw.clickButton(relWin, "OK");
        this.dtw.clickButton(null, "Add");
        relWin = (JDialog)this.dtw.findWindow("Add Relationship");
        this.dtw.selectComboBox(relWin, "Multiplicity", "Many to Many (*:*)");
        ejbA = this.dtw.findComponent((Component)relWin, UITitledBox.class, "Enterprise Bean A");
        this.dtw.selectComboBox(ejbA, "Enterprise Bean Name", "CustomerBean");
        this.dtw.selectComboBox(ejbA, "Field Referencing", "subscriptions");
        this.dtw.selectComboBox(ejbA, "Field Type", "java.util.Collection");
        ejbB = this.dtw.findComponent((Component)relWin, UITitledBox.class, "Enterprise Bean B");
        this.dtw.selectComboBox(ejbB, "Enterprise Bean Name", "SubscriptionBean");
        this.dtw.selectComboBox(ejbB, "Field Referencing", "customers");
        this.dtw.selectComboBox(ejbB, "Field Type", "java.util.Collection");
        this.dtw.clickButton(relWin, "OK");
    }

    private void set_Ejb_EjbRefs() throws ScriptException {
        this.dtw.selectTreeDescriptor("AddressBean");
        this.dtw.selectTab("EJB Refs");
        Component box = this.dtw.findComponent(null, UITitledBox.class, "EJB's Referenced");
        Component table = this.dtw.findComponent(box, UITitledTable.class, null);
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"ejb/CustomerRef", "Entity", "Local", "customer.LocalCustomerHome", "customer.LocalCustomer"});
        this.dtw.selectTableRow(table, null, "ejb/CustomerRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "CustomerBean");
        this.dtw.selectTreeDescriptor("CustomerBean");
        this.dtw.selectTab("EJB Refs");
        box = this.dtw.findComponent(null, UITitledBox.class, "EJB's Referenced");
        table = this.dtw.findComponent(box, UITitledTable.class, null);
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"ejb/AddressRef", "Entity", "Local", "customer.LocalAddressHome", "customer.LocalAddress"});
        this.dtw.selectTableRow(table, null, "ejb/AddressRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "AddressBean");
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"ejb/SubscriptionRef", "Entity", "Local", "customer.LocalSubscriptionHome", "customer.LocalSubscription"});
        this.dtw.selectTableRow(table, null, "ejb/SubscriptionRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "SubscriptionBean");
        this.dtw.selectTreeDescriptor("SubscriptionBean");
        this.dtw.selectTab("EJB Refs");
        box = this.dtw.findComponent(null, UITitledBox.class, "EJB's Referenced");
        table = this.dtw.findComponent(box, UITitledTable.class, null);
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"ejb/CustomerRef", "Entity", "Local", "customer.LocalCustomerHome", "customer.LocalCustomer"});
        this.dtw.selectTableRow(table, null, "ejb/CustomerRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "CustomerBean");
    }

    private void create_webBundle() throws ScriptException {
        JDialog warWin = this.dtw.newWarWizard();
        this.dtw.selectRadioButton(warWin, "Create New WAR");
        this.dtw.selectComboBox(warWin, "$.AppChooser", APP_NAME);
        this.dtw.setTextField(warWin, "$.AppModuleDisplayName", WAR_BUNDLE);
        this.dtw.clickButton(warWin, "Edit...");
        JDialog ceWin = (JDialog)this.dtw.findWindow("Edit Contents");
        this.dtw.selectComboBox(ceWin, null, CmpCustomerScript.makeFilename(this.scriptBaseDir, "contentRoot"));
        this.dtw.selectTreeItems(ceWin, null, new String[]{"createCustomer.jsp", "createSubscription.jsp", "editCustomer.jsp", "index.html", "searchAddress.jsp", "searchCustomer.jsp", "searchSubscription.jsp"});
        this.dtw.clickButton(ceWin, "Add");
        this.dtw.clickButton(ceWin, "OK");
        this.dtw.clickButton(warWin, "Next");
        this.dtw.selectRadioButton(warWin, "No Component");
        this.dtw.clickButton(warWin, "Next");
        this.dtw.clickButton(warWin, "Finish");
    }

    private void create_customerJSPs() throws ScriptException {
        this.dtw.createSimpleJSP(WAR_BUNDLE, APP_NAME, "createCustomer.jsp");
        this.dtw.createSimpleJSP(WAR_BUNDLE, APP_NAME, "searchCustomer.jsp");
        this.dtw.createSimpleJSP(WAR_BUNDLE, APP_NAME, "editCustomer.jsp");
    }

    private void create_subscriptionJSPs() throws ScriptException {
        this.dtw.createSimpleJSP(WAR_BUNDLE, APP_NAME, "createSubscription.jsp");
        this.dtw.createSimpleJSP(WAR_BUNDLE, APP_NAME, "searchSubscription.jsp");
    }

    private void create_addressJSPs() throws ScriptException {
        this.dtw.createSimpleJSP(WAR_BUNDLE, APP_NAME, "searchAddress.jsp");
    }

    private void customer_security() throws ScriptException {
        Print.dprintln((String)"starting");
        this.dtw.selectTreeDescriptor(WAR_BUNDLE);
        this.dtw.selectTab("Security");
        Component t1 = this.dtw.findComponent(null, UITitledTable.class, "Security Constraints");
        this.dtw.clickButton(t1, "Add");
        Component t2 = this.dtw.findComponent(null, UITitledTable.class, "Web Resource Collections");
        this.dtw.clickButton(t2, "Add");
        Component t3 = this.dtw.findComponent(null, UITitledList.class, "Authorized Roles");
        this.dtw.clickButton(t3, "Edit");
        Window w1 = this.dtw.findWindow("Authorized Roles");
        this.dtw.clickButton(w1, "Edit Roles");
        Window w2 = this.dtw.findWindow("Edit Roles");
        Component t4 = this.dtw.findComponent((Component)w2, UITitledTable.class, "Defined Roles");
        this.dtw.clickButton(t4, "Add");
        this.dtw.setTableValues(t4, null, "", new String[]{"abc"});
        this.dtw.clickButton(w2, "OK");
        Component l1 = this.dtw.findComponent((Component)w1, UITitledList.class, "Roles in");
        this.dtw.selectTableRow(l1, null, "abc");
        this.dtw.clickButton(w1, "Add>");
        this.dtw.clickButton(w1, "OK");
    }

    private void set_War_EjbRefs() throws ScriptException {
        this.dtw.selectTreeDescriptor(WAR_BUNDLE);
        this.dtw.selectTab("EJB Refs");
        Component box = this.dtw.findComponent(null, UITitledBox.class, "EJB's Referenced");
        Component table = this.dtw.findComponent(box, UITitledTable.class, null);
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"CustomerBeanRef", "Entity", "Local", "customer.LocalCustomerHome", "customer.LocalCustomer"});
        this.dtw.selectTableRow(table, null, "CustomerBeanRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "CustomerBean");
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"AddressBeanRef", "Entity", "Local", "customer.LocalAddressHome", "customer.LocalAddress"});
        this.dtw.selectTableRow(table, null, "AddressBeanRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "AddressBean");
        this.dtw.clickButton(table, "Add");
        this.dtw.setTableValues(table, null, "", new String[]{"SubscriptionBeanRef", "Entity", "Local", "customer.LocalSubscriptionHome", "customer.LocalSubscription"});
        this.dtw.selectTableRow(table, null, "SubscriptionBeanRef");
        this.dtw.selectRadioButton(box, "Enterprise Bean Name");
        this.dtw.selectComboBox(box, EjbRefsInspector.ID_EJB_NAME, "SubscriptionBean");
    }

    private void set_Application_Settings() throws ScriptException {
        this.dtw.selectTreeDescriptor(APP_NAME);
        this.dtw.selectTab("JNDI Names");
        Component appJndi = this.dtw.findComponent(null, UITitledTable.class, "Application");
        Component refJndi = this.dtw.findComponent(null, UITitledTable.class, "References");
        this.dtw.setTableValues(appJndi, null, new String[]{"EJB", "AddressBean"}, new String[]{null, null, "CmpCustomerApp/Address"});
        this.dtw.setTableValues(appJndi, null, new String[]{"EJB", "CustomerBean"}, new String[]{null, null, "CmpCustomerApp/Customer"});
        this.dtw.setTableValues(appJndi, null, new String[]{"EJB", "SubscriptionBean"}, new String[]{null, null, "CmpCustomerApp/Subscription"});
        this.dtw.selectTab("Web Context");
        Component webCtx = this.dtw.findComponent(null, UITitledTable.class, ApplicationWebContextInspector.ID_WEB_CONTEXT_TABLE);
        this.dtw.setTableValues(webCtx, null, WAR_BUNDLE, new String[]{null, "customer"});
    }

    private void set_Generate_SQL() throws ScriptException {
        this.dtw.selectTreeDescriptor(EJB_BUNDLE);
        this.dtw.selectTab("General");
        this.dtw.clickButton(null, "Deployment Setting");
        Window dsWin = this.dtw.findWindow("Deployment Settings");
        this.dtw.setTextField(dsWin, "Database JNDI Name", "jdbc/Cloudscape");
        this.dtw.clickButton(dsWin, "Generate SQL");
        this.pause(1000);
        this.dtw.findWindow("Error Dialog", 5000, false);
        this.dtw.clickButton(this.dtw.findWindow("Information Dialog", 60000), "OK");
        this.dtw.clickButton(dsWin, "OK");
    }

    private void deploy_Application() throws ScriptException {
        this.dtw.saveObject(APP_NAME);
        this.dtw.simpleObjectDeploy(APP_NAME, SERVER, true);
    }
}

