/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.remote;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;

public abstract class DTRemoteStub
extends RemoteStub
implements Remote {
    private Class remoteInterface = null;
    private Hashtable methHash = new Hashtable();

    public DTRemoteStub(RemoteRef ref, Class ri) {
        super(ref);
        this.remoteInterface = ri;
    }

    protected Object invoke(Method meth, Object[] args) throws Exception {
        return this.ref.invoke(this, meth, args, DTRemoteStub.computeMethodHash(meth));
    }

    protected Object invoke(String methName, Object[] args, Class[] types) throws RemoteException {
        try {
            Method meth = (Method)this.methHash.get(methName);
            if (meth == null) {
                if (types == null) {
                    types = new Class[]{};
                }
                meth = this.remoteInterface.getMethod(methName, types);
                this.methHash.put(methName, meth);
            }
            return (String)this.invoke(meth, args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (RemoteException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnexpectedException("undeclared exception", ex);
        }
    }

    private static long computeMethodHash(Method m) {
        long hash = 0L;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(127);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            String s = DTRemoteStub.getMethodNameAndDescriptor(m);
            out.writeUTF(s);
            out.flush();
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                hash += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            hash = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return hash;
    }

    private static String getMethodNameAndDescriptor(Method m) {
        StringBuffer desc = new StringBuffer(m.getName());
        desc.append('(');
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            desc.append(DTRemoteStub.getTypeDescriptor(paramTypes[i]));
        }
        desc.append(')');
        Class<?> returnType = m.getReturnType();
        if (returnType == Void.TYPE) {
            desc.append('V');
        } else {
            desc.append(DTRemoteStub.getTypeDescriptor(returnType));
        }
        return desc.toString();
    }

    private static String getTypeDescriptor(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + type);
        }
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }
}

