/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.node.connector.ConnectorNode;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.rar.AdminObjInspector;
import com.sun.enterprise.tools.deployment.ui.rar.ConnectorRARGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.rar.MsgInspector;
import com.sun.enterprise.tools.deployment.ui.rar.ResAdaptGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorViewer;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.DTClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class NewResAdaptWizard
extends Wizard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NewResAdaptWizard.class);
    private static final String WIZARD_TITLE = localStrings.getLocalString("ui.newresadaptwizard.newwizardtitle", "New Resource Adapter Wizard");
    private static final String INTRO_HELP = localStrings.getLocalString("ui.newresadaptwizard.intro_help.new_rar", "<HTML><BODY><P>This wizard will help you to create a new resource adapter.  You must begin with the set of interface and implementation classes for the resource adapter.<BR>The wizard will then package these classes into a module file and will create the deployment descriptor required by the resource adapter.<P>Creating this resource adapter requires the following steps:<UL><LI>Identify the module file that will contain the resource adapter.<LI>Identify the interface and implementation classes for the resource adapter.</UL><P>Optionally, you can also define the:<UL><LI>Set of connection definitions<LI>Messaging support<LI>Set of administered objects<LI>Security settings</UL></BODY></HTML>");
    protected static String NEXT_STEPS_HELP = localStrings.getLocalString("ui.newresadaptwizard.next_steps", "<HTML><BODY>That is all the information needed to create a basic resource adapter.<br>When you click Finish, a resource adapter will be created and added to the tree control<P>Next steps:<UL><LI>Use the tabbed controls to further edit the standard deployment descriptor, if necessary</LI><LI>Click the File-Deploy menu to deploy the resource adapter to the server</LI></UL><P></BODY></HTML>");
    private static final String RAR_FILE_TITLE = localStrings.getLocalString("ui.newresadaptwizard.rar_file.title", "RAR File");
    private static final String RAR_FILE_HELP = localStrings.getLocalString("ui.newresadaptwizard.rar_file.help", "A Resource adapter ARchive (.RAR) file is required to contain this resource adapter.  You can create a stand-alone RAR file or add it to an existing application.  After you have selected the RAR file location, add the resource adapter interface and implemantation classes to its contents.");
    private static final String GENERAL_TITLE = localStrings.getLocalString("ui.newresadaptwizard.general.title", "General");
    private static final String GENERAL_HELP = localStrings.getLocalString("ui.newresadaptwizard.general.help", "Please enter the name of the interface and implementation classes to be included in your resource adapter and provide a display name for it.  Optionally, you can also indicate the type of transaction support required, provide the version information, define the icons to be used and provide a description for the resoruce adapter.");
    private static final String CONNFACT_TITLE = localStrings.getLocalString("ui.newresadaptwizard.conn_fact.title", "Connection Factories");
    private static final String CONNFACT_HELP = localStrings.getLocalString("ui.newresadaptwizard.conn_fact.help", "Please list the configuration properties for the connection factories for this resource adapter, as well as their types.  Optionally, you can provide a default value and a description for these properties.  You can also define a set of connection factories to be instantiated when the resource adapter is deployed.");
    private static final String ADMOBJ_TITLE = localStrings.getLocalString("ui.newresadaptwizard.adm_obj.title", "Administered Objects");
    private static final String ADMOBJ_HELP = localStrings.getLocalString("ui.newresadaptwizard.adm_obj.help", "You must provide a list of any administered objects contained in the archive.  Optionally, you can click on the icon in the last column to provide configuration properties for the administered object classes.");
    private static final String MSG_LISTENER_TITLE = localStrings.getLocalString("ui.newresadaptwizard.msg_listener.title", "Messaging Support");
    private static final String MSG_LISTENER_HELP = localStrings.getLocalString("ui.newresadaptwizard.msg_listener.help", "If this resource adapter is capable of delivering messages to message endpoints, you must provide a list of the message listener types supported, as well as the corresponding activation specification classes contained in this archive.\n Optionally, you can click on the icon in the last column to provide configuration properties for the activation specification classes.");
    private static final String SECURITY_TITLE = localStrings.getLocalString("ui.newresadaptwizard.security.title", "Security");
    private static final String SECURITY_HELP = localStrings.getLocalString("ui.newresadaptwizard.security.help", "Choose whether password authentication is to be used for this resource adapter and, if so, indicate whether reauthentication is supported.\nIf an security permissions are required other than the default set specified in the connector specification, please list them and provide a description explaining why they are required.");
    private static final String VENDOR_TYPE = localStrings.getLocalString("ui.newresadaptwizard.general.vendor_type", "Vendor Name");
    private static final String EIS_TYPE = localStrings.getLocalString("ui.newresadaptwizard.general.eis_type", "EIS Type");
    public static final String RESOURCE_VERSION_NUMBER = ConnectorNode.VERSION_15;
    private ConnectorDescriptor connectorDescriptor = null;
    private ConnectorRARGeneralInspector connRarGeneralInspector = null;
    private ResAdaptGeneralInspector rAGeneralInspector = null;
    private MsgInspector msgListenerInspector = null;
    private AdminObjInspector admObjInspector = null;
    private static String savedStartingDirectory = null;

    private static String ERROR_LOADING_CLASS(String v0) {
        return localStrings.getLocalString("ui.newresadaptwizard.error_loading_class", "Unable to load class specified in the module.\nPlease consult online help for assistance.\n  {0}", new Object[]{v0});
    }

    public static Descriptor newModule(Frame owner) throws IOException {
        return NewResAdaptWizard._showWizard(owner, "New");
    }

    public static Descriptor editModule(Frame owner) throws IOException {
        return NewResAdaptWizard._showWizard(owner, "Edit");
    }

    private static Descriptor _showWizard(Frame owner, String addMode) throws IOException {
        NewResAdaptWizard wizard = new NewResAdaptWizard(owner);
        wizard.connRarGeneralInspector.setWizardComponentMode(addMode);
        wizard.show();
        if (wizard.didComplete()) {
            ConnectorDescriptor desc = wizard.getCurrentConnectorDescriptor();
            ModuleContent fcd = wizard.getModuleContent();
            Descriptor target = wizard.isStandAlone() ? null : wizard.getSelectedParentDescriptor();
            String archFile = wizard.isStandAlone() ? wizard.getStandAloneArchiveFileName() : null;
            return NewResAdaptWizard.newComponent(desc, fcd, target, archFile);
        }
        return null;
    }

    private static Descriptor newComponent(ConnectorDescriptor newCD, ModuleContent fcd, Descriptor target, String archFileName) throws IOException {
        Application app = (Application)target;
        if (target == null) {
            app = null;
        } else if (target instanceof Application) {
            app = (Application)target;
        }
        if (app != null) {
            ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)newCD, null, fcd.getEntryNameMap());
            Descriptor md = modArch.addToApplication(app);
            return md;
        }
        ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)newCD, archFileName, fcd.getEntryNameMap());
        modArch.save();
        DT.getModuleManager().addModule((Descriptor)newCD);
        UIProject.resetProject((Descriptor)newCD);
        return newCD;
    }

    public String getHelpGroup() {
        return "RW";
    }

    public NewResAdaptWizard(Frame owner) {
        super(owner);
        super.setTitle(WIZARD_TITLE);
        this.addInspectors();
    }

    private void addInspectors() {
        String UI = UIConfig.UI_PACKAGE;
        super.addIntroPanel(INTRO_HELP);
        this.connRarGeneralInspector = (ConnectorRARGeneralInspector)this.addInspectorPane(UI + "rar.ConnectorRARGeneralInspector", RAR_FILE_TITLE, RAR_FILE_HELP).getPane();
        this.rAGeneralInspector = (ResAdaptGeneralInspector)this.addInspectorPane(UI + "rar.ResAdaptGeneralInspector", GENERAL_TITLE, GENERAL_HELP).getPane();
        this.msgListenerInspector = (MsgInspector)this.addInspectorPane(UI + "rar.MsgInspector", MSG_LISTENER_TITLE, MSG_LISTENER_HELP).getPane();
        this.admObjInspector = (AdminObjInspector)this.addInspectorPane(UI + "rar.AdminObjInspector", ADMOBJ_TITLE, ADMOBJ_HELP).getPane();
        this.addInspectorPane(UI + "rar.ResAdaptSecurityInspector", SECURITY_TITLE, SECURITY_HELP);
        this.addNextStepsPanel(NEXT_STEPS_HELP);
    }

    public ConnectorDescriptor getCurrentConnectorDescriptor() {
        if (this.connectorDescriptor == null) {
            this.connectorDescriptor = new ConnectorDescriptor();
            this.connectorDescriptor.setName("Rar1");
            this.addDescriptorListener((Descriptor)this.connectorDescriptor, new NotificationListener(){

                public void notification(NotificationEvent ae) {
                    NewResAdaptWizard.this.descriptorChanged();
                }
            });
        }
        return this.connectorDescriptor;
    }

    public void setCurrentConnectorDescriptor(ConnectorDescriptor descriptor) {
        this.connectorDescriptor = descriptor;
    }

    public Descriptor getSelectedParentDescriptor() {
        return this.connRarGeneralInspector.getSelectedParentDescriptor();
    }

    public ModuleContent getModuleContent() {
        return this.connRarGeneralInspector.getModuleContent();
    }

    public String getStandAloneArchiveFileName() {
        return this.connRarGeneralInspector.getArchiveFileName();
    }

    protected void descriptorChanged() {
        this.delegateNotification(this.getCurrentComponent());
    }

    void delegateNotification(Object insp) {
        if (insp instanceof DescriptorInspector) {
            ConnectorDescriptor cd = this.getCurrentConnectorDescriptor();
            ((DescriptorInspector)insp).setDescriptor((Descriptor)cd);
            if (insp instanceof InspectorPane) {
                ((InspectorPane)insp).invokeRefresh();
            }
        }
    }

    public void goForward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent == this.connRarGeneralInspector) {
            if (this.isStandAlone()) {
                String archName = this.getStandAloneArchiveFileName();
                if (archName.equals("")) {
                    UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newresadaptwizard.module_name_not_specified", "Please supply an module filename"));
                    return;
                }
                if (!archName.toLowerCase().endsWith(".rar")) {
                    archName = archName + ".rar";
                }
                if (!FileTools.validateFileName(this, archName)) {
                    return;
                }
            } else if (this.connRarGeneralInspector.getSelectedParentDescriptor() == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newresadaptwizard.please_select_application", "Please select an application"));
                return;
            }
            boolean hasJar = false;
            ModuleContent fcd = this.connRarGeneralInspector.getModuleContent();
            Enumeration e = fcd.getEntryNameMap().keys();
            while (e.hasMoreElements()) {
                String fn = e.nextElement().toString();
                if (!fn.endsWith(".jar") && !fn.endsWith(".class")) continue;
                hasJar = true;
            }
            if (!hasJar) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newresadaptwizard.content_not_added", "Please add .class or .jar files to the content."));
                return;
            }
            Vector clzList = this._getArchiveClasses(fcd);
            this.msgListenerInspector.setClassList(clzList);
            this.admObjInspector.setClassList(clzList);
            if (this.isStandAlone() && !this.connRarGeneralInspector.validateTargetLocation()) {
                return;
            }
        }
        super.goForward();
        JComponent newCurrent = super.getCurrentComponent();
        if (newCurrent instanceof DescriptorViewer.XMLTextArea) {
            ConnectorDescriptor cd = this.connectorDescriptor;
            ((DescriptorViewer.XMLTextArea)newCurrent).updateXMLText((Descriptor)cd);
        }
        this.delegateNotification(newCurrent);
    }

    public Vector getArchiveClasses() {
        ModuleContent fcd = this.connRarGeneralInspector.getModuleContent();
        return this._getArchiveClasses(fcd);
    }

    private Vector _getArchiveClasses(ModuleContent fcd) {
        ClassLoader fcdClassLoader = null;
        try {
            UIProject proj;
            fcdClassLoader = fcd.getClassLoader();
            Descriptor pd = this.getSelectedParentDescriptor();
            if (pd instanceof Descriptor && (proj = UIProject.getProject(pd)) != null) {
                DTClassLoader cl = (DTClassLoader)proj.getClassLoader(pd);
                cl.setParent(fcdClassLoader, true);
                fcdClassLoader = cl;
            }
        }
        catch (IOException ioe) {
            Print.println((String)"Unable to obtain ClassLoader");
            return null;
        }
        Vector clzList = null;
        try {
            clzList = UIJarPackager.getClassNames(fcd, fcdClassLoader);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Loading Servlet class", (Throwable)t);
            if (UIUtils.debugMode()) {
                UIJarPackager.printModuleContent(fcd, null);
                if (fcdClassLoader instanceof DTClassLoader) {
                    ((DTClassLoader)fcdClassLoader).printClassPaths();
                } else if (fcdClassLoader instanceof JarClassLoader) {
                    Print.println((String)("  (JarClassLoader)Classpath: " + ((JarClassLoader)fcdClassLoader).getClassPath()));
                }
            }
            UIOptionPane.showErrorDialog(this, NewResAdaptWizard.ERROR_LOADING_CLASS(t.toString()));
            return null;
        }
        return clzList;
    }

    public boolean isStandAlone() {
        return this.connRarGeneralInspector.isStandAlone();
    }

    public void goBackward() {
        super.goBackward();
    }

    public void finishAction() {
        String eis;
        String vn = this.connectorDescriptor.getVendorName();
        if (vn == null || vn.equals("")) {
            this.connectorDescriptor.setVendorName(VENDOR_TYPE);
        }
        if ((eis = this.connectorDescriptor.getEisType()) == null || eis.equals("")) {
            this.connectorDescriptor.setEisType(EIS_TYPE);
        }
        this.connectorDescriptor.setResourceAdapterVersion(RESOURCE_VERSION_NUMBER);
        if (this.isStandAlone()) {
            savedStartingDirectory = new File(this.getStandAloneArchiveFileName()).getParent();
        }
        this.connRarGeneralInspector.ensureNonNullDisplayName();
        super.finishAction();
    }

    public static String getSavedStartingDirectory() {
        String ret = savedStartingDirectory == null ? UIConfig.getStartingDirectory().getAbsolutePath() : savedStartingDirectory;
        Print.dprint((String)("Saving RAR starting directory as " + ret.toString()));
        return ret;
    }
}

