/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.rar.ConfigPropsDialog;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.TableCellEditor;

public class AdminObjInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AdminObjInspector.class);
    private static final String ADMIN_OBJ_TABLE_TITLE = localStrings.getLocalString("ui.adminobjinspector.admin_obj_table_title", "Administered Objects");
    private static final String IFACE_CLASS = localStrings.getLocalString("ui.adminobjinspector.iface_class", "Interface Class");
    private static final String IMPL_CLASS = localStrings.getLocalString("ui.adminobjinspector.impl_class", "Implementation Class");
    private static final String CLASS_NOT_IN_ARCH = localStrings.getLocalString("ui.adminobjinspector.class_not_in_arch", "There is no Implementation Class in the Archive that implements the interace you selected");
    private static final String TABNAME = localStrings.getLocalString("ui.adminobjinspector.tabname", "Administered Objects");
    private static String wizardHelpID = "RARAdminObjs";
    private static String deployHelpID = "RARAdminObjs";
    private ConnectorDescriptor descriptor = null;
    private UITitledTable admObjTablePanel = null;
    private AdminObjectTable admObjTable = null;
    private AdminObjectTableModel admObjTableModel = null;
    private Vector classList = null;
    private ConfigPropsDialog cfgPropsDiag = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new AdminObjInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        Print.dprintln((String)"Set Descriptor");
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof ConnectorDescriptor ? (ConnectorDescriptor)desc : null;
            this.admObjTable.clearTableData();
        }
        this.admObjTable.interfClassEditor = null;
    }

    public boolean validateEntries(boolean showErrors) {
        Print.dprintln((String)("validateEntries " + showErrors));
        this.admObjTable.interfClassEditor = null;
        return true;
    }

    private AdminObjInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.admObjTablePanel = new UITitledTable(ADMIN_OBJ_TABLE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.admObjTablePanel, c);
        this.admObjTableModel = new AdminObjectTableModel();
        this.admObjTable = new AdminObjectTable(this.admObjTableModel);
        this.admObjTablePanel.setTableView(this.admObjTable);
        this.admObjTablePanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AdminObjInspector.this.addAdminObjAction();
            }
        }));
        this.admObjTablePanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AdminObjInspector.this.deleteAdmObjAction();
            }
        }, true));
    }

    public void refresh() {
        this.admObjTable.updateTableData(this.descriptor.getAdminObjects());
    }

    public void setClassList(Vector newClassList) {
        this.classList = newClassList;
        this.admObjTable.interfClassEditor = null;
    }

    private void addAdminObjAction() {
        if (this.admObjTable.getRowWithValue(0, "") == null) {
            this.descriptor.addAdminObject(new AdminObject("", ""));
        }
        this.admObjTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteAdmObjAction() {
        Object[] list = this.admObjTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                AdminObject ref = (AdminObject)list[i];
                this.descriptor.removeAdminObject(ref);
            }
            this.invokeRefresh();
        }
    }

    public void cfgPropsAction() {
        AdminObject ref = (AdminObject)this.admObjTable.getSelectedRowObject();
        if (ref == null) {
            return;
        }
        if (this.cfgPropsDiag == null) {
            this.cfgPropsDiag = ConfigPropsDialog.newDialog(this);
        }
        this.cfgPropsDiag.showDialog((Descriptor)ref);
        this.invokeRefresh();
    }

    private class AdminObjectTableModel
    extends InspectorTableModel {
        public AdminObjectTableModel() {
            super(new String[]{IFACE_CLASS, IMPL_CLASS, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            AdminObject ref = (AdminObject)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getAdminObjectInterface();
                    break;
                }
                case 1: {
                    value = ref.getAdminObjectClass();
                    break;
                }
                case 2: {
                    value = ref.getConfigProperties().size() == 0 ? "blank" : "filled";
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            AdminObject ref = (AdminObject)obj;
            switch (col) {
                case 0: {
                    String val = value.toString();
                    ref.setAdminObjectInterface(val);
                    break;
                }
                case 1: {
                    ref.setAdminObjectClass(value != null ? value.toString() : "");
                    break;
                }
            }
        }
    }

    private class AdminObjectTable
    extends InspectorTable {
        private InspectorTable.TableComboBoxEditor interfClassEditor;
        private InspectorTable.TableIconCellEditor adminCfgPropsEditor;

        public AdminObjectTable(AdminObjectTableModel model) {
            super(model);
            this.interfClassEditor = null;
            this.adminCfgPropsEditor = null;
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.initIconColumn(2, UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_TBL_ICON), (Object[][])new Object[][]{{"filled", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_FILLED_TBL_ICON)}, {"blank", UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_TBL_ICON)}}, new ActionListener(this){
                private final /* synthetic */ AdminObjectTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AdminObjectTable.access$300(this.this$1).cfgPropsAction();
                }
            });
        }

        public TableCellEditor getCellEditor(int r, int c) {
            switch (c) {
                case 0: {
                    if (this.interfClassEditor == null) {
                        Print.dprintln((String)"redo interface class list");
                        Vector interfList = AdminObjInspector.this.getArchiveInterfaceNames();
                        interfList.add("javax.jms.Topic");
                        interfList.add("javax.jms.Queue");
                        interfList.add("javax.jms.Destination");
                        this.interfClassEditor = super.getComboBoxEditor(interfList);
                        this.interfClassEditor.setEditable(true);
                    }
                    return this.interfClassEditor;
                }
                case 1: {
                    Vector classList;
                    Class ifaceClass = null;
                    String ifaceName = (String)this.getValueAt(r, 0);
                    Vector implClasses = new Vector();
                    if (ifaceName != null && !"".equals(ifaceName) && (classList = AdminObjInspector.this.getArchiveClasses()) != null) {
                        Iterator i = classList.iterator();
                        while (i.hasNext()) {
                            Class clz = (Class)i.next();
                            if (!clz.getName().equals(ifaceName)) continue;
                            ifaceClass = clz;
                            break;
                        }
                        if (ifaceClass != null) {
                            Print.dprintln((String)("searching for class that implements " + ifaceClass.getName()));
                            implClasses = AdminObjInspector.this.getArchiveImplementationNames(new Class[]{ifaceClass});
                        }
                    }
                    if (implClasses.size() == 0) {
                        implClasses.add(" ");
                    }
                    InspectorTable.TableComboBoxEditor editor = super.getComboBoxEditor(implClasses);
                    editor.setEditable(true);
                    return editor;
                }
                case 2: {
                    if (this.adminCfgPropsEditor == null) {
                        this.adminCfgPropsEditor = new InspectorTable.TableIconCellEditor(new ActionListener(this){
                            private final /* synthetic */ AdminObjectTable this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void actionPerformed(ActionEvent ae) {
                                AdminObjectTable.access$300(this.this$1).cfgPropsAction();
                            }
                        });
                    }
                    return this.adminCfgPropsEditor;
                }
            }
            return super.getCellEditor();
        }

        static /* synthetic */ AdminObjInspector access$300(AdminObjectTable x0) {
            return x0.AdminObjInspector.this;
        }
    }
}

