/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.pref;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.pref.DeployManagerPreferences;
import com.sun.enterprise.tools.deployment.ui.pref.GeneralPreferences;
import com.sun.enterprise.tools.deployment.ui.pref.PreferencePanel;
import com.sun.enterprise.tools.deployment.ui.pref.StartupPreferences;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITreePaneViewer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class UIPreferences
extends UIDialog {
    private static String NodeSeparator = UITreePaneViewer.NodePathSeparator;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIPreferences.class);
    protected static String TITLE = localStrings.getLocalString("ui.uipreferences.title", "Edit Preferences");
    protected static String NODE_GENERAL;
    public static final String PREF_GENERAL;
    protected static String NODE_STARTUP;
    protected static String NODE_GENERAL_STARTUP;
    public static final String PREF_GENERAL_STARTUP;
    protected static String NODE_BROWSER;
    protected static String NODE_GENERAL_BROWSER;
    public static final String PREF_GENERAL_BROWSER;
    protected static String NODE_DEPMGRS;
    public static final String PREF_DEPMGRS;
    protected static String NODE_UPDATE;
    protected static String EDIT_PROPERTIES;
    private static UIPreferences prefDialog;
    private static PrefPanels prefPanels;
    protected UITreePaneViewer paneViewer = null;
    protected PrefPanels nodePanels = null;
    protected UIButton configPB = null;

    public static void editPreferences() {
        UIPreferences.editPreferences(null);
    }

    public static void editPreferences(String dftSel) {
        if (prefDialog == null) {
            UIPreferences.addPreferencePanel(NODE_GENERAL, new GeneralPreferences(NODE_GENERAL));
            UIPreferences.addPreferencePanel(NODE_GENERAL_STARTUP, new StartupPreferences(NODE_STARTUP));
            if (UIConfig.debugMode()) {
                UIPreferences.addPreferencePanel(NODE_DEPMGRS, new DeployManagerPreferences(NODE_DEPMGRS));
            }
            prefDialog = new UIPreferences();
        }
        prefDialog.showPreference(dftSel);
    }

    public static void addPreferencePanel(String prefPath, Component prefComp) {
        if (prefPanels == null) {
            prefPanels = new PrefPanels();
        }
        if (prefPath == null || prefPath.equals("")) {
            prefPath = UITreePaneViewer.NodePathSeparator;
        }
        prefPanels.put(prefPath, prefComp);
        if (prefDialog != null) {
            UIPreferences.prefDialog.paneViewer.addNode(prefPath, prefComp);
        }
    }

    protected UIPreferences(Frame frame) {
        super(frame, true);
        this.initLayout();
    }

    protected UIPreferences(Dialog dialog) {
        super(dialog, true);
        this.initLayout();
    }

    protected UIPreferences() {
        this(DT.getApplicationFrame());
    }

    protected void initLayout() {
        UIControlButtonBox content = new UIControlButtonBox(null, false);
        this.getContentBox().addWithGBConstraints(content);
        this.setTitle(TITLE);
        this.paneViewer = new UITreePaneViewer(TITLE, true);
        this.paneViewer.setDividerLocation(180);
        content.setView(this.paneViewer);
        this.nodePanels = new PrefPanels(prefPanels);
        Iterator i = this.nodePanels.keyIterator();
        while (i.hasNext()) {
            String prefPath = (String)i.next();
            Component prefComp = this.nodePanels.get(prefPath);
            this.paneViewer.addNode(prefPath, prefComp);
        }
        this.paneViewer.expandAllNodes();
        content.setControlButtonLocation(15);
        this.configPB = new UIButton(EDIT_PROPERTIES, '\u0000', new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (UIConfig.editConfig(UIPreferences.this)) {
                    UIPreferences.this.refreshConfig();
                }
            }
        });
        content.addControlButton(this.configPB);
        content.addControlSpacer(-1);
        UIButton savePB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIPreferences.this.saveConfig();
                UIPreferences.this.hide();
            }
        });
        content.addControlButton(savePB);
        UIButton cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIPreferences.this.hide();
            }
        });
        content.addControlButton(cancelPB);
        UIButton helpPB = UIButton.createHelpButton("EditPreferences");
        content.addControlButton(helpPB);
    }

    public void showPreference(String sel) {
        if (sel != null && !sel.equals("")) {
            UITreePaneViewer.ViewNode node = this.paneViewer.getNodeForName(sel);
            this.paneViewer.setSelectedNode(node);
        }
        this.show();
    }

    public void show() {
        this.refreshConfig();
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeToOwner();
        super.show();
    }

    public void refreshConfig() {
        this.nodePanels.refreshConfig();
        if (this.configPB != null) {
            this.configPB.setVisible(UIConfig.debugMode());
        }
    }

    public void saveConfig() {
        boolean restart = this.nodePanels.commitConfig();
        UIConfig.saveConfig();
        if (restart) {
            UIOptionPane.showInfoDialog(this, localStrings.getLocalString("ui.uipreferences.changes_effect_on_next_invocation", "Some of the changes that were made may require deploytool\nto be restarted before they will become effective"));
        }
    }

    static {
        PREF_GENERAL = NODE_GENERAL = localStrings.getLocalString("ui.uipreferences.general.node", "General");
        NODE_STARTUP = localStrings.getLocalString("ui.uipreferences.general.startup.node", "Startup");
        PREF_GENERAL_STARTUP = NODE_GENERAL_STARTUP = NODE_GENERAL + NodeSeparator + NODE_STARTUP;
        NODE_BROWSER = localStrings.getLocalString("ui.uipreferences.general.browser.node", "Web Browser");
        PREF_GENERAL_BROWSER = NODE_GENERAL_BROWSER = NODE_GENERAL + NodeSeparator + NODE_BROWSER;
        PREF_DEPMGRS = NODE_DEPMGRS = localStrings.getLocalString("ui.uipreferences.deploy_managers.node", "Deployment Managers");
        NODE_UPDATE = localStrings.getLocalString("ui.uipreferences.update.node", "Update");
        EDIT_PROPERTIES = localStrings.getLocalString("ui.uipreferences.edit_properties", "Properties...");
        prefDialog = null;
        prefPanels = null;
    }

    private static class PrefPanels {
        private Vector prefOrder = null;
        private HashMap prefMap = null;

        public PrefPanels() {
            this.prefOrder = new Vector();
            this.prefMap = new HashMap();
        }

        public PrefPanels(PrefPanels copy) {
            this.prefOrder = new Vector(copy.prefOrder);
            this.prefMap = new HashMap(copy.prefMap);
        }

        private PrefPanels(Vector order, HashMap map) {
            this.prefOrder = new Vector(order);
            this.prefMap = new HashMap(map);
        }

        public Object clone() {
            return new PrefPanels(this.prefOrder, this.prefMap);
        }

        public void put(String prefPath, Component prefComp) {
            this.prefOrder.add(prefPath);
            this.prefMap.put(prefPath, prefComp);
        }

        public Component get(String prefPath) {
            return (Component)this.prefMap.get(prefPath);
        }

        public void remove(Object key) {
            this.prefOrder.remove(key);
            this.prefMap.remove(key);
        }

        public Iterator keyIterator() {
            return this.prefOrder.iterator();
        }

        public void refreshConfig() {
            Iterator i = this.prefMap.values().iterator();
            while (i.hasNext()) {
                Component prefComp = (Component)i.next();
                if (!(prefComp instanceof PreferencePanel)) continue;
                ((PreferencePanel)((Object)prefComp)).refreshConfig();
            }
        }

        public boolean commitConfig() {
            boolean restart = false;
            Iterator i = this.prefMap.values().iterator();
            while (i.hasNext()) {
                Component prefComp = (Component)i.next();
                if (!(prefComp instanceof PreferencePanel) || !((PreferencePanel)((Object)prefComp)).commitConfig()) continue;
                restart = true;
            }
            return restart;
        }
    }
}

