/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.pref;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.pref.PreferencePanel;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.PublicCloneable;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellEditor;

public class PreferenceTable
extends UITitledTable
implements PreferencePanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PreferenceTable.class);
    protected static String N_A = localStrings.getLocalString("ui.preferencetable.not_available", "n/a");
    protected static String LIST = localStrings.getLocalString("ui.preferencetable.list", "<list>");
    protected static String UNKNOWN = localStrings.getLocalString("ui.preferencetable.unknown", "<unknown>");
    private String configKey = null;
    private Object template = null;
    private PrefTable table = null;
    private PrefTableModel model = null;
    private boolean restartRequired = false;
    private PrefRecordHandler prefRcdHandler = null;

    public PreferenceTable(String title, boolean showBorder, String cfgKey, String[] colNames) {
        super(title, showBorder);
        this.model = new PrefTableModel(colNames);
        this.table = new PrefTable(this.model);
        this.setTableView(this.table);
        this.setConfigKey(cfgKey);
    }

    public void addEditButtons(int btnLoc) {
        this.setControlButtonLocation(btnLoc);
        UIButton addBtn = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PreferenceTable.this.addNewRecord();
            }
        });
        this.addControlButton(addBtn);
        UIButton delBtn = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PreferenceTable.this.removeSelectedRecord();
            }
        });
        this.addSelectionEnabledButton(delBtn);
    }

    public void setRecordHandler(PrefRecordHandler prh) {
        this.prefRcdHandler = prh;
    }

    public void setConfigKey(String key) {
        this.configKey = key;
    }

    public void setCellEditors(Object[] colTypes) {
        this.table.setCellEditors(colTypes);
    }

    public void setRestartRequired(boolean required) {
        this.restartRequired = required;
    }

    public void setNewRecordTemplate(Object template) {
        this.template = template;
    }

    public void addNewRecord() {
        this._addNewRecord(this.template);
    }

    public void addNewRecord(Object tmpl) {
        this._addNewRecord(tmpl);
    }

    protected void _addNewRecord(Object tmpl) {
        Object colVal;
        Object rowObj;
        Object newRcd = null;
        if (tmpl instanceof PrefNewRecord) {
            newRcd = ((PrefNewRecord)tmpl).newRecord();
        } else if (tmpl instanceof Class) {
            try {
                newRcd = ((Class)tmpl).newInstance();
            }
            catch (Throwable t) {
                Print.printStackTrace((String)"Unable to create new record", (Throwable)t);
            }
        } else if (tmpl instanceof List) {
            newRcd = ListTools.listTreeCopy((List)tmpl);
        } else if (tmpl instanceof Object[]) {
            newRcd = ListTools.arrayTreeCopy((Object[])tmpl);
        } else if (tmpl instanceof String) {
            newRcd = tmpl;
        } else if (tmpl instanceof PublicCloneable) {
            newRcd = ((PublicCloneable)tmpl).clone();
        }
        if (newRcd == null) {
            newRcd = "";
        }
        if ((rowObj = this.model.getRowWithValue(0, colVal = this.model.getObjectValue(newRcd, 0))) == null) {
            this.model.addRowObject(newRcd, true);
            this.model.fireTableDataChanged();
        }
    }

    public void removeSelectedRecord() {
        Object[] sel = this.table.confirmDeleteSelection(null, null);
        if (sel != null) {
            int last = sel.length - 1;
            for (int i = 0; i <= last; ++i) {
                this.model.removeRowObject(sel[i], i == last);
            }
        }
    }

    public List getConfigData() {
        return this.model.getData();
    }

    public void setConfigData(List list) {
        this.model.setData(list != null ? list : new Vector());
    }

    public void setConfigData(Object[] array) {
        this.setConfigData(ListTools.toList(array));
    }

    public void setConfigData(List list, int dataSet) {
        if (list != null && dataSet < list.size()) {
            Object elem = list.get(dataSet);
            if (elem instanceof List) {
                this.model.setData((List)elem);
            } else if (elem instanceof Object[]) {
                this.model.setData(ListTools.toList((Object[])elem));
            } else {
                Vector v = new Vector();
                v.add(elem);
                this.model.setData(v);
            }
        } else {
            this.model.setData(new Vector());
        }
    }

    public void setConfigData(Object[] array, int dataSet) {
        this.setConfigData(ListTools.toList(array), dataSet);
    }

    public void clearTableData() {
        Print.printStackTrace((String)"Use 'setConfigData(null)' instead");
        this.setConfigData((List)null);
    }

    public void refreshConfig() {
        if (this.configKey != null) {
            List list = UIConfig.getConfigList(this.configKey);
            this.model.setData(list);
        }
    }

    public boolean commitConfig() {
        if (this.configKey != null) {
            String oldValue = UIConfig.getConfigValue(this.configKey, "");
            UIConfig.setConfigList(this.configKey, this.model.getData());
            String newValue = UIConfig.getConfigValue(this.configKey, "");
            return newValue.equals(oldValue) ? false : this.restartRequired;
        }
        return false;
    }

    protected class PrefTableModel
    extends InspectorTableModel {
        public PrefTableModel(String[] colNames) {
            super(colNames);
        }

        public boolean isCellEditable(int row, int col) {
            Object ref = this.getRowObject(row);
            if (PreferenceTable.this.prefRcdHandler != null) {
                return PreferenceTable.this.prefRcdHandler.isColumnEditable(ref, col);
            }
            if (ref instanceof String) {
                return col == 0;
            }
            if (ref instanceof Vector) {
                Vector v = (Vector)ref;
                if (col < v.size()) {
                    ref = v.elementAt(col);
                    return ref instanceof String;
                }
                return false;
            }
            if (ref instanceof Object[]) {
                Object[] a = (Object[])ref;
                if (col < a.length) {
                    ref = a[col];
                    return ref instanceof String;
                }
                return false;
            }
            Print.dprintln((String)("Can't handle row type: " + UIUtils.debugClassName(ref)));
            return false;
        }

        public Object getObjectValue(Object ref, int col) {
            if (PreferenceTable.this.prefRcdHandler != null) {
                return PreferenceTable.this.prefRcdHandler.getColumnValue(ref, col);
            }
            if (ref instanceof String) {
                return col == 0 ? ((String)ref).trim() : N_A;
            }
            if (ref instanceof Vector) {
                Vector v = (Vector)ref;
                if (col < v.size()) {
                    Object item = v.elementAt(col);
                    return item instanceof String ? ((String)item).trim() : LIST;
                }
                return N_A;
            }
            if (ref instanceof Object[]) {
                Object[] a = (Object[])ref;
                if (col < a.length) {
                    Object item = a[col];
                    return item instanceof String ? ((String)item).trim() : LIST;
                }
                return N_A;
            }
            Print.dprintln((String)("Can't handle row type: " + UIUtils.debugClassName(ref)));
            return UNKNOWN;
        }

        public void setValueAt(Object value, int row, int col) {
            if (value instanceof String) {
                Object ref = this.getRowObject(row);
                if (PreferenceTable.this.prefRcdHandler != null) {
                    PreferenceTable.this.prefRcdHandler.setColumnValue(ref, col, value);
                } else if (ref instanceof String) {
                    this.replaceRowObject(row, (Object)((String)value).trim(), true);
                } else if (ref instanceof Vector) {
                    Vector v = (Vector)ref;
                    if (col < v.size() && v.elementAt(col) instanceof String) {
                        v.setElementAt(((String)value).trim(), col);
                        this.fireTableCellUpdated(row, col);
                    }
                } else if (ref instanceof Object[]) {
                    Object[] a = (Object[])ref;
                    if (col < a.length && a[col] instanceof String) {
                        a[col] = ((String)value).trim();
                        this.fireTableCellUpdated(row, col);
                    }
                } else {
                    Print.dprintln((String)("Can't handle row type: " + UIUtils.debugClassName(ref)));
                }
            } else {
                Print.dprintln((String)("Can't handle value type: " + UIUtils.debugClassName(value)));
            }
        }

        public void setObjectValue(Object item, int col, Object value) {
            Print.printStackTrace((String)"Should not be called");
        }
    }

    protected class PrefTable
    extends InspectorTable {
        private String[] columnTypes;
        private TableCellEditor[] columnEditors;

        public PrefTable(PrefTableModel model) {
            super(model);
            this.columnTypes = null;
            this.columnEditors = null;
        }

        public void setCellEditors(Object[] colTypes) {
            this.columnEditors = new TableCellEditor[this.getColumnCount()];
            if (colTypes != null) {
                for (int i = 0; i < colTypes.length; ++i) {
                    if (colTypes[i] instanceof TableCellEditor) {
                        this.columnEditors[i] = (TableCellEditor)colTypes[i];
                        continue;
                    }
                    if (colTypes[i] instanceof String[]) {
                        this.columnEditors[i] = super.getComboBoxEditor((String[])colTypes[i]);
                        continue;
                    }
                    if (colTypes[i] == null) continue;
                }
            }
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor tce = this.columnEditors != null && col < this.columnEditors.length ? this.columnEditors[col] : null;
            return tce != null ? tce : super.getCellEditor(row, col);
        }
    }

    public static interface PrefRecordHandler {
        public Object getColumnValue(Object var1, int var2);

        public void setColumnValue(Object var1, int var2, Object var3);

        public boolean isColumnEditable(Object var1, int var2);
    }

    public static interface PrefNewRecord {
        public Object newRecord();
    }
}

