/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.pref;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.pref.PreferencePanel;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledHTMLText;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class GeneralPreferences
extends UITitledBox
implements PreferencePanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GeneralPreferences.class);
    protected static String GENERAL_TEMPDIR = localStrings.getLocalString("ui.generalpreferences.temp_dir", "Temporary Directory");
    protected static String MISCELLANEOUS = localStrings.getLocalString("ui.generalpreferences.misc.title", "Miscellaneous");
    protected static String SHOW_SHORT_URI_IN_TREE = localStrings.getLocalString("ui.generalpreferences.misc.show_short_uri", "Show abbreviated Deployment Manager URI in tree");
    protected static String DONT_ASK_SAVE_AND_DEPLOY = localStrings.getLocalString("ui.generalpreferences.misc.dont_ask_save_and_deploy", "Don't ask me again to save and deploy");
    private UITitledHTMLText tempDirHelp = null;
    private UITitledTextField tempDirectory = null;
    private UICheckBox showLongDepMgrUris = null;
    private UICheckBox dontAsk = null;
    public static final String dontAskSaveAndDeploy = "ui.dontShowAgain_SaveAndDeploy";

    protected static String GENERAL_TEMPDIR_HELP(Object v0) {
        return localStrings.getLocalString("ui.generalpreferences.temp_dir.help", "Set the directory name to use for temporary file creation in the deploytool.<br>Leave blank for default: <b>{0}</b>", new Object[]{v0});
    }

    protected static String TEMPDIR_NONEXISTENT(Object v0) {
        return localStrings.getLocalString("ui.generalpreferences.temp_dir.doesnt_exist", "Specified temporary directory does not exist.\n {0}", new Object[]{v0});
    }

    public GeneralPreferences(String nodeTitle) {
        super(nodeTitle, true);
        GridBagConstraints gbc = this.getGBConstraints();
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        UITitledBox tempDir = new UITitledBox(GENERAL_TEMPDIR, true);
        this.addWithGBConstraints(tempDir);
        this.tempDirHelp = new UITitledHTMLText(null, false);
        tempDir.addWithGBConstraints(this.tempDirHelp);
        this.tempDirHelp.setText(GeneralPreferences.GENERAL_TEMPDIR_HELP(UIConfig.getDefaultTempDirectory()));
        this.tempDirectory = new UITitledTextField(null, false);
        this.tempDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String f = GeneralPreferences.this.tempDirectory.getText();
                if (!f.equals("") && !new File(f).exists()) {
                    UIOptionPane.showWarningDialog(GeneralPreferences.this, GeneralPreferences.TEMPDIR_NONEXISTENT(f));
                }
            }
        });
        tempDir.addWithGBConstraints(this.tempDirectory);
        gbc.insets.top = 5;
        UITitledBox miscBox = new UITitledBox(MISCELLANEOUS, true);
        this.addWithGBConstraints(miscBox);
        miscBox.getGBConstraints().insets.left = 10;
        this.showLongDepMgrUris = new UICheckBox(SHOW_SHORT_URI_IN_TREE);
        miscBox.addWithGBConstraints(this.showLongDepMgrUris);
        this.dontAsk = new UICheckBox(DONT_ASK_SAVE_AND_DEPLOY);
        miscBox.addWithGBConstraints(this.dontAsk);
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.addWithGBConstraints(new UITitledBox(null, false));
    }

    public void refreshConfig() {
        this.tempDirHelp.setText(GeneralPreferences.GENERAL_TEMPDIR_HELP(UIConfig.getDefaultTempDirectory()));
        this.tempDirectory.setText(UIConfig.getConfigValue("ui.tempDirectory"));
        this.showLongDepMgrUris.setSelected(UIConfig.getConfigBoolean("ui.tree.showAbbreviatedUri"));
        this.dontAsk.setSelected(UIConfig.getConfigBoolean(dontAskSaveAndDeploy));
    }

    public boolean commitConfig() {
        boolean restart = !this.tempDirectory.getText().equals(UIConfig.getConfigValue("ui.tempDirectory"));
        UIConfig.setConfigValue("ui.tempDirectory", this.tempDirectory.getText());
        UIConfig.setConfigBoolean("ui.tree.showAbbreviatedUri", this.showLongDepMgrUris.isSelected());
        UIConfig.setConfigBoolean(dontAskSaveAndDeploy, this.dontAsk.isSelected());
        DT.getServerManager().fireServerRefreshNotification();
        return restart;
    }
}

