/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbComponentGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbEntityInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbJarGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbMessageInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorViewer;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleManagerImpl;
import com.sun.enterprise.tools.deployment.ui.shared.MsgDestRefsInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.tools.deployment.ui.websrv.WSEndpointInspector;
import com.sun.enterprise.tools.deployment.ui.websrv.WSLocationInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.xml.namespace.QName;

public class NewEjbWizard
extends Wizard
implements DescriptorInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NewEjbWizard.class);
    public static final String WIZARD_TITLE_NEW = localStrings.getLocalString("ui.newejbwizard.title.new", "New Enterprise Bean Wizard");
    private static final String WIZARD_TITLE_EDIT = localStrings.getLocalString("ui.newejbwizard.title.edit", "Edit Enterprise Bean Wizard");
    private static String INTRO_HELP = localStrings.getLocalString("ui.newejbwizard.intro_help.new_ejb", "<HTML><BODY><P>This wizard will help you to create a new Enterprise Bean.  You must begin with an implementation and interface classes for the bean.<br>The wizard will then package the selected files into an EJB JAR module and will create the deployment descriptor required.<P>Creating this bean requires the following steps:<UL><LI>Select the EJB JAR module to contain the bean<LI>Identify the bean's interface and implementation classes</UL></BODY></HTML>");
    protected static String NEXT_STEPS_HELP = localStrings.getLocalString("ui.newejbwizard.next_steps", "<HTML><BODY>That is all the information needed to create a basic enterprise bean.<br>When you click Finish, an enterprise bean &#060;and module&#062; will be created and added to the tree control<P>Next steps:<UL><LI>Use the tabbed controls to further edit the standard deployment descriptor, if necessary</LI><LI>Provide any required Sun-specific settings, if necessary</LI><LI>Click the Tools>Deploy menu to deploy the enterprise bean to the server</LI></UL><P></BODY></HTML>");
    private static String EJB_JAR_TITLE = localStrings.getLocalString("ui.newejbwizard.ejb_jar_gen.title", "EJB JAR General Settings");
    private static String EJB_JAR_HELP = localStrings.getLocalString("ui.newejbwizard.ejb_jar_gen.help", "An EJB Jar module is required to contain this enterprise bean.\nSelect the location and name of the module to be used.\nThen click the Edit button and add the desired files to the module.");
    private static String EJB_CLASSES_REQD = localStrings.getLocalString("ui.newejbwizard.ejb_classes_reqd", "Enterprise Bean Classes Required");
    private static String GENERAL_TITLE = localStrings.getLocalString("ui.newejbwizard.bean_general.title", "Bean General Settings");
    private static String GENERAL_HELP = localStrings.getLocalString("ui.newejbwizard.bean_general.help", "Please choose the enterprise bean class and indicate the type, if necessary.\nYou must also choose the interface classes.  You can choose to provide only local interfaces, only remote interfaces, or both.");
    private static String CONFIG_OPTION_TITLE = localStrings.getLocalString("ui.newejbwizard.config_options.title", "Expose as Web Service Endpoint");
    private static String CONFIG_OPTION_HELP = localStrings.getLocalString("ui.newejbwizard.config_options.help", "Do you want to expose this bean as a web service endpoint?");
    private static final String SETTINGS_SELECTOR_HELP = localStrings.getLocalString("ui.newejbwizard.settings_selector_help", "Please select the set of bean-level settings that you would like to define.");
    private static final String SETTINGS_SELECTOR = localStrings.getLocalString("ui.newejbwizard.settings_selector", "Bean-level Settings:");
    private static String WEBSERVICE_LOCATION_TITLE = localStrings.getLocalString("ui.newejbwizard.websrv.location.title", "Choose Service");
    private static String WEBSERVICE_LOCATION_HELP = localStrings.getLocalString("ui.newejbwizard.websrv.location.help", "This web service endpoint must be contained within a web service. You may either define a new service, or add it to an existing service.");
    private static String WEBSERVICE_ENDPOINT_TITLE = localStrings.getLocalString("ui.newejbwizard.websrv.endpoint.title", "Web Service Endpoint");
    private static String WEBSERVICE_ENDPOINT_HELP = localStrings.getLocalString("ui.newejbwizard.websrv.endpoint.help", "Please choose the service endpoint interface that this endpoint implements.\nYou must also identify which port in the WSDL file this endpoint maps to, and provide a port component name.");
    private static String ENTITY_TITLE = localStrings.getLocalString("ui.newejbwizard.entity_settings.title", "Entity Bean Settings");
    private static String ENTITY_HELP = localStrings.getLocalString("ui.newejbwizard.entity_settings.help", "Since this is an entity bean, please choose the type of persistence management that it supports.\nYou must also provide the primary key and optionally the primary key field name.\nIf you are using container managed persistence, please choose the fields to be persisted.\nYou may also provide EJB-QL queries to handle finder and select methods.");
    private static String TRANSACTION_TITLE = localStrings.getLocalString("ui.newejbwizard.trans_mgmnt.title", "Transaction Management");
    private static String TRANSACTION_HELP = localStrings.getLocalString("ui.newejbwizard.trans_mgmnt.help", "Please choose whether the bean's transactions are managed by the bean or by the container.\nIf they are managed by the container, you can also define what level of transaction support is required for each method in each interface.\nOptionally, you can provide a description for each method.");
    private static String MSG_DEST_REF_TITLE = localStrings.getLocalString("ui.newejbwizard.msgdestref.title", "Message Destination References");
    private static String MSG_DEST_REF_HELP = localStrings.getLocalString("ui.newejbwizard.msgdestref.help", "If this component is going to send or receive messages from any message destinations, you will need to provide a reference to these destinations.\n You must provide the name of the destination as it appears in your code, as well as the logical destination name that is used for the destination.\n You must also idenity the type of destination required and whether you will be producting or consuming messages. \n Optionally you can provide a description of this reference.");
    private static String MDB_TITLE = localStrings.getLocalString("ui.newejbwizard.msgbean_settings.title", "Message-driven Bean Settings");
    private static String MDB_HELP = localStrings.getLocalString("ui.newejbwizard.msgbean_settings.help", "Since this is a message-driven bean, please indicate whether it is going to be used with JMS.\nIf it is to be used with JMS, you must identify the target message destination that this bean will be consuming messages from, as well as the destination's type.\nIf you are using a non-JMS destination, you must indicate the message listener interface to be used, and provide a set of activation configuration properties.");
    private static String ENV_TITLE = localStrings.getLocalString("ui.newejbwizard.env_entries.title", "Environment Entries");
    private static String ENV_HELP = localStrings.getLocalString("ui.newejbwizard.env_entries.help", "Please list any environment entries that are referenced in the code of the Enterprise Bean, as well as their Java types.\nOptionally, you can provide descriptions and default values to be used for these entries.");
    private static String EJB_REF_TITLE = localStrings.getLocalString("ui.newejbwizard.ejb_refs.title", "Enterprise Bean References");
    private static String EJB_REF_HELP = localStrings.getLocalString("ui.newejbwizard.ejb_refs.help", "Please list any enterprise beans that are referenced in the code of this bean.  In addition to the coded name that appears in the source, indicate the type of bean expected, the type of interface that will be used to access the bean, and the interface classes (including package).\nOptionally, you can provide a description for each reference");
    private static String RES_REF_TITLE = localStrings.getLocalString("ui.newejbwizard.res_refs.title", "Resource References");
    private static String RES_REF_HELP = localStrings.getLocalString("ui.newejbwizard.res_refs.help", "Please list any resource factories referenced in the code of this enterprise bean.\nFor each of these, indicate the type of resource required, and how the authentication of resource users will be handled (application-managed or container-managed).\nOptionally, you can define if the resource is shareable and provide a description for it.");
    private static String RESENV_REF_TITLE = localStrings.getLocalString("ui.newejbwizard.res_env_refs.title", "Resource Environment References");
    private static String RESENV_REF_HELP = localStrings.getLocalString("ui.newejbwizard.res_env_refs.help", "Please list any resource environment references in the code of this enterprise bean.  Currently, these references are only used to refer to JMS destinations.  After you have provided the coded name and type of destination expected, you can optionally add a description.");
    private static String SECURITY_TITLE = localStrings.getLocalString("ui.newejbwizard.security.title", "Security");
    private static String SECURITY_HELP = localStrings.getLocalString("ui.newejbwizard.security.help", "Please choose which security identity should be used for the execution of the methods of other components that are called from this bean.\nYou can also indicate which of the bean's methods can be accessed by each role name in the deployment environment.\nIf the 'isCallerInRole()' method is used in this bean, you can enter the names referenced in it, and optionally provide the role name in the deployment environment that matches the coded name used.");
    protected static String WEBSERVICE_REFS_TITLE = localStrings.getLocalString("ui.newejbwizard.web_service_ref.title", "Web Service References");
    protected static String WEBSERVICE_REFS_HELP = localStrings.getLocalString("ui.newejbwizard.web_service_ref.help", "If this Enterprise Bean is going to interact with any web services, you will need to provide a reference to those services.  You must provide the name of the service as it appears in your code and the service interface that it implements.  Optionally, you can identify the WSDL file and JAX-RPC mapping file for teh service, and identify a set of endpoints in the service.");
    protected static String SUNONE_EJB_TITLE = localStrings.getLocalString("at.newejbwizard.s1_deploy_settings.title", "Sun-specific Settings");
    protected static String SUNONE_EJB_HELP = localStrings.getLocalString("at.newejbwizard.s1_deploy_settings.help", "The following deployment descriptor will be generated for your JAR file.\nTo change any of the settings, click Back.  If you are satisfied with the settings, click Finish.");
    protected static String PROVIDE_SCHEMA_NAME = localStrings.getLocalString("ui.newejbwizard.enter_abstract_schema", "You must first provide an Abstract Schema Name.");
    protected static String SELECT_PM_TYPE = localStrings.getLocalString("ui.newejbwizard.enter_pm_type", "You must select the Persistence Management Type");
    private static NewEjbWizard wizardDialog = null;
    protected String currentAddMode = null;
    protected ConfigOptionsPanel configOptionsPanel = null;
    private EjbEntityInspector entityInspector = null;
    private EjbMessageInspector messageBeanInspector = null;
    private MsgDestRefsInspector msgDestRefsInsp = null;
    private EjbJarGeneralInspector ejbJarGeneralInspector = null;
    private EjbComponentGeneralInspector ejbComponentGeneralInspector = null;
    private int webSrvLocationIndex = -1;
    private int webSrvEndpointIndex = -1;
    private EjbBundleDescriptor ejbBundleDescriptor = null;
    private EjbDescriptor ejbDescriptor = null;
    private WebServiceEndpoint webServiceEndpoint = null;
    private static String savedStartingDirectory = null;
    private static final String EXPOSE_BEAN = localStrings.getLocalString("ui.newejbwizard.config_options.export_bean", "Expose Bean as Web Service Endpoint:");
    private static final String EXPOSE_YES = localStrings.getLocalString("ui.newejbwizard.config_options.yes", "Yes");
    private static final String EXPOSE_NO = localStrings.getLocalString("ui.newejbwizard.config_options.no", "No");
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Descriptor;

    public static Descriptor newModule(Frame owner) throws IOException {
        return NewEjbWizard._showWizard(owner, null);
    }

    public static Descriptor editModule(Frame owner) throws IOException {
        return NewEjbWizard._showWizard(owner, "Edit");
    }

    private static Descriptor _showWizard(Frame owner, String addMode) throws IOException {
        wizardDialog = new NewEjbWizard(owner);
        wizardDialog.show(addMode);
        if (wizardDialog.didComplete()) {
            return NewEjbWizard._completedWizard(wizardDialog);
        }
        return null;
    }

    private static Descriptor _completedWizard(NewEjbWizard wizard) throws IOException {
        WebServiceEndpoint wse;
        EjbBundleDescriptor tbd;
        String dn;
        EjbDescriptor ejb = wizard.getCurrentEjbDescriptor();
        EjbBundleDescriptor newEBD = wizard.getEjbBundleDescriptor();
        ModuleContent fcd = wizard.getArchiveModuleContent();
        Descriptor target = wizard.getSelectedParentDescriptor();
        String archFile = wizard.getArchiveFileLocation();
        String edn = ejb.getDisplayName();
        if (target instanceof EjbBundleDescriptor && !(dn = DescriptorTools.createUniqueDisplayName((BundleDescriptor)(tbd = (EjbBundleDescriptor)target), edn)).equals(edn)) {
            ejb.setDisplayName(dn);
            edn = dn;
        }
        if ((wse = wizard.getWebServiceEndpoint()) != null) {
            if (wse.getWsdlPort() == null) {
                wse.setWsdlPort(new QName("urn:" + edn, "Local_" + edn));
            }
            wse.setEjbLink(edn);
            ejb.setWebServiceEndpointInterfaceName(wse.getServiceEndpointInterface());
            WebService ws = wizard.getWebService();
            ws.addEndpoint(wse);
            if (!wizard.isAddToExistingWebService()) {
                String n2;
                WebServicesDescriptor wsd = wizard.getEjbBundleDescriptor().getWebServices();
                String n1 = ws.getWebServiceName();
                if (!n1.equals(n2 = DescriptorTools.createUniqueWebServiceName(wsd, n1))) {
                    ws.setWebServiceName(n2);
                }
                wsd.addWebService(ws);
            }
        }
        EjbBundleDescriptor ebd = (EjbBundleDescriptor)NewEjbWizard.newComponent(newEBD, fcd, target, archFile);
        if (wse != null) {
            WebserviceEndpoint endpoint = (WebserviceEndpoint)SunOneUtils.getSunDescriptor((Descriptor)wse);
            if (endpoint == null) {
                Print.dprintln((String)"endpoint from getSunDescriptor is null");
            } else {
                SunEjbJar sej = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)ebd);
                Ejb e = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejb);
                Ejb ej = null;
                for (int i = 0; i < sej.getEnterpriseBeans().sizeEjb(); ++i) {
                    if (!sej.getEnterpriseBeans().getEjb(i).getEjbName().equals(e.getEjbName())) continue;
                    ej = sej.getEnterpriseBeans().getEjb(i);
                    break;
                }
                ej.addWebserviceEndpoint(endpoint);
                Descriptor mod = DescriptorTools.getModuleDescriptor((Descriptor)ebd);
                ((ModuleManagerImpl)DT.getModuleManager()).saveModule(mod, false);
            }
        }
        return ebd;
    }

    private static Descriptor newComponent(EjbBundleDescriptor newEBD, ModuleContent fcd, Descriptor target, String archFile) throws IOException {
        if (newEBD == null) {
            throw new RuntimeException("EJB Bundle Descriptor is null");
        }
        if (target instanceof Application) {
            Application app = (Application)target;
            Set ebdList = app.getEjbBundleDescriptors();
            String newName = DescriptorTools.createUniqueName(newEBD.getDisplayName(), ebdList);
            if (!newName.equals(newEBD.getDisplayName())) {
                newEBD.setDisplayName(newName);
            }
            ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)newEBD, null, fcd.getEntryNameMap());
            Descriptor md = modArch.addToApplication(app);
            return md;
        }
        if (target instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)target;
            ebd.addEjbBundleDescriptor(newEBD);
            SunOneUtils.mergeEjbBundles(ebd, newEBD);
            ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)ebd);
            modArch.addArchiveEntries(fcd.getEntryNameMap());
            modArch.save();
            return ebd;
        }
        ModuleArchive modArch = ModuleArchive.newModuleArchive((Descriptor)newEBD, archFile, fcd.getEntryNameMap());
        modArch.save();
        DT.getModuleManager().addModule((Descriptor)newEBD);
        UIProject.resetProject((Descriptor)newEBD);
        return newEBD;
    }

    public String getHelpGroup() {
        return "EW";
    }

    public NewEjbWizard(Frame owner) {
        super(owner);
        super.setTitle(WIZARD_TITLE_NEW);
        this.addInspectors();
    }

    private void addInspectors() {
        String mode = "WizardMode";
        String UI = UIConfig.UI_PACKAGE;
        super.addIntroPanel(INTRO_HELP);
        this.ejbJarGeneralInspector = (EjbJarGeneralInspector)this.addInspectorPane(UI + "ejb.EjbJarGeneralInspector", EJB_JAR_TITLE, EJB_JAR_HELP).getPane();
        this.ejbComponentGeneralInspector = (EjbComponentGeneralInspector)this.addInspectorPane(UI + "ejb.EjbComponentGeneralInspector", GENERAL_TITLE, GENERAL_HELP).getPane();
        this.configOptionsPanel = (ConfigOptionsPanel)this.addInspectorPane(new ConfigOptionsPanel(mode), CONFIG_OPTION_TITLE, CONFIG_OPTION_HELP).getPane();
        this.webSrvLocationIndex = this.addInspectorPane(UI + "websrv.WSLocationInspector", WEBSERVICE_LOCATION_TITLE, WEBSERVICE_LOCATION_HELP).getIndex();
        this.webSrvEndpointIndex = this.addInspectorPane(UI + "websrv.WSEndpointInspector", WEBSERVICE_ENDPOINT_TITLE, WEBSERVICE_ENDPOINT_HELP).getIndex();
        this.entityInspector = (EjbEntityInspector)this.addInspectorPane(UI + "ejb.EjbEntityInspector", ENTITY_TITLE, ENTITY_HELP).getPane();
        this.messageBeanInspector = (EjbMessageInspector)this.addInspectorPane(UI + "ejb.EjbMessageInspector", MDB_TITLE, MDB_HELP).getPane();
        this.addPaneSelector(this.addInspectorPane(UI + "ejb.EjbTransactionInspector", TRANSACTION_TITLE, TRANSACTION_HELP));
        this.msgDestRefsInsp = (MsgDestRefsInspector)this.addPaneSelector(this.addInspectorPane(UI + "shared.MsgDestRefsInspector", MSG_DEST_REF_TITLE, MSG_DEST_REF_HELP)).getPane();
        this.addPaneSelector(this.addInspectorPane(UI + "shared.EnvironmentInspector", ENV_TITLE, ENV_HELP));
        this.addPaneSelector(this.addInspectorPane(UI + "ejb.EjbRefsInspector", EJB_REF_TITLE, EJB_REF_HELP));
        this.addPaneSelector(this.addInspectorPane(UI + "shared.ResourceRefsInspector", RES_REF_TITLE, RES_REF_HELP));
        this.addPaneSelector(this.addInspectorPane(UI + "shared.JmsDestinationRefsInspector", RESENV_REF_TITLE, RESENV_REF_HELP));
        this.addPaneSelector(this.addInspectorPane(UI + "ejb.EjbComponentSecurityInspector", SECURITY_TITLE, SECURITY_HELP));
        this.addPaneSelector(this.addInspectorPane(UI + "websrv.WSRefsInspector", WEBSERVICE_REFS_TITLE, WEBSERVICE_REFS_HELP));
        this.addNextStepsPanel(NEXT_STEPS_HELP);
    }

    public void show(String addMode) {
        this.currentAddMode = addMode;
        if (this.currentAddMode == null || "New".equals(addMode)) {
            super.setTitle(WIZARD_TITLE_NEW);
        } else {
            super.setTitle(WIZARD_TITLE_EDIT);
        }
        this.ejbJarGeneralInspector.setWizardComponentMode(addMode);
        this.ejbBundleDescriptor = null;
        this.ejbDescriptor = null;
        super.show(addMode);
    }

    public Class getDescriptorClass() {
        return EjbBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.getEjbBundleDescriptor();
    }

    public void setDescriptor(Descriptor d) {
        Print.dprintStackTrace((String)"Descriptor should not be set");
    }

    public WebServiceEndpoint getWebServiceEndpoint() {
        if (this.configOptionsPanel.isExposeBean()) {
            WSEndpointInspector wse = (WSEndpointInspector)super.getWizardPane(this.webSrvEndpointIndex).getPane();
            return wse.getWebServiceEndpoint();
        }
        return null;
    }

    public WebService getWebService() {
        if (this.configOptionsPanel.isExposeBean()) {
            WSLocationInspector wsi = (WSLocationInspector)super.getWizardPane(this.webSrvLocationIndex).getPane();
            return wsi.getWebService();
        }
        return null;
    }

    public boolean isAddToExistingWebService() {
        if (this.configOptionsPanel.isExposeBean()) {
            WSLocationInspector wsi = (WSLocationInspector)super.getWizardPane(this.webSrvLocationIndex).getPane();
            return wsi.isAddToExistingWebService();
        }
        return false;
    }

    public Set getLibraryJars() {
        return this.ejbJarGeneralInspector.getModuleContent().getLibraryJars();
    }

    public void setCurrentEjbDescriptor(EjbDescriptor ejbDescriptor) {
        this.ejbDescriptor = ejbDescriptor;
    }

    private EjbDescriptor getCurrentEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public Descriptor getSelectedParentDescriptor() {
        return this.ejbJarGeneralInspector.getSelectedParentDescriptor();
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        if (this.ejbBundleDescriptor == null) {
            this.ejbBundleDescriptor = new EjbBundleDescriptor();
            ModuleArchive.wrapStandAloneInApplication((BundleDescriptor)this.ejbBundleDescriptor, null);
            this.addDescriptorListener((Descriptor)this.ejbBundleDescriptor, new NotificationListener(){

                public void notification(NotificationEvent ne) {
                    NewEjbWizard.this.descriptorChanged();
                }
            });
        }
        return this.ejbBundleDescriptor;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.getEjbBundleDescriptor();
    }

    private void replaceEjbDescriptor(EjbDescriptor oldEjb, EjbDescriptor newEjb) {
        if (oldEjb != newEjb) {
            SunEjbJar sej = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.getEjbBundleDescriptor());
            if (oldEjb != null) {
                this.getEjbBundleDescriptor().removeEjb(oldEjb);
                Ejb ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)oldEjb);
                if (ejb != null) {
                    sej.getEnterpriseBeans().removeEjb(ejb);
                }
            }
            this.setCurrentEjbDescriptor(newEjb);
            this.getEjbBundleDescriptor().addEjb(newEjb);
            sej.getEnterpriseBeans().addEjb(SunOneUtils.createSunEjb(newEjb));
        }
    }

    public String getArchiveFileLocation() {
        return this.ejbJarGeneralInspector.getFileLocation();
    }

    public ModuleContent getArchiveModuleContent() {
        return this.ejbJarGeneralInspector.getArchiveModuleContent();
    }

    private boolean verifyAddedClasses(ModuleContent fcd) {
        ClassLoader fcdClassLoader = null;
        try {
            fcdClassLoader = fcd.getClassLoader();
        }
        catch (IOException ioe) {
            Print.println((String)"Unable to obtain ClassLoader");
            return false;
        }
        int classCount = 0;
        String className = "";
        try {
            ModuleArchive.getModuleArchive((Descriptor)this.getEjbBundleDescriptor()).setClassLoader(fcdClassLoader);
            Iterator clsIter = fcd.getClassNamesSet().iterator();
            while (clsIter.hasNext()) {
                className = (String)clsIter.next();
                fcdClassLoader.loadClass(className);
                ++classCount;
            }
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)("Error loading class: " + className), (Throwable)t);
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.the_class_not_loaded_consult_help", "The class ({0}) could not be loaded:\nPlease consult online help for assistance in setting up the class root directory and choosing class files.", new Object[]{className, t.toString()}));
            return false;
        }
        if (classCount <= 0) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_class_files", "You must add the class files for this enterprise bean.\nClick 'Edit Contents' to add files to the module."), EJB_CLASSES_REQD);
            return false;
        }
        return true;
    }

    private boolean createAndAddNewEjb() {
        EjbDescriptor oldEjbDescriptor;
        String ejbClass = this.ejbComponentGeneralInspector.uiGetEjbClassName();
        if (ejbClass == null || ejbClass.trim().equals("")) {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_ejbclass_selected", "You must select an enterprise bean class."));
            return false;
        }
        if (!this.ejbComponentGeneralInspector.uiIsMessageDrivenBean()) {
            boolean remoteInterface;
            boolean localInterface;
            boolean localHomeInterface = this.ejbComponentGeneralInspector.uiGetLocalHomeClassName() != null;
            boolean bl = localInterface = this.ejbComponentGeneralInspector.uiGetLocalClassName() != null;
            if (localHomeInterface != localInterface) {
                if (!localHomeInterface) {
                    UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_localhomeclass_selected", "You must select a local home interface class."));
                } else if (!localInterface) {
                    UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_localclass_selected", "You must select a local interface class."));
                }
                return false;
            }
            boolean remoteHomeInterface = this.ejbComponentGeneralInspector.uiGetHomeClassName() != null;
            boolean bl2 = remoteInterface = this.ejbComponentGeneralInspector.uiGetRemoteClassName() != null;
            if (remoteHomeInterface != remoteInterface) {
                if (!remoteHomeInterface) {
                    UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_remotehomeclass_selected", "You must select a remote home interface class."));
                } else if (!remoteInterface) {
                    UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_remoteclass_selected", "You must select a remote interface class."));
                }
                return false;
            }
            if (!(this.ejbComponentGeneralInspector.uiIsStatelessBean() || localHomeInterface || remoteHomeInterface)) {
                UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.no_interface_specified", "One of local and/or remote interfaces must be specified"));
                return false;
            }
        }
        EjbEntityDescriptor newEjbDescriptor = null;
        EjbDescriptor updEjbDescriptor = oldEjbDescriptor = this.getCurrentEjbDescriptor();
        if (oldEjbDescriptor == null || oldEjbDescriptor instanceof EjbEntityDescriptor && !this.ejbComponentGeneralInspector.uiIsEntityBean() || oldEjbDescriptor instanceof EjbMessageBeanDescriptor && !this.ejbComponentGeneralInspector.uiIsMessageDrivenBean() || oldEjbDescriptor instanceof EjbSessionDescriptor && !this.ejbComponentGeneralInspector.uiIsSessionBean()) {
            if (this.ejbComponentGeneralInspector.uiIsEntityBean()) {
                if (oldEjbDescriptor == null || !(oldEjbDescriptor instanceof EjbEntityDescriptor)) {
                    newEjbDescriptor = new EjbEntityDescriptor();
                } else {
                    newEjbDescriptor = new EjbEntityDescriptor((EjbDescriptor)((EjbEntityDescriptor)oldEjbDescriptor));
                    newEjbDescriptor.setTransactionType(EjbDescriptor.CONTAINER_TRANSACTION_TYPE);
                }
            } else if (this.ejbComponentGeneralInspector.uiIsMessageDrivenBean()) {
                newEjbDescriptor = oldEjbDescriptor == null || !(oldEjbDescriptor instanceof EjbMessageBeanDescriptor) ? new EjbMessageBeanDescriptor() : new EjbMessageBeanDescriptor((EjbMessageBeanDescriptor)oldEjbDescriptor);
            } else if (this.ejbComponentGeneralInspector.uiIsSessionBean()) {
                newEjbDescriptor = oldEjbDescriptor == null || !(oldEjbDescriptor instanceof EjbSessionDescriptor) ? new EjbSessionDescriptor() : new EjbSessionDescriptor((EjbDescriptor)((EjbSessionDescriptor)oldEjbDescriptor));
                ((EjbSessionDescriptor)newEjbDescriptor).setStateless(this.ejbComponentGeneralInspector.uiIsStatelessBean());
            } else {
                Print.printStackTrace((String)"Unspecified bean type");
            }
            if (newEjbDescriptor != null) {
                updEjbDescriptor = newEjbDescriptor;
            }
        }
        updEjbDescriptor.setDescription(this.ejbComponentGeneralInspector.uiGetDescription());
        updEjbDescriptor.setEjbClassName(this.ejbComponentGeneralInspector.uiGetEjbClassName());
        updEjbDescriptor.setDisplayName(this.ejbComponentGeneralInspector.uiGetDisplayName());
        if (!(updEjbDescriptor instanceof EjbMessageBeanDescriptor)) {
            updEjbDescriptor.setLocalClassName(this.ejbComponentGeneralInspector.uiGetLocalClassName());
            updEjbDescriptor.setLocalHomeClassName(this.ejbComponentGeneralInspector.uiGetLocalHomeClassName());
            updEjbDescriptor.setRemoteClassName(this.ejbComponentGeneralInspector.uiGetRemoteClassName());
            updEjbDescriptor.setHomeClassName(this.ejbComponentGeneralInspector.uiGetHomeClassName());
        }
        if (newEjbDescriptor != null) {
            this.replaceEjbDescriptor(oldEjbDescriptor, (EjbDescriptor)newEjbDescriptor);
            oldEjbDescriptor = newEjbDescriptor;
        }
        try {
            ClassLoader newLoader = this.ejbJarGeneralInspector.getModuleContent().getClassLoader();
            ModuleArchive.getModuleArchive((Descriptor)this.getEjbBundleDescriptor()).setClassLoader(newLoader);
            oldEjbDescriptor.classesChanged();
        }
        catch (IOException e) {
            Print.printStackTrace((String)"Problem getting Bundle ClassLoader", (Throwable)e);
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Problem getting Bundle ClassLoader", (Throwable)t);
        }
        return true;
    }

    public ModuleContent getMergedModuleContent() {
        ModuleContent fcd = this.ejbJarGeneralInspector.getModuleContent();
        return fcd;
    }

    public Vector getArchiveContents() {
        ModuleContent fcd = this.ejbJarGeneralInspector.getModuleContent();
        return ListTools.toList(fcd.getEntries());
    }

    public Vector getArchiveClasses() {
        ModuleContent fcd = this.ejbJarGeneralInspector.getModuleContent();
        Vector classList = null;
        try {
            classList = UIJarPackager.getClassNames(fcd, true);
        }
        catch (Throwable cnfe) {
            classList = UIJarPackager.getClassNames(fcd);
        }
        return classList;
    }

    protected Wizard.PaneSelectorBox createPaneSelectorBox() {
        return new Wizard.PaneSelectorBox(SETTINGS_SELECTOR_HELP, SETTINGS_SELECTOR);
    }

    protected boolean isInspectorAcceptable(int inspIndex) {
        boolean isAcceptable = true;
        if (inspIndex <= this.getIndexOf(this.ejbComponentGeneralInspector)) {
            isAcceptable = true;
        } else if (inspIndex == this.getIndexOf(this.configOptionsPanel)) {
            EjbDescriptor ejb = this.getCurrentEjbDescriptor();
            isAcceptable = ejb instanceof EjbSessionDescriptor ? ((EjbSessionDescriptor)ejb).isStateless() : false;
        } else if (inspIndex == this.webSrvLocationIndex || inspIndex == this.webSrvEndpointIndex) {
            EjbDescriptor ejb = this.getCurrentEjbDescriptor();
            isAcceptable = ejb instanceof EjbSessionDescriptor ? (((EjbSessionDescriptor)ejb).isStateless() ? this.configOptionsPanel.isExposeBean() : false) : false;
        } else {
            EjbDescriptor ejbd = this.getCurrentEjbDescriptor();
            JComponent insp = this.getComponentAt(inspIndex);
            if (insp == this.messageBeanInspector) {
                isAcceptable = ejbd instanceof EjbMessageBeanDescriptor;
            } else if (insp == this.entityInspector) {
                isAcceptable = ejbd instanceof EjbEntityDescriptor;
            }
        }
        return isAcceptable;
    }

    public boolean validateComponent(Component oldComponent) {
        if (oldComponent != this.configOptionsPanel) {
            if (oldComponent == this.ejbJarGeneralInspector) {
                SunEjbJar sunEjbJar;
                if (!this.ejbJarGeneralInspector.validateTargetLocation()) {
                    return false;
                }
                ModuleContent fcd = this.ejbJarGeneralInspector.getModuleContent();
                if (!this.verifyAddedClasses(fcd)) {
                    return false;
                }
                Vector classList = null;
                try {
                    classList = UIJarPackager.getClassNames(fcd, true);
                }
                catch (Throwable cnfe) {
                    classList = UIJarPackager.getClassNames(fcd);
                }
                this.ejbComponentGeneralInspector.setClassFiles(classList);
                if (this.getEjbBundleDescriptor().getDisplayName().equals("")) {
                    this.getEjbBundleDescriptor().setDisplayName("Ejb1");
                }
                if ((sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.getEjbBundleDescriptor())) == null) {
                    SunOneUtils.createSunEjbJar(this.getEjbBundleDescriptor());
                    sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.getEjbBundleDescriptor());
                }
                sunEjbJar.getEnterpriseBeans().setName(this.getEjbBundleDescriptor().getDisplayName());
            } else if (oldComponent == this.ejbComponentGeneralInspector) {
                String nm;
                EjbBundleDescriptor ebd;
                if (this.ejbComponentGeneralInspector.uiGetDisplayName().equals("")) {
                    UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.enter_ejb_name", "Please provide an Enterprise Bean Name."));
                    return false;
                }
                Descriptor pd = this.ejbJarGeneralInspector.getSelectedParentDescriptor();
                if (pd instanceof BundleDescriptor && (ebd = (EjbBundleDescriptor)pd).hasEjbByName(nm = this.ejbComponentGeneralInspector.uiGetDisplayName())) {
                    UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.newejbwizard.duplicate_ejb_name", "Enterprise Bean Name already exist"));
                    return false;
                }
                if (!this.createAndAddNewEjb()) {
                    return false;
                }
                EjbDescriptor ejbd = this.getCurrentEjbDescriptor();
                if (ejbd.getDisplayName().equals("")) {
                    ejbd.setDisplayName(localStrings.getLocalString("ui.newejbwizard.enterprisebean", "Enterprise Bean"));
                }
            } else if (oldComponent == this.entityInspector) {
                if (!this.entityInspector.hasRequiredAbstractSchemaName()) {
                    UIOptionPane.showWarningDialog(this, PROVIDE_SCHEMA_NAME);
                    return false;
                }
                if (!this.entityInspector.PMTypeSelected()) {
                    UIOptionPane.showWarningDialog(this, SELECT_PM_TYPE);
                    return false;
                }
            } else if (oldComponent == this.messageBeanInspector) {
                // empty if block
            }
        }
        return true;
    }

    public void goForward() {
        JComponent oldComponent = super.getCurrentComponent();
        int oldNdx = super.getCurrentComponentIndex();
        super.goForward();
        JComponent newComponent = super.getCurrentComponent();
        if (newComponent == this.messageBeanInspector) {
            this.messageBeanInspector.setEjbClasses(this.ejbComponentGeneralInspector.getEjbClasses());
        } else if (newComponent == this.entityInspector) {
            this.entityInspector.setEjbBeanClass(this.ejbComponentGeneralInspector.getBeanClass());
        } else if (newComponent instanceof DescriptorViewer.XMLTextArea) {
            EjbBundleDescriptor ebd = this.getEjbBundleDescriptor();
            WebServiceEndpoint wse = this.getWebServiceEndpoint();
            if (wse != null) {
                EjbDescriptor ejb = this.getCurrentEjbDescriptor();
                String oldIntf = ejb.getWebServiceEndpointInterfaceName();
                ejb.setWebServiceEndpointInterfaceName(wse.getServiceEndpointInterface());
                ((DescriptorViewer.XMLTextArea)newComponent).updateXMLText((Descriptor)ebd);
                ejb.setWebServiceEndpointInterfaceName(oldIntf);
            } else {
                ((DescriptorViewer.XMLTextArea)newComponent).updateXMLText((Descriptor)ebd);
            }
        }
        this.delegateNotification(newComponent);
    }

    public void goBackward() {
        super.goBackward();
        this.delegateNotification(super.getCurrentComponent());
    }

    public void finishAction() {
        EjbDescriptor ejbd = this.getCurrentEjbDescriptor();
        Set s = ejbd.getIORConfigurationDescriptors();
        if (s.size() == 0) {
            EjbIORConfigurationDescriptor iorDesc = new EjbIORConfigurationDescriptor();
            iorDesc.setEstablishTrustInClient("SUPPORTED");
            iorDesc.setAuthMethodRequired(false);
            ejbd.addIORConfigurationDescriptor(iorDesc);
        }
        super.finishAction();
        if (this.ejbJarGeneralInspector.isCreateNewStandAlone()) {
            savedStartingDirectory = new File(this.getArchiveFileLocation()).getParent();
        }
    }

    public static String getSavedStartingDirectory() {
        String ret = savedStartingDirectory == null ? UIConfig.getStartingDirectory().getAbsolutePath() : savedStartingDirectory;
        return ret;
    }

    protected void descriptorChanged() {
        this.delegateNotification(this.getCurrentComponent());
    }

    private void delegateNotification(Object obj) {
        if (obj instanceof DescriptorInspector) {
            DescriptorInspector insp = (DescriptorInspector)obj;
            Class descClass = insp.getDescriptorClass();
            EjbDescriptor ejbComp = this.getCurrentEjbDescriptor();
            EjbBundleDescriptor ejbBund = this.getEjbBundleDescriptor();
            if (ejbBund != null && descClass.isAssignableFrom(ejbBund.getClass())) {
                insp.setDescriptor((Descriptor)ejbBund);
            } else if (ejbComp != null && descClass.isAssignableFrom(ejbComp.getClass())) {
                insp.setDescriptor((Descriptor)ejbComp);
            } else {
                insp.setDescriptor(null);
            }
            if (insp.getDescriptor() == null && insp != this.ejbComponentGeneralInspector) {
                Print.dprintStackTrace((String)(DT.className(insp) + " doesn't support " + DT.className(ejbComp)));
            }
            if (insp instanceof InspectorPane) {
                ((InspectorPane)insp).invokeRefresh();
            }
        }
    }

    protected class ConfigOptionsPanel
    extends InspectorPane {
        private Descriptor descriptor = null;
        private UIRadioButtonBox webSrvSelector = null;
        private Wizard.PaneSelectorBox paneSelector = null;

        public String getTabName() {
            return "";
        }

        public String getHelpID() {
            return "EJBConfigOptions";
        }

        public Class getDescriptorClass() {
            return this.descriptor != null ? this.descriptor.getClass() : (class$com$sun$enterprise$deployment$Descriptor == null ? (class$com$sun$enterprise$deployment$Descriptor = NewEjbWizard.class$("com.sun.enterprise.deployment.Descriptor")) : class$com$sun$enterprise$deployment$Descriptor);
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(Descriptor desc) {
            if (desc != this.descriptor) {
                this.webSrvSelector.setSelectedItem(EXPOSE_NO);
                this.resetPaneSelectors();
            }
            this.descriptor = desc;
        }

        public ConfigOptionsPanel(String mode) {
            this.setInspectorMode(mode);
            this.initializeLayout();
        }

        private void initializeLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.webSrvSelector = new UIRadioButtonBox(null, false);
            this.webSrvSelector.addActionListener(new ActionListener(this){
                private final /* synthetic */ ConfigOptionsPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    ConfigOptionsPanel.access$100(this.this$1);
                }
            });
            c.weightx = 0.5;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 0);
            c.fill = 2;
            c.anchor = 11;
            this.add((Component)this.webSrvSelector, c);
            this.webSrvSelector.getGBConstraints().insets.left += 10;
            JRadioButton rb_WebSrvYes = UIRadioButtonBox.createRadioButton(EXPOSE_YES);
            this.webSrvSelector.addItem(rb_WebSrvYes);
            JRadioButton rb_WebSrvNo = UIRadioButtonBox.createRadioButton(EXPOSE_NO);
            this.webSrvSelector.addItem(rb_WebSrvNo);
            this.webSrvSelector.setSelectedItem(EXPOSE_NO);
            this.paneSelector = NewEjbWizard.this.getPaneSelectorBox();
            c.weightx = 0.5;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 5, 0, 0);
            c.fill = 1;
            c.anchor = 17;
            this.add((Component)this.paneSelector, c);
            this.paneSelector.setVisible(false);
            this.add((Component)new UIPanel(), c);
            UIPanel filler = new UIPanel();
            c.weightx = 0.0;
            c.weighty = 0.5;
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 3;
            c.anchor = 10;
            this.add((Component)filler, c);
        }

        private void resetPaneSelectors() {
            Print.dprintln((String)"reseting enabled selections");
            Object sel = this.webSrvSelector.getSelectedItem();
            if (sel == null) {
                this.paneSelector.setDisabledItems(null);
            } else {
                this.paneSelector.setDisabledItems(NewEjbWizard.this.getDisabledPanes(sel));
            }
        }

        public void refresh() {
            if (NewEjbWizard.this.getCurrentEjbDescriptor() instanceof EjbSessionDescriptor) {
                boolean localHomeInterface;
                this.webSrvSelector.setItemEnabled(EXPOSE_YES, true);
                boolean remoteHomeInterface = NewEjbWizard.this.ejbComponentGeneralInspector.uiGetHomeClassName() != null;
                boolean bl = localHomeInterface = NewEjbWizard.this.ejbComponentGeneralInspector.uiGetLocalHomeClassName() != null;
                if (!remoteHomeInterface && !localHomeInterface) {
                    this.webSrvSelector.setSelectedItem(EXPOSE_YES);
                    this.webSrvSelector.setItemEnabled(EXPOSE_NO, false);
                } else if (!NewEjbWizard.this.ejbComponentGeneralInspector.uiIsStatelessBean()) {
                    this.webSrvSelector.setItemEnabled(EXPOSE_NO, true);
                    this.webSrvSelector.setSelectedItem(EXPOSE_NO);
                    this.webSrvSelector.setItemEnabled(EXPOSE_YES, false);
                } else {
                    this.webSrvSelector.setItemEnabled(EXPOSE_NO, true);
                }
            } else {
                this.webSrvSelector.setItemEnabled(EXPOSE_NO, true);
                this.webSrvSelector.setSelectedItem(EXPOSE_NO);
                this.webSrvSelector.setItemEnabled(EXPOSE_YES, false);
            }
            this.resetPaneSelectors();
        }

        public boolean isExposeBean() {
            return this.webSrvSelector.isSelectedItem(EXPOSE_YES);
        }

        static /* synthetic */ void access$100(ConfigOptionsPanel x0) {
            x0.resetPaneSelectors();
        }
    }
}

