/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.Method;
import com.sun.enterprise.tools.common.dd.ejb.MethodParams;
import com.sun.enterprise.tools.deployment.ui.ejb.MethodUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class MethodInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MethodInspector.class);
    private HashMap allMap = null;
    private HashMap intfMap = null;
    boolean usingIntf = true;
    private HashMap descMap = null;
    private Set ignoreSet = null;
    private Set descIgnoreSet = null;
    private Method[] methodArray = null;
    private MethodParams params = null;

    static final String GET_METH_ERROR(String v0, String v1) {
        return localStrings.getLocalString("ui.methodinspector.error_getting_methods", "Error obtaining the list of methods on {0}\n{1}\n", new Object[]{v0, v1});
    }

    void setUsingIntf(boolean useIntf) {
        this.usingIntf = useIntf;
    }

    void initMethods(Set mdSet, Method[] methodArray) {
        this.buildMaps(mdSet);
        if (methodArray != null && methodArray.length > 0 && mdSet != null) {
            Iterator iter = mdSet.iterator();
            while (iter.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)iter.next();
                String mdName = md.getName();
                String mdIntf = null;
                if (this.usingIntf) {
                    mdIntf = md.getEjbClassSymbol();
                }
                String[] mdParam = md.getJavaParameterClassNames();
                for (int i = 0; i < methodArray.length; ++i) {
                    int j;
                    boolean match;
                    String name = methodArray[i].getMethodName();
                    String intf = null;
                    if (this.usingIntf) {
                        intf = methodArray[i].getMethodIntf();
                    }
                    MethodParams params = methodArray[i].getMethodParams();
                    String[] param = null;
                    String desc = methodArray[i].getDescription();
                    if (params != null) {
                        param = params.getMethodParam();
                    }
                    if (intf == null && params == null) {
                        if (!name.equals(MethodDescriptor.ALL_EJB_METHODS) && !name.equals(mdName)) continue;
                        this.addToMaps(md, desc);
                        continue;
                    }
                    if (intf != null && params == null) {
                        if (!intf.equals(mdIntf) || !name.equals(MethodDescriptor.ALL_EJB_METHODS) && !name.equals(mdName)) continue;
                        this.addToMaps(md, desc);
                        continue;
                    }
                    if (intf == null && params != null) {
                        if (!name.equals(mdName)) continue;
                        if (!(mdParam != null && mdParam.length != 0 || param != null && param.length != 0)) {
                            this.addToMaps(md, desc);
                            continue;
                        }
                        if (mdParam == null || param.length != mdParam.length) continue;
                        match = true;
                        for (j = 0; j < param.length; ++j) {
                            if (param[j].equals(mdParam[j])) continue;
                            match = false;
                            break;
                        }
                        if (!match) continue;
                        this.addToMaps(md, desc);
                        continue;
                    }
                    if (intf == null || params == null || !name.equals(mdName) || !intf.equals(mdIntf)) continue;
                    if (!(mdParam != null && mdParam.length != 0 || param != null && param.length != 0)) {
                        this.addToMaps(md, desc);
                        continue;
                    }
                    if (mdParam == null || param.length != mdParam.length) continue;
                    match = true;
                    for (j = 0; j < param.length; ++j) {
                        if (param[j].equals(mdParam[j])) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    this.addToMaps(md, desc);
                }
            }
        }
    }

    private void buildMaps(Set mdSet) {
        this.allMap = new HashMap();
        this.intfMap = new HashMap();
        this.descMap = new HashMap();
        if (mdSet != null) {
            HashSet<String> intfNames = new HashSet<String>();
            Iterator iter = mdSet.iterator();
            while (iter.hasNext()) {
                String intf;
                MethodDescriptor md = (MethodDescriptor)iter.next();
                if (this.usingIntf && (intf = md.getEjbClassSymbol()) != null && !intf.trim().equals("")) {
                    intfNames.add(intf);
                }
                this.allMap.put(md, Boolean.FALSE);
                this.descMap.put(md, "");
            }
            iter = intfNames.iterator();
            while (iter.hasNext()) {
                String intf = (String)iter.next();
                Set mds = MethodUtil.getMatchingMethodDescriptorsByIntf(this.allMap.keySet(), intf);
                this.intfMap.put(intf, mds);
            }
        }
    }

    private void addToMaps(MethodDescriptor md, String desc) {
        this.allMap.put(md, Boolean.TRUE);
        this.setDescMap(md, desc);
    }

    private void setDescMap(MethodDescriptor md, String desc) {
        if (desc != null && !desc.trim().equals("")) {
            this.descMap.put(md, desc);
        }
    }

    void updateMethods(MethodDescriptor md, Boolean val) {
        if (md != null && val != null) {
            this.allMap.put(md, val);
            this.writeMethods();
            this.writeDescMethods();
        }
    }

    void updateMethodDesc(MethodDescriptor md, String desc) {
        if (md != null) {
            if (desc == null) {
                this.descMap.put(md, "");
            } else {
                this.descMap.put(md, desc.trim());
            }
            this.writeMethods();
            this.writeDescMethods();
        }
    }

    Set getMethodDescriptorsByIntf(String intf) {
        Set mds = null;
        if (intf != null) {
            mds = (Set)this.intfMap.get(intf);
        }
        return mds;
    }

    Set getAvailableInterfaces() {
        return this.intfMap.keySet();
    }

    Boolean getBooleanValue(MethodDescriptor md) {
        Boolean b = null;
        if (md != null) {
            b = (Boolean)this.allMap.get(md);
        }
        return b;
    }

    String getDescValue(MethodDescriptor md) {
        String s = "";
        if (md != null) {
            s = (String)this.descMap.get(md);
        }
        return s;
    }

    abstract void clearMethod();

    abstract void addMethod(Method var1);

    private void writeMethods() {
        Set intfNames;
        this.clearMethod();
        this.ignoreSet = new HashSet();
        this.descIgnoreSet = new HashSet();
        if (this.allMap.containsValue(Boolean.TRUE)) {
            if (MethodUtil.checkForAllTrue(this.allMap)) {
                Method m = null;
                Set mds = this.descMap.keySet();
                if (MethodUtil.hasStringValue(mds, this.descMap) && MethodUtil.allDescEqual(mds, this.descMap)) {
                    this.descIgnoreSet.addAll(mds);
                    m = MethodUtil.createMethod(MethodDescriptor.ALL_EJB_METHODS, null, MethodUtil.getFirstValue(mds, this.descMap));
                } else {
                    m = MethodUtil.createMethod(MethodDescriptor.ALL_EJB_METHODS);
                }
                this.addMethod(m);
                return;
            }
        } else {
            return;
        }
        if (this.usingIntf && (intfNames = this.getAvailableInterfaces()) != null & !intfNames.isEmpty()) {
            Iterator iter = intfNames.iterator();
            while (iter.hasNext()) {
                String intf = (String)iter.next();
                if (!MethodUtil.checkForAllTrueForIntf(this.allMap, intf)) continue;
                Set intfSet = this.getMethodDescriptorsByIntf(intf);
                this.ignoreSet.addAll(intfSet);
                Method m = null;
                if (MethodUtil.hasStringValue(intfSet, this.descMap) && MethodUtil.allDescEqual(intfSet, this.descMap)) {
                    this.descIgnoreSet.addAll(intfSet);
                    m = MethodUtil.createMethod(MethodDescriptor.ALL_EJB_METHODS, intf, MethodUtil.getFirstValue(intfSet, this.descMap));
                } else {
                    m = MethodUtil.createMethod(MethodDescriptor.ALL_EJB_METHODS, intf);
                }
                this.addMethod(m);
            }
        }
        this.findMostInclusiveRule(this.allMap);
    }

    private void findMostInclusiveRule(Map map) {
        Set setA = map.entrySet();
        Iterator iterA = setA.iterator();
        while (iterA.hasNext()) {
            Set intfSet;
            Set matchSet;
            Method m;
            Set namesSet;
            Map.Entry mA = iterA.next();
            MethodDescriptor kA = (MethodDescriptor)mA.getKey();
            String mdNameA = kA.getName();
            String mdIntfA = null;
            if (this.usingIntf) {
                mdIntfA = kA.getEjbClassSymbol();
            }
            String[] mdParamA = kA.getJavaParameterClassNames();
            String descA = (String)this.descMap.get(kA);
            Boolean vA = (Boolean)mA.getValue();
            if (vA != Boolean.TRUE || this.ignoreSet.contains(kA)) continue;
            Map matchingNamesMap = MethodUtil.findMatchingNames(map, mdNameA);
            if (MethodUtil.checkForAllTrue(matchingNamesMap) && MethodUtil.isUniqueRule(namesSet = matchingNamesMap.keySet(), this.ignoreSet)) {
                this.ignoreSet.addAll(namesSet);
                m = null;
                if (MethodUtil.hasStringValue(namesSet, this.descMap) && MethodUtil.allDescEqual(namesSet, this.descMap)) {
                    this.descIgnoreSet.addAll(namesSet);
                    m = MethodUtil.createMethod(mdNameA, null, descA);
                } else {
                    m = MethodUtil.createMethod(mdNameA);
                }
                this.addMethod(m);
            }
            if (this.usingIntf && MethodUtil.checkForAllTrueForParamList(matchingNamesMap, mdParamA) && MethodUtil.isUniqueRule(matchSet = MethodUtil.getMatchingMethodDescriptorsByParamList(matchingNamesMap.keySet(), mdParamA), this.ignoreSet)) {
                this.ignoreSet.addAll(matchSet);
                m = null;
                if (MethodUtil.hasStringValue(matchSet, this.descMap) && MethodUtil.allDescEqual(matchSet, this.descMap)) {
                    this.descIgnoreSet.addAll(matchSet);
                    m = mdParamA == null || mdParamA.length == 0 ? MethodUtil.createNoParamsMethod(mdNameA, null, descA) : MethodUtil.createMethod(mdNameA, null, mdParamA, descA);
                } else {
                    m = mdParamA == null || mdParamA.length == 0 ? MethodUtil.createNoParamsMethod(mdNameA) : MethodUtil.createMethod(mdNameA, null, mdParamA);
                }
                this.addMethod(m);
            }
            if (this.usingIntf && MethodUtil.checkForAllTrueForIntf(matchingNamesMap, mdIntfA) && MethodUtil.isUniqueRule(intfSet = MethodUtil.getMatchingMethodDescriptorsByIntf(matchingNamesMap.keySet(), mdIntfA), this.ignoreSet)) {
                this.ignoreSet.addAll(intfSet);
                m = null;
                if (MethodUtil.hasStringValue(intfSet, this.descMap) && MethodUtil.allDescEqual(intfSet, this.descMap)) {
                    this.descIgnoreSet.addAll(intfSet);
                    m = MethodUtil.createMethod(mdNameA, mdIntfA, descA);
                } else {
                    m = MethodUtil.createMethod(mdNameA, mdIntfA);
                }
                this.addMethod(m);
            }
            if (this.ignoreSet.contains(kA)) continue;
            this.ignoreSet.add(kA);
            this.descIgnoreSet.add(kA);
            Method m2 = null;
            m2 = mdParamA == null || mdParamA.length == 0 ? MethodUtil.createNoParamsMethod(mdNameA, mdIntfA, descA) : MethodUtil.createMethod(mdNameA, mdIntfA, mdParamA, descA);
            this.addMethod(m2);
        }
    }

    private void writeDescMethods() {
        Set intfNames;
        if (MethodUtil.isAllDescEmpty(this.descMap.values())) {
            return;
        }
        if (this.usingIntf && (intfNames = this.getAvailableInterfaces()) != null & !intfNames.isEmpty()) {
            Iterator iter = intfNames.iterator();
            while (iter.hasNext()) {
                Set intfSet;
                String intf = (String)iter.next();
                if (!MethodUtil.checkForAllTrueForIntf(this.allMap, intf) || !MethodUtil.isUniqueRule(intfSet = this.getMethodDescriptorsByIntf(intf), this.descIgnoreSet) || !MethodUtil.hasStringValue(intfSet, this.descMap) || !MethodUtil.allDescEqual(intfSet, this.descMap)) continue;
                this.descIgnoreSet.addAll(intfSet);
                Method m = MethodUtil.createMethod(MethodDescriptor.ALL_EJB_METHODS, intf, MethodUtil.getFirstValue(intfSet, this.descMap));
                this.addMethod(m);
            }
        }
        this.findMostInclusiveRuleForDesc(this.allMap);
    }

    private void findMostInclusiveRuleForDesc(Map map) {
        Set setA = map.entrySet();
        Iterator iterA = setA.iterator();
        while (iterA.hasNext()) {
            Set intfSet;
            Set matchSet;
            Method m;
            Set namesSet;
            Map.Entry mA = iterA.next();
            MethodDescriptor kA = (MethodDescriptor)mA.getKey();
            String mdNameA = kA.getName();
            String mdIntfA = null;
            if (this.usingIntf) {
                mdIntfA = kA.getEjbClassSymbol();
            }
            String[] mdParamA = kA.getJavaParameterClassNames();
            String descA = (String)this.descMap.get(kA);
            Boolean vA = (Boolean)mA.getValue();
            if (vA != Boolean.TRUE || descA == null || descA.trim().equals("") || this.descIgnoreSet.contains(kA)) continue;
            Map matchingNamesMap = MethodUtil.findMatchingNames(map, mdNameA);
            if (MethodUtil.checkForAllTrue(matchingNamesMap) && MethodUtil.isUniqueRule(namesSet = matchingNamesMap.keySet(), this.descIgnoreSet) && MethodUtil.hasStringValue(namesSet, this.descMap) && MethodUtil.allDescEqual(namesSet, this.descMap)) {
                this.descIgnoreSet.addAll(namesSet);
                m = MethodUtil.createMethod(mdNameA, null, descA);
                this.addMethod(m);
            }
            if (this.usingIntf && MethodUtil.checkForAllTrueForParamList(matchingNamesMap, mdParamA) && MethodUtil.isUniqueRule(matchSet = MethodUtil.getMatchingMethodDescriptorsByParamList(matchingNamesMap.keySet(), mdParamA), this.descIgnoreSet) && MethodUtil.hasStringValue(matchSet, this.descMap) && MethodUtil.allDescEqual(matchSet, this.descMap)) {
                this.descIgnoreSet.addAll(matchSet);
                m = null;
                m = mdParamA == null || mdParamA.length == 0 ? MethodUtil.createNoParamsMethod(mdNameA, null, descA) : MethodUtil.createMethod(mdNameA, null, mdParamA, descA);
                this.addMethod(m);
            }
            if (this.usingIntf && MethodUtil.checkForAllTrueForIntf(matchingNamesMap, mdIntfA) && MethodUtil.isUniqueRule(intfSet = MethodUtil.getMatchingMethodDescriptorsByIntf(matchingNamesMap.keySet(), mdIntfA), this.descIgnoreSet) && MethodUtil.hasStringValue(intfSet, this.descMap) && MethodUtil.allDescEqual(intfSet, this.descMap)) {
                this.descIgnoreSet.addAll(intfSet);
                m = MethodUtil.createMethod(mdNameA, mdIntfA, descA);
                this.addMethod(m);
            }
            if (this.descIgnoreSet.contains(kA)) continue;
            this.descIgnoreSet.add(kA);
            Method m2 = null;
            m2 = mdParamA == null || mdParamA.length == 0 ? MethodUtil.createNoParamsMethod(mdNameA, mdIntfA, descA) : MethodUtil.createMethod(mdNameA, mdIntfA, mdParamA, descA);
            this.addMethod(m2);
        }
    }
}

