/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.FlushAtEndOfMethod;
import com.sun.enterprise.tools.common.dd.ejb.Method;
import com.sun.enterprise.tools.common.dd.ejb.MethodParams;
import com.sun.enterprise.tools.deployment.ui.ejb.MethodInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.MethodUtil;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class FlushMethodInspector
extends MethodInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlushMethodInspector.class);
    private static String TABNAME = localStrings.getLocalString("ui.flushmethodinspector.tabname", "CMP Flushed Methods");
    private static final String FLUSH_METH_ACC_DSC = localStrings.getLocalString("ui.flushmethodinspector.flushed_method.acc_dsc", "Set EJB methods to be flushed.");
    private static final String FLUSH_COLUMN = localStrings.getLocalString("ui.flushmethodinspector.flush_column", "<HTML>&nbsp;Flush&nbsp;</HTML>");
    private static final String METHOD_COLUMN = localStrings.getLocalString("ui.flushmethodinspector.method_column", "Method");
    private static final String SHOW_INTERFACES = localStrings.getLocalString("ui.flushmethodinspector.show_interface", "Show:");
    private static final String SHOW_INTERFACES_ACC_DSC = localStrings.getLocalString("ui.flushmethodinspector.show_interface.acc_dsc", "Choose interfaces to expose");
    private static final String SHOW_INTERFACES_MN = localStrings.getLocalString("ui.flushmethodinspector.show_interface.mnemonic", "S");
    private static final String SHOW_LOCAL = localStrings.getLocalString("ui.flushmethodinspector.local", "Local Methods");
    private static final String SHOW_LOCAL_HOME = localStrings.getLocalString("ui.flushmethodinspector.local_home", "Local Home Methods");
    private static final String SHOW_REMOTE = localStrings.getLocalString("ui.flushmethodinspector.remote", "Remote Methods");
    private static final String SHOW_REMOTE_HOME = localStrings.getLocalString("ui.flushmethodinspector.remote_home", "Remote Home Methods");
    private static String HELP_ID = "Flush";
    private InspectorPane inspectorPane = null;
    private EjbCMPEntityDescriptor descriptor = null;
    private Set mdSet = null;
    private Ejb ejb = null;
    private FlushAtEndOfMethod flush = null;
    private Method[] methodArray = null;
    private MethodParams params = null;
    static Object[] INTERFACE_OPTIONS = new Object[]{SHOW_LOCAL, SHOW_LOCAL_HOME, SHOW_REMOTE, SHOW_REMOTE_HOME};
    private UITitledComboBox availability = null;
    private UITitledComboBox showInterfaces = null;
    private UITitledTable flushPanel = null;
    private FlushTable flushTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbCMPEntityDescriptor;

    public static InspectorPane newInspectorPane(String mode) {
        return new FlushMethodInspector().inspectorPane;
    }

    String[] initIntfOptions() {
        ArrayList<String> list = new ArrayList<String>();
        Set intfNames = this.getAvailableInterfaces();
        if (intfNames.contains(MethodDescriptor.EJB_LOCAL)) {
            list.add(SHOW_LOCAL);
        }
        if (intfNames.contains(MethodDescriptor.EJB_LOCALHOME)) {
            list.add(SHOW_LOCAL_HOME);
        }
        if (intfNames.contains(MethodDescriptor.EJB_REMOTE)) {
            list.add(SHOW_REMOTE);
        }
        if (intfNames.contains(MethodDescriptor.EJB_HOME)) {
            list.add(SHOW_REMOTE_HOME);
        }
        return list.toArray(new String[list.size()]);
    }

    private void setMDSet() {
        try {
            this.mdSet = this.descriptor.getMethodDescriptors();
        }
        catch (Throwable e) {
            Print.printStackTrace((String)"Getting method descriptors", (Throwable)e);
            UIOptionPane.showErrorDialog(this.inspectorPane, FlushMethodInspector.GET_METH_ERROR(this.descriptor.getDisplayName(), e.toString()));
        }
        this.removeFindersFromMDSet();
    }

    public FlushMethodInspector() {
        if (this.inspectorPane == null) {
            this.inspectorPane = new InspectorPane(){

                public String getHelpID() {
                    return HELP_ID;
                }

                public String getTabName() {
                    return TABNAME;
                }

                public Descriptor getDescriptor() {
                    return FlushMethodInspector.this.descriptor;
                }

                public Class getDescriptorClass() {
                    return class$com$sun$enterprise$deployment$EjbCMPEntityDescriptor == null ? (class$com$sun$enterprise$deployment$EjbCMPEntityDescriptor = FlushMethodInspector.class$("com.sun.enterprise.deployment.EjbCMPEntityDescriptor")) : class$com$sun$enterprise$deployment$EjbCMPEntityDescriptor;
                }

                public void setDescriptor(Descriptor d) {
                    if (d instanceof EjbCMPEntityDescriptor) {
                        FlushMethodInspector.this.descriptor = (EjbCMPEntityDescriptor)d;
                        FlushMethodInspector.this.setMDSet();
                        FlushMethodInspector.this.flushTable.clearTableData();
                        FlushMethodInspector.this.ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)FlushMethodInspector.this.descriptor);
                        FlushMethodInspector.this.flush = FlushMethodInspector.this.ejb.getFlushAtEndOfMethod();
                        if (FlushMethodInspector.this.flush != null) {
                            FlushMethodInspector.access$702(FlushMethodInspector.this, FlushMethodInspector.this.flush.getMethod());
                        } else {
                            FlushMethodInspector.access$702(FlushMethodInspector.this, null);
                        }
                        FlushMethodInspector.this.initMethods(FlushMethodInspector.this.mdSet, FlushMethodInspector.this.methodArray);
                        if (FlushMethodInspector.this.showInterfaces != null) {
                            FlushMethodInspector.this.showInterfaces.setModel(FlushMethodInspector.this.initIntfOptions());
                        }
                    }
                }

                protected void refresh() {
                    if (FlushMethodInspector.this.descriptor == null) {
                        return;
                    }
                    FlushMethodInspector.this.flushTable.setModel(new FlushTableModel());
                    FlushMethodInspector.this.flushTable.updateTableData(FlushMethodInspector.this.getMethodsForSelIntf());
                }
            };
        }
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.inspectorPane.setLayout(new GridBagLayout());
        this.showInterfaces = new UITitledComboBox(SHOW_INTERFACES, false);
        this.showInterfaces.getAccessibleContext().setAccessibleDescription(SHOW_INTERFACES_ACC_DSC);
        this.showInterfaces.setMnemonic(SHOW_INTERFACES_MN.charAt(0));
        this.showInterfaces.setModel(INTERFACE_OPTIONS);
        this.showInterfaces.setClearWhenDisabled(true);
        this.showInterfaces.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FlushMethodInspector.this.inspectorPane.invokeRefresh();
            }
        });
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 0;
        c.anchor = 17;
        this.inspectorPane.add((Component)this.showInterfaces, c);
        this.flushPanel = new UITitledTable(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.anchor = 10;
        this.inspectorPane.add((Component)this.flushPanel, c);
        this.flushTable = new FlushTable(new FlushTableModel());
        this.flushTable.getAccessibleContext().setAccessibleDescription(FLUSH_METH_ACC_DSC);
        this.flushPanel.setTableView(this.flushTable);
    }

    private Set getMethodsForSelIntf() {
        String selIntf = (String)this.showInterfaces.getSelectedItem();
        Set set = null;
        if (selIntf == null) {
            if (this.descriptor.getLocalClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_LOCAL);
            } else if (this.descriptor.getRemoteClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_REMOTE);
            }
            selIntf = (String)this.showInterfaces.getSelectedItem();
        }
        if (selIntf.equals(SHOW_LOCAL)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_LOCAL);
        } else if (selIntf.equals(SHOW_LOCAL_HOME)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_LOCALHOME);
        } else if (selIntf.equals(SHOW_REMOTE)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_REMOTE);
        } else if (selIntf.equals(SHOW_REMOTE_HOME)) {
            set = this.getMethodDescriptorsByIntf(MethodDescriptor.EJB_HOME);
        }
        return set;
    }

    private void removeFindersFromMDSet() {
        if (this.mdSet != null) {
            Iterator iter = this.mdSet.iterator();
            while (iter.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)iter.next();
                if (!MethodUtil.isFinderMethod(md.getEjbClassSymbol(), md.getName())) continue;
                iter.remove();
            }
        }
    }

    void clearMethod() {
        this.flush = null;
        this.ejb.setFlushAtEndOfMethod(this.flush);
    }

    void addMethod(Method m) {
        if (this.flush == null) {
            this.flush = new FlushAtEndOfMethod();
            this.ejb.setFlushAtEndOfMethod(this.flush);
        }
        this.flush.addMethod(m);
    }

    public String[] getColumnNames() {
        Vector<String> cn = new Vector<String>();
        cn.add(METHOD_COLUMN);
        cn.add(FLUSH_COLUMN);
        cn.add(DescriptionInspector.DESCRIPTION_COLUMN_INIT);
        return cn.toArray(new String[0]);
    }

    static /* synthetic */ Method[] access$702(FlushMethodInspector x0, Method[] x1) {
        x0.methodArray = x1;
        return x1;
    }

    public class FlushTableModel
    extends InspectorTableModel {
        public FlushTableModel() {
            super(FlushMethodInspector.this.getColumnNames());
            this.setDataOrdering(1);
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            Object value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    value = FlushMethodInspector.this.getBooleanValue(md);
                    break;
                }
                case 2: {
                    if (!FlushMethodInspector.this.getBooleanValue(md).booleanValue()) break;
                    value = md == null ? null : FlushMethodInspector.this.getDescValue(md);
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    FlushMethodInspector.this.updateMethods(md, (Boolean)value);
                    break;
                }
                case 2: {
                    String desc = (String)value;
                    if (!FlushMethodInspector.this.getBooleanValue(md).booleanValue()) break;
                    FlushMethodInspector.this.updateMethodDesc(md, desc);
                }
            }
            FlushMethodInspector.this.descriptor.changed();
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            if (col == 2) {
                return true;
            }
            return true;
        }
    }

    private class FlushTable
    extends InspectorTable {
        public FlushTable(FlushTableModel model) {
            super(model);
            this.setAutoResizeMode(0);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            this.adjustColumnWidth(1, false);
        }

        public void setModel(FlushTableModel model) {
            super.setModel(model);
        }

        public void updateColumnNames() {
            this.getInspectorTableModel().setColumnNames(FlushMethodInspector.this.getColumnNames());
        }
    }
}

