/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.tools.common.dd.EjbRef;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class EjbRefsInspector
extends InspectorPane {
    private static final boolean FULLY_QUALIFIED_EJB_LINK = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbRefsInspector.class);
    private static String EJB_REFS_IN_CODE = localStrings.getLocalString("ui.ejbrefsinspector.table.title", "EJB's Referenced in Code");
    private static final String DEPLOY_SETTINGS = localStrings.getLocalString("at.ejbrefsinspector.deployment_settings", "Sun-specific Settings");
    private static final String USE_SSL = localStrings.getLocalString("ui.ejbrefsinspector.use_ssl", "Use SSL");
    private static final String TABLE_CODED_NAME = localStrings.getLocalString("ui.ejbrefsinspector.table.coded_name", "Coded Name");
    private static final String TABLE_TYPE = localStrings.getLocalString("ui.ejbrefsinspector.table.type", "Type");
    private static final String TABLE_INTERFACES = localStrings.getLocalString("ui.ejbrefsinspector.table.interfaces", "Interfaces");
    private static final String TABLE_HOME_INTERFACE = localStrings.getLocalString("ui.ejbrefsinspector.table.home_interface", "Home Interface");
    private static final String TABLE_EJB_NAME = localStrings.getLocalString("ui.ejbrefsinspector.table.target", "Target");
    private static final String TABLE_REMOTE_INTERFACE = localStrings.getLocalString("ui.ejbrefsinspector.table.remote_interface", "Local/Remote Interface");
    private static final String TABNAME = localStrings.getLocalString("ui.ejbrefsinspector.tabname", "EJB Refs");
    private static final String BEAN_NAME_ACC_DSC = localStrings.getLocalString("at.ejbrefsinspector.enterprise_bean_name.acc_dsc", "Choose Enterprise Bean Name for EJB refernce");
    private static final String JNDI_NAME_ACC_DSC = localStrings.getLocalString("at.ejbrefsinspector.jndi_name.acc_dsc", "Choose JNDI Name for EJB refernce");
    private static final String CODED_NAME_REQUIRED = localStrings.getLocalString("ui.ejbrefsinspector.coded_name_required", "Coded Name is required");
    private static final String EJB_TYPE_REQUIRED = localStrings.getLocalString("ui.ejbrefsinspector.ejb_type_required", "EJB Type is required");
    private static final String INTERFACES_REQUIRED = localStrings.getLocalString("ui.ejbrefsinspector.interfaces_required", "Interfaces is required");
    private static final String HOME_INTERFACE_REQUIRED = localStrings.getLocalString("ui.ejbrefsinspector.home_interface_required", "Home Interface is required");
    private static final String LOCAL_REMOTE_INTERFACE_REQUIRED = localStrings.getLocalString("ui.ejbrefsinspector.local_remote_interface_required", "Local/Remote Interface is required");
    private static String INTERFACE_LOCAL = MethodDescriptor.EJB_LOCAL;
    private static String INTERFACE_REMOTE = MethodDescriptor.EJB_REMOTE;
    private static String[] INTERFACE_TYPES = new String[]{INTERFACE_LOCAL, INTERFACE_REMOTE};
    private static String EJB_SESSION = "Session";
    private static String EJB_ENTITY = EjbEntityDescriptor.TYPE;
    private static String[] EJB_TYPES = new String[]{EJB_SESSION, EJB_ENTITY};
    private static String wizardHelpID = "EJBRef";
    private static String deployHelpID = "EJBRef";
    private static String SESSION = "Session";
    private static String ENTITY = "Entity";
    private WritableJndiNameEnvironment descriptor = null;
    public static final String ID_EJB_NAME = UITitledBox.SCRIPT_ID("combo.ejb_name");
    public static final String ID_JNDI_NAME = UITitledBox.SCRIPT_ID("combo.jndi_name");
    private UITitledTable ejbRefsPanel = null;
    private EjbRefsTable ejbRefsTable = null;
    private Hashtable ejbJndiNameTable = null;
    private EjbRefsDialog ejbRefsDiag = null;
    private static final String EJB_REF_DIALOG_TITLE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.title", "Enterprise Bean Reference");
    private static final String DIALOG_ADD_TITLE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.add_title", "Add Enterprise Bean Reference");
    private static final String DIALOG_EDIT_TITLE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.edit_title", "Edit Enterprise Bean Reference");
    private static final String EJB_DIALOG_REFERENCE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.reference", "Refererence");
    private static final String EJB_DIALOG_TARGET_EJB = localStrings.getLocalString("ui.ejbrefsinspector.dialog.target_ejb", "Target EJB");
    private static final String EJB_DIALOG_CODED_NAME = localStrings.getLocalString("ui.ejbrefsinspector.dialog.coded_name", "Coded Name:");
    private static final String EJB_DIALOG_CODED_NAME_MNEMONIC = localStrings.getLocalString("ui.ejbrefsinspector.dialog.coded_name.mnemonic", "C");
    private static final String EJB_DIALOG_BEAN_NAME = localStrings.getLocalString("ui.ejbrefsinspector.dialog.bean_name", "Enterprise Bean Name:");
    private static final String EJB_DIALOG_BEAN_NAME_MNEMONIC = localStrings.getLocalString("ui.ejbrefsinspector.dialog.bean_name.mnemonic", "n");
    private static final String EJB_DIALOG_TYPE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.type", "EJB Type:");
    private static final String EJB_DIALOG_TYPE_MNEMONIC = localStrings.getLocalString("ui.ejbrefsinspector.dialog.type.mnemonic", "E");
    private static final String EJB_DIALOG_IFACES = localStrings.getLocalString("ui.ejbrefsinspector.dialog.ifaces", "Interfaces:");
    private static final String EJB_DIALOG_IFACES_MNEMONIC = localStrings.getLocalString("ui.ejbrefsinspector.dialog.ifaces.mnemonic", "I");
    private static final String EJB_DIALOG_HOME_IFACE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.homeiface", "Home Interface:");
    private static final String EJB_DIALOG_HOME_IFACE_MNEMONIC = localStrings.getLocalString("ui.ejbrefsinspector.dialog.homeiface.mnemonic", "m");
    private static final String EJB_DIALOG_LOCAL_REMOTE_IFACE = localStrings.getLocalString("ui.ejbrefsinspector.dialog.localiface", "Local/Remote Interface:");
    private static final String EJB_DIALOG_LOCAL_REMOTE_IFACE_MNEMONIC = localStrings.getLocalString("ui.ejbrefsinspector.dialog.localiface.mnemonic", "L");
    private static final String JNDI_NAME = localStrings.getLocalString("at.ejbrefsinspector.jndi_name", "JNDI Name (Sun-specific Setting):");
    private static final String JNDI_NAME_MNEMONIC = localStrings.getLocalString("at.ejbrefsinspector.jndi_name.mnemonic", "J");
    private static String EjbRefsDialogHelpSetMapID_add = "AddEJBRef";
    private static String EjbRefsDialogHelpSetMapID_edit = "EditEJBRef";
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    private static String DEPLOY_SETTINGS_FOR(String v0) {
        return localStrings.getLocalString("at.ejbrefsinspector.deployment_settings_for", "Sun-specific Settings for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new EjbRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WritableJndiNameEnvironment.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)desc : null;
            this.ejbRefsTable.clearTableData();
            this.ejbJndiNameTable = null;
            this.resetFirstRefresh();
        }
    }

    private EjbRefsInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledBox titledBox = new UITitledBox(EJB_REFS_IN_CODE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)titledBox, c);
        this.ejbRefsPanel = new UITitledTable(null, false);
        this.ejbRefsPanel.getAccessibleContext().setAccessibleDescription(EJB_REFS_IN_CODE);
        titledBox.addWithGBConstraints(this.ejbRefsPanel);
        this.ejbRefsTable = new EjbRefsTable(new EjbRefsTableModel());
        this.ejbRefsTable.setAutoResizeMode(4);
        this.ejbRefsPanel.getGBConstraints().weighty = 0.85;
        this.ejbRefsPanel.setTableView(this.ejbRefsTable);
        this.ejbRefsPanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjbRefsInspector.this.addEditEjbRefAction(null);
            }
        }, true));
        this.ejbRefsPanel.addSelectionEnabledButton(UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjbRefsInspector.this.addEditEjbRefAction(EjbRefsInspector.this.getSelectedEjbReference());
            }
        }, true));
        this.ejbRefsPanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjbRefsInspector.this.deleteEjbRefAction();
            }
        }, true));
    }

    private Vector getPossibleEjbJndiNames() {
        if (this.ejbJndiNameTable == null) {
            this.initEjbTable();
        }
        Vector v = new Vector(this.ejbJndiNameTable.keySet());
        return v;
    }

    private void initEjbTable() {
        this.ejbJndiNameTable = new Hashtable();
        Application app = null;
        if (this.descriptor instanceof EjbDescriptor) {
            EjbDescriptor ed = (EjbDescriptor)this.descriptor;
            app = ed.getApplication();
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)this.descriptor;
            app = wbd.getApplication();
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)this.descriptor;
            app = acd.getApplication();
        }
        if (app != null) {
            Vector ejbList = app.getEjbDescriptors();
            Iterator itr = ejbList.iterator();
            while (itr.hasNext()) {
                String jndiN;
                EjbDescriptor ejb = (EjbDescriptor)itr.next();
                if (ejb instanceof EjbMessageBeanDescriptor || (jndiN = ejb.getJndiName()) == null || "".equals(jndiN)) continue;
                this.ejbJndiNameTable.put(jndiN, ejb);
            }
        }
    }

    public void refresh() {
        this.ejbRefsTable.updateTableData(this.descriptor.getEjbReferenceDescriptors());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.ejbRefsPanel.setReadOnly(state);
    }

    public static String getEjbReferenceJndiName(EjbReferenceDescriptor ref) {
        EjbDescriptor ejb = ref.getEjbDescriptor();
        if (ejb != null) {
            String jndiName = ref.isLocal() ? ejb.getJndiName() : ejb.getJndiName();
            return jndiName;
        }
        return "";
    }

    public static void setRefJndiName(Descriptor desc, EjbReferenceDescriptor refDesc, String jndiName, EjbDescriptor ejb) {
        String refName = refDesc.getName();
        EjbRef ejbRef = EjbRefsInspector.findEjbRef(desc, refName);
        if (jndiName.equals("")) {
            refDesc.setJndiName("");
            if (ejbRef == null) {
                return;
            }
            if (desc instanceof EjbDescriptor) {
                ((Ejb)SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)desc))).removeEjbRef(ejbRef);
            } else if (desc instanceof WebBundleDescriptor) {
                ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)((WebBundleDescriptor)desc))).removeEjbRef(ejbRef);
            } else if (desc instanceof ApplicationClientDescriptor) {
                ((SunApplicationClient)SunOneUtils.getSunDescriptor((Descriptor)((ApplicationClientDescriptor)desc))).removeEjbRef(ejbRef);
            }
            desc.changed();
            return;
        }
        refDesc.setLinkName("");
        refDesc.setJndiName(jndiName);
        EjbRefsInspector.setTypeAndClasses(refDesc, ejb);
        if (ejbRef != null) {
            ejbRef.setEjbRefName(refName);
            ejbRef.setJndiName(jndiName);
            desc.changed();
            return;
        }
        ejbRef = new EjbRef();
        ejbRef.setEjbRefName(refName);
        ejbRef.setJndiName(jndiName);
        if (desc instanceof EjbDescriptor) {
            ((Ejb)SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)desc))).addEjbRef(ejbRef);
        } else if (desc instanceof WebBundleDescriptor) {
            ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)((WebBundleDescriptor)desc))).addEjbRef(ejbRef);
        } else if (desc instanceof ApplicationClientDescriptor) {
            ((SunApplicationClient)SunOneUtils.getSunDescriptor((Descriptor)((ApplicationClientDescriptor)desc))).addEjbRef(ejbRef);
        }
        desc.changed();
    }

    public static EjbRef findEjbRef(Descriptor desc, String ejbRefName) {
        EjbRef[] ejbRefs = null;
        EjbRef ejbRef = null;
        SunBaseBean sbb = null;
        if (desc instanceof EjbDescriptor) {
            sbb = SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)desc));
            ejbRefs = ((Ejb)sbb).getEjbRef();
        } else if (desc instanceof WebBundleDescriptor) {
            sbb = SunOneUtils.getSunDescriptor((Descriptor)((WebBundleDescriptor)desc));
            ejbRefs = ((SunWebApp)sbb).getEjbRef();
        } else if (desc instanceof ApplicationClientDescriptor) {
            sbb = SunOneUtils.getSunDescriptor((Descriptor)((ApplicationClientDescriptor)desc));
            ejbRefs = ((SunApplicationClient)sbb).getEjbRef();
        }
        if (ejbRefs != null) {
            for (int i = 0; i < ejbRefs.length; ++i) {
                if (!ejbRefs[i].getEjbRefName().equals(ejbRefName)) continue;
                ejbRef = ejbRefs[i];
                break;
            }
        }
        return ejbRef;
    }

    public static void setTypeAndClasses(EjbReferenceDescriptor refDesc, EjbDescriptor ejb) {
        String homeClass = "";
        String interfaceClass = "";
        if (ejb != null) {
            if (refDesc.isLocal()) {
                homeClass = ejb.getLocalHomeClassName();
                interfaceClass = ejb.getLocalClassName();
                if (homeClass == null) {
                    homeClass = "";
                }
                if ("".equals(homeClass) && !"".equals(ejb.getHomeClassName())) {
                    refDesc.setLocal(false);
                    homeClass = ejb.getHomeClassName();
                    interfaceClass = ejb.getRemoteClassName();
                }
            } else {
                homeClass = ejb.getHomeClassName();
                interfaceClass = ejb.getRemoteClassName();
                if (homeClass == null) {
                    homeClass = "";
                }
                if ("".equals(homeClass) && !"".equals(ejb.getLocalHomeClassName())) {
                    refDesc.setLocal(true);
                    homeClass = ejb.getLocalHomeClassName();
                    interfaceClass = ejb.getLocalClassName();
                }
            }
            if (refDesc.isLocal()) {
                refDesc.setHomeClassName(homeClass);
                refDesc.setBeanClassName(interfaceClass);
            } else {
                refDesc.setHomeClassName(homeClass);
                refDesc.setBeanClassName(interfaceClass);
            }
            if (ejb instanceof EjbEntityDescriptor) {
                refDesc.setType(ENTITY);
            } else if (ejb instanceof EjbSessionDescriptor) {
                refDesc.setType(SESSION);
            }
        }
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.hasEmptyRow(0)) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("at.ejbrefsinspector.missing_coded_name", "All references must specify a 'Coded Name'."));
            }
            return false;
        }
        if (this.hasEmptyRow(3)) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("at.ejbrefsinspector.missing_home_interface", "All references must specify a 'Home Interface'."));
            }
            return false;
        }
        if (this.hasEmptyRow(4)) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("at.ejbrefsinspector.missing_interface", "All references must specify a 'Local/Remote Interface'."));
            }
            return false;
        }
        return true;
    }

    public boolean hasEmptyRow(int col) {
        return this.ejbRefsTable.getRowWithValue(col, "") != null;
    }

    private EjbReferenceDescriptor getSelectedEjbReference() {
        return (EjbReferenceDescriptor)this.ejbRefsTable.getSelectedRowObject();
    }

    private void addEditEjbRefAction(EjbReferenceDescriptor sel) {
        if (this.ejbRefsDiag == null) {
            this.ejbRefsDiag = new EjbRefsDialog(this.getMyParentFrame(), this.getOwner());
        }
        this.ejbRefsDiag.showDialog(sel);
        this.invokeRefresh();
    }

    private void deleteEjbRefAction() {
        Object[] list = this.ejbRefsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                EjbReferenceDescriptor ref = (EjbReferenceDescriptor)list[i];
                EjbRefsInspector.setRefJndiName((Descriptor)this.descriptor, ref, "", null);
                this.descriptor.removeEjbReferenceDescriptor((EjbReference)ref);
            }
        }
        this.invokeRefresh();
    }

    private class EjbRefsDialog
    extends UIDialog {
        private UITitledTextField txCodedName;
        private UITitledComboBox cbIfaces;
        private UITitledComboBox cbHomeIface;
        private UITitledComboBox cbLocRemoteIface;
        private UITitledComboBox cbType;
        private UITitledComboBox cbBeanName;
        private UIHelpButton helpPB;
        private DescriptionInspector.DialogDisplayButton descInspector;
        private UIRadioButtonBox targetEjbBox;
        private UITitledComboBox jndiNameText;
        boolean okSelected;
        private EjbReferenceDescriptor refCopy;
        private EjbReferenceDescriptor refOriginal;
        private List ejbLocalHome;
        private List ejbLocalObject;
        private List ejbHome;
        private List ejbObject;
        private List ejbNames;

        public EjbRefsDialog(Frame owner, InspectorPane.InspectorPaneOwner inspOwner) {
            super(owner, true);
            this.txCodedName = null;
            this.cbIfaces = null;
            this.cbHomeIface = null;
            this.cbLocRemoteIface = null;
            this.cbType = null;
            this.cbBeanName = null;
            this.helpPB = null;
            this.descInspector = null;
            this.targetEjbBox = null;
            this.jndiNameText = null;
            this.okSelected = false;
            this.refCopy = null;
            this.refOriginal = null;
            this.ejbLocalHome = null;
            this.ejbLocalObject = null;
            this.ejbHome = null;
            this.ejbObject = null;
            this.ejbNames = null;
            this.initDialog();
        }

        public EjbRefsDialog(Dialog owner, InspectorPane.InspectorPaneOwner inspOwner) {
            super(owner, true);
            this.txCodedName = null;
            this.cbIfaces = null;
            this.cbHomeIface = null;
            this.cbLocRemoteIface = null;
            this.cbType = null;
            this.cbBeanName = null;
            this.helpPB = null;
            this.descInspector = null;
            this.targetEjbBox = null;
            this.jndiNameText = null;
            this.okSelected = false;
            this.refCopy = null;
            this.refOriginal = null;
            this.ejbLocalHome = null;
            this.ejbLocalObject = null;
            this.ejbHome = null;
            this.ejbObject = null;
            this.ejbNames = null;
            this.initDialog();
        }

        private void initDialog() {
            this.setTitle(EJB_REF_DIALOG_TITLE);
            this.setWindowClosingAction(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent we) {
                    this.this$1.cancelAction();
                }
            });
            UITitledBox contentPanel = new UITitledBox(null, false);
            GridBagConstraints gbc = contentPanel.getGBConstraints();
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 5);
            UITitledBox referenceBox = new UITitledBox(EJB_DIALOG_REFERENCE, true);
            referenceBox.getGBConstraints().weighty = 0.0;
            referenceBox.getGBConstraints().fill = 2;
            referenceBox.getGBConstraints().insets = new Insets(5, 5, 0, 5);
            contentPanel.addWithGBConstraints(referenceBox);
            this.txCodedName = new UITitledTextField(EJB_DIALOG_CODED_NAME, false);
            this.txCodedName.setMnemonic(EJB_DIALOG_CODED_NAME_MNEMONIC.charAt(0));
            this.txCodedName.setRequired(true);
            this.txCodedName.addActionListener(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    EjbRefsDialog.access$1600(this.this$1).setDisplayName(EjbRefsDialog.access$1500(this.this$1).getText());
                }
            });
            referenceBox.addWithGBConstraints(this.txCodedName);
            this.cbType = new UITitledComboBox(EJB_DIALOG_TYPE, false);
            this.cbType.setMnemonic(EJB_DIALOG_TYPE_MNEMONIC.charAt(0));
            this.cbType.setRequired(true);
            this.cbType.setModel(EJB_TYPES);
            this.cbType.addActionListener(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    EjbRefsDialog.access$1600(this.this$1).setType(EjbRefsDialog.access$2000(this.this$1).getText());
                }
            });
            referenceBox.addWithGBConstraints(this.cbType);
            this.cbIfaces = new UITitledComboBox(EJB_DIALOG_IFACES, false);
            this.cbIfaces.setMnemonic(EJB_DIALOG_IFACES_MNEMONIC.charAt(0));
            this.cbIfaces.setRequired(true);
            this.cbIfaces.setModel(INTERFACE_TYPES);
            this.cbIfaces.addActionListener(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    EjbRefsDialog.access$1600(this.this$1).setLocal(EjbRefsInspector.access$900().equals(EjbRefsDialog.access$2400(this.this$1).getSelectedItem()));
                    EjbRefsDialog.access$2500(this.this$1);
                }
            });
            referenceBox.addWithGBConstraints(this.cbIfaces);
            this.cbHomeIface = new UITitledComboBox(EJB_DIALOG_HOME_IFACE, false);
            this.cbHomeIface.setMnemonic(EJB_DIALOG_HOME_IFACE_MNEMONIC.charAt(0));
            this.cbHomeIface.setEditable(true);
            this.cbHomeIface.setRequired(true);
            this.cbHomeIface.addActionListener(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    EjbRefsDialog.access$1600(this.this$1).setHomeClassName(EjbRefsDialog.access$2800(this.this$1).getText());
                }
            });
            referenceBox.addWithGBConstraints(this.cbHomeIface);
            this.cbLocRemoteIface = new UITitledComboBox(EJB_DIALOG_LOCAL_REMOTE_IFACE, false);
            this.cbLocRemoteIface.setMnemonic(EJB_DIALOG_LOCAL_REMOTE_IFACE_MNEMONIC.charAt(0));
            this.cbLocRemoteIface.setEditable(true);
            this.cbLocRemoteIface.setRequired(true);
            this.cbLocRemoteIface.addActionListener(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    EjbRefsDialog.access$1600(this.this$1).setBeanClassName(EjbRefsDialog.access$3100(this.this$1).getText());
                }
            });
            referenceBox.addWithGBConstraints(this.cbLocRemoteIface);
            this.descInspector = new DescriptionInspector.DialogDisplayButton();
            referenceBox.addWithGBConstraints(this.descInspector);
            this.targetEjbBox = new UIRadioButtonBox(EJB_DIALOG_TARGET_EJB, true);
            contentPanel.addWithGBConstraints(this.targetEjbBox);
            this.targetEjbBox.addItem(UIRadioButtonBox.createRadioButton(EJB_DIALOG_BEAN_NAME, EJB_DIALOG_BEAN_NAME_MNEMONIC.charAt(0)));
            this.cbBeanName = new UITitledComboBox(null, false);
            this.cbBeanName.getAccessibleContext().setAccessibleDescription(BEAN_NAME_ACC_DSC);
            this.cbBeanName.setClearWhenDisabled(true);
            this.cbBeanName.setEditable(true);
            this.cbBeanName.addActionListener(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    EjbRefsDialog.access$1600(this.this$1).setLinkName((String)EjbRefsDialog.access$3600(this.this$1).getSelectedItem());
                }
            });
            GridBagConstraints c = this.targetEjbBox.getGBConstraintsCopy();
            c.insets.left += 18;
            c.insets.bottom = 0;
            this.targetEjbBox.add((Component)this.cbBeanName, c);
            this.targetEjbBox.addSelectionEnabledComponent(this.cbBeanName, EJB_DIALOG_BEAN_NAME);
            this.targetEjbBox.addItem(UIRadioButtonBox.createRadioButton(JNDI_NAME, JNDI_NAME_MNEMONIC.charAt(0)));
            this.jndiNameText = new UITitledComboBox(null, false);
            this.jndiNameText.getAccessibleContext().setAccessibleDescription(JNDI_NAME_ACC_DSC);
            this.jndiNameText.setEditable(true);
            this.jndiNameText.setClearWhenDisabled(true);
            this.targetEjbBox.add((Component)this.jndiNameText, c);
            this.targetEjbBox.addSelectionEnabledComponent(this.jndiNameText, JNDI_NAME);
            UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
            dialogPane.setControlButtonLocation(101);
            dialogPane.setView(contentPanel);
            UIButton okPB = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.okAction();
                }
            });
            okPB.clearMnemonic();
            dialogPane.addControlButton(okPB);
            this.getRootPane().setDefaultButton(okPB);
            UIButton cancelPB = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ EjbRefsDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.cancelAction();
                }
            });
            cancelPB.clearMnemonic();
            dialogPane.addControlButton(cancelPB);
            this.helpPB = new UIHelpButton(EjbRefsDialogHelpSetMapID_add);
            dialogPane.addControlButton(this.helpPB);
            this.setContentPane(dialogPane);
        }

        public void showDialog(EjbReferenceDescriptor sel) {
            this.ejbLocalHome = EjbRefsInspector.this.getArchiveClassNames(new Class[]{class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = EjbRefsInspector.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome}, true);
            this.ejbLocalObject = EjbRefsInspector.this.getArchiveClassNames(new Class[]{class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = EjbRefsInspector.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject}, true);
            this.ejbHome = EjbRefsInspector.this.getArchiveClassNames(new Class[]{class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = EjbRefsInspector.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome}, true);
            this.ejbObject = EjbRefsInspector.this.getArchiveClassNames(new Class[]{class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = EjbRefsInspector.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject}, true);
            this.ejbNames = DescriptorTools.getPossibleEjbLinkNames((Descriptor)EjbRefsInspector.this.descriptor);
            this.setEjbRefDescriptor(sel);
            this.setSize(400, 520);
            this.setLocationRelativeTo(EjbRefsInspector.this);
            this.show();
        }

        public void setEjbRefDescriptor(EjbReferenceDescriptor newDesc) {
            this.refOriginal = newDesc;
            if (this.refOriginal != null) {
                if (this.refOriginal.getEjbDescriptor() == null) {
                    this.refCopy = new EjbReferenceDescriptor(this.refOriginal);
                } else {
                    this.refCopy = new EjbReferenceDescriptor();
                    this.refCopy.setDisplayName(this.refOriginal.getDisplayName());
                    this.refCopy.setType(this.refOriginal.getType());
                    this.refCopy.setLocal(this.refOriginal.isLocal());
                    this.refCopy.setLinkName(this.refOriginal.getLinkName());
                    this.refCopy.setHomeClassName(this.refOriginal.getHomeClassName());
                    this.refCopy.setBeanClassName(this.refOriginal.getBeanClassName());
                    this.refCopy.setDescription(this.refOriginal.getDescription());
                }
                this.setTitle(DIALOG_EDIT_TITLE);
                this.helpPB.setHelpID(EjbRefsDialogHelpSetMapID_edit);
            } else {
                this.refCopy = new EjbReferenceDescriptor();
                this.setTitle(DIALOG_ADD_TITLE);
                this.helpPB.setHelpID(EjbRefsDialogHelpSetMapID_add);
            }
            this.refreshDescriptor();
        }

        private void refreshDescriptor() {
            String jndiName;
            String linkName;
            this.txCodedName.setText(this.refCopy.getDisplayName());
            this.cbIfaces.setSelectedItem(this.refCopy.isLocal() ? INTERFACE_LOCAL : INTERFACE_REMOTE);
            this.cbType.setSelectedItem(this.refCopy.getType());
            this.targetEjbBox.setItemEnabled(EJB_DIALOG_BEAN_NAME, true);
            if (this.refCopy.isLocal()) {
                this.cbHomeIface.setModel(this.ejbLocalHome);
                this.cbLocRemoteIface.setModel(this.ejbLocalObject);
                this.targetEjbBox.setItemEnabled(JNDI_NAME, false);
            } else {
                this.cbHomeIface.setModel(this.ejbHome);
                this.cbLocRemoteIface.setModel(this.ejbObject);
                this.targetEjbBox.setItemEnabled(JNDI_NAME, true);
            }
            this.cbHomeIface.setSelectedItem(this.refCopy.getHomeClassName(), true);
            this.cbLocRemoteIface.setSelectedItem(this.refCopy.getBeanClassName(), true);
            this.descInspector.setDescriptionInspector((Descriptor)this.refCopy);
            String string = linkName = this.refCopy.isLinked() ? this.refCopy.getLinkName() : "";
            if (linkName == null) {
                linkName = "";
            }
            if ((jndiName = DescriptorTools.getRefJndiName((Descriptor)EjbRefsInspector.this.descriptor, this.refCopy)) == null) {
                jndiName = "";
            }
            if (linkName.equals("") && jndiName.equals("")) {
                this.targetEjbBox.setSelectedItem(EJB_DIALOG_BEAN_NAME);
            } else if (!linkName.equals("")) {
                this.targetEjbBox.setSelectedItem(EJB_DIALOG_BEAN_NAME);
                if (!jndiName.equals("")) {
                    jndiName = "";
                    EjbRefsInspector.setRefJndiName((Descriptor)EjbRefsInspector.this.descriptor, this.refCopy, jndiName, null);
                }
            } else {
                this.targetEjbBox.setSelectedItem(JNDI_NAME);
            }
            this.cbBeanName.setModel(this.ejbNames);
            this.cbBeanName.setSelectedItem(linkName);
            if (!this.refCopy.isLocal()) {
                Vector ejbJndiNames = EjbRefsInspector.this.getPossibleEjbJndiNames();
                this.jndiNameText.setModel(ejbJndiNames);
                this.jndiNameText.setSelectedItem(jndiName);
            }
        }

        public boolean validateEntries() {
            boolean valid = true;
            String msg = null;
            if (this.txCodedName.getText().equals("")) {
                msg = CODED_NAME_REQUIRED;
                valid = false;
            }
            if (this.cbType.getText().equals("")) {
                msg = msg == null ? EJB_TYPE_REQUIRED : msg + "\n" + EJB_TYPE_REQUIRED;
                valid = false;
            }
            if (this.cbIfaces.getText().equals("")) {
                msg = msg == null ? INTERFACES_REQUIRED : msg + "\n" + INTERFACES_REQUIRED;
                valid = false;
            }
            if (this.cbHomeIface.getText().equals("")) {
                msg = msg == null ? HOME_INTERFACE_REQUIRED : msg + "\n" + HOME_INTERFACE_REQUIRED;
                valid = false;
            }
            if (this.cbLocRemoteIface.getText().equals("")) {
                msg = msg == null ? LOCAL_REMOTE_INTERFACE_REQUIRED : msg + "\n" + LOCAL_REMOTE_INTERFACE_REQUIRED;
                valid = false;
            }
            if (msg != null) {
                UIOptionPane.showErrorDialog(null, msg);
            }
            return valid;
        }

        public void okAction() {
            if (!this.validateEntries()) {
                return;
            }
            this.okSelected = true;
            String jndiName = this.jndiNameText.getText();
            if (this.refOriginal != null) {
                if (jndiName == null) {
                    jndiName = "";
                }
                if (this.refOriginal.getEjbDescriptor() != null) {
                    Print.dprintln((String)"Clearing original <EjbReferenceDescriptor>.getEjbDescriptor() value");
                    this.refOriginal.setEjbDescriptor(null);
                }
                if (!this.refOriginal.getDisplayName().equals(this.refCopy.getDisplayName()) && !jndiName.equals("")) {
                    EjbRefsInspector.setRefJndiName((Descriptor)EjbRefsInspector.this.descriptor, this.refOriginal, "", null);
                }
                this.refOriginal.setDisplayName(this.refCopy.getDisplayName());
                this.refOriginal.setType(this.refCopy.getType());
                this.refOriginal.setLocal(this.refCopy.isLocal());
                this.refOriginal.setHomeClassName(this.refCopy.getHomeClassName());
                this.refOriginal.setBeanClassName(this.refCopy.getBeanClassName());
                this.refOriginal.setDescription(this.refCopy.getDescription());
            } else {
                EjbRefsInspector.this.descriptor.addEjbReferenceDescriptor((EjbReference)this.refCopy);
            }
            if (this.targetEjbBox.isSelectedItem(JNDI_NAME)) {
                EjbRefsInspector.setRefJndiName((Descriptor)EjbRefsInspector.this.descriptor, this.refCopy, jndiName, this.refCopy.getEjbDescriptor());
                if (this.refOriginal != null) {
                    this.refOriginal.setLinkName(null);
                }
            } else {
                EjbRefsInspector.setRefJndiName((Descriptor)EjbRefsInspector.this.descriptor, this.refCopy, "", null);
                if (this.refOriginal != null) {
                    this.refOriginal.setLinkName(this.refCopy.getLinkName());
                }
            }
            this.jndiNameText.setText("");
            this.hide();
        }

        public void cancelAction() {
            this.okSelected = false;
            this.hide();
        }

        static /* synthetic */ UITitledTextField access$1500(EjbRefsDialog x0) {
            return x0.txCodedName;
        }

        static /* synthetic */ EjbReferenceDescriptor access$1600(EjbRefsDialog x0) {
            return x0.refCopy;
        }

        static /* synthetic */ UITitledComboBox access$2000(EjbRefsDialog x0) {
            return x0.cbType;
        }

        static /* synthetic */ UITitledComboBox access$2400(EjbRefsDialog x0) {
            return x0.cbIfaces;
        }

        static /* synthetic */ void access$2500(EjbRefsDialog x0) {
            x0.refreshDescriptor();
        }

        static /* synthetic */ UITitledComboBox access$2800(EjbRefsDialog x0) {
            return x0.cbHomeIface;
        }

        static /* synthetic */ UITitledComboBox access$3100(EjbRefsDialog x0) {
            return x0.cbLocRemoteIface;
        }

        static /* synthetic */ UITitledComboBox access$3600(EjbRefsDialog x0) {
            return x0.cbBeanName;
        }
    }

    public class EjbRefsTableModel
    extends InspectorTableModel {
        EjbRefsInspector inspector;

        public EjbRefsTableModel() {
            super(new String[]{TABLE_CODED_NAME, TABLE_TYPE, TABLE_INTERFACES, TABLE_HOME_INTERFACE, TABLE_REMOTE_INTERFACE, TABLE_EJB_NAME, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            EjbReferenceDescriptor ref = (EjbReferenceDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getType();
                    break;
                }
                case 2: {
                    value = ref.isLocal() ? INTERFACE_LOCAL : INTERFACE_REMOTE;
                    break;
                }
                case 3: {
                    value = ref.getHomeClassName();
                    break;
                }
                case 4: {
                    value = ref.getBeanClassName();
                    break;
                }
                case 5: {
                    value = ref.getLinkName();
                    break;
                }
                case 6: {
                    value = ref.getDescription();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EjbReferenceDescriptor ref = (EjbReferenceDescriptor)obj;
        }
    }

    private class EjbRefsTable
    extends InspectorTable {
        public EjbRefsTable(EjbRefsTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
            this.setColumnHidden(TABLE_TYPE, true);
            this.setColumnHidden(TABLE_INTERFACES, true);
        }
    }
}

