/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.cmp.CmpInspectorPane;
import com.sun.enterprise.tools.deployment.ui.dtv.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.ejb.NewEjbWizard;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.shared.JndiNameInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ManifestClasspathInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.RoleMapInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunONESettingsDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EjbJarGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
ManifestClasspathInspector.UpdateListener,
DescriptionInspector.UpdateListener,
UIJarPackagerBox.UpdateListener {
    private static final boolean EnableAlternate = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbJarGeneralInspector.class);
    private static final String TABNAME = localStrings.getLocalString("ui.ejbjargeneralinspector.tabname", "General");
    private static final String LOCATION = localStrings.getLocalString("ui.ejbjargeneralinspector.location", "Location:");
    private static final String JAR_FILE_NAME = localStrings.getLocalString("ui.ejbjargeneralinspector.jar_filename", "JAR File Name:");
    private static final String TARGET = localStrings.getLocalString("ui.ejbjargeneralinspector.bean_target", "Enterprise Bean will Go In:");
    private static final String MFCLASSPATH = localStrings.getLocalString("ui.ejbjargeneralinspector.manifest_classpath", "Manifest Classpath:");
    private static final String BASEDIR = localStrings.getLocalString("ui.ejbjargeneralinspector.base_directory", "Base directory:");
    private static final String DISPLAYNAME = localStrings.getLocalString("ui.ejbjargeneralinspector.jar_display_name", "JAR Display Name:");
    private static String BEAN_NAME = localStrings.getLocalString("at.ejbjargeneralinspector.bean_name", "Name");
    private static String BEAN_NAME_TOOLTIP = localStrings.getLocalString("at.ejbjargeneralinspector.bean_name.tooltip", "name of this jar");
    private static String DISPLAY_BOX_ACC_DSC = localStrings.getLocalString("at.ejbjargeneralinspector.display_box.acc_dsc", "Read-only jar file name and editable Display name of EJB jar");
    private static String CONTENTS_ACC_DSC = localStrings.getLocalString("at.ejbjargeneralinspector.contents.acc_dsc", "Contents of the EJB Jar file");
    private static String S1_SETTINGS_BUTTON = localStrings.getLocalString("ui.ejbjargeneralinspector.sunone_settings_button", "Sun-specific Settings...");
    private static String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.ejbjargeneralinspector.description.acc_dsc", "Enter Description for EJB Jar file");
    private static String ICON_ACC_DSC = localStrings.getLocalString("at.ejbjargeneralinspector.icon.acc_dsc", "Add Icons for the EJB Jar file");
    private static String MANIFEST_CLASSPATH_ACC_DSC = localStrings.getLocalString("at.ejbjargeneralinspector.manifest_classpath.acc_dsc", "Enter Manifest Classpath for the EJB Jar file");
    private static String DEPLOYMENT_SETTINGS_ACC_DSC = localStrings.getLocalString("at.ejbjargeneralinspector.deployment_settings.acc_dsc", "Enter Sun-specific Settings for the EJB Jar file");
    private static char S1_SETTINGS_BUTTON_MNEMONIC = localStrings.getLocalString("ui.ejbjargeneralinspector.sunone_settings_button_mnemonic", "S").charAt(0);
    private static String wizardHelpID = "NewJAR";
    private static String deployHelpID = "General";
    private EjbBundleDescriptor descriptor;
    private static Random generateId = new Random();
    private boolean isFirstTime = true;
    private static int FILENAME_FIELD_WIDTH = 400;
    private ManifestClasspathInspector.DialogDisplayButton classpathButton = null;
    private ModuleContent archiveContents = null;
    private UIDisplayNameBox fileDisplayBox = null;
    private UIJarPackagerBox contentsPanel = null;
    private JButton s1SettingsPB = null;
    private IconInspector.DialogDisplayButton iconInspector = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;
    private JComponent targetChooser = null;
    private SunONESettingsDialog sunOneSettingsDialog = null;
    private InspectorPane sunOneEjbJarInspector = null;
    private InspectorPane cmpInspector = null;
    private InspectorPane roleMapInspector = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new EjbJarGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return EjbBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof EjbBundleDescriptor) {
            boolean newDesc = obj != this.descriptor;
            this.descriptor = (EjbBundleDescriptor)obj;
            if (newDesc) {
                this.fileDisplayBox.refresh();
            }
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private EjbJarGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.archiveContents = new ModuleContent();
        this.initializeWidgets();
    }

    public ModuleContent getArchiveModuleContent() {
        if (!this.isWizardMode()) {
            return null;
        }
        this.archiveContents.addEntries(UIProject.getProjectFileEntry((Descriptor)this.descriptor));
        return this.archiveContents;
    }

    public ModuleContent getModuleContent() {
        if (!this.isWizardMode()) {
            return null;
        }
        Descriptor d = this.fileDisplayBox.getSelectedParentDescriptor();
        if (d instanceof EjbBundleDescriptor) {
            return UIJarPackager.getMergedModuleContent(this.archiveContents, d);
        }
        if (d instanceof Application) {
            return UIJarPackager.getMergedModuleContent(this.archiveContents, d);
        }
        Print.dprintln((String)("Parent " + DT.className(d)));
        return this.archiveContents;
    }

    private void initializeWidgets() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.fileDisplayBox = new UIDisplayNameBox(2, this.isWizardMode());
        this.fileDisplayBox.getAccessibleContext().setAccessibleDescription(DISPLAY_BOX_ACC_DSC);
        if (this.isWizardMode()) {
            this.fileDisplayBox.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent lse) {
                    EjbJarGeneralInspector.this.invokeRefresh();
                }
            });
            this.fileDisplayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    Descriptor d;
                    if (EjbJarGeneralInspector.this.fileDisplayBox.isCreateNewInApp()) {
                        String n = EjbJarGeneralInspector.this.fileDisplayBox.getDisplayName();
                        if (!n.equals("") && EjbJarGeneralInspector.this.descriptor != null) {
                            EjbJarGeneralInspector.this.setDescriptorDisplayName(n);
                        }
                    } else if (EjbJarGeneralInspector.this.fileDisplayBox.isAddToExisting() && (d = EjbJarGeneralInspector.this.fileDisplayBox.getSelectedParentDescriptor()) instanceof EjbBundleDescriptor) {
                        EjbBundleDescriptor t = (EjbBundleDescriptor)d;
                        EjbJarGeneralInspector.this.setDescriptorDisplayName(t.getDisplayName());
                        EjbJarGeneralInspector.this.descriptor.setDescription(t.getDescription());
                        EjbJarGeneralInspector.this.descriptor.setApplication(t.getApplication());
                    }
                    EjbJarGeneralInspector.this.invokeRefresh();
                }
            });
        } else {
            this.fileDisplayBox.setFileLocation(new File("ejb.jar").getAbsolutePath());
            this.fileDisplayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String n = EjbJarGeneralInspector.this.fileDisplayBox.getDisplayName();
                    if (!n.equals("")) {
                        EjbJarGeneralInspector.this.setDescriptorDisplayName(n);
                    }
                    EjbJarGeneralInspector.this.invokeRefresh();
                }
            });
        }
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)this.fileDisplayBox, c);
        this.contentsPanel = new UIJarPackagerBox(this, "ejbjar", true);
        this.contentsPanel.getAccessibleContext().setAccessibleDescription(CONTENTS_ACC_DSC);
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)this.contentsPanel, c);
        UIControlButtonBox buttonBox = new UIControlButtonBox(null, false);
        buttonBox.setControlButtonLocation(103);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)buttonBox, c);
        this.s1SettingsPB = new UIButton(S1_SETTINGS_BUTTON, S1_SETTINGS_BUTTON_MNEMONIC);
        this.s1SettingsPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbJarGeneralInspector.this.sunOneSettingsDialog();
            }
        });
        buttonBox.addControlButton(this.s1SettingsPB);
        this.classpathButton = new ManifestClasspathInspector.DialogDisplayButton(this);
        this.classpathButton.getAccessibleContext().setAccessibleDescription(MANIFEST_CLASSPATH_ACC_DSC);
        buttonBox.addControlButton(this.classpathButton);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        this.descInspector.getAccessibleContext().setAccessibleDescription(DESCRIPTION_ACC_DSC);
        buttonBox.addControlButton(this.descInspector);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        this.iconInspector.getAccessibleContext().setAccessibleDescription(ICON_ACC_DSC);
        buttonBox.addControlButton(this.iconInspector);
    }

    public Object getSelectedTargetDescriptor() {
        if (this.targetChooser != null) {
            return ((TreeCombo)this.targetChooser).getSelectedDescriptor();
        }
        return null;
    }

    public Descriptor getSelectedParentDescriptor() {
        return this.fileDisplayBox.getSelectedParentDescriptor();
    }

    public String getFileLocation() {
        return this.fileDisplayBox.getFileLocation();
    }

    public boolean validateTargetLocation() {
        if (!StringTools.isEmpty(this.fileDisplayBox.getDisplayName())) {
            this.descriptor.setDisplayName(this.fileDisplayBox.getDisplayName());
        }
        return this.fileDisplayBox.validateTargetLocation();
    }

    public boolean isCreateNewStandAlone() {
        return this.fileDisplayBox.isCreateNewStandAlone();
    }

    public boolean isCreateNewInApp() {
        return this.fileDisplayBox.isCreateNewInApp();
    }

    public boolean isAddToExisting() {
        return this.fileDisplayBox.isAddToExisting();
    }

    public void setWizardComponentMode(String addMode) {
        this.fileDisplayBox.setWizardComponentMode(addMode);
        this.fileDisplayBox.setSavedStartingDirectory(NewEjbWizard.getSavedStartingDirectory());
    }

    private void sunOneSettingsDialog() {
        if (this.sunOneSettingsDialog == null) {
            Frame frame = DT.getApplicationFrame();
            this.sunOneSettingsDialog = new SunONESettingsDialog(frame);
            String mode = "DeploymentMode";
            this.cmpInspector = CmpInspectorPane.newInspectorPane(mode);
            this.sunOneSettingsDialog.addPanel(this, this.cmpInspector);
            this.sunOneSettingsDialog.addPanel(this, JndiNameInspector.newInspectorPane(mode));
            this.roleMapInspector = RoleMapInspector.newInspectorPane(mode);
            this.sunOneSettingsDialog.addPanel(this, this.roleMapInspector);
        }
        this.sunOneSettingsDialog.setAllPanelsEnabled();
        this.sunOneSettingsDialog.setPanelEnabled(this.cmpInspector, DescriptorTools.isCmpBeanPresent(this.descriptor));
        this.sunOneSettingsDialog.setPanelEnabled(this.roleMapInspector, DescriptorTools.isStandAlone((Descriptor)this.descriptor));
        this.sunOneSettingsDialog.show((Descriptor)this.descriptor, null);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            this._addWizardIcon("large", iconFile, this.archiveContents, (Descriptor)this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            this._addWizardIcon("small", iconFile, this.archiveContents, (Descriptor)this.descriptor);
        }
    }

    public void manifestClasspathUpdated(ListModel listModel) {
        Vector cpList = ListTools.toList(listModel);
        ModuleArchive.getModuleArchive((Descriptor)this.descriptor).setManifestClasspaths(cpList);
    }

    public void addContentsAction(ModuleContent clsFcd, ModuleContent conFcd, Vector delCon) throws IOException {
        if (this.isWizardMode()) {
            this.archiveContents.removeEntries(delCon);
            this.archiveContents.addEntries(conFcd);
            UIProject.addArchivePaths((Descriptor)this.descriptor, conFcd);
        } else {
            ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)this.descriptor);
            modArch.removeArchiveEntries(delCon);
            modArch.addArchiveEntries(conFcd.getEntryNameMap());
        }
        this.invokeRefresh();
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.isDeploymentMode()) {
            this.fileDisplayBox.setFileLocation(ModuleArchive.getArchiveUri((Descriptor)this.descriptor));
            String dispName = this.descriptor.getDisplayName();
            if (dispName == null) {
                dispName = "";
            }
            this.fileDisplayBox.setDisplayName(dispName);
            String sunJarName = ((SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getEnterpriseBeans().getName();
            if (sunJarName == null) {
                sunJarName = "";
            }
            if (!dispName.equals(sunJarName)) {
                sunJarName = this.descriptor.getDisplayName();
                ((SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getEnterpriseBeans().setName(sunJarName);
                this.descriptor.changed();
            }
            this.contentsPanel.setContents((BundleDescriptor)this.descriptor);
            List cpList = ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getManifestClasspaths();
            DefaultListModel classPathListModel = ListTools.toListModel(cpList);
            this.classpathButton.setManifestClasspathInspector(classPathListModel, null, (Descriptor)this.descriptor);
        } else {
            boolean bundleInfoEnabled = false;
            if (this.fileDisplayBox.isCreateNewStandAlone()) {
                bundleInfoEnabled = false;
            } else if (this.fileDisplayBox.isCreateNewInApp()) {
                bundleInfoEnabled = true;
            } else if (this.fileDisplayBox.isAddToExisting()) {
                bundleInfoEnabled = true;
            }
            this.classpathButton.setEnabled(bundleInfoEnabled);
            this.iconInspector.setEnabled(bundleInfoEnabled);
            DefaultListModel contentsListModel = new DefaultListModel();
            DefaultListModel classPathListModel = new DefaultListModel();
            Descriptor obj = this.fileDisplayBox.getSelectedParentDescriptor();
            if (obj instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)obj;
                if (!((Object)this.descriptor.getRoles()).equals(ebd.getRoles())) {
                    this.descriptor.changed();
                }
                this.contentsPanel.setContents((BundleDescriptor)ebd, null, this.archiveContents);
                ListTools.toListModel(ModuleArchive.getModuleArchive((Descriptor)ebd).getManifestClasspaths(), classPathListModel);
            } else {
                Application app = obj instanceof Application ? (Application)obj : null;
                this.contentsPanel.setContents((BundleDescriptor)this.descriptor, app, null, this.archiveContents);
                ListTools.toListModel(ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getManifestClasspaths(), classPathListModel);
                String fdName = this.fileDisplayBox.getDisplayName();
                if (fdName.equals("")) {
                    if (app != null) {
                        Set ebdList = app.getEjbBundleDescriptors();
                        String nn = DescriptorTools.createUniqueName(this.descriptor.getDisplayName(), ebdList);
                        if (!nn.equals(this.descriptor.getDisplayName())) {
                            this.setDescriptorDisplayName(nn);
                        }
                    }
                    this.fileDisplayBox.setDisplayName(this.descriptor.getDisplayName());
                } else if (!fdName.equals(this.descriptor.getDisplayName())) {
                    this.setDescriptorDisplayName(fdName);
                }
            }
            this.classpathButton.setManifestClasspathInspector(classPathListModel, null, (Descriptor)this.descriptor, obj);
        }
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getDisplayName(), this, this.descriptor);
        this.invalidate();
        this.validate();
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.fileDisplayBox.setReadOnly(state);
        this.contentsPanel.setReadOnly(state);
        this.iconInspector.setReadOnly(state);
        this.descInspector.setReadOnly(state);
        this.classpathButton.setReadOnly(state);
    }

    private void setDescriptorDisplayName(String name) {
        if (name != null) {
            SunEjbJar sunEjb;
            String sunEjbName;
            String oldName = this.descriptor.getDisplayName();
            if (!name.equals(oldName)) {
                this.descriptor.setDisplayName(name);
            }
            if (!(this.isWizardMode() || (sunEjbName = (sunEjb = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getEnterpriseBeans().getName()) != null && name.equals(sunEjbName))) {
                sunEjb.getEnterpriseBeans().setName(name);
                this.descriptor.changed();
            }
        }
    }
}

