/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.common.dd.application.SunApplication;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.Principal;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIRoleRefsTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.table.TableModel;

public class EjbComponentSecurityInspector
extends InspectorPane
implements DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbComponentSecurityInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.cbox_name", "Method Permission Table");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.cbox_desc", "This is a Method Permission Table for selecting EJB security roles");
    private static final String SECURITY_IDENTITY = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.security_identity", "Security Identity");
    private static final String SECURITY_IDENTITY_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.security_identity.acc_dsc", "Choose Security Identity for the EJB");
    private static final String USE_CALLER_ID = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.use_caller_id", "Use Caller ID");
    private static final String RUN_AS_ROLE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.run_as_role", "Run As Role:");
    private static final String ROLE_NAME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.role_name", "Role Name:");
    private static final String USER_IN_ROLE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.user_in_role", "User In Role:");
    private static final String METHOD_COLUMN = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.method_column", "Method");
    private static final String AVAILABILITY_COLUMN = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability_column", "Availability");
    private static final String AVAIL_ALL_USERS = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability.all_users", "All Users");
    private static final String AVAIL_NO_USERS = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability.no_users", "No Users");
    private static final String AVAIL_SELECTED_ROLES = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability.selected_roles", "Sel Roles");
    private static final String METH_PERM = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.method_permissions", "Method permissions");
    private static final String METH_PERM_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.method_permissions.acc_dsc", "Set required permissions on EJB methods");
    private static final String SHOW_INTERFACES = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.show_interface", "Show:");
    private static final String SHOW_INTERFACES_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.show_interface.acc_dsc", "Choose interfaces to expose");
    private static final String SHOW_LOCAL = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.local", "Local");
    private static final String SHOW_LOCAL_HOME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.local_home", "Local Home");
    private static final String SHOW_REMOTE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.remote", "Remote");
    private static final String SHOW_REMOTE_HOME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.remote_home", "Remote Home");
    private static final String SHOW_SERVICE_ENDPOINT = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.service_endpoint", "Service Endpoint");
    private static final String SSL_REQUIRED = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.ssl_required", "SSL Required");
    private static final String CLIENT_AUTH = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.client_auth", "Client Authentication");
    private static final String CLIENT_AUTH_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.depsettings.client_auth.acc_dsc", "Choose type of Client Authentication");
    private static final String CERTIFICATE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.certificate", "Certificate");
    private static final String PASSWORD = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.password", "Password");
    private static final String CLIENT_CHOICE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.client_choice", "Support Client Choice");
    private static final String RUN_AS_USER = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.run_as_user", "Run as Specified User:");
    private static final String RUN_AS_USER_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.depsettings.run_as_user.acc_dsc", "If security identity chose in a role, select the user to run as");
    private static String ROLE_NAME_REQD = localStrings.getLocalString("at.ejbcomponentsecurityinspector.role_name_reqd", "Role Name is required. Please enter the Role Name or delete the row.");
    private static final String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.description.acc_dsc", "Description for Run As Role of EJB");
    private static final String TABNAME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.tabname", "Security");
    private static String TABNAME_ACC_DSC = localStrings.getLocalString("at.ejbcomponentsecurityinspector.tabname.acc_dsc", "Panel to set security properties for a Bean in a EJB module");
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    private EjbDescriptor descriptor = null;
    private Ejb sunEjb = null;
    private static String REQUIRED = "REQUIRED";
    private static String SUPPORTED = "SUPPORTED";
    private static String[] EJB_METH_TYPE = new String[]{MethodDescriptor.EJB_LOCAL, MethodDescriptor.EJB_LOCALHOME, MethodDescriptor.EJB_REMOTE, MethodDescriptor.EJB_HOME, MethodDescriptor.EJB_WEB_SERVICE};
    private static Object[] INTERFACE_OPTIONS = new Object[]{SHOW_LOCAL, SHOW_LOCAL_HOME, SHOW_REMOTE, SHOW_REMOTE_HOME, SHOW_SERVICE_ENDPOINT};
    private UIRadioButtonBox showInterfaces = null;
    private UIButton editRoles = null;
    private UIRadioButtonBox securityIdBox = null;
    private JRadioButton rbUseCallerId = null;
    private JRadioButton rbRunAsRole = null;
    private UITitledComboBox cbRoleName = null;
    private UITitledComboBox cbUserInRole = null;
    private UIRoleRefsTable roleNamesPanel = null;
    private UITitledTable methodPermissionsPanel = null;
    private MethodPermissionsTable methodPermissionsTable = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static InspectorPane newInspectorPane(String mode) {
        return new EjbComponentSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return EjbDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof EjbDescriptor ? (EjbDescriptor)desc : null;
            this.methodPermissionsTable.clearTableData();
            this.roleNamesPanel.clearTableData();
            this.sunEjb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)desc));
        }
    }

    private EjbComponentSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(TABNAME_ACC_DSC);
        UIControlButtonBox secDepBox = new UIControlButtonBox(null, false);
        secDepBox.setControlButtonLocation(13);
        this.securityIdBox = new UIRadioButtonBox(SECURITY_IDENTITY, true);
        this.securityIdBox.getAccessibleContext().setAccessibleDescription(SECURITY_IDENTITY_ACC_DSC);
        secDepBox.setView(this.securityIdBox);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        this.add((Component)secDepBox, c);
        this.rbUseCallerId = UIRadioButtonBox.createRadioButton(USE_CALLER_ID);
        this.securityIdBox.addItem(this.rbUseCallerId);
        this.rbRunAsRole = UIRadioButtonBox.createRadioButton(RUN_AS_ROLE);
        this.securityIdBox.addItem(this.rbRunAsRole);
        this.securityIdBox.getGBConstraints().insets.left += 25;
        this.cbRoleName = new UITitledComboBox(ROLE_NAME, false);
        this.cbRoleName.setClearWhenDisabled(true);
        this.cbRoleName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbComponentSecurityInspector.this.updateRunAsRole();
            }
        });
        this.securityIdBox.addWithGBConstraints(this.cbRoleName);
        this.securityIdBox.addSelectionEnabledComponent(this.cbRoleName, null);
        this.rbUseCallerId.setSelected(true);
        this.cbUserInRole = new UITitledComboBox(USER_IN_ROLE, false);
        this.cbUserInRole.setSunONE(true);
        this.cbUserInRole.setEditable(true);
        this.cbUserInRole.setClearWhenDisabled(true);
        this.cbUserInRole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbComponentSecurityInspector.this.updateUserInRole();
            }
        });
        this.securityIdBox.addWithGBConstraints(this.cbUserInRole);
        this.securityIdBox.addSelectionEnabledComponent(this.cbUserInRole, null);
        this.securityIdBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean useCID = EjbComponentSecurityInspector.this.descriptor.getUsesCallerIdentity();
                if (useCID && !EjbComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    EjbComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(false);
                } else if (!useCID && EjbComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    EjbComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(true);
                }
                EjbComponentSecurityInspector.this.invokeRefresh();
            }
        });
        this.editRoles = (UIButton)RolesDialog.getEditRolesButton(this);
        secDepBox.addControlButton(this.editRoles);
        UITitledBox methPermBox = new UITitledBox(METH_PERM, true);
        methPermBox.getAccessibleContext().setAccessibleDescription(METH_PERM_ACC_DSC);
        c.weightx = 0.5;
        c.weighty = 0.4;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)methPermBox, c);
        this.showInterfaces = new UIRadioButtonBox(SHOW_INTERFACES, false);
        this.showInterfaces.getAccessibleContext().setAccessibleDescription(SHOW_INTERFACES_ACC_DSC);
        this.showInterfaces.setModel(INTERFACE_OPTIONS);
        this.showInterfaces.setClearWhenDisabled(true);
        this.showInterfaces.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbComponentSecurityInspector.this.invokeRefresh();
            }
        });
        GridBagConstraints gbc = methPermBox.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbc.fill = 0;
        gbc.anchor = 11;
        methPermBox.add((Component)this.showInterfaces, gbc);
        this.methodPermissionsPanel = new UITitledTable(null, false);
        gbc = methPermBox.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methPermBox.add((Component)this.methodPermissionsPanel, gbc);
        this.methodPermissionsTable = new MethodPermissionsTable(new MethodPermissionsTableModel());
        this.methodPermissionsTable.getAccessibleContext().setAccessibleDescription(METH_PERM_ACC_DSC);
        this.methodPermissionsPanel.setTableView(this.methodPermissionsTable);
        this.roleNamesPanel = new UIRoleRefsTable(){

            public Collection getRoleReferences() {
                ArrayList list = new ArrayList();
                Iterator i = EjbComponentSecurityInspector.this.descriptor.getRoleReferences().iterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
                return list;
            }

            public void addRoleReference(RoleReference roleRef) {
                EjbComponentSecurityInspector.this.descriptor.addRoleReference(roleRef);
                EjbComponentSecurityInspector.this.invokeRefresh();
            }

            public void removeRoleReference(RoleReference roleRef) {
                EjbComponentSecurityInspector.this.descriptor.removeRoleReference(roleRef);
                EjbComponentSecurityInspector.this.invokeRefresh();
            }

            public Roles getRolesDescriptor() {
                return EjbComponentSecurityInspector.this.descriptor.getEjbBundleDescriptor();
            }

            public void roleReferenceChanged(RoleReference roleRef) {
                EjbComponentSecurityInspector.this.descriptor.changed();
                EjbComponentSecurityInspector.this.invokeRefresh();
            }
        };
        c.weightx = 0.5;
        c.weighty = 0.6;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.roleNamesPanel, c);
    }

    public void refresh() {
        String methType;
        if (this.descriptor == null) {
            return;
        }
        this.roleNamesPanel.refresh();
        if (this.descriptor.getUsesCallerIdentity()) {
            this.rbUseCallerId.setSelected(true);
        } else {
            Set rolesSet;
            this.rbRunAsRole.setSelected(true);
            EjbBundleDescriptor ebd = this.descriptor.getEjbBundleDescriptor();
            Vector<String> roleList = new Vector<String>();
            Set set = rolesSet = ebd != null ? ebd.getRoles() : null;
            if (rolesSet != null) {
                Iterator i = rolesSet.iterator();
                while (i.hasNext()) {
                    String rn = i.next().toString();
                    roleList.add(rn);
                }
            }
            if (!roleList.contains("") && !roleList.contains(" ")) {
                roleList.add(" ");
            }
            Collections.sort(roleList, ListTools.getStringComparator());
            this.cbRoleName.setModel(roleList);
            RunAsIdentityDescriptor rad = this.getEjbRunAsIdentity();
            this.cbRoleName.setSelectedItem(rad != null ? rad.getRoleName() : " ", true);
            this.cbUserInRole.setModel(this.getUsersInRole(this.cbRoleName.getText(), this.getSecurityRoleMapping()));
            if (this.sunEjb.getPrincipal() != null && this.sunEjb.getPrincipal().getName() != null) {
                this.cbUserInRole.setSelectedItem(this.sunEjb.getPrincipal().getName());
            } else {
                this.cbUserInRole.setSelectedIndex(-1);
            }
        }
        this.showInterfaces.setItemEnabled(SHOW_LOCAL, this.descriptor.getLocalClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_LOCAL_HOME, this.descriptor.getLocalHomeClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_REMOTE, this.descriptor.getRemoteClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_REMOTE_HOME, this.descriptor.getHomeClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_SERVICE_ENDPOINT, this.descriptor.hasWebServiceEndpointInterface());
        int mtNdx = this.showInterfaces.getSelectedIndex();
        String string = methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : null;
        if (methType == null) {
            if (this.descriptor.getLocalClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_LOCAL);
            } else if (this.descriptor.getRemoteClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_REMOTE);
            }
            mtNdx = this.showInterfaces.getSelectedIndex();
            methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : "";
        }
        Vector methods = new Vector();
        try {
            methods.addAll(this.descriptor.getMethodDescriptors());
        }
        catch (Throwable e) {
            Print.printStackTrace((String)"Getting method descriptors", (Throwable)e);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.ejbcomponentsecurityinspector.error_getting_methods", "Error obtaining the list of methods on {0}\n{1}\n", new Object[]{this.descriptor.getDisplayName(), e.toString()}));
        }
        this.methodPermissionsTable.setModel(new MethodPermissionsTableModel());
        Vector<MethodDescriptor> vdata = new Vector<MethodDescriptor>();
        Enumeration e = methods.elements();
        while (e.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e.nextElement();
            if (!md.getEjbClassSymbol().equals(methType)) continue;
            vdata.add(md);
        }
        this.methodPermissionsTable.updateTableData(vdata);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.securityIdBox.setReadOnly(state);
        this.editRoles.setReadOnly(state);
        this.showInterfaces.setReadOnly(state);
        this.methodPermissionsPanel.setReadOnly(state);
        this.roleNamesPanel.setReadOnly(state);
    }

    public void descriptionUpdated(String desc, Object arg) {
        this.descriptor.getRunAsIdentity().setDescription(desc);
        this.descriptor.changed();
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.roleNamesPanel.getInspectorTableView().getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, ROLE_NAME_REQD);
            }
            return false;
        }
        return true;
    }

    private RunAsIdentityDescriptor getEjbRunAsIdentity() {
        return !this.descriptor.getUsesCallerIdentity() ? this.descriptor.getRunAsIdentity() : null;
    }

    private void updateRunAsRole() {
        String roleName;
        if (!this.rbRunAsRole.isSelected()) {
            return;
        }
        if (this.descriptor.getUsesCallerIdentity()) {
            this.descriptor.setUsesCallerIdentity(false);
        }
        if ((roleName = this.cbRoleName.getText().trim()).equals("")) {
            this.descriptor.setRunAsIdentity(null);
            return;
        }
        RunAsIdentityDescriptor rad = this.getEjbRunAsIdentity();
        if (rad == null) {
            rad = new RunAsIdentityDescriptor("");
            this.descriptor.setRunAsIdentity(rad);
        }
        rad.setRoleName(roleName);
        this.invokeRefresh();
    }

    private void updateUserInRole() {
        if (!this.rbRunAsRole.isSelected()) {
            return;
        }
        String user = this.cbUserInRole.getText().trim();
        if (user.equals("")) {
            this.sunEjb.setPrincipal(null);
            return;
        }
        Principal principal = this.sunEjb.getPrincipal();
        if (principal == null) {
            principal = new Principal();
            this.sunEjb.setPrincipal(principal);
        }
        principal.setName(user);
    }

    private SecurityRoleMapping[] getSecurityRoleMapping() {
        SecurityRoleMapping[] srm = null;
        EjbBundleDescriptor ebd = (EjbBundleDescriptor)DescriptorTools.getBundleDescriptor((Descriptor)this.descriptor);
        if (DescriptorTools.isStandAlone((Descriptor)ebd)) {
            SunEjbJar sej = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)ebd);
            srm = sej.getSecurityRoleMapping();
        } else {
            Application app = ebd.getApplication();
            SunApplication sa = (SunApplication)SunOneUtils.getSunDescriptor((Descriptor)app);
            srm = sa.getSecurityRoleMapping();
        }
        return srm;
    }

    private String[] getUsersInRole(String role, SecurityRoleMapping[] srm) {
        String[] users = null;
        if (srm != null) {
            for (int i = 0; i < srm.length; ++i) {
                String roleName = srm[i].getRoleName();
                if (!roleName.equals(role)) continue;
                users = srm[i].getPrincipalName();
                break;
            }
        }
        return users;
    }

    public String[] getColumnNames() {
        EjbBundleDescriptor ebd;
        Vector<String> cn = new Vector<String>();
        cn.add(METHOD_COLUMN);
        cn.add(AVAILABILITY_COLUMN);
        EjbBundleDescriptor ejbBundleDescriptor = ebd = this.descriptor != null ? this.descriptor.getEjbBundleDescriptor() : null;
        if (ebd != null) {
            Iterator ri = ebd.getRoles().iterator();
            while (ri.hasNext()) {
                cn.add(((Role)ri.next()).getName());
            }
        }
        return cn.toArray(new String[0]);
    }

    public class MethodPermissionsTableModel
    extends InspectorTableModel {
        private MethodPermission unchMP;
        private MethodPermission exclMP;

        public MethodPermissionsTableModel() {
            super(EjbComponentSecurityInspector.this.getColumnNames());
            this.unchMP = null;
            this.exclMP = null;
            this.unchMP = MethodPermission.getUncheckedMethodPermission();
            this.exclMP = MethodPermission.getExcludedMethodPermission();
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            Set mpSet = null;
            Role role = null;
            MethodPermission mp = null;
            Object value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
                    if (mpSet.contains(this.exclMP)) {
                        value = AVAIL_NO_USERS;
                        break;
                    }
                    if (mpSet.contains(this.unchMP)) {
                        value = AVAIL_ALL_USERS;
                        break;
                    }
                    value = AVAIL_SELECTED_ROLES;
                    break;
                }
                default: {
                    mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
                    role = new Role(this.getColumnName(col));
                    mp = new MethodPermission(role);
                    value = mpSet.contains(mp) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    if (value.equals(AVAIL_NO_USERS)) {
                        EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.unchMP, md);
                        EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod(this.exclMP, md);
                        break;
                    }
                    if (value.equals(AVAIL_ALL_USERS)) {
                        EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.exclMP, md);
                        EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod(this.unchMP, md);
                        break;
                    }
                    EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.exclMP, md);
                    Set mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
                    HashSet<MethodPermission> newSet = new HashSet<MethodPermission>();
                    for (int c = 2; c < this.getColumnCount(); ++c) {
                        MethodPermission mp = new MethodPermission(new Role(this.getColumnName(c)));
                        if (mpSet.contains(mp)) {
                            newSet = null;
                            break;
                        }
                        newSet.add(mp);
                    }
                    if (newSet != null) {
                        Iterator i = newSet.iterator();
                        while (i.hasNext()) {
                            EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod((MethodPermission)i.next(), md);
                        }
                    }
                    EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.unchMP, md);
                    break;
                }
                default: {
                    MethodPermission mp = new MethodPermission(new Role(this.getColumnName(col)));
                    if (((Boolean)value).booleanValue()) {
                        EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod(mp, md);
                        break;
                    }
                    EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(mp, md);
                }
            }
        }

        public Class getColumnClass(int col) {
            Class clazz = col <= 1 ? (class$java$lang$String == null ? (class$java$lang$String = EjbComponentSecurityInspector.class$("java.lang.String")) : class$java$lang$String) : (class$java$lang$Boolean == null ? (class$java$lang$Boolean = EjbComponentSecurityInspector.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return clazz;
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            MethodDescriptor md = (MethodDescriptor)this.getRowObject(row);
            Set mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
            return !mpSet.contains(this.unchMP) && !mpSet.contains(this.exclMP);
        }
    }

    private class MethodPermissionsTable
    extends InspectorTable {
        private DefaultCellEditor availEditor;

        public MethodPermissionsTable(MethodPermissionsTableModel model) {
            super((TableModel)model, true);
            this.availEditor = null;
            this.setSelectionMode(0);
            JComboBox<Object> cBox = new JComboBox<Object>(new Object[]{AVAIL_ALL_USERS, AVAIL_NO_USERS, AVAIL_SELECTED_ROLES});
            cBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            cBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            this.availEditor = new DefaultCellEditor(cBox);
        }

        public void setModel(MethodPermissionsTableModel model) {
            super.setModel(model);
            this.getColumnModel().getColumn(1).setCellEditor(this.availEditor);
        }

        public void updateColumnNames() {
            this.getInspectorTableModel().setColumnNames(EjbComponentSecurityInspector.this.getColumnNames());
        }
    }
}

