/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.ejb.DeploymentSettingsInspector;
import com.sun.enterprise.tools.deployment.ui.ejb.FinderSelectDialog;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeploymentSettingsDialog
extends UIDialog
implements DeploymentSettingsInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentSettingsDialog.class);
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsdialog.title", "Sun-specific Settings");
    private static final String DB_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsdialog.db_settings", "Database settings...");
    private static final String DB_TABLE = localStrings.getLocalString("ui.deploymentsettingsdialog.db_table", "Database Table");
    private static final String CREATE_ON_DEPLOY = localStrings.getLocalString("ui.deploymentsettingsdialog.create_table_on_deploy", "Create table on deploy");
    private static final String DELETE_ON_UNDEPLOY = localStrings.getLocalString("ui.deploymentsettingsdialog.delete_table_on_undeploy", "Delete table on undeploy");
    private static final String METH_IMPL_QUERIES = localStrings.getLocalString("ui.deploymentsettingsdialog.method_impl_queries", "Method Implementation Queries");
    private static final String GENERATE_SQL = localStrings.getLocalString("ui.deploymentsettingsdialog.generate_default_sql", "Generate Default SQL...");
    private static final String SQL_QUERY = localStrings.getLocalString("ui.deploymentsettingsdialog.sqlquery", "SQL Query:");
    private static final String EJB_QL_QUERY = localStrings.getLocalString("ui.deploymentsettingsdialog.implementationquery", "EJB QL Query:");
    private static final String METHOD_TABLE_METHOD = localStrings.getLocalString("ui.deploymentsettingsdialog.methodtablemethod", "Method");
    private static final String SHOW_FINDERS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_finders", "Show:");
    private static final String SHOW_LOCAL_FINDERS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_local_finders", "Local Finders");
    private static final String SHOW_REMOTE_FINDERS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_remote_finders", "Remote Finders");
    private static final String SHOW_SELECT_METHODS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_select_methods", "Select Methods");
    private static final String SHOW_CONTAINER_METHODS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_container_methods", "Container Methods");
    private static final char CREATE_ON_DEPLOY_MNEMONIC = localStrings.getLocalString("ui.deploymentsettingsdialog.create_table_on_deploy_mnemonic", "D").charAt(0);
    private static final char DELETE_ON_UNDEPLOY_MNEMONIC = localStrings.getLocalString("ui.deploymentsettingsdialog.delete_table_on_undeploy_mnemonic", "U").charAt(0);
    private static final char GENERATE_SQL_MNEMONIC = localStrings.getLocalString("ui.deploymentsettingsdialog.generate_default_sql_mnemonic", "G").charAt(0);
    private static final String METHOD_FIND = "find";
    private static final String METHOD_EJB_SELECT = "ejbSelect";
    private static final String METHOD_FindBPK = "findByPrimaryKey";
    private static final String SQL_where = "where";
    private static String helpSetMapID1 = "EntityDeploySettings";
    private static String helpSetMapID2 = "DepObjDeploySettings";
    private static Object[] FINDER_OPTIONS = new Object[]{SHOW_LOCAL_FINDERS, SHOW_REMOTE_FINDERS, SHOW_SELECT_METHODS, SHOW_CONTAINER_METHODS};
    private UIRadioButtonBox showFinders = null;
    private EjbDescriptor descriptor = null;
    private PersistenceDescriptor persDesc = null;
    private EjbBundleDescriptor ejbBundle = null;
    private boolean cmp2x = false;
    private UITitledBox dbTableBox = null;
    private DeploymentSettingsInspector.DialogDisplayButton databaseSettingsPB = null;
    private JCheckBox createTblOnDeployCB;
    private JCheckBox deleteTblOnUnDeployCB;
    private UIHelpButton helpPB;
    private JButton sqlgenPB;
    private UITitledTable sqlMethodsList;
    private MethodTable methodTable;
    private UITitledTextArea sqlStmtText = null;
    private UITitledTextArea ejbQLText = null;
    private UIControlButtonBox ejbQLBox = null;
    private FinderSelectDialog finderSelectDialog = null;
    private Hashtable tableDataCache = new Hashtable();
    private JButton cancelPB = null;

    private static String ERROR_GETTING_QUERY_METHODS(String v0) {
        return localStrings.getLocalString("ui.deploymentsettingsdialog.error_getting_query_methods", "Error encountered while trying to obtain query methods\n {0}", new Object[]{v0});
    }

    private static String ERROR_MISSING_WHERE_CLAUSE(String v0) {
        return localStrings.getLocalString("ui.deploymentsettingsdialog.sql_missing_where_clause", "Warning: SQL for finder method does not have a WHERE clause:\n  {0}", new Object[]{v0});
    }

    public DeploymentSettingsDialog(Frame frame) {
        super(frame, true);
        this.initLayout();
    }

    private void initLayout() {
        this.setTitle(DEPLOYMENT_SETTINGS);
        this.doNothingOnClose();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DeploymentSettingsDialog.this.cancelAction();
            }
        });
        this.setEnableBusyCursor(true);
        UIPanel contentPane = new UIPanel();
        contentPane.setToolTipText(DEPLOYMENT_SETTINGS);
        contentPane.setPreferredSize(new Dimension(580, 400));
        GridBagLayout gridbag = new GridBagLayout();
        contentPane.setLayout(gridbag);
        this.setContentPane(contentPane);
        GridBagConstraints c = new GridBagConstraints();
        UIControlButtonBox upperHalf = new UIControlButtonBox(null, false);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 2;
        c.anchor = 11;
        contentPane.add((Component)upperHalf, c);
        UITitledBox lowerHalf = new UITitledBox(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 1;
        c.anchor = 15;
        contentPane.add((Component)lowerHalf, c);
        UITitledBox dbSettingsPane = new UITitledBox(null, false);
        upperHalf.setView(dbSettingsPane);
        UITitledBox dbSettingsLeft = new UITitledBox(null, false);
        GridBagConstraints gbc = dbSettingsPane.getGBConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 2;
        dbSettingsPane.add((Component)dbSettingsLeft, gbc);
        UITitledBox dbSettingsRight = new UITitledBox(null, false);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 0;
        gbc.anchor = 15;
        dbSettingsPane.add((Component)dbSettingsRight, gbc);
        this.dbTableBox = new UITitledBox(DB_TABLE, true);
        gbc = dbSettingsLeft.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 15;
        dbSettingsLeft.add((Component)this.dbTableBox, gbc);
        gbc = dbSettingsPane.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.fill = 1;
        dbSettingsPane.add((Component)new UIPanel(), gbc);
        this.createTblOnDeployCB = new UICheckBox(CREATE_ON_DEPLOY, CREATE_ON_DEPLOY_MNEMONIC);
        this.createTblOnDeployCB.setSelected(false);
        this.dbTableBox.addWithGBConstraints(this.createTblOnDeployCB);
        this.deleteTblOnUnDeployCB = new UICheckBox(DELETE_ON_UNDEPLOY, DELETE_ON_UNDEPLOY_MNEMONIC);
        this.deleteTblOnUnDeployCB.setSelected(false);
        this.dbTableBox.addWithGBConstraints(this.deleteTblOnUnDeployCB);
        UITitledBox dbButtonBox = new UITitledBox(null, false);
        gbc = dbSettingsLeft.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 14;
        dbSettingsRight.add((Component)dbButtonBox, gbc);
        this.sqlgenPB = new UIButton(GENERATE_SQL, GENERATE_SQL_MNEMONIC);
        this.sqlgenPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeploymentSettingsDialog.this.generateSQL();
            }
        });
        dbSettingsRight.addWithGBConstraints(this.sqlgenPB);
        this.databaseSettingsPB = new DeploymentSettingsInspector.DialogDisplayButton(this);
        this.databaseSettingsPB.setText(DB_SETTINGS);
        dbSettingsRight.getGBConstraints().insets.top += 5;
        dbSettingsRight.addWithGBConstraints(this.databaseSettingsPB);
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeploymentSettingsDialog.this.okAction();
            }
        });
        upperHalf.addControlButton(okPB);
        this.cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeploymentSettingsDialog.this.cancelAction();
            }
        });
        upperHalf.addControlButton(this.cancelPB);
        this.helpPB = new UIHelpButton();
        upperHalf.addControlButton(this.helpPB);
        UITitledBox methodBox = new UITitledBox(METH_IMPL_QUERIES, true);
        lowerHalf.addWithGBConstraints(methodBox);
        this.showFinders = new UIRadioButtonBox(SHOW_FINDERS, false);
        this.showFinders.setModel(FINDER_OPTIONS);
        this.showFinders.setClearWhenDisabled(true);
        this.showFinders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeploymentSettingsDialog.this.refreshDialog();
            }
        });
        gbc = methodBox.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.fill = 0;
        gbc.anchor = 11;
        methodBox.add((Component)this.showFinders, gbc);
        this.sqlMethodsList = new UITitledTable(null, false);
        this.methodTable = new MethodTable(new MethodTableModel());
        this.methodTable.setSelectionMode(0);
        this.methodTable.getSelectionModel().addListSelectionListener(new SqlMethodsListener());
        this.sqlMethodsList.setTableView(this.methodTable);
        Dimension sqlps = this.sqlMethodsList.getPreferredSize();
        gbc = methodBox.getGBConstraintsCopy();
        gbc.weightx = 0.4;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methodBox.add((Component)this.sqlMethodsList, gbc);
        this.sqlStmtText = new UITitledTextArea(SQL_QUERY, false);
        this.sqlStmtText.setClearWhenDisabled(true);
        this.sqlStmtText.setEnabled(false);
        this.sqlStmtText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MethodItem ref = (MethodItem)DeploymentSettingsDialog.this.sqlMethodsList.getSelectedRowObject();
                if (ref != null) {
                    ref.setSQL(DeploymentSettingsDialog.this.sqlStmtText.getText());
                }
            }
        });
        gbc = methodBox.getGBConstraintsCopy();
        gbc.weightx = 0.6;
        gbc.weighty = 0.4;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methodBox.add((Component)this.sqlStmtText, gbc);
        this.ejbQLBox = new UIControlButtonBox(EJB_QL_QUERY, false);
        this.ejbQLBox.setControlButtonLocation(101);
        gbc.weightx = 0.6;
        gbc.weighty = 0.6;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methodBox.add((Component)this.ejbQLBox, gbc);
        this.ejbQLText = new UITitledTextArea(null, false);
        this.ejbQLText.setReadOnly(true);
        this.ejbQLText.setClearWhenDisabled(true);
        this.ejbQLBox.setView(this.ejbQLText);
        UIButton editPB = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeploymentSettingsDialog.this.editAction();
            }
        }, true);
        this.ejbQLBox.addControlButton(editPB);
        this.ejbQLBox.setEnabled(false);
        this.setSize(650, 400);
        this.setLocationRelativeToOwner(20, 20);
    }

    protected void _showDialog() {
        this.cancelPB.setEnabled(true);
        super._showDialog();
    }

    void setDescriptor(Object d) {
        if (!(d instanceof EjbCMPEntityDescriptor)) {
            this.descriptor = null;
            this.persDesc = null;
            this.ejbBundle = null;
            this.cmp2x = true;
            return;
        }
        EjbCMPEntityDescriptor ejbCmp = (EjbCMPEntityDescriptor)d;
        this.descriptor = ejbCmp;
        this.persDesc = ejbCmp.getPersistenceDescriptor();
        this.ejbBundle = ejbCmp.getEjbBundleDescriptor();
        this.cmp2x = ejbCmp.isEJB20();
        this.dbTableBox.setVisible(true);
        this.showFinders.setVisible(this.cmp2x);
        this.ejbQLBox.setVisible(this.cmp2x);
        this.helpPB.setHelpID(helpSetMapID1);
        if (this.ejbBundle == null) {
            Print.dprintln((String)"EJB bundle descriptor is NULL!");
            return;
        }
        ResourceReferenceDescriptor rrd = this.ejbBundle.getCMPResourceReference();
        if (rrd != null) {
            ResourcePrincipal rp = rrd.getResourcePrincipal();
            this.databaseSettingsPB.setDeploymentSettingsInspector(rrd.getJndiName(), rp.getName(), rp.getPassword());
            this.sqlgenPB.setEnabled(true);
        } else {
            this.databaseSettingsPB.setDeploymentSettingsInspector("", "", "");
            this.sqlgenPB.setEnabled(false);
        }
        this.createTblOnDeployCB.setSelected(true);
        this.deleteTblOnUnDeployCB.setSelected(true);
        this.updateSqlMethods(true);
        this.refreshDialog();
    }

    private void refreshDialog() {
        String showMeth = null;
        if (this.cmp2x) {
            this.showFinders.setItemEnabled(SHOW_LOCAL_FINDERS, this.descriptor.getLocalHomeClassName() != null);
            this.showFinders.setItemEnabled(SHOW_REMOTE_FINDERS, this.descriptor.getHomeClassName() != null);
            showMeth = (String)this.showFinders.getSelectedItem();
            if (showMeth == null) {
                if (this.showFinders.isItemEnabled(SHOW_LOCAL_FINDERS)) {
                    this.showFinders.setSelectedItem(SHOW_LOCAL_FINDERS);
                } else if (this.showFinders.isItemEnabled(SHOW_REMOTE_FINDERS)) {
                    this.showFinders.setSelectedItem(SHOW_REMOTE_FINDERS);
                } else {
                    this.showFinders.setSelectedItem(SHOW_SELECT_METHODS);
                }
                showMeth = (String)this.showFinders.getSelectedItem();
            }
            this.methodTable.setColumnHidden(this.methodTable.getDescriptionColumn(), SHOW_CONTAINER_METHODS.equals(showMeth));
        } else {
            this.methodTable.setColumnHidden(this.methodTable.getDescriptionColumn(), false);
        }
        Vector<MethodItem> queryList = new Vector<MethodItem>();
        Enumeration values = this.tableDataCache.elements();
        while (values.hasMoreElements()) {
            MethodItem mi = (MethodItem)values.nextElement();
            if (this.cmp2x && !mi.getType().equals(showMeth)) continue;
            queryList.add(mi);
        }
        this.methodTable.clearTableData();
        this.methodTable.updateTableData(queryList);
    }

    private Hashtable updateSqlMethods(boolean clear) {
        if (clear) {
            this.tableDataCache.clear();
        }
        try {
            String className = null;
            className = this.descriptor.getLocalHomeClassName();
            if (className != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), MethodDescriptor.EJB_LOCALHOME, SHOW_LOCAL_FINDERS, METHOD_FIND, this.tableDataCache);
            }
            if ((className = this.descriptor.getHomeClassName()) != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), MethodDescriptor.EJB_HOME, SHOW_REMOTE_FINDERS, METHOD_FIND, this.tableDataCache);
            }
            this.addMethods(this.persDesc.getPersistentClass().getMethods(), MethodDescriptor.EJB_BEAN, SHOW_SELECT_METHODS, METHOD_EJB_SELECT, this.tableDataCache);
        }
        catch (Exception ex) {
            UIOptionPane.showErrorDialog(this, DeploymentSettingsDialog.ERROR_GETTING_QUERY_METHODS(ex.toString()));
        }
        return this.tableDataCache;
    }

    private void addMethods(Method[] methods, String methodIntf, String type, String mKey, Hashtable ht) {
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            MethodDescriptor meth = new MethodDescriptor(m, methodIntf);
            String methName = meth.getFormattedString();
            if (!methName.startsWith(mKey) || methName.startsWith(METHOD_FindBPK)) continue;
            QueryDescriptor qd = this.persDesc.getQueryFor(meth);
            MethodItem mi = (MethodItem)ht.get(methName);
            if (mi == null) {
                String eql = qd != null && qd.getIsEjbQl() ? qd.getQuery() : "";
                String sql = qd != null ? qd.getSQL() : "";
                String desc = qd != null ? qd.getDescription() : "";
                mi = new MethodItem(methName, eql, sql, desc, type);
                ht.put(methName, mi);
                continue;
            }
            if (qd == null) continue;
            mi.setEjbQL(qd.getIsEjbQl() ? qd.getQuery() : "");
        }
    }

    private Class getEjbClass(String className) {
        try {
            return ModuleArchive.getModuleArchive((Descriptor)this.persDesc.getEjbBundleDescriptor()).getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    private void applyAction(boolean checkWhere) {
        this.cancelPB.setEnabled(false);
        Iterator i = this.persDesc.getAllPossibleQueriedMethods().iterator();
        while (i.hasNext()) {
            MethodDescriptor method = (MethodDescriptor)i.next();
            String name = method.getFormattedString();
            MethodItem mi = (MethodItem)this.tableDataCache.get(name);
            if (mi == null) continue;
            QueryDescriptor qd = this.persDesc.getQueryFor(method);
            if (qd == null) {
                qd = new QueryDescriptor();
                qd.setQueryMethod(method.getMethod((EjbDescriptor)this.persDesc.getParentDescriptor()));
                this.persDesc.setQueryFor(method, qd);
            }
            qd.setDescription(mi.getDescription());
            String sql = mi.getSQL();
            if (checkWhere && !this.cmp2x && !sql.equals("") && !name.startsWith(METHOD_FindBPK) && sql.toLowerCase().indexOf(SQL_where) < 0) {
                UIOptionPane.showWarningDialog(this, DeploymentSettingsDialog.ERROR_MISSING_WHERE_CLAUSE(name));
            }
            qd.setSQL(sql);
        }
    }

    private void okAction() {
        this.applyAction(true);
        this.hide();
    }

    protected void cancelAction() {
        this.hide();
    }

    private void editAction() {
        if (this.finderSelectDialog == null) {
            this.finderSelectDialog = new FinderSelectDialog(this);
        }
        this.finderSelectDialog.setDescriptor(this.descriptor);
        this.finderSelectDialog.show();
        this.updateSqlMethods(false);
        this.refreshDialog();
    }

    public void resourceReferenceUpdated(String dbNameText, String userNameText, String passwdText) {
        ResourceReferenceDescriptor rrd = this.ejbBundle.getCMPResourceReference();
        if (rrd == null) {
            rrd = new ResourceReferenceDescriptor();
        }
        rrd.setJndiName(dbNameText);
        ResourcePrincipal rp = new ResourcePrincipal(userNameText, passwdText);
        rrd.setResourcePrincipal(rp);
        this.ejbBundle.setCMPResourceReference(rrd);
        this.sqlgenPB.setEnabled(true);
    }

    public void generateSQL(String dbNameText, String userNameText, String passwdText, JDialog owner) {
        this.generateSQL();
    }

    private void generateSQL() {
        try {
            ResourceReferenceDescriptor rrd = this.ejbBundle.getCMPResourceReference();
            if (rrd == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.no_db_name_specified", "ERROR: No database name specified"));
                return;
            }
            String currentServer = DT.getServerManager().getTargetServer();
            if (currentServer == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.please_connect_to_server", "You must connect to the target server to generate the SQL"));
                return;
            }
            this.applyAction(false);
            this.updateSqlMethods(true);
            this.refreshDialog();
            UIOptionPane.showInfoDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.sql_complete", "SQL Generation complete"));
        }
        catch (Exception ex) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.error_generating_sql", "ERROR: while generating SQL.\n{0}\nPlease make sure the database name/user/password is valid\nand the J2EE server and database are running.", new Object[]{ex}));
            return;
        }
    }

    public class MethodTableModel
    extends InspectorTableModel {
        public MethodTableModel() {
            super(new String[]{METHOD_TABLE_METHOD, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.setDataOrdering(1);
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Object getObjectValue(Object obj, int col) {
            MethodItem ref = (MethodItem)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodItem ref = (MethodItem)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    ref.setDescription(value.toString());
                }
            }
        }
    }

    private class MethodTable
    extends InspectorTable {
        public MethodTable(MethodTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class MethodItem
    extends InspectorTableModel.InspectorDataWrapper {
        public MethodItem(String n, String e, String s, String d, String t) {
            super(new Object[]{n, e, s, d, t});
            this.setDefaultNullValue("");
        }

        public String getDisplayName() {
            return (String)this.getObject(0);
        }

        public String getEjbQL() {
            return (String)this.getObject(1);
        }

        public String getSQL() {
            return (String)this.getObject(2);
        }

        public String getDescription() {
            return (String)this.getObject(3);
        }

        public String getType() {
            return (String)this.getObject(4);
        }

        public void setEjbQL(String v) {
            this.setObject(1, v);
        }

        public void setSQL(String v) {
            this.setObject(2, v);
        }

        public void setDescription(String v) {
            this.setObject(3, v);
        }
    }

    private class SqlMethodsListener
    implements ListSelectionListener {
        private SqlMethodsListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MethodItem mi = (MethodItem)DeploymentSettingsDialog.this.sqlMethodsList.getSelectedRowObject();
            if (mi == null) {
                DeploymentSettingsDialog.this.sqlStmtText.setEnabled(false);
                DeploymentSettingsDialog.this.ejbQLBox.setEnabled(false);
            } else {
                DeploymentSettingsDialog.this.sqlStmtText.setText(mi.getSQL());
                DeploymentSettingsDialog.this.sqlStmtText.setEnabled(true);
                if (mi.getType().equals(SHOW_CONTAINER_METHODS)) {
                    DeploymentSettingsDialog.this.ejbQLBox.setEnabled(false);
                } else {
                    DeploymentSettingsDialog.this.ejbQLText.setText(mi.getEjbQL());
                    DeploymentSettingsDialog.this.ejbQLBox.setEnabled(true);
                }
            }
        }
    }
}

