/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.FilesRootTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.dtv.ServerRootTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.UIDescriptorTree;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Print;

public class RootTreeNode
extends DescriptorTreeNode {
    protected DescriptorTreeNode fixedFilesNode = null;
    protected DescriptorTreeNode fixedServerNode = null;

    public RootTreeNode() {
        super(new NodeDescriptors.GrandpaRootDescriptor(), true);
        this.getFilesRootNode();
    }

    public DescriptorTreeNode getFilesRootNode() {
        if (this.fixedFilesNode == null) {
            this.fixedFilesNode = new FilesRootTreeNode();
        }
        super.addNode(null, this.fixedFilesNode);
        return this.fixedFilesNode;
    }

    public DescriptorTreeNode getServerRootNode() {
        if (this.fixedServerNode == null) {
            this.fixedServerNode = new ServerRootTreeNode();
            this.fixedServerNode.setPruneParent(this);
        }
        return this.fixedServerNode;
    }

    public void update(DescriptorTreeModel treeModel) {
        this.getFilesRootNode().update(treeModel);
        this.getServerRootNode().update(treeModel);
    }

    public boolean notification(UIDescriptorTree uiTree, NotificationEvent ne) {
        String type = ne.getType();
        if (type == null) {
            Print.dprintStackTrace((String)"No event type!");
            return false;
        }
        if (type.equals(Descriptor.DESCRIPTOR_CHANGED)) {
            Descriptor d = (Descriptor)ne.getObjectThatChanged();
            DescriptorTreeNode node = this.getNodeFor(d);
            if (node != null) {
                node.update((DescriptorTreeModel)uiTree.getModel());
                node.resizeDisplayNames(uiTree);
                uiTree.repaint();
            }
            return true;
        }
        return this.getFilesRootNode().notification(uiTree, ne) || this.getServerRootNode().notification(uiTree, ne);
    }

    protected DescriptorTreeNode.NodeComparator newNodeComparator() {
        return new RootNodeComparator();
    }

    private class RootNodeComparator
    extends DescriptorTreeNode.NodeComparator {
        private RootNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == RootTreeNode.this.getFilesRootNode()) {
                return o2 == RootTreeNode.this.getFilesRootNode() ? 0 : -1;
            }
            if (o1 == RootTreeNode.this.getServerRootNode()) {
                return o2 == RootTreeNode.this.getServerRootNode() ? 0 : 1;
            }
            return super.compare(o1, o2);
        }
    }
}

