/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.EEClusterTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.EEInstanceTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.dtv.ServerTreeNode;
import com.sun.enterprise.tools.deployment.ui.server.EEClusterDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.EEInstanceDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.EEServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

public class EEServerTreeNode
extends ServerTreeNode {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NodeDescriptors.class);
    public static final String DAS_SUFFIX = localStrings.getLocalString("ui.dtv.eeservertreenode.display_name_suffix", " (DAS)");

    public EEServerTreeNode(ServerDescriptor desc) {
        super(desc);
        this.setDisplayNameSuffix("            ");
    }

    public void update(DescriptorTreeModel treeModel) {
        Vector delNodes = this.getChildrenCopy();
        try {
            DeploymentPlatform.ManagerURI server = this.getServerDescriptor().getServer();
            DeploymentPlatform dp = server.getDeploymentPlatform();
            DeploymentFactory[] factories = dp.getDeploymentFactoryManager().getDeploymentFactories();
            for (int x = 0; x < factories.length; ++x) {
                if (!factories[x].handlesURI(server.getURI()) || ("" + server.getUser()).equals("") || ("" + server.getPassword()).equals("")) continue;
                boolean cluster = false;
                DeploymentManager mgr = factories[x].getDeploymentManager(DeploymentPlatform.detectPortSecurity(server.getURI()), server.getUser(), server.getPassword());
                DeploymentPlatform.setServerConnectionEnvironment(mgr);
                Target[] tgts = mgr.getTargets();
                DeploymentPlatform.ManagerURI childServerURI = null;
                for (int y = 0; y < tgts.length; ++y) {
                    if (((SunTarget)tgts[y]).isDAS()) {
                        if (DeploymentPlatform.isPE(mgr)) {
                            this.setDisplayNameSuffix(PE_INSTANCE_SUFFIX);
                        } else {
                            this.setDisplayNameSuffix(DAS_SUFFIX);
                        }
                        if (server.getTarget() != null) continue;
                        server.setTarget(tgts[y]);
                        continue;
                    }
                    childServerURI = dp.newManagerURI(server);
                    childServerURI.setTarget(tgts[y]);
                    EEServerDescriptor serverDesc = null;
                    if (("" + ((SunTarget)tgts[y]).getTargetType()).equals("cluster")) {
                        serverDesc = new EEClusterDescriptor(childServerURI);
                        cluster = true;
                    } else {
                        serverDesc = new EEInstanceDescriptor(childServerURI);
                        cluster = false;
                    }
                    DescriptorTreeNode node = this.getNodeFor(DescriptorTools.getDisplayName((Object)serverDesc), ((Object)((Object)serverDesc)).getClass());
                    if (node != null) {
                        node.update(treeModel);
                        delNodes.remove(node);
                        continue;
                    }
                    node = cluster ? new EEClusterTreeNode(serverDesc) : new EEInstanceTreeNode(serverDesc);
                    this.addNode(treeModel, node);
                }
            }
        }
        catch (Exception ex) {
            Print.dprintStackTrace((String)"", (Throwable)ex);
        }
        this.removeNodes(treeModel, delNodes);
    }
}

