/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.UIDescriptorTree;
import com.sun.enterprise.tools.deployment.ui.server.DeployedObjectDescriptor;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;

public class DescriptorTreeView
extends JPanel
implements NotificationListener {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DescriptorTreeView.class);
    private final String PANEL_NAME = localStrings.getLocalString("ui.descriptortreeview.panel_name", "Panel");
    private final String PANEL_DESC = localStrings.getLocalString("ui.descriptortreeview.panel_desc", "This panel is for descriptor tree view");
    private final String SCROLL_NAME = localStrings.getLocalString("ui.descriptortreeview.scroll_name", "Scroll Panel");
    private final String SCROLL_DESC = localStrings.getLocalString("ui.descriptortreeview.scroll_desc", "This scroll pane is for descriptor tree view");
    private UIDescriptorTree rootTree = null;

    public DescriptorTreeView() {
        this(new UIDescriptorTree());
    }

    public DescriptorTreeView(UIDescriptorTree rootTree) {
        this.rootTree = rootTree;
        this.getAccessibleContext().setAccessibleName(this.PANEL_NAME);
        this.getAccessibleContext().setAccessibleDescription(this.PANEL_DESC);
        this.setLayout(new BorderLayout());
        UIPanel mainPanel = new UIPanel(this.PANEL_NAME, this.PANEL_DESC);
        mainPanel.setBorder(new LineBorder(Color.black, 0));
        mainPanel.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(rootTree);
        js.getAccessibleContext().setAccessibleName(this.SCROLL_NAME);
        js.getAccessibleContext().setAccessibleDescription(this.SCROLL_DESC);
        mainPanel.add(js);
        this.add(mainPanel);
        this.rootTree.refresh();
        this.rootTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 17) {
                    DescriptorTreeView.this.rootTree.refresh();
                    return;
                }
            }
        });
        DT.getModuleManager().addNotificationListener(this);
        DT.getServerManager().addNotificationListener(this);
        this.setPreferredSize(this.getMaximumSize());
    }

    public void tabValidationChanged() {
        super.repaint();
    }

    public UIDescriptorTree getRootTree() {
        return this.rootTree;
    }

    public DescriptorTreeNode getRootNode() {
        Print.dprintln((String)"Should be removed");
        return this.getRootTree().getRootNode();
    }

    public Descriptor getSelectedParent() {
        return this.rootTree.getSelectedParent();
    }

    public Descriptor getSelectedModule() {
        Descriptor d = this.rootTree.getSelectedDescriptor(new Class[]{Application.class, BundleDescriptor.class});
        return d != null ? DescriptorTools.getModuleDescriptor(d) : null;
    }

    public BundleDescriptor getSelectedBundle() {
        Descriptor d = this.rootTree.getSelectedDescriptor(BundleDescriptor.class);
        return (BundleDescriptor)d;
    }

    public ServerDescriptor getSelectedServer() {
        return (ServerDescriptor)this.rootTree.getSelectedDescriptor(ServerDescriptor.class);
    }

    public DeployedObjectDescriptor getSelectedDeployedObject() {
        Descriptor d = this.getSelectedDescriptor();
        return d instanceof DeployedObjectDescriptor ? (DeployedObjectDescriptor)d : null;
    }

    public Descriptor getSelectedSaveableDescriptor() {
        Descriptor d = this.getSelectedDescriptor();
        if (d instanceof Application || d instanceof BundleDescriptor) {
            return d;
        }
        if (d instanceof EjbDescriptor) {
            return ((EjbDescriptor)d).getEjbBundleDescriptor();
        }
        if (d instanceof WebComponentDescriptor) {
            return ((WebComponentDescriptor)d).getWebBundleDescriptor();
        }
        return null;
    }

    public TreePath getTreePathFor(Descriptor d) {
        return this.rootTree.getTreePathFor(d);
    }

    public TreePath getTreePathFor(String n) {
        return this.rootTree.getTreePathFor(n);
    }

    public boolean replaceNodeDescriptor(Descriptor oldVal, Descriptor newVal) {
        return this.rootTree.replaceDescriptor(oldVal, newVal);
    }

    public void expandDescriptor(Descriptor d) {
        this.setSelectedDescriptor(d, true);
    }

    public void expandFixedNodes() {
        this.rootTree.expandTreeRootDescriptors();
    }

    public void expandAllNodes() {
        this.rootTree.expandAllDescriptors();
    }

    public void clearSelection() {
        this.rootTree.clearSelection();
    }

    public void setSelectedDescriptor(Descriptor d, boolean expand) {
        this.rootTree.setSelectedDescriptor(d, expand);
    }

    public Descriptor getSelectedDescriptor() {
        return this.rootTree.getSelectedDescriptor();
    }

    public synchronized void notification(NotificationEvent ne) {
        this.rootTree.notification(ne);
    }

    public String toString() {
        return "Descrioptor Tree View";
    }

    public String getSelectionAsString() {
        return this.rootTree.getSelectionString();
    }
}

