/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.dtv.ApplicationTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.UIDescriptorTree;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Print;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DescriptorTreeNode
extends DefaultMutableTreeNode {
    private DescriptorTreeNode pruneParent = null;
    private Application app = null;
    private String lastName = "";
    private boolean sortChildren = true;
    private DescriptorTreeNode delegate = null;
    private Comparator nodeComparator = null;

    public DescriptorTreeNode(Application app, Descriptor desc, boolean children) {
        super(desc, children);
        this.app = app;
        this.resetName();
    }

    public DescriptorTreeNode(Descriptor desc, boolean children) {
        super(desc, children);
        this.app = null;
        this.resetName();
    }

    public void setPruneParent(DescriptorTreeNode parent) {
        this.pruneParent = parent;
    }

    public void setSortChildren(boolean sort) {
        this.sortChildren = sort;
    }

    public void setDelegateNode(DescriptorTreeNode node) {
        this.delegate = node;
    }

    public String getName() {
        return this.delegate != null ? this.delegate.getName() : DescriptorTools.getDisplayName(this.getDescriptor());
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean hasNameChanged() {
        return !this.lastName.equals(this.getName());
    }

    public void resetName() {
        this.lastName = this.getName();
    }

    public void resizeDisplayNames(JTree tree) {
        if (this.hasNameChanged()) {
            this.resetName();
            tree.setEditable(true);
            tree.startEditingAtPath(this.getTreePath());
            tree.stopEditing();
            tree.setEditable(false);
        }
        if (this.hasChildren()) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                DescriptorTreeNode node = (DescriptorTreeNode)e.nextElement();
                node.resizeDisplayNames(tree);
            }
        }
    }

    protected Vector getChildren() {
        return this.children;
    }

    protected Vector getChildrenCopy() {
        Vector c = this.getChildren();
        return c != null ? new Vector(c) : new Vector();
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getUserObject();
    }

    public void setUserObject(Object obj) {
        if ("*Resizer*".equals(obj)) {
            return;
        }
        if (!(obj instanceof Descriptor)) {
            Print.dprintStackTrace((String)("Not a 'Descriptor': " + UIUtils.debugClassName(obj)));
            return;
        }
        Object oldValue = super.getUserObject();
        if (oldValue != obj) {
            super.setUserObject(obj);
        }
    }

    public boolean hasErrors() {
        boolean isValid;
        Descriptor d = this.getDescriptor();
        boolean bl = isValid = d == null || DescriptorTools.isTabValid(d);
        if (!isValid) {
            return true;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            DescriptorTreeNode node = (DescriptorTreeNode)e.nextElement();
            if (!node.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public void addNodes(DescriptorTreeModel treeModel, Vector nodes) {
        Enumeration e = nodes.elements();
        while (e.hasMoreElements()) {
            DescriptorTreeNode n = (DescriptorTreeNode)e.nextElement();
            this.addNode(treeModel, n);
        }
    }

    public void addNode(DescriptorTreeModel treeModel, DescriptorTreeNode node) {
        if (!this.isNodeChild(node)) {
            this.addToPruneParent(treeModel);
            if (this.sortChildren) {
                Vector ch = this.getChildren();
                int loc = ch != null ? Collections.binarySearch(ch, node, this.getNodeComparator()) : 0;
                this.insertNode(treeModel, node, loc);
            } else {
                this.insertNode(treeModel, node, this.getChildCount());
            }
        }
    }

    public void insertNode(DescriptorTreeModel treeModel, DescriptorTreeNode node, int loc) {
        int newRow;
        int n = newRow = loc < 0 ? -(loc + 1) : loc;
        if (treeModel != null) {
            treeModel.insertNodeInto(node, this, newRow);
        } else {
            super.insert(node, newRow);
        }
    }

    public void removeAllNodes(DescriptorTreeModel treeModel) {
        this.removeAllChildren();
        if (treeModel != null) {
            treeModel.nodeStructureChanged(this);
        }
    }

    public void removeNode(DescriptorTreeModel treeModel, DescriptorTreeNode node) {
        if (this.isNodeChild(node)) {
            if (treeModel != null) {
                treeModel.removeNodeFromParent(node);
            } else {
                super.remove(node);
            }
            this.pruneParent(treeModel);
        }
    }

    public void removeNodes(DescriptorTreeModel treeModel, Vector nodes) {
        Enumeration e = nodes.elements();
        while (e.hasMoreElements()) {
            DescriptorTreeNode n = (DescriptorTreeNode)e.nextElement();
            this.removeNode(treeModel, n);
        }
    }

    public void detach(DescriptorTreeModel treeModel) {
        DescriptorTreeNode parent = (DescriptorTreeNode)this.getParent();
        if (parent != null) {
            parent.removeNode(treeModel, this);
        }
    }

    public void pruneNode(DescriptorTreeModel treeModel, DescriptorTreeNode child) {
        if (child.hasChildren()) {
            this.addNode(treeModel, child);
        } else {
            this.removeNode(treeModel, child);
        }
    }

    public void pruneParent(DescriptorTreeModel treeModel) {
        if (this.pruneParent != null) {
            this.pruneParent.pruneNode(treeModel, this);
        }
    }

    public void addToPruneParent(DescriptorTreeModel treeModel) {
        if (this.pruneParent != null) {
            this.pruneParent.addNode(treeModel, this);
        }
    }

    public void update(DescriptorTreeModel treeModel) {
    }

    protected void updateChildDescriptorNodes(DescriptorTreeModel treeModel, Collection descriptors) {
        DescriptorTreeNode node;
        if (descriptors == null) {
            return;
        }
        HashSet<DescriptorTreeNode> childNodes = new HashSet<DescriptorTreeNode>();
        HashSet<Object> childNodeDescriptors = new HashSet<Object>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            node = (DescriptorTreeNode)e.nextElement();
            childNodes.add(node);
            childNodeDescriptors.add(node.getUserObject());
        }
        Iterator itr = childNodes.iterator();
        while (itr.hasNext()) {
            node = (DescriptorTreeNode)itr.next();
            Descriptor d = (Descriptor)node.getUserObject();
            if (!this.isValidDescriptor(d) || !descriptors.contains(node.getUserObject())) {
                this.removeNode(treeModel, node);
                childNodeDescriptors.remove(node.getUserObject());
                continue;
            }
            node.update(treeModel);
        }
        itr = descriptors.iterator();
        while (itr.hasNext()) {
            DescriptorTreeNode node2;
            Descriptor d = (Descriptor)itr.next();
            if (!this.isValidDescriptor(d) || childNodeDescriptors.contains(d) || (node2 = this.createChildDescriptorNode(d)) == null) continue;
            this.addNode(treeModel, node2);
            node2.update(treeModel);
        }
    }

    protected boolean isValidDescriptor(Descriptor d) {
        return true;
    }

    protected DescriptorTreeNode createChildDescriptorNode(Descriptor d) {
        return new DescriptorTreeNode(d, false);
    }

    public boolean notification(UIDescriptorTree uiTree, NotificationEvent ne) {
        return false;
    }

    public Set getSubNodesFor(Class type) {
        HashSet<DefaultMutableTreeNode> subNodes = new HashSet<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            if (type != null && !type.isInstance(next.getUserObject())) continue;
            subNodes.add(next);
        }
        return subNodes;
    }

    public DescriptorTreeNode getNodeFor(Descriptor d) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            DescriptorTreeNode child;
            DescriptorTreeNode sn = (DescriptorTreeNode)e.nextElement();
            if (sn.getUserObject() == d) {
                return sn;
            }
            if (sn.getChildCount() <= 0 || (child = sn.getNodeFor(d)) == null) continue;
            return child;
        }
        return null;
    }

    public DescriptorTreeNode getNodeFor(String n) {
        return this.getNodeFor(n, null);
    }

    public DescriptorTreeNode getNodeFor(String n, Class type) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            DescriptorTreeNode child;
            DescriptorTreeNode sn = (DescriptorTreeNode)e.nextElement();
            Descriptor snd = sn.getDescriptor();
            if ((type == null || type.isInstance(snd)) && DescriptorTools.getDisplayName(snd).equals(n)) {
                return sn;
            }
            if (sn.getChildCount() <= 0 || (child = sn.getNodeFor(n, type)) == null) continue;
            return child;
        }
        return null;
    }

    public TreePath getTreePathFor(Descriptor d) {
        DescriptorTreeNode child;
        if (d != null && (child = this.getNodeFor(d)) != null) {
            return new TreePath(child.getPath());
        }
        return null;
    }

    public TreePath getTreePathFor(String n) {
        DescriptorTreeNode child;
        if (n != null && (child = this.getNodeFor(n)) != null) {
            return child.getTreePath();
        }
        return null;
    }

    public Descriptor getDescriptorFor(String n) {
        DescriptorTreeNode child;
        if (n != null && (child = this.getNodeFor(n)) != null) {
            return child.getDescriptor();
        }
        return null;
    }

    public boolean replaceDescriptor(Descriptor oldVal, Descriptor newVal) {
        DescriptorTreeNode node = this.getNodeFor(oldVal);
        if (node != null) {
            node.setUserObject(newVal);
            return true;
        }
        return false;
    }

    public TreePath getTreePath() {
        return new TreePath(this.getPath());
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        Descriptor d = this.getDescriptor();
        if (d == null) {
            return "";
        }
        String name = DescriptorTools.getDisplayName(d);
        if (this.getParent() instanceof ApplicationTreeNode || this.app == null || this.app == d) {
            return name;
        }
        return name + " (" + this.app.getDisplayName() + ")";
    }

    protected NodeComparator newNodeComparator() {
        return new NodeComparator();
    }

    protected Comparator getNodeComparator() {
        if (this.nodeComparator == null) {
            this.nodeComparator = this.newNodeComparator();
        }
        return this.nodeComparator;
    }

    public boolean sort(DescriptorTreeModel treeModel) {
        Vector c = this.getChildren();
        if (c != null) {
            Collections.sort(c, this.getNodeComparator());
            if (treeModel != null) {
                treeModel.nodeStructureChanged(this);
            }
        }
        return false;
    }

    protected class NodeComparator
    implements Comparator {
        protected NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            DescriptorTreeNode d1 = (DescriptorTreeNode)o1;
            DescriptorTreeNode d2 = (DescriptorTreeNode)o2;
            String n1 = d1.toString().toLowerCase();
            String n2 = d2.toString().toLowerCase();
            return n1.compareTo(n2);
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

