/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.dtv.AppClientBundleTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.ArchiveTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.ConnectorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.EjbBundleTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.WebBundleTreeNode;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class ApplicationTreeNode
extends ArchiveTreeNode {
    public static int AppType_NONE = 0;
    public static int AppType_Client_sn = 1;
    public static int AppType_Client = 2;
    public static int AppType_EJB_sn = 4;
    public static int AppType_EJB = 8;
    public static int AppType_WAR_sn = 16;
    public static int AppType_WAR = 32;
    public static int AppType_ResAdapt_sn = 64;
    public static int AppType_ResAdapt = 128;
    public static int AppType_Apps = 256;
    public static int AppType_AppsAndEJBs = AppType_Apps | AppType_EJB;
    public static int AppType_AppsAndWars = AppType_Apps | AppType_WAR;
    public static int AppType_AppsEjbsWars = AppType_Apps | AppType_EJB | AppType_WAR;
    private static int AppType_AppTreeUpdate = AppType_Client | AppType_Client_sn | (AppType_EJB | AppType_EJB_sn) | (AppType_WAR | AppType_WAR_sn) | (AppType_ResAdapt | AppType_ResAdapt_sn);
    public static int AppType_CUSTOM = 61440;
    private int nodeUpdateType = AppType_NONE;

    public ApplicationTreeNode(Application app, int appType) {
        super((Descriptor)app, true);
        this.nodeUpdateType = appType;
    }

    public ApplicationTreeNode(Application app) {
        this(app, AppType_AppTreeUpdate);
    }

    public void update(DescriptorTreeModel treeModel) {
        ApplicationTreeNode.populateNode(treeModel, this, null, this.nodeUpdateType);
    }

    public static void populateNode(DescriptorTreeModel treeModel, DescriptorTreeNode appNode, Application application, int appType) {
        DescriptorTreeNode node;
        Iterator itr;
        if (appType == AppType_Apps || appType == AppType_NONE) {
            return;
        }
        Application app = null;
        if (application == null && appNode instanceof ApplicationTreeNode) {
            application = (Application)((ApplicationTreeNode)appNode).getDescriptor();
        } else {
            app = application;
        }
        HashSet<TreeNode> childSet = null;
        if (appNode instanceof ApplicationTreeNode) {
            childSet = new HashSet<TreeNode>();
            Enumeration<TreeNode> e = appNode.children();
            while (e.hasMoreElements()) {
                childSet.add(e.nextElement());
            }
        }
        if ((appType & AppType_WAR) != 0) {
            itr = application.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                node = (WebBundleTreeNode)ApplicationTreeNode.extractDescriptorNode(childSet, (Descriptor)wbd);
                if (node == null) {
                    node = new WebBundleTreeNode(app, (Descriptor)wbd, true);
                    appNode.addNode(treeModel, node);
                }
                if ((appType & AppType_WAR_sn) == 0) continue;
                node.update(treeModel);
            }
        }
        if ((appType & AppType_EJB) != 0) {
            itr = application.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)itr.next();
                node = (EjbBundleTreeNode)ApplicationTreeNode.extractDescriptorNode(childSet, (Descriptor)ebd);
                if (node == null) {
                    node = new EjbBundleTreeNode(app, (Descriptor)ebd, true);
                    appNode.addNode(treeModel, node);
                }
                if ((appType & AppType_EJB_sn) == 0) continue;
                ((EjbBundleTreeNode)node).update(treeModel);
            }
        }
        if ((appType & AppType_Client) != 0) {
            itr = application.getApplicationClientDescriptors().iterator();
            while (itr.hasNext()) {
                ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr.next();
                node = ApplicationTreeNode.extractDescriptorNode(childSet, (Descriptor)acd);
                if (node == null) {
                    node = new AppClientBundleTreeNode(app, (Descriptor)acd, true);
                    appNode.addNode(treeModel, node);
                }
                if ((appType & AppType_Client_sn) == 0) continue;
                ((DescriptorTreeNode)node).update(treeModel);
            }
        }
        if ((appType & AppType_ResAdapt) != 0) {
            itr = application.getRarDescriptors().iterator();
            while (itr.hasNext()) {
                ConnectorDescriptor d = (ConnectorDescriptor)itr.next();
                node = ApplicationTreeNode.extractDescriptorNode(childSet, (Descriptor)d);
                if (node == null) {
                    node = new ConnectorTreeNode(app, (Descriptor)d, true);
                    appNode.addNode(treeModel, node);
                }
                if ((appType & AppType_ResAdapt_sn) == 0) continue;
                ((DescriptorTreeNode)node).update(treeModel);
            }
        }
        if (childSet != null) {
            Iterator i = childSet.iterator();
            while (i.hasNext()) {
                DescriptorTreeNode node2 = (DescriptorTreeNode)i.next();
                appNode.removeNode(treeModel, node2);
            }
        }
    }

    private static DescriptorTreeNode extractDescriptorNode(Set list, Descriptor desc) {
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                DescriptorTreeNode node = (DescriptorTreeNode)i.next();
                if (desc != node.getDescriptor()) continue;
                i.remove();
                return node;
            }
        }
        return null;
    }

    protected DescriptorTreeNode.NodeComparator newNodeComparator() {
        return new AppNodeComparator();
    }

    private static int NodeOrder(DescriptorTreeNode n) {
        Descriptor d = n.getDescriptor();
        if (d instanceof WebBundleDescriptor) {
            return 1;
        }
        if (d instanceof EjbBundleDescriptor) {
            return 2;
        }
        if (d instanceof ApplicationClientDescriptor) {
            return 3;
        }
        if (d instanceof ConnectorDescriptor) {
            return 4;
        }
        return 9;
    }

    protected class AppNodeComparator
    extends DescriptorTreeNode.NodeComparator {
        protected AppNodeComparator() {
            super(ApplicationTreeNode.this);
        }

        public int compare(Object o1, Object o2) {
            int s2;
            int s1 = ApplicationTreeNode.NodeOrder((DescriptorTreeNode)o1);
            if (s1 != (s2 = ApplicationTreeNode.NodeOrder((DescriptorTreeNode)o2))) {
                return s1 - s2;
            }
            return super.compare(o1, o2);
        }
    }
}

