/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Frame;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PreDeploymentValidation {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PreDeploymentValidation.class);
    private static String APP_HAS_NO_BUNDLES = localStrings.getLocalString("ui.predeploymentvalidation.app_has_no_bundles", "This application has no deployable bundles");
    private static String MISSING_CONTEXT_ROOT = localStrings.getLocalString("ui.predeploymentvalidation.context_root.missing", " [missing context-root]");
    private static String DUPLICATE_CONTEXT_ROOT = localStrings.getLocalString("ui.predeploymentvalidation.context_root.duplicate", " [duplicate context-root]");
    private static String NO_WAR_COMPONENTS = localStrings.getLocalString("ui.predeploymentvalidation.no_war_components", " [no components]");
    private static String WAR_REQUIRED_CONTEXT_ROOT = localStrings.getLocalString("ui.predeploymentvalidation.war_required_context_root", "Please provide a context root for this WAR module and save your changes.\n(see WAR module 'General' tab)");
    private static String WAR_REQUIRED_COMPONENTS = localStrings.getLocalString("ui.predeploymentvalidation.war_required_components", "Please add JSP/Servlet components to this WAR module and save your changes.");
    private Frame frameOwner = null;
    private boolean showErrorDialog = true;

    private static String APP_NEEDS_ATTENTION(Object v0) {
        return localStrings.getLocalString("ui.predeploymentvalidation.app_modules_need_attention", "The following WAR module(s) need attention before they can be deployed.\n{0}", new Object[]{v0});
    }

    public PreDeploymentValidation(Frame frameOwner) {
        this.frameOwner = frameOwner;
        this.setShowErrorDialog(true);
    }

    public void setShowErrorDialog(boolean state) {
        this.showErrorDialog = state;
    }

    public boolean getShowErrorDialog() {
        return this.showErrorDialog;
    }

    public boolean validate(RootDeploymentDescriptor desc) {
        if (desc instanceof Application) {
            return this.validateAPP((Application)desc);
        }
        if (desc instanceof WebBundleDescriptor) {
            return this.validateWAR((WebBundleDescriptor)desc);
        }
        if (desc instanceof EjbBundleDescriptor) {
            return this.validateEJB((EjbBundleDescriptor)desc);
        }
        if (desc instanceof ConnectorDescriptor) {
            return this.validateRAR((ConnectorDescriptor)desc);
        }
        return true;
    }

    protected boolean validateAPP(Application app) {
        if (app.getBundleDescriptors().size() == 0) {
            if (this.getShowErrorDialog()) {
                UIOptionPane.showErrorDialog(this.frameOwner, APP_HAS_NO_BUNDLES);
            }
            return false;
        }
        StringBuffer sb = new StringBuffer();
        HashSet<String> ctxRoots = new HashSet<String>();
        Iterator w = app.getWebBundleDescriptors().iterator();
        while (w.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)w.next();
            String cr = wbd.getContextRoot();
            if (cr == null || cr.trim().equals("")) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("   ").append(wbd.getDisplayName()).append(MISSING_CONTEXT_ROOT);
                continue;
            }
            if (ctxRoots.contains(cr)) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("   ").append(wbd.getDisplayName()).append(DUPLICATE_CONTEXT_ROOT);
                continue;
            }
            ctxRoots.add(cr);
        }
        if (sb.length() > 0) {
            if (this.getShowErrorDialog()) {
                UIOptionPane.showErrorDialog(this.frameOwner, PreDeploymentValidation.APP_NEEDS_ATTENTION(sb));
            }
            return false;
        }
        Iterator ejbBundles = app.getEjbBundleDescriptors().iterator();
        while (ejbBundles.hasNext()) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)ejbBundles.next();
            if (this.validateEJB(ebd)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateWAR(WebBundleDescriptor wbd) {
        return true;
    }

    protected boolean validateEJB(EjbBundleDescriptor ebd) {
        List errors;
        if (DescriptorTools.isCmpBeanPresent(ebd) && (errors = SunOneUtils.preDeploymentCheck(ebd)) != null && errors.size() > 0) {
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), UIUtils.constructMessage(errors));
            return false;
        }
        return true;
    }

    protected boolean validateRAR(ConnectorDescriptor rar) {
        return true;
    }
}

