/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import [Ljavax.enterprise.deploy.spi.TargetModuleID;;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.deployapi.DeploymentFactoryInstaller;
import com.sun.enterprise.deployapi.SunDeploymentManager;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionEnvironment;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentConnectionException;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentModule;
import com.sun.enterprise.tools.deployment.ui.server.X509TrustManager;
import com.sun.enterprise.tools.deployment.ui.utils.ExecProcess;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.PortDetector;
import com.sun.enterprise.tools.deployment.ui.utils.PublicCloneable;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.xml.sax.SAXParseException;

public class DeploymentPlatform
implements PublicCloneable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentPlatform.class);
    private static final String DISTRIBUTE_MODULE = localStrings.getLocalString("ui.deploymentplatform.distribute_module", "Distribute Module");
    private static String DEPLOY_START_MODULE = "deploy.startModule";
    private static String DEPLOY_EXECUTE_CLIENT = "deploy.executeClients";
    private static String DEPLOY_MODULE_NAME = "deploy.moduleName";
    private static String DEPLOY_REF_NAME = "deploy.referenceModuleName";
    private static String DEPLOY_APP_CLIENT_STUB = "deploy.applicationStubFile";
    public static final int MODULE_RUNNING_UNKNOWN = -1;
    public static final int MODULE_RUNNING_YES = 1;
    public static final int MODULE_RUNNING_NO = 0;
    public static final String URI_DEPLOYER = "deployer:";
    public static final String DEFAULT_URI_PREFIX = "deployer:Sun:AppServer::";
    public static final String SECURE_URI_SUFFIX = ":https";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 4848;
    public static final String DEFAULT_HOSTPORT = "localhost:4848";
    public static final String DEFAULT_URI = "deployer:Sun:AppServer::localhost:4848";
    protected static Map _portSecurityCache = new HashMap();
    private static ManagerURI targetManagerURI = null;
    private static ManagerURI selectedManagerURI = null;
    protected static ModuleType[] moduleTypes = new ModuleType[]{ModuleType.EAR, ModuleType.WAR, ModuleType.EJB, ModuleType.RAR, ModuleType.CAR};
    protected static Class[] moduleClasses = new Class[]{Application.class, WebBundleDescriptor.class, EjbBundleDescriptor.class, ConnectorDescriptor.class, ApplicationClientDescriptor.class};
    private static List platformList = null;
    private static boolean _didInit_deploymentFactoryManager = false;
    private DeploymentFactory depFactory = null;
    private String platformName = "";
    private Vector uriList = null;
    private boolean alwaysUseConnected = false;
    private ManagerURI selectedURI = null;
    private DeploymentManagerHolder connectedDeploymentManager = null;
    private DeploymentManagerHolder disconnectedDeploymentManager = null;
    protected static int SUCCESS = 0;
    private static boolean CREATE_TEMP_DEPLOYMENT_PLAN = false;

    public static String NormalizeDefaultURI(String uri) {
        return uri.startsWith(URI_DEPLOYER) ? uri : DEFAULT_URI_PREFIX + uri;
    }

    public static void setTargetManagerURI(ManagerURI mu) {
        targetManagerURI = mu;
        if (targetManagerURI != null) {
            targetManagerURI.setCurrent();
        }
        String hostName = targetManagerURI != null ? targetManagerURI.getHost() : null;
        DT.getServerManager().fireTargetedServerNotification(hostName);
    }

    public static ManagerURI getTargetManagerURI() {
        List muList = DeploymentPlatform.getManagerURIs();
        if (targetManagerURI == null && muList.size() > 0) {
            targetManagerURI = (ManagerURI)muList.get(0);
            targetManagerURI.setCurrent();
        }
        return targetManagerURI;
    }

    public static String getTargetManagerHost() {
        ManagerURI mu = DeploymentPlatform.getTargetManagerURI();
        return mu != null ? mu.getHost() : DEFAULT_HOST;
    }

    public static DeploymentPlatform getTargetDeploymentPlatform() {
        ManagerURI mu = DeploymentPlatform.getTargetManagerURI();
        return mu != null ? mu.getDeploymentPlatform() : null;
    }

    public static void setSelectedManagerURI(ManagerURI mu) {
        selectedManagerURI = mu;
        if (selectedManagerURI != null) {
            selectedManagerURI.setCurrent();
        }
        String hostName = selectedManagerURI != null ? selectedManagerURI.getHost() : null;
        DT.getServerManager().fireSelectedServerNotification(hostName);
    }

    public static ManagerURI getSelectedManagerURI() {
        List muList = DeploymentPlatform.getManagerURIs();
        if (selectedManagerURI == null && muList.size() > 0) {
            selectedManagerURI = (ManagerURI)muList.get(0);
            selectedManagerURI.setCurrent();
        }
        return selectedManagerURI;
    }

    public static String getSelectedManagerHost() {
        ManagerURI mu = DeploymentPlatform.getSelectedManagerURI();
        return mu != null ? mu.getHost() : DEFAULT_HOST;
    }

    public static DeploymentPlatform getSelectedDeploymentPlatform() {
        ManagerURI mu = DeploymentPlatform.getSelectedManagerURI();
        return mu != null ? mu.getDeploymentPlatform() : null;
    }

    public static Class getClassForModuleType(ModuleType type) {
        for (int i = 0; i < moduleTypes.length; ++i) {
            if (!moduleTypes[i].equals(type)) continue;
            return moduleClasses[i];
        }
        return null;
    }

    public static ModuleType getModuleTypeForClass(Class clzz) {
        for (int i = 0; i < moduleClasses.length; ++i) {
            if (!moduleClasses[i].isAssignableFrom(clzz)) continue;
            return moduleTypes[i];
        }
        return null;
    }

    private static List _getPlatforms() {
        if (platformList == null) {
            platformList = new Vector();
        }
        return platformList;
    }

    public static List getPlatforms() {
        HashMap<String, DeploymentFactory> platformMap = new HashMap<String, DeploymentFactory>();
        List dflist = DeploymentPlatform.getDeploymentFactories();
        Iterator<Object> i = dflist.iterator();
        while (i.hasNext()) {
            DeploymentFactory df = (DeploymentFactory)i.next();
            String dfn = df.getDisplayName();
            if (dfn == null || dfn.equals("")) {
                dfn = df.getClass().getName();
            }
            platformMap.put(dfn, df);
        }
        if (platformList == null) {
            Object[] mgrs = UIConfig.getConfigArray("ui.Deploy.deploymentManagers");
            for (int m = 0; m < mgrs.length; ++m) {
                int er = -1;
                if (!(mgrs[m] instanceof Object[])) {
                    er = 1;
                } else {
                    Object[] dm = (Object[])mgrs[m];
                    if (!(dm[0] instanceof String)) {
                        er = 2;
                    } else {
                        String pn = (String)dm[0];
                        if (!(dm[1] instanceof Object[])) {
                            er = 3;
                        } else {
                            Vector u = ListTools.toList((Object[])dm[1]);
                            DeploymentFactory df = (DeploymentFactory)platformMap.get(pn);
                            if (df != null) {
                                DeploymentPlatform dp = u.size() > 0 ? new DeploymentPlatform(df, u.get(0).toString(), (List)u) : new DeploymentPlatform(df, DEFAULT_URI, (List)u);
                                dp.setCurrentUser(UIConfig.getDefaultUserName(), UIConfig.getDefaultPassword());
                                DeploymentPlatform.addPlatform(dp);
                                platformMap.remove(pn);
                            }
                            er = 0;
                        }
                    }
                }
                if (er == 0) continue;
                Print.dprintln((String)("Invalid syntax [" + er + "]"));
            }
        }
        i = platformMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            DeploymentFactory df = (DeploymentFactory)platformMap.get(name);
            if (DeploymentPlatform.getPlatform(name) != null) continue;
            DeploymentPlatform dp = new DeploymentPlatform(df, DEFAULT_URI);
            dp.setCurrentUser(UIConfig.getDefaultUserName(), UIConfig.getDefaultPassword());
            DeploymentPlatform.addPlatform(dp);
        }
        DeploymentPlatform.savePlatforms();
        return DeploymentPlatform._getPlatforms();
    }

    public static List getPlatformsClone() {
        Vector<Object> cloneList = new Vector<Object>();
        Iterator i = DeploymentPlatform.getPlatforms().iterator();
        while (i.hasNext()) {
            cloneList.add(((DeploymentPlatform)i.next()).clone());
        }
        return cloneList;
    }

    public static void savePlatforms() {
        Vector<Object[]> v = new Vector<Object[]>();
        Iterator i = DeploymentPlatform._getPlatforms().iterator();
        while (i.hasNext()) {
            DeploymentPlatform dp = (DeploymentPlatform)i.next();
            String dpn = dp.getName();
            if (dpn.equals("")) continue;
            v.add(new Object[]{dpn, dp.getURIList()});
        }
        UIConfig.setConfigArray("ui.Deploy.deploymentManagers", ListTools.listToArray(v));
    }

    public static void setPlatforms(List p) {
        platformList = null;
        Iterator i = p.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof DeploymentPlatform)) continue;
            DeploymentPlatform.addPlatform((DeploymentPlatform)obj);
        }
        DeploymentPlatform.savePlatforms();
    }

    public static DeploymentPlatform getPlatform(String p) {
        if (p != null && platformList != null) {
            Iterator i = platformList.iterator();
            while (i.hasNext()) {
                DeploymentPlatform dp = (DeploymentPlatform)i.next();
                if (!dp.getName().equals(p)) continue;
                return dp;
            }
        }
        return null;
    }

    public static void addPlatform(DeploymentPlatform platform) {
        if (!DeploymentPlatform._getPlatforms().contains(platform)) {
            DeploymentPlatform._getPlatforms().add(platform);
        }
    }

    public static List getManagerURIs() {
        Vector mgrUris = new Vector();
        Iterator i = DeploymentPlatform.getPlatforms().iterator();
        while (i.hasNext()) {
            DeploymentPlatform dp = (DeploymentPlatform)i.next();
            mgrUris.addAll(dp.getManagerURIList());
        }
        return mgrUris;
    }

    public static DeploymentFactoryManager getDeploymentFactoryManager() {
        if (!_didInit_deploymentFactoryManager) {
            DeploymentFactoryInstaller.getInstaller();
            _didInit_deploymentFactoryManager = true;
            if (DeploymentPlatform.getDeploymentFactories().size() <= 0) {
                UIOptionPane.showWarningDialog(null, localStrings.getLocalString("ui.deploymentplatform.no_deployment_managers", "Unable to find/load any DeploymentManagers."));
            }
        }
        return DeploymentFactoryManager.getInstance();
    }

    public static List getDeploymentFactories() {
        return ListTools.toList(DeploymentPlatform.getDeploymentFactoryManager().getDeploymentFactories());
    }

    public static String detectPortSecurity(String uri) throws IOException, ConnectException, SocketTimeoutException {
        String host = DeploymentPlatform.getHostInfo(uri);
        String cachedURI = (String)_portSecurityCache.get(host);
        if (cachedURI != null) {
            return cachedURI;
        }
        cachedURI = PortDetector.isSecurePort(DeploymentPlatform.getHost(host), DeploymentPlatform.getPort(host)) ? (uri.endsWith(SECURE_URI_SUFFIX) ? uri : uri + SECURE_URI_SUFFIX) : (uri.endsWith(SECURE_URI_SUFFIX) ? uri.substring(0, uri.indexOf(SECURE_URI_SUFFIX)) : uri);
        _portSecurityCache.put(host, cachedURI);
        return cachedURI;
    }

    protected DeploymentPlatform(DeploymentPlatform dp) {
        this.depFactory = dp.depFactory;
        this.platformName = dp.platformName;
        Iterator i = dp.getManagerURIList().iterator();
        while (i.hasNext()) {
            ManagerURI mu = (ManagerURI)i.next();
            this.getManagerURIList().add(this.newManagerURI(mu));
        }
        this.selectedURI = dp.selectedURI != null ? this.getManagerURI(dp.selectedURI.getURI()) : null;
    }

    public DeploymentPlatform(DeploymentFactory df) {
        this(df, null, null);
    }

    public DeploymentPlatform(String platform) {
        this(platform, null, null);
    }

    public DeploymentPlatform(DeploymentFactory df, String defaultURI) {
        this(df, defaultURI, null);
    }

    public DeploymentPlatform(String platform, String defaultURI) {
        this(platform, defaultURI, null);
    }

    public DeploymentPlatform(DeploymentFactory df, List availURI) {
        this(df, null, availURI);
    }

    public DeploymentPlatform(String platform, List availURI) {
        this(platform, null, availURI);
    }

    public DeploymentPlatform(DeploymentFactory df, String defaultURI, List availURI) {
        this.setDeploymentFactory(df);
        this.setURIList(availURI);
        this.setDefaultURI(defaultURI);
    }

    public DeploymentPlatform(String platform, String defaultURI, List availURI) {
        this.setName(platform);
        this.setURIList(availURI);
        this.setDefaultURI(defaultURI);
    }

    protected void setSelectedURI(ManagerURI mu) {
        if (mu != null && mu.getDeploymentPlatform() == this) {
            this.selectedURI = mu;
            this.clearCachedDeploymentManagers();
        } else {
            Print.dprintStackTrace((String)("Invalid ManagerURI: " + mu));
        }
    }

    public void setSelectedURI(String uri) {
        this.selectedURI = this.addURI(uri);
    }

    public String getSelectedURI() {
        ManagerURI mu = this._getSelectedURI();
        return mu != null ? mu.getURI() : "";
    }

    protected ManagerURI _getSelectedURI() {
        return this.selectedURI != null ? this.selectedURI : this._getDefaultURI();
    }

    public boolean hasValidSelectedURI() {
        try {
            return this._getDeploymentManager(this.alwaysUseConnected) != null;
        }
        catch (DeploymentConnectionException dce) {}
        finally {
            return false;
        }
    }

    public boolean isConnected() {
        try {
            return this._getDeploymentManager(true) != null;
        }
        catch (DeploymentConnectionException dce) {}
        finally {
            return false;
        }
    }

    public boolean isServerRunning() {
        if (this.isConnected()) {
            try {
                DeploymentManager dm = this.getDeploymentManager(true);
                if (dm != null) {
                    dm.getTargets();
                    return true;
                }
                return false;
            }
            catch (IllegalStateException ise) {
                return false;
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"Unexpected Exception", (Throwable)t);
                return false;
            }
        }
        return false;
    }

    public void setAlwaysConnect(boolean connect) {
        this.alwaysUseConnected = connect;
    }

    public boolean getAlwaysConnect() {
        return this.alwaysUseConnected;
    }

    public void setCurrentUser(String user, String pass) {
        ManagerURI mu = this._getSelectedURI();
        if (mu != null) {
            mu.setUser(user, pass);
        }
    }

    public String getCurrentUser() {
        ManagerURI mu = this._getSelectedURI();
        return mu != null ? mu.getUser() : "";
    }

    public String getCurrentPassword() {
        ManagerURI mu = this._getSelectedURI();
        return mu != null ? mu.getPassword() : "";
    }

    public boolean hasCurrentUserPassword() {
        ManagerURI mu = this._getSelectedURI();
        return mu != null ? mu.hasUserPassword() : false;
    }

    public Target getSelectedTarget() {
        ManagerURI mu = DeploymentPlatform.getSelectedManagerURI();
        if (mu == null) {
            return null;
        }
        return mu.getTarget();
    }

    public Target getCurrentTarget() {
        ManagerURI mu = DeploymentPlatform.getTargetManagerURI();
        if (mu == null) {
            return null;
        }
        Target currTarget = mu.getTarget();
        if (currTarget == null) {
            Target[] targets = this.getTargets();
            for (int idx = 0; idx < targets.length; ++idx) {
                if (!((SunTarget)targets[idx]).isDAS()) continue;
                currTarget = targets[idx];
                mu.setTarget(currTarget);
                break;
            }
            if (currTarget == null) {
                return null;
            }
            if (!DeploymentPlatform.isPE(this.getDeploymentManager(true))) {
                ((DeployToolWindow)DT.getApplicationFrame()).getDescriptorTreeView().getRootTree().refresh();
            }
        }
        return currTarget;
    }

    public boolean isValidDisconnectedURI(String uri) {
        try {
            return this._getDeploymentManager(false, uri, null, null) != null;
        }
        catch (DeploymentConnectionException dce) {}
        finally {
            return false;
        }
    }

    public boolean isValidConnectedURI(String uri, String usr, String pwd) {
        try {
            return this._getDeploymentManager(true, uri, usr, pwd) != null;
        }
        catch (DeploymentConnectionException dce) {}
        finally {
            return false;
        }
    }

    public void showInvalidURI(Component owner, boolean connected) {
        if (connected) {
            UIOptionPane.showErrorDialog(owner, localStrings.getLocalString("ui.deploymentplatform.invalid_connected_uri", "Cannot obtain a connected Deployment Manager.\nPossible reasons:\n  - The specified URI is invalid.\n  - The server is not running."));
        } else {
            UIOptionPane.showErrorDialog(owner, localStrings.getLocalString("ui.deploymentplatform.invalid_disconnected_uri", "The specified URI does not appear to be supported by any available Deployment Manager"));
        }
    }

    public Target[] getTargets() {
        Target[] targets;
        DeploymentManager dm = this.getDeploymentManager(true);
        Target[] targetArray = targets = dm != null ? dm.getTargets() : new Target[]{};
        if (targets.length == 0) {
            Print.dprintln((String)"No targets found! (server not running?)");
        } else if (Print.isDebugMode() && targets.length > 1) {
            Print.dprintln((String)"More than one target found:");
            for (int i = 0; i < targets.length; ++i) {
                Print.dprintln((String)(i + ") Target: " + targets[i]));
            }
        }
        return targets;
    }

    public Target getTarget(DeploymentManager dm, Object object) {
        if (object instanceof Target) {
            return (Target)object;
        }
        if (object == null) {
            return null;
        }
        Target[] targets = dm.getTargets();
        if (targets != null) {
            String targetName = object.toString();
            for (int count = 0; count < targets.length; ++count) {
                if (!targets[count].getName().equals(targetName)) continue;
                return targets[count];
            }
        }
        return null;
    }

    public Target getTarget(int ndx) {
        if (ndx < 0) {
            return null;
        }
        Target[] targets = this.getTargets();
        return ndx < targets.length ? targets[ndx] : null;
    }

    public DeploymentManager getDeploymentManager() {
        return this.getDeploymentManager(this.alwaysUseConnected);
    }

    public DeploymentManager getDeploymentManagerWithException(boolean connected) throws DeploymentConnectionException {
        return this._getDeploymentManager(connected);
    }

    public DeploymentManager getDeploymentManager(boolean connected) {
        try {
            return this._getDeploymentManager(connected);
        }
        catch (DeploymentConnectionException dce) {
            if (connected) {
                Print.dprintStackTrace((String)"Can't get connected DeploymentManager", (Throwable)dce);
            }
            return null;
        }
        catch (Throwable t) {
            if (connected) {
                Print.dprintStackTrace((String)"Can't get connected DeploymentManager", (Throwable)t);
            }
            return null;
        }
    }

    public static void setServerConnectionEnvironment(DeploymentManager dm) {
        ServerConnectionEnvironment env = new ServerConnectionEnvironment();
        env.put((Object)"TRUST_MANAGER_KEY", (Object)new X509TrustManager());
        if (dm instanceof SunDeploymentManager) {
            ((SunDeploymentManager)dm).setServerConnectionEnvironment(env);
        } else {
            Print.dprintStackTrace(null, (Throwable)new IllegalArgumentException("Unsupported DeploymentManager type: '" + dm.getClass().getName() + "'."));
        }
    }

    public void clearCachedDeploymentManagers() {
        this.connectedDeploymentManager = null;
        this.disconnectedDeploymentManager = null;
    }

    private DeploymentManager _getDeploymentManager(boolean connected) throws DeploymentConnectionException {
        ManagerURI mu = this._getSelectedURI();
        if (mu != null) {
            return this._getDeploymentManager(connected, mu.getURI(), mu.getUser(), mu.getPassword());
        }
        return null;
    }

    private DeploymentManager _getDeploymentManager(boolean connected, String uri, String usr, String pwd) throws DeploymentConnectionException {
        if (uri == null) {
            return null;
        }
        try {
            DeploymentManager dm = null;
            if (connected) {
                if (this.connectedDeploymentManager != null) {
                    dm = this.connectedDeploymentManager.getDeploymentManager(uri, usr, pwd);
                }
                if (dm == null) {
                    this.connectedDeploymentManager = new DeploymentManagerHolder(uri, usr, pwd);
                    dm = this.connectedDeploymentManager.getDeploymentManager();
                }
            } else {
                if (this.disconnectedDeploymentManager != null) {
                    dm = this.disconnectedDeploymentManager.getDeploymentManager(uri);
                }
                if (dm == null) {
                    this.disconnectedDeploymentManager = new DeploymentManagerHolder(uri);
                    dm = this.disconnectedDeploymentManager.getDeploymentManager();
                }
            }
            return dm;
        }
        catch (DeploymentManagerCreationException dmce) {
            Print.dprintStackTrace((String)"Unable to get DeploymentManager", (Throwable)dmce);
            throw new DeploymentConnectionException(dmce);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Unexpected Exception", (Throwable)t);
            throw new DeploymentConnectionException(t);
        }
    }

    public void setDeploymentFactory(DeploymentFactory df) {
        this.depFactory = df;
    }

    public DeploymentFactory getDeploymentFactory() {
        return this.depFactory;
    }

    public void setName(String name) {
        if (this.depFactory == null) {
            this.platformName = name != null ? name : "";
        } else if (!this.getName().equals(name)) {
            Print.dprintStackTrace((String)("Can't change DeploymentFactory name: " + this.getName()));
        }
    }

    public String getName() {
        String dfn = null;
        if (this.depFactory != null) {
            dfn = this.depFactory.getDisplayName();
            if (dfn == null || dfn.equals("")) {
                dfn = this.depFactory.getClass().getName();
            }
        } else {
            dfn = this.platformName;
        }
        return dfn != null ? dfn : "";
    }

    public void setURIList(List v) {
        this.getManagerURIList().clear();
        if (v != null) {
            Iterator i = v.iterator();
            while (i.hasNext()) {
                Object u = i.next();
                if (u instanceof String) {
                    this.addURI((String)u);
                    continue;
                }
                if (!(u instanceof URI)) continue;
                this.addURI(u.toString());
            }
        }
    }

    public List getURIList() {
        Vector<String> u = new Vector<String>();
        Iterator i = this.getManagerURIList().iterator();
        while (i.hasNext()) {
            u.add(i.next().toString());
        }
        return u;
    }

    public boolean containsURI(String u) {
        return this.getManagerURI(u) != null;
    }

    public ManagerURI addURI(String u) {
        if (u != null && !u.equals("")) {
            ManagerURI mu = this.getManagerURI(u);
            if (mu == null) {
                mu = this.newManagerURI(u);
                this.getManagerURIList().add(mu);
            }
            return mu;
        }
        return null;
    }

    public boolean removeURI(String u) {
        ManagerURI mu = this.getManagerURI(u);
        if (mu != null) {
            this.getManagerURIList().remove(mu);
            return true;
        }
        return false;
    }

    public void setDefaultURI(String u) {
        if (u != null && !u.equals("") && !u.equals(this.getDefaultURI())) {
            ManagerURI mu = this.getManagerURI(u);
            if (mu != null) {
                this.getManagerURIList().remove(mu);
            } else {
                mu = this.newManagerURI(u);
            }
            this.getManagerURIList().add(0, mu);
        }
    }

    public String getDefaultURI() {
        ManagerURI mu = this._getDefaultURI();
        return mu != null ? mu.getURI() : null;
    }

    protected ManagerURI _getDefaultURI() {
        return this.getManagerURIList().size() > 0 ? (ManagerURI)this.getManagerURIList().get(0) : null;
    }

    public boolean isDeployed(String name) {
        try {
            return this.getDeploymentModuleForName(name) != null;
        }
        catch (DeploymentConnectionException dce) {
            return false;
        }
    }

    public boolean isRunning(TargetModuleID module) {
        ModuleType type = this.getModuleType(module);
        return type != null ? this.isRunning(module, type) : false;
    }

    public boolean isRunning(TargetModuleID module, ModuleType type) {
        return this._isRunning(module, type) == 1;
    }

    public int _isRunning(TargetModuleID module, ModuleType type) {
        if (module instanceof SunTarget && ((SunTarget)module).getAppServerInstance() == null) {
            Print.dprintStackTrace((String)"<SunTarget>.getAppServerInstance is null!");
        }
        SunTarget[] targets = new SunTarget[]{(SunTarget)module.getTarget()};
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm != null) {
            try {
                TargetModuleID[] modules = dm.getRunningModules(type, (Target[])targets);
                if (modules != null) {
                    for (int i = 0; i < modules.length; ++i) {
                        if (!modules[i].getModuleID().equals(module.getModuleID())) continue;
                        return 1;
                    }
                }
                return 0;
            }
            catch (IllegalStateException ise) {}
            catch (TargetException te) {}
            finally {
                return -1;
            }
        }
        return -1;
    }

    public ModuleType getModuleType(TargetModuleID module) {
        Target[] targets = this.getTargets();
        DeploymentManager dm = this.getDeploymentManager(true);
        String moduleID = module.getModuleID();
        if (dm != null && moduleID != null) {
            for (int i = 0; i < moduleTypes.length; ++i) {
                try {
                    TargetModuleID[] modules = dm.getAvailableModules(moduleTypes[i], targets);
                    if (modules == null) continue;
                    for (int m = 0; m < modules.length; ++m) {
                        if (!moduleID.equals(modules[m].getModuleID())) continue;
                        return moduleTypes[i];
                    }
                    continue;
                }
                catch (IllegalStateException ise) {
                    Print.dprintStackTrace((String)"Not connected to server", (Throwable)ise);
                    return null;
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Invalid target", (Throwable)t);
                    return null;
                }
            }
        }
        return null;
    }

    public boolean writeAppClientStubs(Target target, String appName, ModuleType mtype, File stubDir) throws Throwable {
        if (target instanceof SunTarget) {
            int appType = 1001;
            if (mtype != null) {
                if (mtype.equals(ModuleType.EAR)) {
                    appType = 1001;
                } else if (mtype.equals(ModuleType.EJB)) {
                    appType = 1003;
                } else if (mtype.equals(ModuleType.WAR)) {
                    appType = 1002;
                } else if (mtype.equals(ModuleType.RAR)) {
                    appType = 1004;
                } else if (mtype.equals(ModuleType.CAR)) {
                    appType = 1005;
                }
            }
            String appSrvInst = ((SunTarget)target).getAppServerInstance();
            Print.dprintln((String)("ClientStubs: " + appName + " type:" + appType + " dir:" + stubDir + " target: " + target.toString()));
            if (appSrvInst != null) {
                ((SunTarget)target).exportClientStubs(appName, appType, stubDir.getAbsolutePath());
                return true;
            }
            Print.dprintStackTrace((String)"((SunTarget)target).getAppServerInstance() is null!");
        } else {
            Print.dprintStackTrace((String)"Target is not a SunTarget");
        }
        return false;
    }

    public boolean distribute(File jarFile, File depPlanFile) throws Exception {
        if (jarFile == null || !jarFile.isFile()) {
            Print.printStackTrace((String)("Module file does not exist: " + jarFile));
            return false;
        }
        File cfgFile = depPlanFile;
        if (cfgFile == null) {
            cfgFile = DeploymentPlatform.createTempDeploymentPlan(jarFile);
        }
        if (cfgFile != null && !cfgFile.isFile()) {
            Print.printStackTrace((String)("DD file does not exist: " + cfgFile));
            return false;
        }
        Class[] argt = new Class[]{DeploymentProcess.class, File.class, File.class};
        UIActionDispatcher cmd = new UIActionDispatcher((Object)this, "_distribute", argt);
        DeploymentProcess dproc = new DeploymentProcess(cmd);
        cmd.setMethodArgs(new Object[]{dproc, jarFile, cfgFile});
        ExecProcess ep = new ExecProcess(dproc);
        ep.setStopButtonVisible(false);
        ExecProcess.showConsole(ep, DISTRIBUTE_MODULE);
        int exitStatus = -1;
        try {
            exitStatus = ep.getExitValue();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exitStatus == 0) {
            DT.getServerManager().fireDeployedModuleNotification(jarFile);
            return true;
        }
        return false;
    }

    public ExitStatus _distribute(DeploymentProcess process, File jarFile, File cfgFile) throws Exception {
        String title = CommandType.DISTRIBUTE.toString();
        this._header(process, title, jarFile);
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm == null) {
            return this._noDeploymentManager(process, jarFile.toString());
        }
        try {
            SunTarget[] sunTargetArray;
            SunTarget[] targets = null;
            Target currTarget = this.getCurrentTarget();
            if (currTarget == null) {
                sunTargetArray = new SunTarget[]{};
            } else {
                SunTarget[] sunTargetArray2 = new SunTarget[1];
                sunTargetArray = sunTargetArray2;
                sunTargetArray2[0] = (SunTarget)currTarget;
            }
            targets = sunTargetArray;
            ProgressObject progress = dm.distribute((Target[])targets, jarFile, cfgFile);
            ExitStatus st_dist = this._progressWait(process, title, progress);
            if (process.getPropertyBoolean(DEPLOY_EXECUTE_CLIENT, false)) {
                TargetModuleID[] mods = st_dist.getResult();
                for (int i = 0; i < mods.length; ++i) {
                    this.execAppClient(process, progress, mods[i]);
                }
            }
            return st_dist;
        }
        catch (IllegalStateException ise) {
            return this._operationFailed(process, jarFile.toString(), ise);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Unexpected exception", (Throwable)t);
            return this._operationFailed(process, jarFile.toString(), t);
        }
    }

    public boolean deploy(String modName, File jarFile, File cfgFile) throws Exception {
        return this.deploy(modName, jarFile, cfgFile, false);
    }

    public boolean deploy(String modName, File jarFile, File cfgFile, String refName) throws Exception {
        return this.deploy(modName, jarFile, cfgFile, refName, false, null);
    }

    public boolean deploy(String modName, File jarFile, File cfgFile, boolean runAppClient) throws Exception {
        return this.deploy(modName, jarFile, cfgFile, null, runAppClient, null);
    }

    public boolean deploy(String modName, File jarFile, File cfgFile, String refName, File appClientStub) throws Exception {
        return this.deploy(modName, jarFile, cfgFile, refName, false, appClientStub);
    }

    public boolean deploy(String modName, File jarFile, File depPlanFile, String refName, boolean runAppClient, File appClientStub) throws Exception {
        if (!jarFile.isFile()) {
            Print.printStackTrace((String)("Module file does not exist: " + jarFile));
            return false;
        }
        File cfgFile = depPlanFile;
        if (cfgFile == null) {
            cfgFile = DeploymentPlatform.createTempDeploymentPlan(jarFile);
        }
        if (cfgFile != null && !cfgFile.isFile()) {
            Print.printStackTrace((String)("DD file does not exist: " + cfgFile));
            return false;
        }
        Class[] argt = new Class[]{DeploymentProcess.class, File.class, File.class};
        UIActionDispatcher cmd = new UIActionDispatcher((Object)this, "_deploy", argt);
        DeploymentProcess dproc = new DeploymentProcess(cmd);
        dproc.setPropertyBoolean(DEPLOY_START_MODULE, true);
        dproc.setPropertyString(DEPLOY_MODULE_NAME, modName);
        dproc.setPropertyString(DEPLOY_REF_NAME, refName);
        dproc.setPropertyBoolean(DEPLOY_EXECUTE_CLIENT, runAppClient);
        if (appClientStub != null) {
            dproc.setPropertyString(DEPLOY_APP_CLIENT_STUB, appClientStub.getAbsolutePath());
        }
        cmd.setMethodArgs(new Object[]{dproc, jarFile, cfgFile});
        ExecProcess ep = new ExecProcess(dproc);
        ep.setStopButtonVisible(false);
        ExecProcess.showConsole(ep, DISTRIBUTE_MODULE);
        int exitStatus = -1;
        try {
            exitStatus = ep.getExitValue();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exitStatus == 0) {
            DT.getServerManager().fireDeployedModuleNotification(jarFile);
            return true;
        }
        return false;
    }

    public ExitStatus _deploy(DeploymentProcess process, File jarFile, File cfgFile) throws Exception {
        ExitStatus st_dist;
        String refName = process.getPropertyString(DEPLOY_REF_NAME, null);
        if (refName != null && !refName.equals("")) {
            DeploymentModule dm = null;
            try {
                dm = this.getDeploymentModuleForName(refName);
            }
            catch (DeploymentConnectionException dce) {
                dm = null;
            }
            if (dm != null) {
                Print.dprintln((String)"Existing DeploymentModule found");
                TargetModuleID[] targets = new TargetModuleID[]{dm.getTargetModuleID()};
                ExitStatus st_undep = this._undeploy(process, targets);
                if (st_undep.getStatus() != SUCCESS) {
                    return st_undep;
                }
            }
        }
        if ((st_dist = this._distribute(process, jarFile, cfgFile)).getStatus() != SUCCESS) {
            return st_dist;
        }
        TargetModuleID[] modules = st_dist.getResult();
        ExitStatus st_deploy = st_dist;
        if (process.getPropertyBoolean(DEPLOY_START_MODULE, true)) {
            if (modules == null) {
                process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.progressobject_not_supported", "> 'ProgressObject' is not supported for this operation."));
                process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.progressobject_not_supported_result", "> As a result, distributed TargetModuleIDs cannot be automatically started."));
            } else if (modules.length > 0) {
                ModuleType type = this.getModuleType(modules[0]);
                Vector<TargetModuleID> startList = new Vector<TargetModuleID>();
                if (null != type && !type.equals(ModuleType.CAR)) {
                    for (int i = 0; i < modules.length; ++i) {
                        if (this.isRunning(modules[i], type)) continue;
                        startList.add(modules[i]);
                    }
                }
                if (startList.size() > 0) {
                    TargetModuleID[] startMods = startList.size() == modules.length ? modules : (TargetModuleID[])ListTools.listToArray(startList, TargetModuleID.class);
                    ExitStatus st_start = this._start(process, startMods);
                    if (st_start.getStatus() != SUCCESS) {
                        return st_start;
                    }
                } else {
                    Print.dprintln((String)localStrings.getLocalString("ui.deploymentplatform.deploy.modules_already_started", "> All TargetModuleIDs have already been started."));
                }
            } else {
                process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.no_returned_module", "> No returned TargetModuleIDs!"));
            }
            String title = CommandType.DISTRIBUTE.toString() + "/" + CommandType.START.toString();
            st_deploy = new ExitStatus(SUCCESS, title, st_dist.getResult());
        }
        this.saveAppClientStub(process, modules);
        return st_deploy;
    }

    public boolean redeploy(TargetModuleID module, File jarFile, File cfgFile) throws Exception {
        return this.redeploy(new TargetModuleID[]{module}, jarFile, cfgFile);
    }

    public boolean redeploy(TargetModuleID[] modules, File jarFile, File cfgFile) throws Exception {
        return this.redeploy(null, modules, jarFile, cfgFile, null);
    }

    public boolean redeploy(String modName, TargetModuleID[] modules, File jarFile, File cfgFile, File appClientStub) throws Exception {
        if (!jarFile.isFile()) {
            Print.printStackTrace((String)("Module file does not exist: " + jarFile));
            return false;
        }
        if (cfgFile != null && !cfgFile.isFile()) {
            Print.printStackTrace((String)("DD file does not exist: " + cfgFile));
            return false;
        }
        Class[] argt = new Class[]{DeploymentProcess.class, TargetModuleID;.class, File.class, File.class};
        UIActionDispatcher cmd = new UIActionDispatcher((Object)this, "_redeploy", argt);
        DeploymentProcess dproc = new DeploymentProcess(cmd);
        if (modName != null) {
            dproc.setPropertyString(DEPLOY_MODULE_NAME, modName);
        }
        if (appClientStub != null) {
            dproc.setPropertyString(DEPLOY_APP_CLIENT_STUB, appClientStub.getAbsolutePath());
        }
        cmd.setMethodArgs(new Object[]{dproc, modules, jarFile, cfgFile});
        ExecProcess ep = new ExecProcess(dproc);
        ep.setStopButtonVisible(false);
        ExecProcess.showConsole(ep, "Redeploy Module");
        try {
            return ep.getExitValue() == 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public ExitStatus _redeploy(DeploymentProcess process, TargetModuleID[] modules, File jarFile, File cfgFile) throws Exception {
        String title = CommandType.REDEPLOY.toString();
        this._header(process, title, jarFile);
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm == null) {
            return this._noDeploymentManager(process, jarFile.toString());
        }
        try {
            ProgressObject progress = dm.redeploy(modules, jarFile, cfgFile);
            ExitStatus st_redeploy = this._progressWait(process, title, progress);
            this.saveAppClientStub(process, modules);
            return st_redeploy;
        }
        catch (IllegalStateException ise) {
            return this._operationFailed(process, jarFile.toString(), ise);
        }
        catch (UnsupportedOperationException uoe) {
            Print.dprintStackTrace((String)"'redeploy' not supported", (Throwable)uoe);
            return this._operationFailed(process, jarFile.toString(), uoe);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Unexpected exception", (Throwable)t);
            return this._operationFailed(process, jarFile.toString(), t);
        }
    }

    private void saveAppClientStub(DeploymentProcess process, TargetModuleID[] modules) {
        String modName = process.getPropertyString(DEPLOY_MODULE_NAME, null);
        String carStubStr = process.getPropertyString(DEPLOY_APP_CLIENT_STUB, null);
        if (carStubStr != null && modules != null && modules.length > 0) {
            File stubDir = new File(carStubStr);
            try {
                Target target = modules[0].getTarget();
                ModuleType mtype = this.getModuleType(modules[0]);
                process.println("");
                if (this.writeAppClientStubs(target, modName, mtype, stubDir)) {
                    process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.created_client_stub_jar", "> Created client stub jarfile at location: {0}", new Object[]{stubDir}));
                } else {
                    process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.cant_create_client_stub_jar", "> Unable to create client stub jarfile"));
                }
            }
            catch (AFException afe) {
                process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.cant_create_client_stub_jar_error", "> Unable to create client stub jarfile: {0}", new Object[]{afe.getMessage()}));
            }
            catch (Throwable t) {
                process.println(localStrings.getLocalString("ui.deploymentplatform.deploy.cant_create_client_stub_jar_error", "> Unable to create client stub jarfile: {0}", new Object[]{t.toString()}));
                process.println(t);
            }
        }
    }

    public boolean undeploy(TargetModuleID module) {
        return this.undeploy(new TargetModuleID[]{module});
    }

    public boolean undeploy(TargetModuleID[] modules) {
        Class[] argt = new Class[]{DeploymentProcess.class, TargetModuleID;.class};
        UIActionDispatcher cmd = new UIActionDispatcher((Object)this, "_undeploy", argt);
        DeploymentProcess dproc = new DeploymentProcess(cmd);
        cmd.setMethodArgs(new Object[]{dproc, modules});
        ExecProcess ep = new ExecProcess(dproc);
        ep.setStopButtonVisible(false);
        ExecProcess.showConsole(ep, localStrings.getLocalString("ui.deploymentplatform.undeploy_module", "Undeploy Module"));
        int exitStatus = -1;
        try {
            exitStatus = ep.getExitValue();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exitStatus == 0) {
            DT.getServerManager().fireUndeployedModuleNotification(modules);
            return true;
        }
        return false;
    }

    public ExitStatus _undeploy(DeploymentProcess process, TargetModuleID[] modules) {
        ExitStatus stopStatus = this._stop(process, modules);
        if (stopStatus.getStatus() != SUCCESS) {
            return stopStatus;
        }
        String title = CommandType.UNDEPLOY.toString();
        this._header(process, title, this._moduleNames(modules));
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm == null) {
            return this._noDeploymentManager(process, "");
        }
        try {
            ProgressObject progress = dm.undeploy(modules);
            return this._progressWait(process, title, progress);
        }
        catch (IllegalStateException ise) {
            return this._operationFailed(process, "", ise);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Unexpected exception", (Throwable)t);
            return this._operationFailed(process, "", t);
        }
    }

    public boolean stop(TargetModuleID module) {
        return this.stop(new TargetModuleID[]{module});
    }

    public boolean stop(TargetModuleID[] modules) {
        Class[] argt = new Class[]{DeploymentProcess.class, TargetModuleID;.class};
        UIActionDispatcher cmd = new UIActionDispatcher((Object)this, "_stop", argt);
        DeploymentProcess dproc = new DeploymentProcess(cmd);
        cmd.setMethodArgs(new Object[]{dproc, modules});
        ExecProcess ep = new ExecProcess(dproc);
        ep.setStopButtonVisible(false);
        ExecProcess.showConsole(ep, "Stopping Module");
        try {
            return ep.getExitValue() == 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public ExitStatus _stop(DeploymentProcess process, TargetModuleID[] modules) {
        String title = CommandType.STOP.toString();
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm == null) {
            return this._noDeploymentManager(process, "");
        }
        Vector<TargetModuleID> stopList = new Vector<TargetModuleID>();
        for (int i = 0; i < modules.length; ++i) {
            ModuleType type = this.getModuleType(modules[i]);
            if (null == type || type.equals(ModuleType.CAR)) continue;
            stopList.add(modules[i]);
        }
        if (stopList.size() > 0) {
            TargetModuleID[] stopMods = stopList.size() == modules.length ? modules : (TargetModuleID[])ListTools.listToArray(stopList, TargetModuleID.class);
            try {
                this._header(process, title, this._moduleNames(stopMods));
                ProgressObject progress = dm.stop(stopMods);
                return this._progressWait(process, title, progress);
            }
            catch (IllegalStateException ise) {
                return this._operationFailed(process, "", ise);
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"Unexpected exception", (Throwable)t);
                return this._operationFailed(process, "", t);
            }
        }
        return new ExitStatus(SUCCESS, "No Stop needed");
    }

    public boolean start(TargetModuleID module) {
        return this.start(new TargetModuleID[]{module});
    }

    public boolean start(TargetModuleID[] modules) {
        Class[] argt = new Class[]{DeploymentProcess.class, TargetModuleID;.class};
        UIActionDispatcher cmd = new UIActionDispatcher((Object)this, "_start", argt);
        DeploymentProcess dproc = new DeploymentProcess(cmd);
        cmd.setMethodArgs(new Object[]{dproc, modules});
        ExecProcess ep = new ExecProcess(dproc);
        ep.setStopButtonVisible(false);
        ExecProcess.showConsole(ep, "Starting Module");
        try {
            return ep.getExitValue() == 0;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public ExitStatus _start(DeploymentProcess process, TargetModuleID[] modules) {
        String title = CommandType.START.toString();
        this._header(process, title, this._moduleNames(modules));
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm == null) {
            return this._noDeploymentManager(process, "");
        }
        try {
            ProgressObject progress = dm.start(modules);
            ExitStatus st_start = this._progressWait(process, title, progress);
            return st_start;
        }
        catch (IllegalStateException ise) {
            return this._operationFailed(process, "", ise);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)"Unexpected exception", (Throwable)t);
            return this._operationFailed(process, "", t);
        }
    }

    private boolean execAppClient(DeploymentProcess process, ProgressObject progress, TargetModuleID mod) {
        boolean hasClient = false;
        TargetModuleID[] subMods = mod.getChildTargetModuleID();
        if (subMods != null) {
            for (int i = 0; i < subMods.length; ++i) {
                if (subMods[i].getModuleID().indexOf("client") < 0) continue;
                hasClient = true;
                process.println("");
                process.println(localStrings.getLocalString("ui.deploymentplatform.exec_app_client.executing_app_client", "Executing AppClient {0}", new Object[]{subMods[i].getModuleID()}));
                ClientConfiguration cc = progress.getClientConfiguration(subMods[i]);
                if (cc != null) {
                    try {
                        cc.execute();
                        process.println(localStrings.getLocalString("ui.deploymentplatform.exec_app_client.successful", "  --> successful"));
                    }
                    catch (Throwable t) {
                        process.println(localStrings.getLocalString("ui.deploymentplatform.exec_app_client.failed_error", "  --> failed: {0}", new Object[]{t}));
                        Print.printStackTrace((String)("AppClient " + subMods[i]), (Throwable)t);
                    }
                    continue;
                }
                process.println(localStrings.getLocalString("ui.deploymentplatform.exec_app_client.client_config_not_available", "  --> ClientConfiguration not available"));
            }
        }
        return hasClient;
    }

    private void _header(DeploymentProcess process, String title, Object m) {
        process.println("\n");
        process.printSeparator("-");
        process.println(title + ": " + m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExitStatus _progressWait(DeploymentProcess process, String title, ProgressObject progress) {
        if (progress == null) {
            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.progressobject_not_supported", "['ProgressObject' is not supported for this operation.]"));
            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.assume_successful_completion", "[We will assume that this operation has completed successfully.]"));
            return new ExitStatus(SUCCESS, title);
        }
        String forcedState = null;
        progress.addProgressListener((ProgressListener)process);
        try {
            DeploymentStatus ds;
            long waitForRunningTimeout = 2000L;
            int isWaiting = 0;
            while (!(ds = progress.getDeploymentStatus()).isCompleted() && !ds.isFailed()) {
                if (!ds.isRunning()) {
                    if (isWaiting == 2) {
                        process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.progressobject_not_running", "['ProgressObject' is no longer running ...]"));
                        forcedState = "NotRunning";
                        break;
                    }
                    if (waitForRunningTimeout <= 0L) {
                        process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.progressobject_didnt_start", "[TIMEOUT: 'ProgressObject' never started running.]"));
                        forcedState = "NotRunning";
                        break;
                    }
                    waitForRunningTimeout -= process.sleep(200L);
                    isWaiting = 1;
                    continue;
                }
                if (isWaiting == 1) {
                    isWaiting = 2;
                }
                if (process.destroyRequested()) {
                    process.println("");
                    try {
                        if (progress.isCancelSupported()) {
                            progress.cancel();
                            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.cancel", "*** CANCEL ***"));
                            forcedState = "Cancelled";
                        } else if (progress.isStopSupported()) {
                            progress.stop();
                            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.stop", "*** STOP ***"));
                            forcedState = "Stopped";
                        } else {
                            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.cancel_not_supported", "[Cancel/Stop is not supported by this platform]"));
                        }
                    }
                    catch (OperationUnsupportedException uco) {
                        process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.error_cancel_not_supported", "!!! ERROR: 'cancel/stop' not supported by this platform !!!"));
                        try {
                            progress.stop();
                        }
                        catch (OperationUnsupportedException uso) {
                            // empty catch block
                        }
                    }
                }
                process.sleep(1000L);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            for (long delay = 1000L; delay > 0L; delay -= process.sleep(delay)) {
            }
            progress.removeProgressListener((ProgressListener)process);
            throw throwable;
        }
        for (long delay = 1000L; delay > 0L; delay -= process.sleep(delay)) {
        }
        {
        }
        progress.removeProgressListener((ProgressListener)process);
        com.sun.enterprise.deployment.backend.DeploymentStatus jesStatus = null;
        String jesStatusMsg = null;
        if (progress instanceof JESProgressObject) {
            jesStatus = this.getJESDeploymentStatus((JESProgressObject)progress);
            jesStatusMsg = this.getJESStatusMessage(jesStatus);
        }
        process.println("");
        if (forcedState != null) {
            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.operation_incomplete", "!!! Operation Incomplete [{0}] !!!", new Object[]{forcedState}));
            return new ExitStatus(12, title);
        }
        if (!progress.getDeploymentStatus().isFailed()) {
            process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.operation_successful", "--- Operation Completed Successfully ---"));
            if (jesStatus != null && jesStatusMsg != null && jesStatusMsg.length() > 0) {
                if (jesStatus.getStatus() == 1) {
                    process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.operation_successful_warnings", "--- With The Following Warning Messages ---"));
                }
                process.println(jesStatusMsg);
            }
            return new ExitStatus(SUCCESS, title, progress.getResultTargetModuleIDs());
        }
        process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.operation_failed", "!!! Operation Failed !!!"));
        if (jesStatus != null && jesStatusMsg != null && jesStatusMsg.length() > 0) {
            if (jesStatus.getStatus() == 0) {
                process.println(localStrings.getLocalString("ui.deploymentplatform.progress_wait.operation_failed_msgs", "!!! With The Following Failure Messages !!!"));
            }
            jesStatusMsg = this.convertMultiTargetErr(jesStatusMsg);
            process.println(jesStatusMsg);
        }
        return new ExitStatus(13, title);
    }

    private com.sun.enterprise.deployment.backend.DeploymentStatus getJESDeploymentStatus(JESProgressObject progress) {
        return progress.getCompletedStatus();
    }

    private String getJESStatusMessage(com.sun.enterprise.deployment.backend.DeploymentStatus status) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        com.sun.enterprise.deployment.backend.DeploymentStatus.parseDeploymentStatus((com.sun.enterprise.deployment.backend.DeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        return new String(statusBytes);
    }

    private String convertMultiTargetErr(String jesStatusMsg) {
        String err = localStrings.getLocalString(Deployer.class, "enterprise.deployment.backend.deploy_error_application_exists", "Cannot deploy.  Application already exists.  Please select the Redeploy option.");
        String newErr = localStrings.getLocalString("ui.deploymentplatform.convert_multi_target_err", "Cannot deploy.  Application is already deployed to a target -- Deploytool can only deploy to a single target.  Use the admin console or asadmin CLI to deploy to multiple targets.");
        int index = jesStatusMsg.indexOf(err);
        if (index != -1) {
            jesStatusMsg = jesStatusMsg.replaceAll(err, newErr);
        }
        return jesStatusMsg;
    }

    private ExitStatus _operationFailed(DeploymentProcess process, String mid, Throwable t) {
        Print.printStackTrace((String)("Operation failed: " + mid), (Throwable)t);
        process.println("");
        process.println(localStrings.getLocalString("ui.deploymentplatform.operation_failed.operation_failed", "*** Operation failed:"));
        process.println(t);
        return new ExitStatus(20, mid);
    }

    private ExitStatus _noDeploymentManager(DeploymentProcess process, String mid) {
        Print.printStackTrace((String)("Operation failed: " + mid));
        process.println("");
        process.println(localStrings.getLocalString("ui.deploymentplatform.no_deployment_manager.operation_failed", "*** Operation failed:"));
        process.println(localStrings.getLocalString("ui.deploymentplatform.no_deployment_manager.unable_to_connect", "*** Unable to obtain a connected DeploymentManager"));
        return new ExitStatus(30, mid);
    }

    private String _moduleNames(TargetModuleID[] tmi) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tmi.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(tmi[i].getModuleID());
        }
        return sb.toString();
    }

    public List getDeploymentModules() throws DeploymentConnectionException {
        return this.getDeploymentModules(moduleTypes);
    }

    public List getDeploymentModules(ModuleType mtype) throws DeploymentConnectionException {
        return this.getDeploymentModules(new ModuleType[]{mtype});
    }

    public List getDeploymentModules(ModuleType[] mtypes) throws DeploymentConnectionException {
        Vector<DeploymentModule> moduleList = new Vector<DeploymentModule>();
        DeploymentManager dm = this.getDeploymentManager(true);
        if (dm != null) {
            SunTarget[] targets = null;
            SunTarget sunTarget = (SunTarget)this.getSelectedTarget();
            if (sunTarget != null) {
                targets = new SunTarget[]{sunTarget};
            } else {
                sunTarget = (SunTarget)this.getTarget(this.getDeploymentManager(true), "server");
                if (sunTarget != null) {
                    targets = new SunTarget[]{sunTarget};
                }
            }
            if (sunTarget == null) {
                targets = (SunTarget[])this.getTargets();
                if (targets == null || targets.length == 0) {
                    Print.dprint((String)"No targets found!");
                    return moduleList;
                }
                sunTarget = targets[0];
            }
            if (sunTarget.getAppServerInstance() == null) {
                Print.dprintStackTrace((String)"main <SunTarget>.getAppServerInstance is null");
                sunTarget = null;
            }
            for (int i = 0; i < mtypes.length; ++i) {
                if (mtypes[i] == null) continue;
                try {
                    TargetModuleID[] mids = dm.getAvailableModules(mtypes[i], (Target[])targets);
                    if (mids == null) continue;
                    for (int m = 0; m < mids.length; ++m) {
                        if (sunTarget != null && mids[m] instanceof SunTarget && ((SunTarget)mids[m]).getAppServerInstance() == null && sunTarget != null) {
                            Print.dprintln((String)"Resetting null <SunTarget>.getAppServerInstance");
                            ((SunTarget)mids[m]).setAppServerInstance(sunTarget.getAppServerInstance());
                        }
                        DeploymentModule depMod = new DeploymentModule(mids[m], mtypes[i], this);
                        moduleList.add(depMod);
                    }
                    continue;
                }
                catch (IllegalStateException ise) {
                    throw new DeploymentConnectionException(ise);
                }
                catch (TargetException te) {
                    throw new DeploymentConnectionException(te);
                }
                catch (Throwable t) {
                    Print.printStackTrace((String)("Unexpected exception: " + mtypes[i]), (Throwable)t);
                    throw new DeploymentConnectionException(t);
                }
            }
        } else {
            Print.dprintln((String)"No connected DeploymentManager");
        }
        return moduleList;
    }

    public DeploymentModule getDeploymentModuleForName(String name) throws DeploymentConnectionException {
        List moduleList = this.getDeploymentModules();
        Iterator i = moduleList.iterator();
        while (i.hasNext()) {
            DeploymentModule m = (DeploymentModule)i.next();
            if (!m.toString().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static boolean isPE(DeploymentManager mgr) {
        if (mgr instanceof SunDeploymentManager) {
            return ((SunDeploymentManager)mgr).isPE();
        }
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof DeploymentPlatform && this.toString().equals(obj.toString());
    }

    public String toString() {
        return this.getName();
    }

    public Object clone() {
        return new DeploymentPlatform(this);
    }

    public ManagerURI newManagerURI(ManagerURI uri) {
        return new ManagerURI(uri);
    }

    public ManagerURI newManagerURI(String uri) {
        return this.newManagerURI(uri, null, null, null);
    }

    public ManagerURI newManagerURI(String uri, String user, String pass, Target target) {
        return new ManagerURI(uri, user, pass, target);
    }

    public ManagerURI getManagerURI(String u) {
        if (u != null) {
            Iterator i = this.getManagerURIList().iterator();
            while (i.hasNext()) {
                ManagerURI mu = (ManagerURI)i.next();
                if (!mu.getURI().equals(u)) continue;
                return mu;
            }
        }
        return null;
    }

    public List getManagerURIList() {
        if (this.uriList == null) {
            this.uriList = new Vector();
        }
        return this.uriList;
    }

    protected static String getHostInfo(String uri) {
        int p = uri.indexOf("::");
        String hp = p >= 0 ? uri.substring(p + 2) : "";
        p = hp.indexOf(SECURE_URI_SUFFIX);
        if (p != -1) {
            hp = hp.substring(0, p);
        }
        return !hp.equals("") ? hp : DEFAULT_HOST;
    }

    protected static String getHost(String hostPort) {
        int s = hostPort.indexOf(":");
        String h = s >= 0 ? hostPort.substring(0, s) : hostPort;
        return !h.equals("") ? h : DEFAULT_HOST;
    }

    protected static int getPort(String hostPort) {
        int s = hostPort.indexOf(":");
        if (s >= 0 && s < hostPort.length() - 1) {
            String p = hostPort.substring(s + 1);
            try {
                return Integer.parseInt(p);
            }
            catch (Throwable t) {
                Print.dprintln((String)("Unable to parse port: " + p));
            }
        }
        return 4848;
    }

    private static File createTempDeploymentPlan(File jarFile) {
        if (CREATE_TEMP_DEPLOYMENT_PLAN) {
            String j2eeName = null;
            String cfgName = jarFile.getName() + "_runtime";
            try {
                FileOutputStream cfgOut;
                File j2eeFile = j2eeName != null ? File.createTempFile(j2eeName, ".jar") : null;
                File cfgFile = cfgName != null ? File.createTempFile(cfgName, ".jar") : null;
                FileOutputStream j2eeOut = j2eeFile != null ? new FileOutputStream(j2eeFile) : null;
                FileOutputStream fileOutputStream = cfgOut = cfgFile != null ? new FileOutputStream(cfgFile) : null;
                if (j2eeOut != null) {
                    Print.dprintln((String)("Creating standard file: " + j2eeFile));
                }
                if (cfgOut != null) {
                    Print.dprintln((String)("Creating runtime file: " + cfgFile));
                }
                try {
                    DeploymentPlatform.extractDeploymentPlan(jarFile, j2eeOut, cfgOut);
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Unable to extract DeploymentPlan", (Throwable)t);
                }
                try {
                    ((OutputStream)cfgOut).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return cfgFile;
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"Unable to extract DeploymentPlan", (Throwable)t);
            }
        }
        return null;
    }

    private static void extractDeploymentPlan(File archive, OutputStream j2eeOut, OutputStream dpOut) throws IOException, SAXParseException {
        JarOutputStream dpJarOut;
        Archivist archivist = ArchivistFactory.getArchivistForArchive((File)archive);
        InputJarArchive archJarIn = new InputJarArchive();
        archJarIn.open(archive.getAbsolutePath());
        JarOutputStream j2eeJarOut = j2eeOut != null ? new JarOutputStream(j2eeOut) : null;
        JarOutputStream jarOutputStream = dpJarOut = dpOut != null ? new JarOutputStream(dpOut) : null;
        if (archivist.getModuleType().equals(ModuleType.EAR)) {
            DeploymentDescriptorFile ddFile = archivist.getStandardDDFile();
            InputStream is = new BufferedInputStream(archJarIn.getEntry(ddFile.getDeploymentDescriptorPath()));
            Application app = (Application)ddFile.read(is);
            ((InputStream)is).close();
            Iterator itr = app.getModules();
            while (itr.hasNext()) {
                Enumeration e;
                String mappingPath;
                String runtimeDDPath;
                ModuleDescriptor module = (ModuleDescriptor)itr.next();
                Archivist subArchivist = ArchivistFactory.getArchivistForType((ModuleType)module.getModuleType());
                AbstractArchive subJar = archJarIn.getEmbeddedArchive(module.getArchiveUri());
                InputStream subIs = subJar.getEntry(runtimeDDPath = subArchivist.getConfigurationDDFile().getDeploymentDescriptorPath());
                if (subIs != null) {
                    String entryName = module.getArchiveUri() + "." + runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
                    DeploymentPlatform.copyEntry(subIs, entryName, dpJarOut);
                }
                if ((subIs = subJar.getEntry(mappingPath = "META-INF/sun-cmp-mappings.xml")) != null) {
                    String entryName = module.getArchiveUri() + "." + "sun-cmp-mappings.xml";
                    DeploymentPlatform.copyEntry(subIs, entryName, dpJarOut);
                }
                if ((e = subJar.entries()) != null) {
                    while (e.hasMoreElements()) {
                        String subEntryName = (String)e.nextElement();
                        if (!subEntryName.endsWith(".dbschema")) continue;
                        subIs = subJar.getEntry(subEntryName);
                        String entryName = module.getArchiveUri() + "." + subEntryName.replaceAll("/", "#");
                        DeploymentPlatform.copyEntry(subIs, entryName, dpJarOut);
                    }
                }
                subJar.close();
            }
            String runtimeDDPath = archivist.getConfigurationDDFile().getDeploymentDescriptorPath();
            is = archJarIn.getEntry(runtimeDDPath);
            if (is != null) {
                String entryName = runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
                DeploymentPlatform.copyEntry(new BufferedInputStream(is), entryName, dpJarOut);
            }
        } else {
            String runtimeDDPath = archivist.getConfigurationDDFile().getDeploymentDescriptorPath();
            BufferedInputStream is = new BufferedInputStream(archJarIn.getEntry(runtimeDDPath));
            DeploymentPlatform.copyEntry(is, runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1), dpJarOut);
            String cmpMappings = "META-INF/sun-cmp-mappings.xml";
            InputStream cmpMapIn = archJarIn.getEntry(cmpMappings);
            if (cmpMapIn != null) {
                BufferedInputStream cmpMapIs = new BufferedInputStream(cmpMapIn);
                String entryName = cmpMappings.substring(cmpMappings.lastIndexOf(47) + 1);
                DeploymentPlatform.copyEntry(cmpMapIs, entryName, dpJarOut);
            }
            Enumeration entries = archJarIn.entries();
            while (entries.hasMoreElements()) {
                String dbschemaName = (String)entries.nextElement();
                if (!dbschemaName.endsWith(".dbschema")) continue;
                InputStream subIs = archJarIn.getEntry(dbschemaName);
                String entryName = dbschemaName.replace('/', '#');
                DeploymentPlatform.copyEntry(subIs, entryName, dpJarOut);
            }
        }
        if (j2eeJarOut != null) {
            j2eeJarOut.close();
        }
        if (dpJarOut != null) {
            dpJarOut.close();
        }
        archJarIn.close();
    }

    private static void copyEntry(InputStream is, String entryName, JarOutputStream out) throws IOException {
        if (out != null) {
            ZipEntry ze = new ZipEntry(entryName);
            out.putNextEntry(ze);
            Archivist.copyWithoutClose((InputStream)is, (OutputStream)out);
            is.close();
            out.flush();
            out.closeEntry();
        }
    }

    private static void copyManifest(AbstractArchive in, JarOutputStream jarOut) throws IOException {
        Manifest manifest = in.getManifest();
        if (manifest != null) {
            jarOut.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(jarOut);
            jarOut.closeEntry();
        }
    }

    public class ManagerURI
    implements PublicCloneable {
        private String uri = "";
        private String user = "";
        private String pass = "";
        private Target target = null;

        private ManagerURI(ManagerURI mu) {
            this.uri = mu.uri;
            this.user = mu.user;
            this.pass = mu.pass;
            this.target = mu.target;
        }

        public ManagerURI(String uri) {
            this.uri = uri;
        }

        public ManagerURI(String uri, String user, String pass) {
            this(uri);
            this.user = user;
            this.pass = pass;
        }

        public ManagerURI(String uri, String user, String pass, Target target) {
            this(uri);
            this.user = user;
            this.pass = pass;
            this.target = target;
        }

        public DeploymentPlatform getDeploymentPlatform() {
            return DeploymentPlatform.this;
        }

        public String getURI() {
            return this.uri != null ? this.uri : "";
        }

        public void setURI(String name) {
            this.uri = name;
        }

        public void setUser(String user, String pass) {
            this.user = user != null ? user : "";
            this.pass = pass != null ? pass : "";
        }

        public String getUser() {
            return this.user != null ? this.user : "";
        }

        public String getPassword() {
            return this.pass != null ? this.pass : "";
        }

        public boolean hasUserPassword() {
            return !this.getUser().equals("") && !this.getPassword().equals("");
        }

        public void setTarget(Target target) {
            this.target = target;
        }

        public Target getTarget() {
            return this.target;
        }

        public String getTargetName() {
            Target tgt = this.getTarget();
            return tgt == null ? "" : tgt.getName();
        }

        public String getHostInfo() {
            return DeploymentPlatform.getHostInfo(this.getURI());
        }

        public String getHost() {
            return DeploymentPlatform.getHost(this.getHostInfo());
        }

        public int getPort() {
            return DeploymentPlatform.getPort(this.getHostInfo());
        }

        public String toString() {
            return this.getURI();
        }

        public Object clone() {
            return new ManagerURI(this);
        }

        public void setCurrent() {
            this.getDeploymentPlatform().setSelectedURI(this);
        }

        public void setAsDefaultTarget() {
            DeploymentPlatform.setTargetManagerURI(this);
        }

        public boolean equals(Object other) {
            if (other instanceof ManagerURI) {
                ManagerURI mu = (ManagerURI)other;
                return this.getURI().equals(mu.getURI()) && this.getUser().equals(mu.getUser()) && this.getPassword().equals(mu.getPassword()) && this.getTargetName().equals(mu.getTargetName());
            }
            return false;
        }
    }

    private static class DeploymentProcess
    extends ExecProcess.ThreadMain
    implements ProgressListener {
        private HashMap properties = new HashMap();
        private UIActionDispatcher command = null;
        private LinkedList progressEventList = null;
        private ExitStatus exitStatus = null;

        private DeploymentProcess(UIActionDispatcher cmd) {
            this.command = cmd;
            this.progressEventList = new LinkedList();
        }

        public int run() {
            this.exitStatus = (ExitStatus)this.command.invoke();
            return this.exitStatus != null ? this.exitStatus.getStatus() : -9999;
        }

        public ExitStatus getExitStatus() {
            return this.exitStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent pe) {
            LinkedList linkedList = this.progressEventList;
            synchronized (linkedList) {
                this.progressEventList.addLast(pe);
                this.progressEventList.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long sleep(long timeout) {
            long startTime = System.currentTimeMillis();
            this.printProgressEvents();
            LinkedList linkedList = this.progressEventList;
            synchronized (linkedList) {
                try {
                    this.progressEventList.wait(timeout);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            this.printProgressEvents();
            return System.currentTimeMillis() - startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void printProgressEvents() {
            while (true) {
                ProgressEvent pe = null;
                LinkedList linkedList = this.progressEventList;
                synchronized (linkedList) {
                    if (this.progressEventList.size() > 0) {
                        pe = (ProgressEvent)this.progressEventList.getFirst();
                        this.progressEventList.removeFirst();
                    }
                }
                if (pe == null) break;
                super.println(pe.getDeploymentStatus().getMessage());
            }
        }

        public void setProperty(String key, String value) {
            this.setProperty(key, value);
        }

        public void setPropertyString(String key, String value) {
            this.properties.put(key, value);
        }

        public void setPropertyBoolean(String key, boolean value) {
            this.properties.put(key, value ? "true" : "false");
        }

        public String getProperty(String key, String dft) {
            return this.properties.containsKey(key) ? (String)this.properties.get(key) : dft;
        }

        public String getPropertyString(String key, String dft) {
            return this.getProperty(key, dft);
        }

        public boolean getPropertyBoolean(String key, boolean dft) {
            return this.getProperty(key, dft ? "true" : "false").equals("true");
        }
    }

    private static class ExitStatus {
        private int status = SUCCESS;
        private String msg = null;
        private TargetModuleID[] modules = null;

        public ExitStatus(int status, String msg) {
            this.status = status;
            this.msg = msg;
        }

        public ExitStatus(int status, String msg, TargetModuleID[] modules) {
            this(status, msg);
            this.modules = modules;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.msg;
        }

        public TargetModuleID[] getResult() {
            return this.modules;
        }

        public String toString() {
            String m = this.msg != null ? " [" + this.msg + "]" : "";
            return "Status: " + this.status + m;
        }
    }

    protected class DeploymentManagerHolder {
        private String uriKey = null;
        private DeploymentManager depMgr = null;
        private boolean isConnected = false;

        public DeploymentManagerHolder(String uri) throws Throwable {
            DeploymentFactoryManager dfm = DeploymentPlatform.this.getDeploymentFactoryManager();
            this.depMgr = dfm.getDisconnectedDeploymentManager(DeploymentPlatform.detectPortSecurity(uri));
            this.uriKey = uri;
            this.isConnected = false;
            if (UIConfig.debugMode()) {
                this.debugPrintInfo();
            }
        }

        public DeploymentManagerHolder(String uri, String usr, String pwd) throws Throwable {
            DeploymentFactoryManager dfm = DeploymentPlatform.this.getDeploymentFactoryManager();
            String u = usr != null ? usr : "";
            String p = pwd != null ? pwd : "";
            this.depMgr = dfm.getDeploymentManager(DeploymentPlatform.detectPortSecurity(uri), u, p);
            this.uriKey = this.uriKey(uri, u, p);
            this.isConnected = true;
            if (UIConfig.debugMode()) {
                this.debugPrintInfo();
            }
        }

        public String uriKey(String uri, String usr, String pwd) {
            String u = usr != null ? usr : "";
            String p = pwd != null ? pwd : "";
            return uri + ":" + u + ":" + p;
        }

        public DeploymentManager getDeploymentManager() {
            DeploymentPlatform.setServerConnectionEnvironment(this.depMgr);
            return this.depMgr;
        }

        public DeploymentManager getDeploymentManager(String uri) {
            return !this.isConnected && this.uriKey.equals(uri) ? this.getDeploymentManager() : null;
        }

        public DeploymentManager getDeploymentManager(String uri, String usr, String pwd) {
            return this.isConnected && this.uriKey.equals(this.uriKey(uri, usr, pwd)) ? this.getDeploymentManager() : null;
        }

        protected void debugPrintInfo() {
            if (UIConfig.debugMode()) {
                Target[] ta = new Target[]{};
                try {
                    ta = this.getDeploymentManager().getTargets();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    StringBuffer tb = new StringBuffer();
                    for (int i = 0; i < ta.length; ++i) {
                        tb.append(ta[i]).append(", ");
                    }
                    String uri = this.uriKey;
                    uri = uri.substring(0, uri.lastIndexOf(58));
                    uri = uri.substring(0, uri.lastIndexOf(58));
                    uri = DeploymentPlatform.detectPortSecurity(uri);
                    Print.dprintln((String)("New DeploymentManagerHolder:\n    URI        : " + uri + "\n" + "    Target     : " + tb.toString() + "\n" + "    Connected  : " + this.isConnected + ""));
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Error while printing Debug info", (Throwable)t);
                }
            }
        }
    }
}

