/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;

public class DeploymentModule {
    protected Target target = null;
    protected TargetModuleID moduleID = null;
    protected ModuleType moduleType = null;
    protected boolean isRunning = false;
    protected DeploymentPlatform platform = null;

    private DeploymentModule(TargetModuleID moduleID, ModuleType moduleType) {
        this.moduleID = moduleID;
        this.moduleType = moduleType;
        if (this.getTargetModuleID().getParentTargetModuleID() != null) {
            Print.printStackTrace((String)"This module id does not represent the deployed object");
        }
    }

    private DeploymentModule(TargetModuleID moduleID, ModuleType moduleType, boolean isRunning) {
        this(moduleID, moduleType);
        this.isRunning = isRunning;
    }

    public DeploymentModule(TargetModuleID moduleID, ModuleType moduleType, DeploymentPlatform dp) {
        this(moduleID, moduleType);
        this.platform = dp;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getDisplayName() {
        return this.getTargetModuleID().getModuleID();
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public TargetModuleID getTargetModuleID() {
        return this.moduleID;
    }

    public Target getTarget() {
        return this.target != null ? this.target : this.getTargetModuleID().getTarget();
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public Class getModuleClassType() {
        return DeploymentPlatform.getClassForModuleType(this.moduleType);
    }

    public boolean isRunning() {
        return this.platform != null ? this.platform.isRunning(this.getTargetModuleID(), this.getModuleType()) : this.isRunning;
    }

    public int _isRunning() {
        if (this.platform != null) {
            return this.platform._isRunning(this.getTargetModuleID(), this.getModuleType());
        }
        return this.isRunning ? 1 : 0;
    }

    public DeploymentPlatform getDeploymentPlatform() {
        return this.platform;
    }

    public String getPlatformName() {
        return this.platform != null ? this.platform.getName() : "";
    }

    public boolean undeploy() {
        return this.getDeploymentPlatform().undeploy(this.getTargetModuleID());
    }

    public boolean writeAppClientStubs(File stubDir) throws Throwable {
        return this.getDeploymentPlatform().writeAppClientStubs(this.getTarget(), this.getName(), this.getModuleType(), stubDir);
    }

    public RootDeploymentDescriptor findRootDeploymentDescriptor() {
        String name;
        List mods = DT.getModuleManager().getModules(this.getModuleType());
        Descriptor d = this._getMatchingNamedDescriptor(mods, name = this.getDisplayName());
        if (d != null) {
            return (RootDeploymentDescriptor)d;
        }
        int p = name.lastIndexOf("-");
        if (p > 0 && (d = this._getMatchingNamedDescriptor(mods, name = name.substring(0, p))) != null) {
            return (RootDeploymentDescriptor)d;
        }
        return null;
    }

    private Descriptor _getMatchingNamedDescriptor(List list, String name) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Descriptor d = (Descriptor)i.next();
            if (!DescriptorTools.getDisplayName(d).equals(name)) continue;
            return d;
        }
        return null;
    }
}

