/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.deployapi.SunDeploymentManager;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeployModuleDialog;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentConnectionException;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentManager;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentModule;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.deploy.PreDeploymentValidation;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.swing.JLabel;

public class DeploymentManagerImpl
implements DeploymentManager {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentManagerImpl.class);
    private static String RETURN_CLIENT_JAR_UNSUPPORTED = localStrings.getLocalString("ui.deploymentmanagerimpl.return_client_jar_unsupported", "(WARNING: Returning the client jar is not supported for redeployment.)");
    private static String UNABLE_TO_CONNECT = localStrings.getLocalString("ui.deploymentmanagerimpl.unable_to_connect_to_server", "The server could not be contacted.\nPlease confirm that the server is running,\nand that a valid user/password has been entered.");
    private static final String PREDEPLOY_INTRO = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.introduction", "Introduction");
    private static final String SAVE_DEPLOY_LABEL = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.save_deploy_label", "Finish");
    private static final String PREDEPLOY_CLICK_FINISH = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.click_finish_to_deploy", "Click the Finish button to begin the deployment.\n");
    private static final String PREDEPLOY_JNDI_NAMES = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.jndinames", "JNDI Names");
    private static final String PREDEPLOY_WAR_ROOT = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.war_context_root", ".WAR Context Root");
    private static final String PREDEPLOY_REVIEW = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.review", "Review");
    private static final String PLEASE_SELECT_SERVER = localStrings.getLocalString("ui.deploymentmanagerimpl.please_select_server", "Please select a server");
    private static final String PLEASE_SELECT_DEPLOYABLE = localStrings.getLocalString("ui.deploymentmanagerimpl.please_select_deployable", "Please select object to deploy");
    private static final String PREDEPLOY_RETURN_JAR = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.return_client_jar", "Return Client Jar");
    private static String PREDEPLOY_SELECT_SERVER = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.select_server_help", "Please select the object to be deployed and the server to which it should be deployed:");
    private static final String PREDEPLOY_TARGET_SERVER = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.target_server", "Target Server:");
    private static final String PREDEPLOY_DEPLOYED_OBJECTS = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.deployed_object", "Object to Deploy:");
    private static final String PREDEPLOY_CJAR_HELP = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.client_jar_help", "The server can send back a client JAR file. It contains the extra RMI/IIOP stub classes that client applications written to access this application will need at runtime.");
    private static final String PREDEPLOY_CHOOSE_FILE = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.choose_file", "Choose File");
    private static final String PREDEPLOY_SAVE_ON_DEPLOY = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.save_on_deploy", "Save object before deploying");
    private static String PREDEPLOY_CJAR_FILE = localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.client_jar_file", "Client JAR File Name:");
    private static final int NEVER_SAVE = 0;
    private static final int ALWAYS_SAVE = 1;
    private static final int CONFIRM_SAVE = 2;
    private static final int DEFAULT_SAVE_ON_DEPLOY = 2;
    private static int SaveOnDeploy = -1;
    private Frame frameOwner = null;
    private int saveOnDeploy = 2;
    private PreDeploymentValidation preDeploymentValidator = null;
    private Hashtable clientCodeHash = new Hashtable();

    private static String ERROR_SERVER_COMMUNICATION(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_server_communication", "There was an error communicating with {0}\nto establish whether this object was already deployed.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0});
    }

    private static String ERROR_SERVER_CONNECTION(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_server_connection", "There was a server connection error\n {0}\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information.", new Object[]{v0});
    }

    private static String ERROR_SERVER_DEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_server_deploy", "There was a deployment error\n {0}\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0});
    }

    private static String ERROR_SERVER_UNDEPLOY(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_server_undeploy", "Error uninstalling {0} from {1}.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0, v1});
    }

    private static String ERROR_SAVING(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_saving", "Error encountered while saving ''{0}''\n {1}.\n Please refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0, v1});
    }

    private static String ASK_REDEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_already_deployed", "{0} has already been deployed.\nDo you wish to redeploy?", new Object[]{v0});
    }

    private static String ERROR_ALREADY_DEPLOYED(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.error_already_deployed", "A module with this name has already been deployed:\n  {0}", new Object[]{v0});
    }

    private static String PLEASE_CONNECT_DEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.deploy.connect_to_server", "Please connect to a server before deploying ''{0}''", new Object[]{v0});
    }

    private static String PLEASE_CONNECT_REDEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.redeploy.connect_to_server", "Please connect to a server before redeploying ''{0}''", new Object[]{v0});
    }

    private static String UPDATE_FAILED(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.update_failed", "Update failed for ''{0}''\n {1}\nPlease refer to \n<J2EE_HOME>/logs/<machine-name>/j2ee/j2ee/error.log\n for more information. Please verify your Application with the Verifier tool.", new Object[]{v0, v1});
    }

    private static String PREDEPLOY_TITLE(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.deploy_title", "Deploy {0}", new Object[]{v0});
    }

    private static String READY_TO_DEPLOY(String v0) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.predeployment.ready_to_deploy_object", "''{0}'' is ready to be deployed to the selected server.", new Object[]{v0});
    }

    private static String NO_SQL(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.sql_missing_for_cmpejb", "Application: {0}\nSQL has not been generated for the following EJBs:\n{1}\nDo you wish to continue?", new Object[]{v0, v1});
    }

    private static String RAR_DEPLOY_SUCCEEDED(String v0, String v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.connector.deployed_successfully", "Resource Adapter ''{0}'' was successfully deployed to server ''{1}''", new Object[]{v0, v1});
    }

    private static String CONFIRM_UNDEPLOY(Object v0, Object v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.confirm_undeploy", "Server: {0}\nConfirm undeploy of the following modules\n{1}", new Object[]{v0, v1});
    }

    private static String CONFIRM_START(Object v0, Object v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.confirm_start", "Server: {0}\nConfirm start of the following modules\n{1}", new Object[]{v0, v1});
    }

    private static String CONFIRM_STOP(Object v0, Object v1) {
        return localStrings.getLocalString("ui.deploymentmanagerimpl.confirm_stop", "Server: {0}\nConfirm stop of the following modules\n{1}", new Object[]{v0, v1});
    }

    public DeploymentManagerImpl(Frame owner) {
        this.frameOwner = owner;
        if (SaveOnDeploy == -1) {
            SaveOnDeploy = UIConfig.getConfigInteger("ui.Deploy.saveOnDeploy", 2);
        }
        this.saveOnDeploy = SaveOnDeploy;
    }

    private boolean saveIfDirty(Descriptor desc) {
        int saveMode = this.saveOnDeploy;
        boolean isDirty = DT.isDirty(desc);
        if (!isDirty && saveMode != 1) {
            Print.dprintln((String)("Object doesn't need to be saved: " + desc.getDisplayName()));
            return true;
        }
        if (saveMode == 0) {
            Print.dprintln((String)("NOT Saving Object: " + desc.getDisplayName()));
            return false;
        }
        Frame frame = DT.getApplicationFrame();
        SaveAndDeployDialog dialog = new SaveAndDeployDialog(frame);
        if (UIConfig.getConfigBoolean("ui.dontShowAgain_SaveAndDeploy", false)) {
            dialog.okToSave = true;
        } else {
            dialog.show();
        }
        if (dialog.okToSave) {
            Print.dprintln((String)("Saving Object: " + desc.getDisplayName()));
            return this.save(desc);
        }
        Print.dprintln((String)("NOT Saving Object: " + desc.getDisplayName()));
        return false;
    }

    private boolean save(Descriptor desc) {
        Print.dprintln((String)("Saving " + desc.getDisplayName()));
        try {
            DT.getModuleManager().saveModule(desc);
            return true;
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this.frameOwner, DeploymentManagerImpl.ERROR_SAVING(desc.getDisplayName(), ioe.toString()));
            return false;
        }
    }

    private File getSavedFile(Descriptor desc) {
        File descFile = null;
        if (this.saveIfDirty(desc) && desc instanceof RootDeploymentDescriptor) {
            descFile = ModuleArchive.getArchiveFile(desc);
        }
        return descFile;
    }

    private File createTempFile(String prefix, String extn) throws IOException {
        File tmpDir = UIConfig.getTempDirectory();
        File tmpFile = File.createTempFile(prefix, extn, tmpDir);
        FileUtil.deleteOnExit((File)tmpFile, (boolean)true);
        return tmpFile;
    }

    public boolean updateProjectFiles(Descriptor desc, boolean interactive) {
        if (desc == null) {
            return false;
        }
        try {
            UIProject prj = UIProject.getProject(desc);
            if (prj == null) {
                throw new RuntimeException("No Project found");
            }
            return prj.updateArchiveFiles(interactive);
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Update Failed", (Throwable)t);
            String updFail = DeploymentManagerImpl.UPDATE_FAILED(desc.getDisplayName(), t.getMessage());
            Print.println((String)updFail);
            if (interactive) {
                UIOptionPane.showErrorDialog(this.frameOwner, updFail);
            }
            return false;
        }
    }

    private boolean preDeploymentValidation(RootDeploymentDescriptor desc) {
        if (this.preDeploymentValidator == null) {
            this.preDeploymentValidator = new PreDeploymentValidation(this.frameOwner);
        }
        return this.preDeploymentValidator.validate(desc);
    }

    public void deployObject(RootDeploymentDescriptor desc) {
        if (desc == null) {
            return;
        }
        File f = ModuleArchive.getArchiveFile((Descriptor)desc);
        String fileName = f.getName();
        String descName = fileName.substring(0, fileName.lastIndexOf("."));
        if (!DescriptorTools.isModuleDescriptor((Descriptor)desc)) {
            Print.printStackTrace((String)("Not a deployable module: " + descName));
            return;
        }
        DeployModuleDialog dmd = DeployModuleDialog.getDeployModuleInfo(desc, false);
        if (dmd == null) {
            return;
        }
        DeploymentPlatform platform = dmd.getDeploymentPlatform();
        if (!platform.isConnected() || !platform.isServerRunning()) {
            UIOptionPane.showErrorDialog(this.frameOwner, UNABLE_TO_CONNECT);
            return;
        }
        DeploymentModule depModule = null;
        try {
            depModule = platform.getDeploymentModuleForName(descName);
        }
        catch (DeploymentConnectionException dce) {
            depModule = null;
        }
        File descCfgFile = dmd.getFileLocation();
        File appClientStub = dmd.getAppClientStubDir();
        if (depModule == null) {
            File descSavedFile = this.getSavedFile((Descriptor)desc);
            if (descSavedFile == null) {
                return;
            }
            if (!this.preDeploymentValidation((RootDeploymentDescriptor)DT.getActiveModule())) {
                return;
            }
            try {
                platform.deploy(descName, descSavedFile, descCfgFile, descName, appClientStub);
            }
            catch (Throwable t) {
                Print.printStackTrace((String)("Unable to deploy: " + descName), (Throwable)t);
            }
        } else {
            String s = DeploymentManagerImpl.ASK_REDEPLOY(descName);
            if (UIOptionPane.showConfirmDialog(this.frameOwner, s)) {
                File descSavedFile = this.getSavedFile((Descriptor)desc);
                if (descSavedFile == null) {
                    return;
                }
                if (!this.preDeploymentValidation((RootDeploymentDescriptor)DT.getActiveModule())) {
                    return;
                }
                TargetModuleID module = depModule.getTargetModuleID();
                TargetModuleID[] modules = new TargetModuleID[]{module};
                try {
                    platform.redeploy(descName, modules, descSavedFile, descCfgFile, appClientStub);
                }
                catch (Throwable t) {
                    Print.printStackTrace((String)("Unable to redeploy: " + descName), (Throwable)t);
                }
            }
        }
    }

    public void redeployObject(RootDeploymentDescriptor desc) {
        if (desc == null) {
            return;
        }
        File f = ModuleArchive.getArchiveFile((Descriptor)desc);
        String fileName = f.getName();
        String descName = fileName.substring(0, fileName.lastIndexOf("."));
        if (!DescriptorTools.isModuleDescriptor((Descriptor)desc)) {
            Print.printStackTrace((String)("Not a deployable module: " + descName));
            return;
        }
        if (!this.preDeploymentValidation(desc)) {
            return;
        }
        DeployModuleDialog dmd = DeployModuleDialog.getDeployModuleInfo(desc, true);
        if (dmd == null) {
            return;
        }
        DeploymentPlatform platform = dmd.getDeploymentPlatform();
        if (!platform.isConnected() || !platform.isServerRunning()) {
            UIOptionPane.showErrorDialog(this.frameOwner, UNABLE_TO_CONNECT);
            return;
        }
        DeploymentModule depModule = null;
        try {
            depModule = platform.getDeploymentModuleForName(descName);
        }
        catch (DeploymentConnectionException dce) {
            depModule = null;
        }
        File descSavedFile = this.getSavedFile((Descriptor)desc);
        if (descSavedFile == null) {
            return;
        }
        File descCfgFile = dmd.getFileLocation();
        if (depModule != null) {
            TargetModuleID module = depModule.getTargetModuleID();
            TargetModuleID[] modules = new TargetModuleID[]{module};
            try {
                platform.redeploy(modules, descSavedFile, descCfgFile);
            }
            catch (Throwable t) {
                Print.printStackTrace((String)("Unable to redeploy: " + descName), (Throwable)t);
            }
        } else {
            try {
                platform.deploy(descName, descSavedFile, descCfgFile);
            }
            catch (Throwable t) {
                Print.printStackTrace((String)("Unable to deploy: " + descName), (Throwable)t);
            }
        }
    }

    private void _moduleOperation(DeploymentModule depMod, CommandType cmd) {
        if (depMod != null) {
            this._moduleOperation(new DeploymentModule[]{depMod}, cmd);
        }
    }

    public void _moduleOperation(DeploymentModule[] depMod, CommandType cmd) {
        if (depMod == null || depMod.length <= 0) {
            return;
        }
        StringBuffer modNames = new StringBuffer();
        TargetModuleID[] modules = new TargetModuleID[depMod.length];
        DeploymentPlatform platform = null;
        for (int i = 0; i < depMod.length; ++i) {
            if (platform == null) {
                platform = depMod[i].getDeploymentPlatform();
            } else if (!platform.equals(depMod[i].getDeploymentPlatform())) {
                Print.printStackTrace((String)"All DeploymentModules must belong to the same DeploymentPlatform");
                return;
            }
            modules[i] = depMod[i].getTargetModuleID();
            if (i > 0) {
                modNames.append("\n");
            }
            modNames.append("  ").append(modules[i].getModuleID());
        }
        boolean status = false;
        String serverName = ((SunDeploymentManager)platform.getDeploymentManager(true)).getShortProductVersion();
        if (cmd.equals(CommandType.UNDEPLOY)) {
            String msg = DeploymentManagerImpl.CONFIRM_UNDEPLOY(serverName, modNames);
            if (!UIOptionPane.showConfirmDialog(null, msg)) {
                return;
            }
            status = platform.undeploy(modules);
        } else if (cmd.equals(CommandType.START)) {
            String msg = DeploymentManagerImpl.CONFIRM_START(serverName, modNames);
            if (!UIOptionPane.showConfirmDialog(null, msg)) {
                return;
            }
            status = platform.start(modules);
        } else if (cmd.equals(CommandType.STOP)) {
            String msg = DeploymentManagerImpl.CONFIRM_STOP(serverName, modNames);
            if (!UIOptionPane.showConfirmDialog(null, msg)) {
                return;
            }
            status = platform.stop(modules);
        } else {
            Print.printStackTrace((String)("Unsupported CommandType: " + cmd));
            return;
        }
    }

    public void undeployObject(DeploymentModule depMod) {
        this._moduleOperation(depMod, CommandType.UNDEPLOY);
    }

    public void undeployObject(DeploymentModule[] depMod) {
        this._moduleOperation(depMod, CommandType.UNDEPLOY);
    }

    public void startObject(DeploymentModule depMod) {
        this._moduleOperation(depMod, CommandType.START);
    }

    public void startObject(DeploymentModule[] depMod) {
        this._moduleOperation(depMod, CommandType.START);
    }

    public void stopObject(DeploymentModule depMod) {
        this._moduleOperation(depMod, CommandType.STOP);
    }

    public void stopObject(DeploymentModule[] depMod) {
        this._moduleOperation(depMod, CommandType.STOP);
    }

    static /* synthetic */ LocalStringManagerImpl access$000() {
        return localStrings;
    }

    private static class SaveAndDeployDialog
    extends UIDialog {
        private static final String TITLE = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.title", "Confirm Save and Deploy");
        private static final String SAVE_AND_DEPLOY_MSG = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.msg", "This module has unsaved changes. These changes will be saved prior to deployment.");
        public static final String SAVE_AND_DEPLOY = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.btn.save_and_deploy", "Save and Deploy");
        private static final String SAVE_AND_DEPLOY_MNEMONIC = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.btn.save_and_deploy.mnemonic", "S");
        private static final String CANCEL_DEPLOY = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.btn.cancel_deploy", "Cancel Deployment");
        private static final String CANCEL_DEPLOY_MNEMONIC = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.btn.cancel_deploy.mnemonic", "C");
        private static final String DONT_ASK_LABEL = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.lbl.dont_ask", "Don't ask me this again");
        private static final String DONT_ASK_LABEL_MNEMONIC = DeploymentManagerImpl.access$000().getLocalString("ui.deploymentmanagerimpl.saveanddeploydialog.lbl.dont_ask.mnemonic", "D");
        boolean okToSave = false;
        UICheckBox dontAskCheckBox;

        public SaveAndDeployDialog(Frame owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        private void initDialog(Window window) {
            this.setTitle(TITLE);
            UIPanel contentPane = new UIPanel();
            GridBagLayout gridbag = new GridBagLayout();
            contentPane.setLayout(gridbag);
            this.setContentPane(contentPane);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 0.5;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.gridwidth = 2;
            JLabel label = new JLabel(SAVE_AND_DEPLOY_MSG);
            contentPane.add((Component)label, c);
            UIButton saveBtn = new UIButton(SAVE_AND_DEPLOY, SAVE_AND_DEPLOY_MNEMONIC.charAt(0));
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.anchor = 13;
            saveBtn.addActionListener(new ActionListener(this){
                private final /* synthetic */ SaveAndDeployDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    SaveAndDeployDialog.access$100(this.this$0);
                }
            });
            contentPane.add((Component)saveBtn, c);
            UIButton cancelBtn = new UIButton(CANCEL_DEPLOY, CANCEL_DEPLOY_MNEMONIC.charAt(0));
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.anchor = 17;
            cancelBtn.addActionListener(new ActionListener(this){
                private final /* synthetic */ SaveAndDeployDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.cancelAction();
                }
            });
            contentPane.add((Component)cancelBtn, c);
            this.dontAskCheckBox = new UICheckBox(DONT_ASK_LABEL, DONT_ASK_LABEL_MNEMONIC.charAt(0));
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            c.anchor = 16;
            contentPane.add((Component)this.dontAskCheckBox, c);
        }

        public void show() {
            this.setLocationRelativeToOwner(150, 300);
            this.pack();
            super.show();
        }

        private void okAction() {
            this.okToSave = true;
            if (this.dontAskCheckBox.isSelected()) {
                UIConfig.setConfigBoolean("ui.dontShowAgain_SaveAndDeploy", this.dontAskCheckBox.isSelected());
            }
            this.hide();
        }

        protected void cancelAction() {
            this.okToSave = false;
            if (this.dontAskCheckBox.isSelected()) {
                this.dontAskCheckBox.setSelected(false);
            }
            this.hide();
        }

        static /* synthetic */ void access$100(SaveAndDeployDialog x0) {
            x0.okAction();
        }
    }
}

