/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentURISelector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class DeployModuleDialog
extends UIDialog {
    private static final boolean SHOW_FILE_LOCATION = false;
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployModuleDialog.class);
    protected static String FILE_LOCATION_HELP = localStrings.getLocalString("ui.deploymoduledialog.ds_file_name.help", "You must provide a deployment settings file that contains the platform-specific information needed to deploy this module.<br><B>Note:</B><I>If this module was created using a previous version of the Deployment Tool, and it already contains a version of this platform-specific deployment file (\"sun-j2ee-ri.xml\"), you can leave the Deployment Settings File field blank</I><br><hr>");
    protected static String FILE_LOCATION = localStrings.getLocalString("ui.deploymoduledialog.ds_file_name", "Deployment Settings File Name:");
    protected static String APP_CLIENT_STUB_DIR = localStrings.getLocalString("ui.deploymoduledialog.app_client.stub_dir", "Application Client Stub Directory");
    protected static String APP_CLIENT_STUB_JAR = localStrings.getLocalString("ui.deploymoduledialog.app_client.stub_jar", "Application Client Stub Jar");
    private static final String RETURN_CLIENT_JAR = localStrings.getLocalString("ui.deploymoduledialog.app_client.return_jar", "Return Client Jar");
    private static String NO_USERNAME_PASSWORD_ERROR_MSG = localStrings.getLocalString("ui.deploymoduledialog.please_set_username_password", "The user name and password to the Deployment Manager is not set");
    private static DeployModuleDialog dialog = null;
    private File archiveFile = null;
    private UITitledBox fileLocationBox = null;
    private UITitledTextField fileLocation = null;
    private DeploymentURISelector uriSelector = null;
    private UITitledBox appClientStubBox = null;
    private UICheckBox returnClientJar = null;
    private UITitledTextField clientStubDir = null;
    private boolean isOk = false;

    protected static String DEPLOY_TITLE(Object v0) {
        return localStrings.getLocalString("ui.deploymoduledialog.window_title.deploy", "Deploy Module {0}", new Object[]{v0});
    }

    public static DeployModuleDialog getDeployModuleInfo(RootDeploymentDescriptor rd) {
        return DeployModuleDialog.getDeployModuleInfo(rd, false);
    }

    public static DeployModuleDialog getDeployModuleInfo(RootDeploymentDescriptor rd, boolean redeploy) {
        if (dialog == null) {
            dialog = new DeployModuleDialog(DT.getApplicationFrame());
        }
        dialog.showDialog(rd, redeploy);
        return DeployModuleDialog.dialog.isOk ? dialog : null;
    }

    protected DeployModuleDialog(Frame parentFrame) {
        super(parentFrame, true);
        this.setTitle(DeployModuleDialog.DEPLOY_TITLE(""));
        this._initLayout();
    }

    protected void _initLayout() {
        UITitledBox content = (UITitledBox)this.getContentPane();
        UIControlButtonBox control = new UIControlButtonBox(null, false);
        control.setControlButtonLocation(101);
        content.addWithGBConstraints(control);
        UITitledBox box = new UITitledBox(null, false);
        box.getGBConstraints().weighty = 0.0;
        box.getGBConstraints().fill = 2;
        box.getGBConstraints().anchor = 11;
        box.getGBConstraints().insets.top = 5;
        control.setView(box);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeployModuleDialog.this.okAction();
            }
        });
        control.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeployModuleDialog.this.cancelAction();
            }
        });
        control.addControlButton(cancelBtn);
        control.addControlButton(new UIHelpButton("DeployModule"));
        this.uriSelector = new DeploymentURISelector(true);
        this.uriSelector.setConnectionSettingsVisible(true);
        box.addWithGBConstraints(this.uriSelector);
        this.appClientStubBox = new UITitledBox(APP_CLIENT_STUB_DIR, true);
        box.addWithGBConstraints(this.appClientStubBox);
        this.returnClientJar = new UICheckBox(RETURN_CLIENT_JAR);
        this.appClientStubBox.addWithGBConstraints(this.returnClientJar);
        this.returnClientJar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeployModuleDialog.this.clientStubDir.setEnabled(DeployModuleDialog.this.returnClientJar.isSelected());
            }
        });
        this.clientStubDir = new UITitledTextField(null, false);
        this.clientStubDir.setBrowserFilterKey(null);
        this.appClientStubBox.addWithGBConstraints(this.clientStubDir);
        this.clientStubDir.setClearWhenDisabled(true);
        this.clientStubDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (DeployModuleDialog.this.clientStubDir.isVisible() && DeployModuleDialog.this.clientStubDir.getText().equals("")) {
                    DeployModuleDialog.this.clientStubDir.setText(UIConfig.getTempDirectory().toString());
                }
            }
        });
    }

    private void showDialog(RootDeploymentDescriptor rd, boolean redeploy) {
        this.setTitle(DeployModuleDialog.DEPLOY_TITLE(rd.getDisplayName()));
        this.isOk = false;
        this.archiveFile = ModuleArchive.getArchiveFile((Descriptor)rd);
        if (rd instanceof ConnectorDescriptor) {
            this.appClientStubBox.setVisible(false);
            this.clientStubDir.setText("");
            dialog.pack();
            dialog.setSize(470, DeployModuleDialog.dialog.getSize().height);
        } else {
            if (!redeploy && (rd instanceof Application || rd instanceof EjbBundleDescriptor || rd instanceof ApplicationClientDescriptor)) {
                this.appClientStubBox.setVisible(true);
                this.clientStubDir.setText(this.archiveFile != null ? this.archiveFile.getParent() : UIConfig.getHomeDirectory().toString());
            } else {
                this.appClientStubBox.setVisible(false);
                this.clientStubDir.setText("");
            }
            dialog.pack();
            dialog.setSize(470, DeployModuleDialog.dialog.getSize().height);
        }
        this.uriSelector.refreshPlatforms();
        this.uriSelector.setSelectedURI(DeploymentPlatform.getTargetManagerURI());
        this.returnClientJar.setSelected(false);
        this.clientStubDir.setEnabled(false);
        dialog.setLocationRelativeToOwner();
        super.show();
    }

    private boolean isFileLocationRequired() {
        return false;
    }

    public DeploymentPlatform getDeploymentPlatform() {
        return this.uriSelector.getSelectedPlatform();
    }

    public File getFileLocation() {
        if (!this.isFileLocationRequired()) {
            return null;
        }
        String fn = this.fileLocation.getText();
        if (fn.equals("")) {
            return null;
        }
        File f = new File(fn).getAbsoluteFile();
        if (!fn.equals(f.toString())) {
            this.fileLocation.setText(f.toString());
        }
        return f;
    }

    public File getAppClientStubDir() {
        return this.returnClientJar.isSelected() ? new File(this.clientStubDir.getText()) : null;
    }

    private void browseFileLocation() {
        UIFileChooser fc = UIFileChooser.getFileChooser(this.getFileLocation());
        int rtn = fc.showDialog(this, null);
        if (rtn == 0) {
            File file = fc.getSelectedFile();
            this.fileLocation.setText(file.toString());
        }
    }

    private void okAction() {
        File f;
        if (this.isFileLocationRequired() && ((f = this.getFileLocation()) == null || !f.isFile())) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymoduledialog.please_select_existing_file", "Please select an existing file."));
            return;
        }
        File stubDir = this.getAppClientStubDir();
        if (stubDir != null && !stubDir.canWrite()) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymoduledialog.appclient_dir_error", "The Application Client Stub Directory {0} \ndoes not exist or you have no write permission.", new Object[]{stubDir.getAbsolutePath()}));
            return;
        }
        if (!this.uriSelector.isValidUsernamePassword()) {
            UIOptionPane.showErrorDialog(this, NO_USERNAME_PASSWORD_ERROR_MSG);
            return;
        }
        if (!this.uriSelector.isValidURI()) {
            this.getDeploymentPlatform().showInvalidURI(this, this.uriSelector.getAlwaysConnect());
            return;
        }
        this.uriSelector.applySelections();
        this.isOk = true;
        this.hide();
    }

    protected void cancelAction() {
        this.isOk = false;
        this.hide();
    }
}

