/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.cmp;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class UIDialogDisplayer
extends DialogDisplayer {
    private static final String IMAGE_NAME = "wizard_generic_full.gif";
    private static final String[] _emptySteps = new String[0];
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_IMAGE = "WizardPanel_image";
    private static ImageIcon _wizardImage;
    private static JDialog _currentModalDialog;

    public Object notify(NotifyDescriptor nd) {
        JOptionPane optionPane = new JOptionPane(nd.getMessage(), nd.getMessageType(), nd.getOptionType());
        JDialog dialog = optionPane.createDialog(UIDialogDisplayer.getParentWindow(), nd.getTitle());
        Object returnValue = null;
        optionPane.setWantsInput(false);
        dialog.show();
        returnValue = optionPane.getValue();
        return returnValue != null ? returnValue : NotifyDescriptor.CLOSED_OPTION;
    }

    private static synchronized ImageIcon getWizardImage() {
        if (_wizardImage == null) {
            _wizardImage = UIIcons.getImageIconFor(IMAGE_NAME);
        }
        return _wizardImage;
    }

    public Dialog createDialog(final DialogDescriptor dd) {
        Window parentWindow = UIDialogDisplayer.getParentWindow();
        final SimpleDialog dialog = parentWindow instanceof Dialog ? new SimpleDialog(dd, (Dialog)parentWindow) : new SimpleDialog(dd, (Frame)parentWindow);
        dd.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                String pname = ev.getPropertyName();
                if ("title".equals(pname)) {
                    dialog.setTitle(dd.getTitle());
                } else if ("message".equals(pname)) {
                    dialog.configureMessage();
                    dialog.validate();
                    dialog.repaint();
                } else if (UIDialogDisplayer.PROP_CONTENT_DATA.equals(pname)) {
                    String[] newSteps = (String[])ev.getNewValue();
                    if (!_emptySteps.equals(newSteps)) {
                        dialog.configureSteps();
                    }
                } else if ("valid".equals(pname)) {
                    dialog.updateOK((Boolean)ev.getNewValue());
                } else if ("helpCtx".equals(pname)) {
                    dialog.updateHelp(((HelpCtx)ev.getNewValue()).getHelpID());
                }
            }
        });
        return dialog;
    }

    private static Window getParentWindow() {
        Window activeWindow;
        Window parentWindow;
        JDialog jDialog = parentWindow = _currentModalDialog != null ? _currentModalDialog : DT.getSunOneSettingsDialog();
        if (parentWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) instanceof Frame) {
            parentWindow = activeWindow;
        }
        return parentWindow;
    }

    static {
        UIDefaults uiDefaults = UIManager.getDefaults();
        if (uiDefaults != null && uiDefaults.get("controlFont") == null) {
            uiDefaults.put("controlFont", new Font("Dialog", 0, 11));
        }
    }

    private static final class SimpleDialog
    extends UIDialog
    implements ActionListener {
        private UIControlButtonBox content;
        private DialogDescriptor descriptor;
        private AbstractButton okButton;
        private UIHelpButton helpButton;

        public SimpleDialog(DialogDescriptor dd, Dialog dialog) {
            super(dialog, dd.getTitle(), dd.isModal());
            this.initializeContent(dd);
        }

        public SimpleDialog(DialogDescriptor dd, Frame frame) {
            super(frame, dd.getTitle(), dd.isModal());
            this.initializeContent(dd);
        }

        private void initializeContent(DialogDescriptor dd) {
            this.descriptor = dd;
            this.content = new UIControlButtonBox(null, false);
            this.content.setControlButtonLocation(101);
            this.setContentBox(this.content);
            this.configureButtons();
            this.configureMessage();
            this.setBounds(Utilities.findCenterBounds(this.getSize()));
            this.setDefaultCloseOperation(2);
        }

        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd.equals("ok")) {
                this.descriptor.setValue(DialogDescriptor.OK_OPTION);
                this.hide();
            } else if (cmd.equals("cancel")) {
                this.descriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                this.hide();
            }
        }

        public void show() {
            JDialog previousModal = _currentModalDialog;
            this.configureSteps();
            if (this.isModal()) {
                _currentModalDialog = this;
            }
            super.show();
            if (_currentModalDialog != previousModal) {
                _currentModalDialog = previousModal;
            }
        }

        private static JComponent message2Component(Object message) {
            if (message instanceof JComponent) {
                return (JComponent)message;
            }
            if (message instanceof Object[]) {
                Object[] sub = (Object[])message;
                JPanel panel = new JPanel();
                panel.setLayout(new FlowLayout());
                for (int i = 0; i < sub.length; ++i) {
                    panel.add(SimpleDialog.message2Component(sub[i]));
                }
                return panel;
            }
            if (message instanceof Icon) {
                return new JLabel((Icon)message);
            }
            return new JLabel(message.toString());
        }

        private void configureButtons() {
            Object[] options = this.descriptor.getOptions();
            int[] spacers = null;
            if (options == null) {
                switch (this.descriptor.getOptionType()) {
                    case -1: 
                    case 2: {
                        options = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
                        break;
                    }
                    case 0: {
                        options = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION};
                        break;
                    }
                    case 1: {
                        options = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION};
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (this.descriptor instanceof WizardDescriptor && options.length == 4) {
                Object[] shuffledOptions = new Object[4];
                ((WizardDescriptor)this.descriptor).putProperty(UIDialogDisplayer.PROP_IMAGE, UIDialogDisplayer.getWizardImage().getImage());
                this.configureHelp();
                this.content.addControlSpacer(15);
                shuffledOptions[0] = options[3];
                shuffledOptions[1] = options[0];
                shuffledOptions[2] = options[1];
                shuffledOptions[3] = options[2];
                options = shuffledOptions;
                spacers = new int[]{15, 1, 15, 5};
            }
            this.processOptions(options, spacers);
            this.processOptions(this.descriptor.getAdditionalOptions(), null);
            if (this.helpButton == null) {
                this.configureHelp();
            }
        }

        private void processOptions(Object[] options, int[] spacers) {
            if (this.content != null) {
                int count = options != null ? options.length : 0;
                for (int i = 0; i < count; ++i) {
                    this.content.addControlButton(this.option2Button(options[i]));
                    if (spacers == null) continue;
                    this.content.addControlSpacer(spacers[i]);
                }
            }
        }

        private void configureHelp() {
            HelpCtx helpCtx = this.descriptor.getHelpCtx();
            if (helpCtx != null && helpCtx != HelpCtx.DEFAULT_HELP) {
                this.helpButton = new UIHelpButton(helpCtx.getHelpID());
                this.content.addControlButton(this.helpButton);
            }
        }

        private void configureMessage() {
            this.content.setView(SimpleDialog.message2Component(this.descriptor.getMessage()));
            this.configureSteps();
            this.pack();
        }

        private void configureSteps() {
            if (this.descriptor instanceof WizardDescriptor) {
                ((WizardDescriptor)this.descriptor).putProperty(UIDialogDisplayer.PROP_CONTENT_DATA, _emptySteps);
            }
        }

        private AbstractButton option2Button(Object option) {
            if (option instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)option;
                b.addActionListener(this);
                return b;
            }
            if (option == NotifyDescriptor.OK_OPTION) {
                ActionListener al = this.descriptor.getButtonListener();
                this.okButton = UIButton.createOkButton(al != null ? al : this);
                return this.okButton;
            }
            if (option == NotifyDescriptor.CANCEL_OPTION) {
                return UIButton.createCancelButton(this);
            }
            if (option == NotifyDescriptor.CLOSED_OPTION) {
                throw new IllegalArgumentException();
            }
            String text = option.toString();
            JButton b = new JButton(text);
            b.addActionListener(this);
            return b;
        }

        private void updateOK(boolean flag) {
            if (this.okButton != null && this.okButton.isVisible()) {
                this.okButton.setEnabled(flag);
            }
        }

        private void updateHelp(String helpID) {
            if (this.helpButton != null && this.helpButton.isVisible()) {
                this.helpButton.setHelpID(helpID);
            }
        }
    }
}

