/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.cmp;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.common.cmp.ui.BeanMappingPanel;
import com.sun.enterprise.tools.common.cmp.ui.CmpResourceJndiPanel;
import com.sun.enterprise.tools.common.cmp.ui.CreateFieldMappings;
import com.sun.enterprise.tools.common.cmp.ui.EnterpriseBeanPanel;
import com.sun.enterprise.tools.common.cmp.ui.SunOneUtilsCMP;
import com.sun.enterprise.tools.common.cmp.ui.TableGenerationSettings;
import com.sun.enterprise.tools.common.dd.ejb.CmpResource;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.deployment.ui.cmp.CmpPanel;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.MappingStrategy;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContextFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CmpSettingsPanel
extends JPanel
implements CmpPanel {
    private MappingContext mappingContext = null;
    private EjbBundleDescriptor descriptor = null;
    private SunEjbJar sunEjbJar = null;
    private InspectorPane parent;
    private CmpResourceJndiPanel jndiPanel = null;
    private EnterpriseBeanPanel eBeanPanel = null;
    private BeanMappingPanel beanMappingPanel = null;
    private String currentSelectedEBean = null;
    private String currentSelectedPrimaryTable = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CmpSettingsPanel.class);
    public static final String MSG_CMP_SETTINGS = localStrings.getLocalString("ui.cmpsettingspanel.accessibility_cmp_settings", "This CMP Settings is the top-level dialog used to define the server-specific CMP settings for an EJB Jar");
    public static final String CREATE_FIELD_MAPPINGS = localStrings.getLocalString("ui.cmpsettingspanel.create_field_mappings", "Create Database Mappings ...");
    public static final String CREATE_FIELD_MAPPINGS_MN = localStrings.getLocalString("ui.cmpsettingspanel.create_field_mappings_mn", "C");
    public static final String CFM_TOOLTIP = localStrings.getLocalString("ui.cmpsettingspanel.tooltip", "Creates a mapping from EJBs and fields to tables and columns.");
    public static final String CFM_BORDER = localStrings.getLocalString("ui.cmpsettingspanel.cfm_border", "Persistent Field Mappings");
    public static final String TAB_NAME = localStrings.getLocalString("ui.cmpsettingspanel.tabname", "CMP Database");
    public static final String TABLE_GEN_SETTINGS = localStrings.getLocalString("ui.cmpsettingspanel.table_gen_settings", "Table Generation Settings");
    public static final String TABLE_GEN_SETTINGS_MN = localStrings.getLocalString("ui.cmpsettingspanel.table_gen_settings_mn", "T");
    public static final String TABLE_GEN_SETTINGS_TT = localStrings.getLocalString("ui.cmpsettingspanel.table_gen_settings_tt", "Specify table generation settings at deployment");
    private static final String DEFAULT_CMP_JNDI = "jdbc/PointBase";
    private JButton createFieldMappingButton;
    private JPanel ePanel;
    private JPanel jPanel1;
    private JPanel jnPanel;
    private JPanel mPanel;
    private JButton tableGenButton;
    boolean eBeanListenerEnabled = false;

    public CmpSettingsPanel(Component _parent) {
        this.parent = (InspectorPane)_parent;
        this.mappingContext = MappingContextFactory.getMappingContext(Model.RUNTIME);
        this.initComponents();
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(MSG_CMP_SETTINGS);
    }

    private void initComponents() {
        this.jnPanel = new CmpResourceJndiPanel(this.mappingContext);
        this.jndiPanel = (CmpResourceJndiPanel)this.jnPanel;
        this.createFieldMappingButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ePanel = new EnterpriseBeanPanel(this.mappingContext);
        this.eBeanPanel = (EnterpriseBeanPanel)this.ePanel;
        this.mPanel = new BeanMappingPanel(this.mappingContext);
        this.beanMappingPanel = (BeanMappingPanel)this.mPanel;
        this.tableGenButton = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jnPanel, gridBagConstraints);
        this.createFieldMappingButton.setMnemonic(CREATE_FIELD_MAPPINGS_MN.trim().charAt(0));
        this.createFieldMappingButton.setText(CREATE_FIELD_MAPPINGS);
        this.createFieldMappingButton.setToolTipText(CFM_TOOLTIP);
        this.createFieldMappingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmpSettingsPanel.this.createFieldMappingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.createFieldMappingButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder(CFM_BORDER));
        this.ePanel.setMinimumSize(new Dimension(200, 100));
        this.ePanel.setPreferredSize(new Dimension(200, 100));
        this.addEBeanPanelListener();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.ePanel, gridBagConstraints);
        this.mPanel.setMinimumSize(new Dimension(400, 200));
        this.mPanel.setPreferredSize(new Dimension(450, 400));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel1.add((Component)this.mPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.tableGenButton.setMnemonic(TABLE_GEN_SETTINGS_MN.trim().charAt(0));
        this.tableGenButton.setText(TABLE_GEN_SETTINGS);
        this.tableGenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmpSettingsPanel.this.tableGenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.tableGenButton, gridBagConstraints);
    }

    private void tableGenButtonActionPerformed(ActionEvent evt) {
        TableGenerationSettings tgs = new TableGenerationSettings();
        tgs.setDescriptor(this.sunEjbJar);
        if (tgs.showAsDialog(this.descriptor.getName())) {
            this.descriptor.changed();
        }
    }

    private void createFieldMappingButtonActionPerformed(ActionEvent evt) {
        CreateFieldMappings cfm = new CreateFieldMappings(this.mappingContext, this.descriptor, this.jndiPanel.getJndiName(), this.getBeansVector());
        cfm.setSchemaFiles(this.getSchemaFileList());
        this.setCmpResourceJndiName();
        do {
            if (!cfm.showAsDialog()) continue;
            if (!cfm.isGenerateTableSelected()) {
                try {
                    List classStateList = cfm.getModifiedClassStateList();
                    Iterator iter = classStateList.iterator();
                    while (iter.hasNext()) {
                        ClassState classState = (ClassState)iter.next();
                        MappingStrategy.attach(classState);
                        this.removeDummyVersionField(classState);
                    }
                }
                catch (Exception ex) {
                    Print.dprint((String)"Error in attaching class state");
                }
            }
            this.beanMappingPanel.reset();
            this.descriptor.changed();
            this.refresh();
            break;
        } while (cfm.isContinueNeeded());
    }

    private List getSchemaFileList() {
        return this.parent.getArchiveContents(SunOneUtilsCMP.DBSCHEMA_EXTENSION_ARRAY);
    }

    private void addEBeanPanelListener() {
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (!CmpSettingsPanel.this.eBeanListenerEnabled) {
                    return;
                }
                if (ev.getStateChange() == 1) {
                    String newBean = (String)ev.getItem();
                    if (newBean.equals(CmpSettingsPanel.this.currentSelectedEBean)) {
                        return;
                    }
                    CmpSettingsPanel.this.currentSelectedEBean = newBean;
                    CmpSettingsPanel.this.beanMappingPanel.showMappingForBean(CmpSettingsPanel.this.currentSelectedEBean);
                }
            }
        };
        this.eBeanPanel.addListener(il);
    }

    public String getTabName() {
        return TAB_NAME;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj == this.descriptor) {
            return;
        }
        if (!(obj instanceof EjbBundleDescriptor) && !(obj instanceof EjbEntityDescriptor)) {
            this.descriptor = null;
            return;
        }
        if (obj instanceof EjbEntityDescriptor) {
            this.currentSelectedEBean = ((EjbEntityDescriptor)obj).getName();
            this.descriptor = (EjbBundleDescriptor)DescriptorTools.getBundleDescriptor(obj);
        } else {
            this.currentSelectedEBean = null;
            this.descriptor = (EjbBundleDescriptor)obj;
        }
        this.sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
        EnterpriseBeans enterpriseBeans = this.sunEjbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            enterpriseBeans = new EnterpriseBeans();
            this.sunEjbJar.setEnterpriseBeans(enterpriseBeans);
        }
        this.mappingContext = null;
        if (this.mappingContext == null) {
            SunCmpMappings sunCmpMappings = SunOneUtils.getSunCmpMappings((Descriptor)this.descriptor);
            try {
                this.mappingContext = SunOneUtilsCMP.getMappingContext(sunCmpMappings, this.descriptor);
                SunOneUtilsCMP.setExistingMappingContext((Descriptor)this.descriptor, this.mappingContext);
            }
            catch (Exception ex) {
                Print.dprint((String)"Exception in getMappingContext");
                Print.dprintStackTrace((String)("Exception: " + ex));
                this.descriptor = null;
                return;
            }
        }
        this.currentSelectedPrimaryTable = null;
        this.beanMappingPanel.setMappingContext(this.mappingContext, this.descriptor);
        this.beanMappingPanel.setSchemaFiles(this.getSchemaFileList());
    }

    private Vector getBeansVector() {
        Set ejbs = this.descriptor.getEjbs();
        ArrayList<String> beansVector = new ArrayList<String>();
        Iterator itr = this.descriptor.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejb = (EjbDescriptor)itr.next();
            if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
            beansVector.add(ejb.getDisplayName());
        }
        Collections.sort(beansVector);
        return new Vector(beansVector);
    }

    public void refresh() {
        if (this.descriptor == null) {
            this.jndiPanel.setJndiName("");
            this.eBeanPanel.initEnterpriseBeanComboBox(null, null);
            this.createFieldMappingButton.setEnabled(false);
            this.tableGenButton.setEnabled(false);
            this.beanMappingPanel.disableAll();
            return;
        }
        this.createFieldMappingButton.setEnabled(true);
        this.beanMappingPanel.reset();
        CmpResource cmpResource = this.sunEjbJar.getEnterpriseBeans().getCmpResource();
        String jndiName = cmpResource == null ? "" : cmpResource.getJndiName();
        this.jndiPanel.setJndiName(jndiName);
        this.eBeanListenerEnabled = false;
        this.eBeanPanel.initEnterpriseBeanComboBox(this.getBeansVector(), this.currentSelectedEBean);
        this.eBeanListenerEnabled = true;
        if (SunOneUtilsCMP.isJavaToDB(this.descriptor)) {
            MappingContext mc;
            this.tableGenButton.setVisible(true);
            String genSchemaName = SunOneUtilsCMP.getGeneratedSchemaName(this.descriptor);
            if (genSchemaName == null && (mc = SunOneUtilsCMP.getExistingMappingContext((Descriptor)this.descriptor)) != null) {
                SunOneUtilsCMP.setGeneratedSchemaName(this.descriptor, mc.getModel());
            }
        } else {
            this.tableGenButton.setVisible(false);
            this.descriptor.removeExtraAttribute("Generated_Schema_Name");
        }
        this.currentSelectedEBean = this.eBeanPanel.getEnterpriseBeanName();
        if (this.currentSelectedEBean == null) {
            this.beanMappingPanel.setEnabled(false);
        } else {
            boolean hasMapping = this.beanMappingPanel.showMappingForBean(this.currentSelectedEBean);
            if (!hasMapping && this.jndiPanel.getJndiName().trim().equals("")) {
                this.jndiPanel.setJndiName(DEFAULT_CMP_JNDI);
            }
        }
    }

    private void removeDummyVersionField(ClassState classState) throws ModelException {
        MappingClassElement mce = classState.getMappingClassElement();
        if (16 != mce.getConsistencyLevel()) {
            ArrayList<MappingFieldElement> versionFields = new ArrayList<MappingFieldElement>();
            Iterator iterator = mce.getFields().iterator();
            while (iterator.hasNext()) {
                MappingFieldElement nextField = (MappingFieldElement)iterator.next();
                if (!nextField.isVersion()) continue;
                versionFields.add(nextField);
            }
            if (!versionFields.isEmpty()) {
                MappingFieldElement versionField = (MappingFieldElement)versionFields.get(0);
                PersistenceClassElement pce = classState.getPersistenceClassElement();
                mce.removeField(versionField);
                pce.removeField(pce.getField(versionField.getName()));
            }
        }
    }

    public boolean validateEntries(boolean showErrors) {
        Print.dprint((String)("validateEntries ----" + showErrors));
        if (this.descriptor == null) {
            return true;
        }
        if (showErrors) {
            Map classStateMap = this.beanMappingPanel.getAllEditedClassState();
            Iterator iter = classStateMap.values().iterator();
            try {
                while (iter.hasNext()) {
                    ClassState classState = (ClassState)iter.next();
                    MappingStrategy.attach(classState);
                    this.removeDummyVersionField(classState);
                }
            }
            catch (Exception ex) {
                Print.dprintStackTrace((String)"Error in attaching classState", (Throwable)ex);
            }
            MappingContext mc = SunOneUtilsCMP.getExistingMappingContext((Descriptor)this.descriptor);
            if (null != mc) {
                SunOneUtils.setSunCmpMappings((Descriptor)this.descriptor, SunOneUtilsCMP.getSunCmpMappings(mc, this.descriptor));
            }
            this.setCmpResourceJndiName();
        } else {
            this.beanMappingPanel.reset();
        }
        return true;
    }

    private void setCmpResourceJndiName() {
        String jndiName = this.jndiPanel.getJndiName();
        if (jndiName.equals("")) {
            this.sunEjbJar.getEnterpriseBeans().setCmpResource(null);
        } else {
            CmpResource cmpResource = this.sunEjbJar.getEnterpriseBeans().getCmpResource();
            if (cmpResource == null) {
                cmpResource = new CmpResource();
                this.sunEjbJar.getEnterpriseBeans().setCmpResource(cmpResource);
            }
            cmpResource.setJndiName(jndiName);
        }
        this.descriptor.changed();
    }
}

