/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.io.runtime.EjbRuntimeDDFile;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.util.Print;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class SunOneEjbRuntimeDDFile
extends EjbRuntimeDDFile {
    public Descriptor read(Descriptor descriptor, InputStream is) {
        SunEjbJar sej = null;
        try {
            sej = SunEjbJar.createGraph((InputStream)is);
        }
        catch (Schema2BeansException se) {
            se.printStackTrace();
            throw new RuntimeException(se.getMessage());
        }
        SunOneUtils.setSunDescriptor(descriptor, (SunBaseBean)sej);
        this.setEjbs(descriptor, sej);
        String jarName = descriptor.getName();
        AbstractArchive absArch = SunOneUtils.getAbstractArchive();
        SunCmpMappings scm = null;
        if (absArch != null && jarName != null) {
            scm = SunOneUtils.createSunCmpMappings(absArch, jarName);
        }
        if (scm != null) {
            SunOneUtils.setSunCmpMappings(descriptor, scm);
        }
        return descriptor;
    }

    public void write(Descriptor descriptor, OutputStream os) {
        SunEjbJar sej = (SunEjbJar)SunOneUtils.getSunDescriptor(descriptor);
        if (sej == null) {
            SunOneUtils.createSunOneXml(descriptor);
            sej = (SunEjbJar)SunOneUtils.getSunDescriptor(descriptor);
        }
        sej.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd");
        try {
            sej.write(os);
        }
        catch (Exception ex) {
            Print.dprintStackTrace((String)("Exception in writing out descriptors : " + descriptor.getName()));
        }
    }

    private void setEjbs(Descriptor desc, SunEjbJar sej) {
        SunEjbJar sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor(desc);
        EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            enterpriseBeans = new EnterpriseBeans();
            sunEjbJar.setEnterpriseBeans(enterpriseBeans);
            enterpriseBeans.setName(desc.getName());
        }
        Iterator itr = ((EjbBundleDescriptor)desc).getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            this.setEjb((BundleDescriptor)desc, nextEjbDescriptor, enterpriseBeans);
        }
    }

    private void setEjb(BundleDescriptor bd, EjbDescriptor desc, EnterpriseBeans eb) {
        for (int i = 0; i < eb.sizeEjb(); ++i) {
            Ejb ejb = eb.getEjb(i);
            if (!desc.getName().equals(ejb.getEjbName())) continue;
            SunOneUtils.setSunDescriptor((Descriptor)desc, (SunBaseBean)ejb);
            this.checkJndiName(desc, ejb);
            this.setWebserviceEndpoints(bd, desc, ejb);
            return;
        }
        Ejb ejb = new Ejb();
        ejb.setEjbName(desc.getName());
        this.checkJndiName(desc, ejb);
        eb.addEjb(ejb);
        SunOneUtils.setSunDescriptor((Descriptor)desc, (SunBaseBean)ejb);
        this.setWebserviceEndpoints(bd, desc, ejb);
    }

    private void checkJndiName(EjbDescriptor desc, Ejb ejb) {
        if ((desc instanceof EjbEntityDescriptor || desc instanceof EjbSessionDescriptor) && desc.isRemoteInterfacesSupported()) {
            if (this.jndiOk(ejb.getJndiName())) {
                desc.setJndiName(ejb.getJndiName());
                return;
            }
            if (this.jndiOk(desc.getJndiName())) {
                ejb.setJndiName(desc.getJndiName());
                return;
            }
            desc.setJndiName(desc.getName());
            ejb.setJndiName(desc.getName());
        }
    }

    private boolean jndiOk(String nm) {
        return nm != null || "".equals(nm);
    }

    private void setWebserviceEndpoints(BundleDescriptor bd, EjbDescriptor ed, Ejb ejb) {
        Iterator itr = bd.getWebServices().getEndpointsImplementedBy(ed).iterator();
        while (itr.hasNext()) {
            WebServiceEndpoint wse = (WebServiceEndpoint)itr.next();
            this.setWebserviceEndpoint(wse, ejb);
        }
    }

    private void setWebserviceEndpoint(WebServiceEndpoint wse, Ejb ejb) {
        for (int i = 0; i < ejb.sizeWebserviceEndpoint(); ++i) {
            WebserviceEndpoint endpoint = ejb.getWebserviceEndpoint(i);
            if (!wse.getEndpointName().equals(endpoint.getPortComponentName())) continue;
            SunOneUtils.setSunDescriptor((Descriptor)wse, (SunBaseBean)endpoint);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCmpMappings(Descriptor descriptor, AbstractArchive out) {
        SunCmpMappings scm = SunOneUtils.SunCmpMappingsToBeWritenOut((EjbBundleDescriptor)descriptor);
        if (scm == null) return;
        scm.graphManager().setDoctype("-//Sun Microsystems, Inc.//DTD Application Server 8.1 OR Mapping//EN", "http://www.sun.com/software/appserver/dtds/sun-cmp-mapping_1_2.dtd");
        OutputStream os = null;
        os = out.addEntry("META-INF/sun-cmp-mappings.xml");
        scm.write(os);
        Object var7_5 = null;
        if (null == os) return;
        try {
            out.closeEntry(os);
            return;
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)("Exception in writing out descriptors : " + descriptor.getName()));
        }
        return;
        {
            catch (Exception ex) {
                Print.dprintStackTrace((String)("Exception in writing out descriptors : " + descriptor.getName()));
                Object var7_6 = null;
                if (null == os) return;
                try {
                    out.closeEntry(os);
                    return;
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)("Exception in writing out descriptors : " + descriptor.getName()));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == os) throw throwable;
            try {
                out.closeEntry(os);
                throw throwable;
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)("Exception in writing out descriptors : " + descriptor.getName()));
            }
            throw throwable;
        }
    }
}

