/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.app;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

public class UsersDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UsersDialog.class);
    private static String USERS = localStrings.getLocalString("ui.usersdialog.users", "Users");
    private static String TOOLTIP = localStrings.getLocalString("ui.usersdialog.tool_tip", "Select a user from list and press OK");
    private static String USERS_LABEL = localStrings.getLocalString("ui.usersdialog.users_label", "Users:");
    private static String GROUPS_LABEL = localStrings.getLocalString("ui.usersdialog.groups_label", "User Groups:");
    private static String helpSetMapID = "AIAddUser";
    private UsersTableModel usersTableModel = null;
    private UsersTable usersTable = null;
    private UsersTableModel userGroupsTableModel = null;
    private UsersTable userGroupsTable = null;
    private boolean finished = true;
    private NotificationListener displayUsersNotification = null;
    private static String[] usersColumnNames = new String[]{localStrings.getLocalString("ui.usersdialog.table.user_name", "User Name")};
    private static String[] userGroupsColumnNames = new String[]{localStrings.getLocalString("ui.usersdialog.table.group_name", "Group Name")};

    public UsersDialog(Frame frame, boolean modal) {
        super(frame, modal);
        this.doNothingOnClose();
        this.setTitle(USERS);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                UsersDialog.this.cancelAction();
            }
        });
        UIPanel contentPane = new UIPanel(localStrings.getLocalString("ui.userdialog.panel_name", "Panel"), localStrings.getLocalString("ui.userdialog.panel_desc", "This panel is for the user dialog window"));
        contentPane.setToolTipText(TOOLTIP);
        GridBagLayout gb1 = new GridBagLayout();
        contentPane.setLayout(gb1);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        JLabel tblLabel = new JLabel(USERS_LABEL);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(tblLabel, c);
        contentPane.add(tblLabel);
        this.usersTableModel = new UsersTableModel(usersColumnNames);
        this.userGroupsTableModel = new UsersTableModel(userGroupsColumnNames);
        this.initializeUsersTableModel();
        this.usersTable = new UsersTable(this.usersTableModel);
        JScrollPane usersTablePane = new JScrollPane(this.usersTable);
        usersTablePane.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.userdialog.scroll1_name", "Scroll Pane"));
        usersTablePane.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.userdialog.scroll1_desc", "This is the scroll pane for user name table"));
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        this.userGroupsTable = new UsersTable(this.userGroupsTableModel);
        JScrollPane userGroupsTablePane = new JScrollPane(this.userGroupsTable);
        userGroupsTablePane.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.userdialog.scroll2_name", "Scroll Pane"));
        userGroupsTablePane.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.userdialog.scroll2_desc", "This is the scroll pane for user's group name table"));
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersTablePane.setPreferredSize(new Dimension(300, 200));
        userGroupsTablePane.setPreferredSize(new Dimension(300, 200));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        gb1.setConstraints(usersTablePane, c);
        contentPane.add(usersTablePane);
        JLabel tblGroupLabel = new JLabel(GROUPS_LABEL);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(tblGroupLabel, c);
        contentPane.add(tblGroupLabel);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        gb1.setConstraints(userGroupsTablePane, c);
        contentPane.add(userGroupsTablePane);
        UIPanel dialogButtonPanel = new UIPanel(localStrings.getLocalString("ui.userdialog.button_panel_name", "Panel"), localStrings.getLocalString("ui.userdialog.button_panel_desc", "This panel is for the button in user dialog window"));
        dialogButtonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.okAction();
            }
        });
        dialogButtonPanel.add(okPB);
        UIButton cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.cancelAction();
            }
        });
        dialogButtonPanel.add(cancelPB);
        UIButton helpPB = UIButton.createHelpButton(helpSetMapID);
        dialogButtonPanel.add(helpPB);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        c.fill = 0;
        gb1.setConstraints(dialogButtonPanel, c);
        contentPane.add(dialogButtonPanel);
        this.setContentPane(contentPane);
        contentPane.setMinimumSize(contentPane.getPreferredSize());
        this.displayUsersNotification = new NotificationListener(){

            public void notification(NotificationEvent ne) {
                if (UsersDialog.this.isVisible()) {
                    UsersDialog.this.displayUsers();
                }
            }
        };
    }

    public String getSelectedUser() {
        int index;
        String selectedUser = null;
        ListSelectionModel sm = this.usersTable.getSelectionModel();
        if (!sm.isSelectionEmpty() && (index = this.usersTable.getSelectedRow()) >= 0) {
            UsersTableModel model = (UsersTableModel)this.usersTable.getModel();
            selectedUser = model.getUserAt(index);
        }
        return selectedUser;
    }

    public String getSelectedGroup() {
        int index;
        String selectedGroup = null;
        ListSelectionModel sm = this.userGroupsTable.getSelectionModel();
        if (!sm.isSelectionEmpty() && (index = this.userGroupsTable.getSelectedRow()) >= 0) {
            UsersTableModel model = (UsersTableModel)this.userGroupsTable.getModel();
            selectedGroup = model.getUserAt(index);
        }
        return selectedGroup;
    }

    private void initializeUsersTableModel() {
        Iterator i = DT.getServerManager().getServerUserNames().iterator();
        while (i.hasNext()) {
            this.usersTableModel.addUser((String)i.next());
        }
        i = DT.getServerManager().getServerGroupNames().iterator();
        while (i.hasNext()) {
            this.userGroupsTableModel.addUser((String)i.next());
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void okAction() {
        this.finished = true;
        this.hide();
    }

    protected void cancelAction() {
        this.usersTable.clearSelection();
        this.finished = false;
        this.hide();
    }

    public void show() {
        DT.getServerManager().addNotificationListener(this.displayUsersNotification);
        this.displayUsers();
        super.show();
    }

    public void hide() {
        super.hide();
        DT.getServerManager().removeNotificationListener(this.displayUsersNotification);
    }

    private void displayUsers() {
        this.usersTable.clearTableData();
        this.userGroupsTable.clearTableData();
        this.initializeUsersTableModel();
    }

    private class UsersTableModel
    extends InspectorTableModel {
        public UsersTableModel(String[] columnNames) {
            super(columnNames);
        }

        public void addUser(String user) {
            super.addRowObject(super.wrapDataItem(user), true);
        }

        public String getUserAt(int index) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)super.getRowObject(index);
            return ref != null ? (String)ref.getObject() : null;
        }

        public void removeRowAt(int index) {
            super.removeRowObject(index, true);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            return col == 0 ? (String)ref.getObject() : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            if (col == 0) {
                ref.setObject(value);
            }
        }
    }

    private class UsersTable
    extends InspectorTable {
        public UsersTable(UsersTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }
}

